/* EDITED
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2015)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/
// old source: http://sourceforge.net/projects/gogrinder
// new source: http://sourceforge.net/projects/mygogrinder

// called from GoGrinder/ui/ProbFrame.java and (now) from .../WGFFrame.java

package GoGrinder.ui;

import GoGrinder.*;
import java.awt.event.*;
import javax.swing.*;

/**
 *
 * @author  tkington
 * @author  Ruediger Klehn
 */
public class AboutDialog extends javax.swing.JDialog {
    private javax.swing.JPanel panelTxt;
    private javax.swing.JLabel labelVersion;
    private javax.swing.JPanel panelOKButton;
    private javax.swing.JButton buttonOK;
    private javax.swing.JButton buttonViewSysInfo;
    private javax.swing.JLabel labelLogo;
    private javax.swing.JTextArea textAreaCopyright;
    private javax.swing.JTextArea textAreaLicense;

    /** Creates new form AboutDialog */
    public AboutDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
    }
    
    private void initComponents() {

        labelLogo = new javax.swing.JLabel();
        panelOKButton = new javax.swing.JPanel(); 
        panelTxt = new javax.swing.JPanel(); 
        labelVersion = new javax.swing.JLabel();
        textAreaCopyright = new javax.swing.JTextArea();
        textAreaLicense = new javax.swing.JTextArea(); 
        buttonOK = new javax.swing.JButton();
        buttonViewSysInfo = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE); 
        
        setTitle(Messages.getString("about_gg")); //$NON-NLS-1$
        
        panelTxt.setLayout(new javax.swing.BoxLayout(panelTxt, javax.swing.BoxLayout.Y_AXIS)); // Y = top->down
        panelTxt.setBorder(new javax.swing.border.CompoundBorder(new javax.swing.border.LineBorder(new java.awt.Color(0, 0, 0)), new javax.swing.border.EmptyBorder(new java.awt.Insets(3, 3, 3, 3)))); // only right part is panelTxt; Border = 1px, black
        labelVersion.setText(Main.GRINDER_TITLE + Main.VERSION_STRING); //$NON-NLS-1$ 
        panelTxt.add(labelVersion);
        // missing: SubAutor, Contributors, ...

        textAreaCopyright.setBackground(new java.awt.Color(228, 234, 219));
        textAreaCopyright.setEditable(false);
        textAreaCopyright.setText(
              "Current development (2018): \n"
            + "    Ruediger Klehn (RuediRf @ KGS and " + getAddress() + ") \n"
            + "    ( http://sourceforge.net/projects/mygogrinder ) \n"
            + "Most of the code:\n"
            + "    " + Messages.getString("copyright1") + "\n" //$NON-NLS-1$ //$NON-NLS-2$
            + "    ( http://sourceforge.net/projects/gogrinder ) \n"
            + "The code in com/Ostermiller/util (for displaying the help in your OS's browser) \n"
            + "    is from the OstermillerUtils version 1.08.02 and \n"
            + "    Copyright (C) 2001-2010 Stephen Ostermiller (http://ostermiller.org/contact.pl?regarding=Java+Utilities) \n"
            + "    + Copyright (C) 2005 Johann N. Loefflmann (jonelo@jonelo.de) \n\n"
            + "Translations: I'm not sure about this (T.K. didn't mention it), but: \n"
            + "    Spanish possibly by \"alfredo\" (https://sourceforge.net/u/userid-1210873) and \n"
            + "    Chinese possibly by \"Webcraft@cn\" (mathcrown @ sf.net - https://sourceforge.net/u/mathcrown) \n\n"
            + "Graphics: \n"
            + "    " + Messages.getString("copyright2") + "\n" //$NON-NLS-1$ //$NON-NLS-2$
            + "    " + Messages.getString("copyright3") + "\n" //$NON-NLS-1$ //$NON-NLS-2$
            + "    " + Messages.getString("copyright4") + "\n"); //$NON-NLS-1$ //$NON-NLS-2$
        textAreaCopyright.setAlignmentX(0.0F);
        panelTxt.add(textAreaCopyright);

        textAreaLicense.setBackground(new java.awt.Color(228, 234, 219));
        textAreaLicense.setEditable(false);
        textAreaLicense.setLineWrap(true);
        textAreaLicense.setText(Messages.getString("gpl1") //$NON-NLS-1$
            + "\n\n" + Messages.getString("gpl2") //$NON-NLS-1$ //$NON-NLS-2$
            + "\n\n" + Messages.getString("gpl3")); //$NON-NLS-1$ //$NON-NLS-2$
        textAreaLicense.setWrapStyleWord(true);
        textAreaLicense.setAlignmentX(0.0F);
        textAreaLicense.setMinimumSize(new java.awt.Dimension(100, 153));
        textAreaLicense.setPreferredSize(new java.awt.Dimension(100, 180)); 
        // if we let the user set the font size, we need to take this into account
        panelTxt.add(textAreaLicense);

        panelOKButton.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT)); // LEFT RIGHT only means the buttons

      // button view system's info
        buttonViewSysInfo.setText(Messages.getString("view_sys_info")); //$NON-NLS-1$
        buttonViewSysInfo.setToolTipText(Messages.getString("about_dlg_view_yr_sys_info"));
        buttonViewSysInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              onViewSys();
            }
        });
        panelOKButton.add(buttonViewSysInfo);

        panelOKButton.setAlignmentX(0.0F);

      // button for closing this info dialog ansd saving the settings
        buttonOK.setText(Messages.getString("ok")); //$NON-NLS-1$

      // close this dialog with [Enter], [Space], click on OK or [Esc]
        ActionListener closeListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                onOK();
            }
        };
        buttonOK.addActionListener(closeListener);
        buttonOK.registerKeyboardAction(closeListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
                                 JComponent.WHEN_FOCUSED);  // WHEN_FOCUSED
        buttonOK.registerKeyboardAction(closeListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_SPACE, 0),
                                 JComponent.WHEN_FOCUSED);  // WHEN_FOCUSED
        buttonOK.registerKeyboardAction(closeListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW); // WHEN_IN_FOCUSED_WINDOW

        panelOKButton.add(buttonOK);

        panelTxt.add(panelOKButton);

        getContentPane().add(panelTxt, java.awt.BorderLayout.CENTER);

        labelLogo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/GoGrinder/images/aboutchar.png"))); //$NON-NLS-1$
        labelLogo.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 3, 1, 3)));
        getContentPane().add(labelLogo, java.awt.BorderLayout.WEST);

        pack();
        getRootPane().setDefaultButton(buttonOK);
        buttonOK.requestFocusInWindow();
    }

  // close this dialog
    private void onOK() {
        dispose();
    }


  // view system's info dialog
    private void onViewSys() {
      SysInfoDialog ViewSysInfo = new SysInfoDialog(AboutDialog.this, true);
      ViewSysInfo.setVisible(true);
    }

    private String getAddress(){
      // testing an obfuscation in the code
      char storm = 's';
      int alvin = 64;
      char eskimo = (char)alvin;
      char every = 'e';
      String rover = "r";
      String all = "definrstu";

      String retD = rover.toUpperCase() + all.charAt(8) + every + all.charAt(0);
      String retF = "i" + rover.toUpperCase() + all.charAt(2) + eskimo;
      String retH = "" + all.charAt(8) + storm + every;
      String retP = rover + storm + (char)(alvin-18) + storm;
      String retV = "" + all.charAt(2) + '\u002e' + all.charAt(4) + every + "" + all.charAt(7);
      return retD + retF + retH + retP + retV;
    }

}
