/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder;

import java.io.*;
import java.util.Properties;

/**
 *
 * @author  Ruediger Klehn
 */
// thought of reading in some fixed program info from an in-jar-file, which 
// changes from one version to the other (e.g. version, compile date/time, build-##, ...)
public class Params{
  private static String msg = "";
  private static String paramFile = "presets.txt"; // NOT YET, could be names of 
  // folders, files, captions, program name itself, default sgf code, default 
  // values for settings, web adresses, language tokens and names, 
  private static String compileDateFile = "compiledate"; // apparently the path is seen relative to this .class file
  private static String compileTimeFile = "compiletime"; // can also be e.g. /GoGrinder/compiledate (absolute, always inside the jar)
  private static String buildCountFile = "buildcount";
  private static String compilerIDFile = "compiler";
  private static Properties myPresets; // NOT YET
  private static int counter = 0;
  
  // format in the presets file is as in the settings file: 
  // GROUPNAME_PARAMETERNAME=text or integer number  (spaces don't matter, file should be utf-8)
  // # comment
  
  public Params(){/*NOTHING*/}
  
  public static int getBuildCount(){ // buildNumber = new Params().getBuildCount()
    // just gets the count of bytes in the buildcount file: for every compiling:
    // "type onebytefile >> GoGrinder/buildcount"
    counter = 0;
    String dummy = getContent(buildCountFile); // getContent counts also the bytes in the buildcount file
    return counter;
  }
  
  public static String getCompileDate(){
    return getContent(compileDateFile).trim();
  }
  
  public static String getCompilerVersion(){
    return getContent(compilerIDFile).trim();
  }
  
  public static String getCompileTime(){
    return getContent(compileTimeFile).trim();
  }
  
  public static String getContent(String resource){ 
    // This is a multi-use method: for build-count it counts only the bytes of the buildcount
    // file; here the returned string ("dummy") is only for getting the counting done.
    // For compile date/time the returned string is used.
    // FileWReadWrite.readStream(paramFile, getClass());  I don't know, how to handle

    int currReadCount = 0;
    String content = "";
    byte[] ba = new byte[10]; // 10: just an interval for reading the bytes from the InputStream
      InputStream bytes = Params.class.getResourceAsStream(resource); // getClass()
    try{
      do{
        counter += currReadCount;
        currReadCount = bytes.read(ba); // -1 / 1-10 (return value 0 is possible, when the length of byte[] is 0
                                        //              - this would here give an endless loop! (tested))
        /*
          InputStream.read(byte[] b)
          "Reads some number of bytes from the input stream and stores them into the buffer array"
          ... "The number of bytes read is, at most, equal to the length of b"
          and "The number of bytes actually read is returned as an integer"
        */
        
        if (currReadCount > -1)
        /* 
          "value byte is returned as an int in the range 0 to 255"
        */
        // these bytes can be added up in a StringBuffer and then further used:
          content = content + new String(ba, 0, currReadCount); // Arrays - static String 	toString(byte[] a)   does the same?...
 //d.b.g("ba.length (should be 0): " + ba.length + " - currReadCount: " + currReadCount + " - counter: " + counter + " - content: " + content);
      }while(currReadCount != -1); // -1 = end of stream
      bytes.close();
    }
    catch(IOException ioe){
      msg = "Error getting content of " + resource + Main.NL 
          + "(I expected it inside the .jar-file)"
          + "Happened in: " + ioe.getStackTrace()[0] + Main.NL
          + ioe.getStackTrace()[1] + Main.NL 
          + "(Compile time problem?)";
      Main.logSilent(ioe, msg); // myExceptions.logInternal
      d.b.g(msg);
      try{bytes.close(); return "";}catch(Exception e){return "";}
    }
    catch(Exception e){Main.log(e); return "";}
    return content;
  }
  
  //public static String getStringFromResource(String resourceFile){return "";}
  
  public static int getParamInt(String name){ // NOT YET
    return 0;
  }
  
  public static String getParamStr(String name){ // NOT YET
    return "";
  }
  
  public static String getPrgInfo(){
    return Main.VERSION_STRING + " build " + Params.getBuildCount();
  }
  
  public static String getCompileInfo(){
    return "(compiled: " + getCompileDate() + " - " + getCompileTime() + " with " + getCompilerVersion() + ")";
  }
  
  public static Properties getAllParameters(){ // NOT YET
    try{
      InputStream paramStream = Params.class.getResourceAsStream(paramFile);
      if (paramStream == null) throw new IOException("Missing presets file " + paramFile + " in Grinder's .jar file.");
    }
    catch(IOException ioe){
      msg = "Error loading presets." + Main.NL 
          + "Happened in: " + ioe.getStackTrace()[0] + Main.NL 
          + ioe.getStackTrace()[1] + Main.NL
          + "(Compile time problem!)";
      Main.logSilent(ioe, msg); // myExceptions.logInternal
      d.b.g(msg);
    }
    return myPresets;
  }
}