/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.sym;

import org.codehaus.jackson.sym.Name;
import org.codehaus.jackson.sym.Name1;
import org.codehaus.jackson.sym.Name2;
import org.codehaus.jackson.sym.Name3;
import org.codehaus.jackson.sym.NameN;
import org.codehaus.jackson.util.InternCache;

public final class BytesToNameCanonicalizer {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    static final int MAX_TABLE_SIZE = 6000;
    static final int MIN_HASH_SIZE = 16;
    static final int INITIAL_COLLISION_LEN = 32;
    static final int LAST_VALID_BUCKET = 254;
    final BytesToNameCanonicalizer _parent;
    private int _count;
    private int _mainHashMask;
    private int[] _mainHash;
    private Name[] _mainNames;
    private Bucket[] _collList;
    private int _collCount;
    private int _collEnd;
    private transient boolean _needRehash;
    private boolean _mainHashShared;
    private boolean _mainNamesShared;
    private boolean _collListShared;

    public static BytesToNameCanonicalizer createRoot() {
        return new BytesToNameCanonicalizer(64);
    }

    public synchronized BytesToNameCanonicalizer makeChild() {
        return new BytesToNameCanonicalizer(this);
    }

    public void release() {
        if (this.maybeDirty() && this._parent != null) {
            this._parent.mergeChild(this);
            this.markAsShared();
        }
    }

    private BytesToNameCanonicalizer(int n) {
        this._parent = null;
        if (n < 16) {
            n = 16;
        } else if ((n & n - 1) != 0) {
            int n2;
            for (n2 = 16; n2 < n; n2 += n2) {
            }
            n = n2;
        }
        this.initTables(n);
    }

    private BytesToNameCanonicalizer(BytesToNameCanonicalizer bytesToNameCanonicalizer) {
        this._parent = bytesToNameCanonicalizer;
        this._count = bytesToNameCanonicalizer._count;
        this._mainHashMask = bytesToNameCanonicalizer._mainHashMask;
        this._mainHash = bytesToNameCanonicalizer._mainHash;
        this._mainNames = bytesToNameCanonicalizer._mainNames;
        this._collList = bytesToNameCanonicalizer._collList;
        this._collCount = bytesToNameCanonicalizer._collCount;
        this._collEnd = bytesToNameCanonicalizer._collEnd;
        this._needRehash = false;
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    private void initTables(int n) {
        this._count = 0;
        this._mainHash = new int[n];
        this._mainNames = new Name[n];
        this._mainHashShared = false;
        this._mainNamesShared = false;
        this._mainHashMask = n - 1;
        this._collListShared = true;
        this._collList = null;
        this._collEnd = 0;
        this._needRehash = false;
    }

    private synchronized void mergeChild(BytesToNameCanonicalizer bytesToNameCanonicalizer) {
        int n = bytesToNameCanonicalizer._count;
        if (n <= this._count) {
            return;
        }
        if (bytesToNameCanonicalizer.size() > 6000) {
            this.initTables(64);
        } else {
            this._count = bytesToNameCanonicalizer._count;
            this._mainHash = bytesToNameCanonicalizer._mainHash;
            this._mainNames = bytesToNameCanonicalizer._mainNames;
            this._mainHashShared = true;
            this._mainNamesShared = true;
            this._mainHashMask = bytesToNameCanonicalizer._mainHashMask;
            this._collList = bytesToNameCanonicalizer._collList;
            this._collCount = bytesToNameCanonicalizer._collCount;
            this._collEnd = bytesToNameCanonicalizer._collEnd;
        }
    }

    private void markAsShared() {
        this._mainHashShared = true;
        this._mainNamesShared = true;
        this._collListShared = true;
    }

    public int size() {
        return this._count;
    }

    public boolean maybeDirty() {
        return !this._mainHashShared;
    }

    public static Name getEmptyName() {
        return Name1.getEmptyName();
    }

    public Name findName(int n) {
        Object object;
        int n2 = BytesToNameCanonicalizer.calcHash(n);
        int n3 = n2 & this._mainHashMask;
        int n4 = this._mainHash[n3];
        if ((n4 >> 8 ^ n2) << 8 == 0) {
            object = this._mainNames[n3];
            if (object == null) {
                return null;
            }
            if (((Name)object).equals(n)) {
                return object;
            }
        } else if (n4 == 0) {
            return null;
        }
        if ((n4 &= 0xFF) > 0 && (object = this._collList[--n4]) != null) {
            return ((Bucket)object).find(n2, n, 0);
        }
        return null;
    }

    public Name findName(int n, int n2) {
        Object object;
        int n3 = BytesToNameCanonicalizer.calcHash(n, n2);
        int n4 = n3 & this._mainHashMask;
        int n5 = this._mainHash[n4];
        if ((n5 >> 8 ^ n3) << 8 == 0) {
            object = this._mainNames[n4];
            if (object == null) {
                return null;
            }
            if (((Name)object).equals(n, n2)) {
                return object;
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 &= 0xFF) > 0 && (object = this._collList[--n5]) != null) {
            return ((Bucket)object).find(n3, n, n2);
        }
        return null;
    }

    public Name findName(int[] nArray, int n) {
        Object object;
        int n2 = BytesToNameCanonicalizer.calcHash(nArray, n);
        int n3 = n2 & this._mainHashMask;
        int n4 = this._mainHash[n3];
        if ((n4 >> 8 ^ n2) << 8 == 0) {
            object = this._mainNames[n3];
            if (object == null || ((Name)object).equals(nArray, n)) {
                return object;
            }
        } else if (n4 == 0) {
            return null;
        }
        if ((n4 &= 0xFF) > 0 && (object = this._collList[--n4]) != null) {
            return ((Bucket)object).find(n2, nArray, n);
        }
        return null;
    }

    public Name addName(String string, int[] nArray, int n) {
        int n2 = BytesToNameCanonicalizer.calcHash(nArray, n);
        Name name = BytesToNameCanonicalizer.constructName(n2, string, nArray, n);
        this._addSymbol(n2, name);
        return name;
    }

    public static final int calcHash(int n) {
        int n2 = n;
        n2 ^= n2 >>> 16;
        n2 ^= n2 >>> 8;
        return n2;
    }

    public static final int calcHash(int n, int n2) {
        int n3 = n * 31 + n2;
        n3 ^= n3 >>> 16;
        n3 ^= n3 >>> 8;
        return n3;
    }

    public static final int calcHash(int[] nArray, int n) {
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            n2 = n2 * 31 + nArray[i];
        }
        n2 ^= n2 >>> 16;
        n2 ^= n2 >>> 8;
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[NameCanonicalizer, size: ");
        stringBuilder.append(this._count);
        stringBuilder.append('/');
        stringBuilder.append(this._mainHash.length);
        stringBuilder.append(", ");
        stringBuilder.append(this._collCount);
        stringBuilder.append(" coll; avg length: ");
        int n = this._count;
        for (int i = 0; i < this._collEnd; ++i) {
            int n2 = this._collList[i].length();
            for (int j = 1; j <= n2; ++j) {
                n += j;
            }
        }
        double d = this._count == 0 ? 0.0 : (double)n / (double)this._count;
        stringBuilder.append(d);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private void _addSymbol(int n, Name name) {
        int n2;
        int n3;
        if (this._mainHashShared) {
            this.unshareMain();
        }
        if (this._needRehash) {
            this.rehash();
        }
        ++this._count;
        int n4 = n & this._mainHashMask;
        if (this._mainNames[n4] == null) {
            this._mainHash[n4] = n << 8;
            if (this._mainNamesShared) {
                this.unshareNames();
            }
            this._mainNames[n4] = name;
        } else {
            if (this._collListShared) {
                this.unshareCollision();
            }
            ++this._collCount;
            n3 = this._mainHash[n4];
            n2 = n3 & 0xFF;
            if (n2 == 0) {
                if (this._collEnd <= 254) {
                    if ((n2 = this._collEnd++) >= this._collList.length) {
                        this.expandCollision();
                    }
                } else {
                    n2 = this.findBestBucket();
                }
                this._mainHash[n4] = n3 & 0xFFFFFF00 | n2 + 1;
            } else {
                --n2;
            }
            this._collList[n2] = new Bucket(name, this._collList[n2]);
        }
        n3 = this._mainHash.length;
        if (this._count > n3 >> 1) {
            n2 = n3 >> 2;
            if (this._count > n3 - n2) {
                this._needRehash = true;
            } else if (this._collCount >= n2) {
                this._needRehash = true;
            }
        }
    }

    private void rehash() {
        int n;
        Bucket[] bucketArray;
        int n2;
        this._needRehash = false;
        this._mainNamesShared = false;
        int n3 = 0;
        int[] nArray = this._mainHash;
        int n4 = nArray.length;
        this._mainHash = new int[n4 + n4];
        this._mainHashMask = n4 + n4 - 1;
        Name[] nameArray = this._mainNames;
        this._mainNames = new Name[n4 + n4];
        for (n2 = 0; n2 < n4; ++n2) {
            bucketArray = nameArray[n2];
            if (bucketArray == null) continue;
            ++n3;
            n = bucketArray.hashCode();
            int n5 = n & this._mainHashMask;
            this._mainNames[n5] = bucketArray;
            this._mainHash[n5] = n << 8;
        }
        n2 = this._collEnd;
        if (n2 == 0) {
            return;
        }
        this._collCount = 0;
        this._collEnd = 0;
        this._collListShared = false;
        bucketArray = this._collList;
        this._collList = new Bucket[bucketArray.length];
        for (n = 0; n < n2; ++n) {
            Bucket bucket = bucketArray[n];
            while (bucket != null) {
                ++n3;
                Name name = bucket.mName;
                int n6 = name.hashCode();
                int n7 = n6 & this._mainHashMask;
                int n8 = this._mainHash[n7];
                if (this._mainNames[n7] == null) {
                    this._mainHash[n7] = n6 << 8;
                    this._mainNames[n7] = name;
                } else {
                    ++this._collCount;
                    int n9 = n8 & 0xFF;
                    if (n9 == 0) {
                        if (this._collEnd <= 254) {
                            if ((n9 = this._collEnd++) >= this._collList.length) {
                                this.expandCollision();
                            }
                        } else {
                            n9 = this.findBestBucket();
                        }
                        this._mainHash[n7] = n8 & 0xFFFFFF00 | n9 + 1;
                    } else {
                        --n9;
                    }
                    this._collList[n9] = new Bucket(name, this._collList[n9]);
                }
                bucket = bucket.mNext;
            }
        }
        if (n3 != this._count) {
            throw new RuntimeException("Internal error: count after rehash " + n3 + "; should be " + this._count);
        }
    }

    private int findBestBucket() {
        Bucket[] bucketArray = this._collList;
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        int n3 = this._collEnd;
        for (int i = 0; i < n3; ++i) {
            int n4 = bucketArray[i].length();
            if (n4 >= n) continue;
            if (n4 == 1) {
                return i;
            }
            n = n4;
            n2 = i;
        }
        return n2;
    }

    private void unshareMain() {
        int[] nArray = this._mainHash;
        int n = this._mainHash.length;
        this._mainHash = new int[n];
        System.arraycopy(nArray, 0, this._mainHash, 0, n);
        this._mainHashShared = false;
    }

    private void unshareCollision() {
        Bucket[] bucketArray = this._collList;
        if (bucketArray == null) {
            this._collList = new Bucket[32];
        } else {
            int n = bucketArray.length;
            this._collList = new Bucket[n];
            System.arraycopy(bucketArray, 0, this._collList, 0, n);
        }
        this._collListShared = false;
    }

    private void unshareNames() {
        Name[] nameArray = this._mainNames;
        int n = nameArray.length;
        this._mainNames = new Name[n];
        System.arraycopy(nameArray, 0, this._mainNames, 0, n);
        this._mainNamesShared = false;
    }

    private void expandCollision() {
        Bucket[] bucketArray = this._collList;
        int n = bucketArray.length;
        this._collList = new Bucket[n + n];
        System.arraycopy(bucketArray, 0, this._collList, 0, n);
    }

    public static Name constructName(int n, String string, int n2, int n3) {
        string = InternCache.instance.intern(string);
        if (n3 == 0) {
            return new Name1(string, n, n2);
        }
        return new Name2(string, n, n2, n3);
    }

    public static Name constructName(int n, String string, int[] nArray, int n2) {
        string = InternCache.instance.intern(string);
        if (n2 < 4) {
            switch (n2) {
                case 1: {
                    return new Name1(string, n, nArray[0]);
                }
                case 2: {
                    return new Name2(string, n, nArray[0], nArray[1]);
                }
                case 3: {
                    return new Name3(string, n, nArray[0], nArray[1], nArray[2]);
                }
            }
        }
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i];
        }
        return new NameN(string, n, nArray2, n2);
    }

    static final class Bucket {
        final Name mName;
        final Bucket mNext;

        Bucket(Name name, Bucket bucket) {
            this.mName = name;
            this.mNext = bucket;
        }

        public int length() {
            int n = 1;
            Bucket bucket = this.mNext;
            while (bucket != null) {
                ++n;
                bucket = bucket.mNext;
            }
            return n;
        }

        public Name find(int n, int n2, int n3) {
            if (this.mName.hashCode() == n && this.mName.equals(n2, n3)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                Name name = bucket.mName;
                if (name.hashCode() == n && name.equals(n2, n3)) {
                    return name;
                }
                bucket = bucket.mNext;
            }
            return null;
        }

        public Name find(int n, int[] nArray, int n2) {
            if (this.mName.hashCode() == n && this.mName.equals(nArray, n2)) {
                return this.mName;
            }
            Bucket bucket = this.mNext;
            while (bucket != null) {
                Name name = bucket.mName;
                if (name.hashCode() == n && name.equals(nArray, n2)) {
                    return name;
                }
                bucket = bucket.mNext;
            }
            return null;
        }
    }
}

