/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.office;

import writer2latex.office.ListStyle;
import writer2latex.util.Misc;

public class ListCounter {
    private int[] nCounter = new int[11];
    private String[] sNumFormat = new String[11];
    private ListStyle style;
    private int nLevel = 1;

    public ListCounter(ListStyle style) {
        this.style = style;
        int i = 1;
        while (i <= 10) {
            this.sNumFormat[i] = style.getLevelProperty(i, "style:num-format");
            ++i;
        }
    }

    public ListCounter step(int nLevel) {
        int n = nLevel;
        this.nCounter[n] = this.nCounter[n] + 1;
        if (nLevel < 10) {
            this.nCounter[nLevel + 1] = 0;
        }
        this.nLevel = nLevel;
        return this;
    }

    public String getLabel() {
        if (this.sNumFormat[this.nLevel] == null) {
            return "*";
        }
        int nLevels = Misc.getPosInteger(this.style.getLevelProperty(this.nLevel, "text:display-levels"), 1);
        String sPrefix = this.style.getLevelProperty(this.nLevel, "style:num-prefix");
        String sSuffix = this.style.getLevelProperty(this.nLevel, "style:num-suffix");
        String sLabel = "";
        if (sPrefix != null) {
            sLabel = sLabel + sPrefix;
        }
        int j = this.nLevel - nLevels + 1;
        while (j < this.nLevel) {
            sLabel = sLabel + this.formatNumber(this.nCounter[j], this.sNumFormat[j], true) + ".";
            ++j;
        }
        sLabel = sLabel + this.formatNumber(this.nCounter[this.nLevel], this.sNumFormat[this.nLevel], true);
        if (sSuffix != null) {
            sLabel = sLabel + sSuffix;
        }
        return sLabel;
    }

    private String formatNumber(int number, String sStyle, boolean bLetterSync) {
        if ("a".equals(sStyle)) {
            return Misc.int2alph(number, bLetterSync);
        }
        if ("A".equals(sStyle)) {
            return Misc.int2Alph(number, bLetterSync);
        }
        if ("i".equals(sStyle)) {
            return Misc.int2roman(number);
        }
        if ("I".equals(sStyle)) {
            return Misc.int2Roman(number);
        }
        if ("1".equals(sStyle)) {
            return Misc.int2arabic(number);
        }
        return "";
    }
}

