/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.viewer;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourcesViewer;
import org.graalvm.visualvm.gotosource.viewer.Bundle;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.openide.awt.Mnemonics;
import org.openide.util.NbPreferences;

public final class RegisteredSourcesViewer
extends SourcesViewer {
    private static final Logger LOGGER = Logger.getLogger(RegisteredSourcesViewer.class.getName());
    private static final String ID = "RegisteredSourcesViewer";
    private static final String PROP_MODE = "prop_RegisteredSourcesViewer_mode";
    private static final boolean DEFAULT_MODE = Boolean.FALSE;
    private JPanel settingsPanel;
    private JRadioButton openChoice;
    private JRadioButton editChoice;

    public RegisteredSourcesViewer() {
        super(ID, Bundle.RegisteredSourcesViewer_Name(), Bundle.RegisteredSourcesViewer_Description());
    }

    @Override
    public boolean open(SourceHandle handle) {
        try {
            if (this.isEdit()) {
                Desktop.getDesktop().edit(new File(handle.getSourceFile()));
            } else {
                Desktop.getDesktop().open(new File(handle.getSourceFile()));
            }
        }
        catch (IOException ex) {
            ProfilerDialogs.displayError((String)Bundle.RegisteredSourcesViewer_CommandFailed(ex.getMessage()));
            LOGGER.log(Level.INFO, "Failed to open source " + handle.getSourceFile(), ex);
        }
        return true;
    }

    @Override
    public void loadSettings() {
        if (this.settingsPanel != null) {
            boolean edit = this.isEdit();
            this.openChoice.setSelected(!edit);
            this.editChoice.setSelected(edit);
        }
    }

    @Override
    public void saveSettings() {
        if (this.settingsPanel != null) {
            this.saveEdit(this.editChoice.isSelected());
        }
    }

    @Override
    public boolean settingsDirty() {
        return this.settingsPanel != null && this.isEdit() != this.editChoice.isSelected();
    }

    private void saveEdit(boolean edit) {
        NbPreferences.forModule(RegisteredSourcesViewer.class).putBoolean(PROP_MODE, edit);
    }

    private boolean isEdit() {
        return NbPreferences.forModule(RegisteredSourcesViewer.class).getBoolean(PROP_MODE, DEFAULT_MODE);
    }

    @Override
    public JComponent getSettingsComponent() {
        if (this.settingsPanel == null) {
            this.settingsPanel = new JPanel(null);
            this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 2));
            this.settingsPanel.setOpaque(false);
            int tab = 15;
            int gap = 5;
            JLabel modeCaption = new JLabel();
            Mnemonics.setLocalizedText((JLabel)modeCaption, (String)Bundle.RegisteredSourcesViewer_ModeLabel());
            this.settingsPanel.add(modeCaption);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            this.openChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.openChoice, (String)Bundle.RegisteredSourcesViewer_OpenChoice());
            this.settingsPanel.add(this.openChoice);
            this.settingsPanel.add(Box.createHorizontalStrut(gap));
            this.editChoice = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.editChoice, (String)Bundle.RegisteredSourcesViewer_EditChoice());
            this.settingsPanel.add(this.editChoice);
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.openChoice);
            bg.add(this.editChoice);
            boolean edit = this.isEdit();
            this.openChoice.setSelected(!edit);
            this.editChoice.setSelected(edit);
        }
        return this.settingsPanel;
    }
}

