package TDS::Admin::TdfEditor;
# $Id: TdfEditor.pm,v 1.18.8.1 2001/02/20 12:15:05 tom Exp $
################################################################

=head1 NAME

TDS::Tdf::TdfEditor - editing tdf files on web

=cut

################################################################

use strict;

use vars qw(@ISA
	    $DayChangeOffset $LogFile);
use TDS::Admin::Editor;

@ISA = qw(TDS::Admin::Editor);

use File::Basename;
use File::Copy;
use File::Path;

use JConv;
use DateTime::Date;

use TDS;
use TDS::System;
use TDS::Status;
use TDS::Collection;
use TDS::DirInfo;

$DayChangeOffset = 4;

attributes qw(date);

################################################################
sub initialize($)
{
    my $self = shift;

    $self->type('tdf');
    $self->ext('tdf');
    $self->date(new DateTime::Date);
    $self->date->SetTime(time(), $TDS::System::TZ);
    if ($TDS::Status->start_time->hour <= $DayChangeOffset){
	$self->date->Decrement('1D');
    }
    $self->SUPER::initialize;
}

sub AsDateLoadForm
{
    my $self = shift;
#    return qq(<input type="input" name="date" size=20 value=$date_str>
#	      <input type="submit" name="load" value="Load">);
    my $form;
    # year
    $form .= qq(<select name="year">\n);
    for ($TDS::Status->start_year..$TDS::Status->start_time->year){
	my $selected;
	$selected = "selected" if $_ == $self->date->year;
	$form .= qq(<option value="$_" $selected>$_);
    }
    $form .= qq(</select>);
    # month
    $form .= qq(<select name="month">\n);
    for (1..12){
	my $selected;
	$selected = "selected" if $_ == $self->date->month;
	$form .= qq(<option value="$_" $selected>$_);
    }
    $form .= qq(</select>);
    # day
    $form .= qq(<select name="day">\n);
    for (1..31){ # $self->date->DaysMonth){
	my $selected;
	$selected = "selected" if $_ == $self->date->day;
	$form .= qq(<option value="$_" $selected>$_);
    }
    $form .= qq(</select>);

    $form .= qq(<input type="submit" name="command" value="Load">\n);

    return $form;
}

################################################################
sub AdditionalCommandHeader
{
    my $self = shift;

    return sprintf("DATE %s\n", $self->get_ymd);
}
sub ShowContent($$)
{
    my ($self, $body) = @_;

    require TDS::Tdf::Parser;
    my $parser = new TDS::Tdf::Parser;
    for (split(/\n/, $body)){
	$parser->Parse("$_\n");
    }
    my $params = $self->date->GetParams;
    print $parser->top->AsHTML($params);
}
sub AdditionalLogComment($)
{
    my $self = shift;
    return $self->get_ymd;
}

################################################################
sub GetTypeDir($)
{
    my $self = shift;
    
    return sprintf("%04d/%02d", $self->date->year, $self->date->month);
}
sub GetKindBasename ($)
{
    my $self = shift;

    return sprintf("%02d", $self->date->day);
}
################################################################
sub get_ymd($)
{
    my $self = shift;
    return sprintf("%04d%02d%02d",
		   $self->date->year,
		   $self->date->month,
		   $self->date->day);
}

1;


