package TDS::Admin::AuthorID;

use strict;
use vars qw(@ISA);

use ObjectTemplate;

use TDS::DirInfo;

@ISA = qw(ObjectTemplate);

attributes qw();
################################################################

sub IsAuthor($$)
{
    my ($self, $id) = @_;
    
    my $filename = GetConfFilename('author_id.txt');
    my %hash;
    if (open(F, $filename)){
	while (<F>){
	    next if /^$/ || /^\#/;
	    chomp;
	    $hash{$_}++;
	}
	close (F);
	return $hash{$id};
    } else {
	return 0;
    }
}
sub Add($$)
{
    my ($self, $id) = @_;

    my $datafile = "author_id.txt";

    require TDS::Admin::WriteServer::Selector;
    
    my $write_server =
	new TDS::Admin::WriteServer::Selector(type=>'conf',
					      kind=>'author_id',
					      ext=>'txt');
    # read original author_id.txt
    my $line;
    if (open(F, GetConfFilename($datafile))){
	$line = join('', <F>);
	close F;
    }
    # add to line
    $line .= "$id\n";
    
    $write_server->Write($line);
}
sub AsForm ($)
{
    my $self = shift;
    
    if ($TDS::Status->is_author){
	print "allready author";
	exit;
    }
    require TDS::Admin::Skelton;    
    my $skelton = new TDS::Admin::Skelton;
    $skelton->skelton
	(qq(<html><head><title><!--#macro cmd="TITLE" --></title></head>
	    <body><h1><!--#macro cmd="TITLE" --></h1>
	    current cookie ID: <!--#macro cmd="COOKIE_ID" -->
	    <form action="add_author_id.cgi" method="post">
	    <!--#macro cmd="INPUT_PASSWORD" -->
	    <hr>
	    <input type="submit" name="command" value="save">
	    <input type="reset" value="reset">
	    </form>
	    </body></html>));
        
    $skelton->SetMacro("TITLE", "Add This Cookie to AuthorID");
    $skelton->SetMacro("COOKIE_ID", $TDS::Status->id->GetID);
    return$skelton->AsHTML;
}
1;
