/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JColorChooser;

public class RColorButton
extends JButton {
    private static final long serialVersionUID = 1L;
    public static final String COLOR_CHANGED_PROPERTY = "RColorButton.colorChanged";

    public RColorButton(Color color) {
        this(color, 40, 12);
    }

    public RColorButton(Color color, int width, int height) {
        this.setMargin(new Insets(5, 5, 5, 5));
        this.setIcon(new ColorIcon(color, width, height));
        this.setDisabledIcon(new ColorIcon(color.darker(), width, height));
        this.addActionListener(this.createActionListener());
    }

    public ActionListener createActionListener() {
        return new RColorButtonActionListener();
    }

    public Color getColor() {
        return ((ColorIcon)this.getIcon()).color;
    }

    public void setColor(Color color) {
        Color oldColor = this.getColor();
        if (color != null && !color.equals(oldColor)) {
            ColorIcon oldIcon = (ColorIcon)this.getIcon();
            int width = oldIcon.getIconWidth();
            int height = oldIcon.getIconHeight();
            this.setIcon(new ColorIcon(color, width, height));
            this.setDisabledIcon(new ColorIcon(color.darker(), width, height));
            this.firePropertyChange(COLOR_CHANGED_PROPERTY, oldColor, color);
        }
    }

    protected class RColorButtonActionListener
    implements ActionListener {
        protected RColorButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Color chosenColor = JColorChooser.showDialog(RColorButton.this, "Pick a Color", RColorButton.this.getColor());
            if (chosenColor != null) {
                RColorButton.this.setColor(chosenColor);
            }
        }
    }

    protected static class ColorIcon
    implements Icon {
        Color color;
        int width;
        int height;

        public ColorIcon(Color color, int width, int height) {
            this.color = color;
            this.width = width;
            this.height = height;
        }

        public Color getColor() {
            return this.color;
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.color != null) {
                g.setColor(this.color);
                g.fillRect(x, y, this.width, this.height);
            }
        }
    }
}

