/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.Mode;

public class ModeMenuItem
extends JPanel {
    private JRadioButton _btnDefault;
    private JRadioButton _btnZoomPrint;
    private JRadioButton _btnQueryBuilder;
    private ActionListener _actionListener;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ModeMenuItem.class);

    public ModeMenuItem(ActionListener actionListener) {
        super(new GridLayout(1, 3));
        this._actionListener = actionListener;
        ButtonGroup bg = new ButtonGroup();
        this._btnDefault = new JRadioButton(Mode.DEFAULT.toString());
        bg.add(this._btnDefault);
        this.add(this._btnDefault);
        this._btnDefault.setSelected(true);
        this._btnZoomPrint = new JRadioButton(Mode.ZOOM_PRINT.toString());
        bg.add(this._btnZoomPrint);
        this.add(this._btnZoomPrint);
        this._btnQueryBuilder = new JRadioButton(Mode.QUERY_BUILDER.toString());
        bg.add(this._btnQueryBuilder);
        this.add(this._btnQueryBuilder);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModeMenuItem.this.onModeChanged(e);
            }
        };
        this._btnDefault.addActionListener(l);
        this._btnZoomPrint.addActionListener(l);
        this._btnQueryBuilder.addActionListener(l);
    }

    private void onModeChanged(ActionEvent e) {
        this._actionListener.actionPerformed(new ActionEvent(this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
    }

    public void setMode(Mode mode) {
        if (Mode.DEFAULT == mode) {
            this._btnDefault.setSelected(true);
        } else if (Mode.ZOOM_PRINT == mode) {
            this._btnZoomPrint.setSelected(true);
        } else if (Mode.QUERY_BUILDER == mode) {
            this._btnQueryBuilder.setSelected(true);
        }
    }

    public boolean isZoomPrint() {
        return this._btnZoomPrint.isSelected();
    }

    public boolean isDefault() {
        return this._btnDefault.isSelected();
    }

    public boolean isQueryBuilder() {
        return this._btnQueryBuilder.isSelected();
    }

    public Mode getMode() {
        if (this._btnDefault.isSelected()) {
            return Mode.DEFAULT;
        }
        if (this._btnZoomPrint.isSelected()) {
            return Mode.ZOOM_PRINT;
        }
        if (this._btnQueryBuilder.isSelected()) {
            return Mode.QUERY_BUILDER;
        }
        throw new IllegalStateException("No mode");
    }
}

