/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jtransforms.dct;

import edu.emory.mathcs.jtransforms.dct.DoubleDCT_1D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_2D;
import edu.emory.mathcs.jtransforms.dct.DoubleDCT_3D;
import edu.emory.mathcs.utils.IOUtils;

public class AccuracyCheckDoubleDCT {
    private AccuracyCheckDoubleDCT() {
    }

    public static void checkAccuracyDCT_1D(int n, int n2) {
        System.out.println("Checking accuracy of 1D DCT...");
        for (int i = 0; i < n2; ++i) {
            int n3 = n + i;
            int n4 = (int)Math.pow(2.0, n3);
            DoubleDCT_1D doubleDCT_1D = new DoubleDCT_1D(n4);
            double d = 0.0;
            double[] dArray = new double[n4];
            IOUtils.fillMatrix_1D(n4, dArray);
            double[] dArray2 = new double[n4];
            IOUtils.fillMatrix_1D(n4, dArray2);
            doubleDCT_1D.forward(dArray, true);
            doubleDCT_1D.inverse(dArray, true);
            for (int j = 0; j < n4; ++j) {
                double d2 = Math.abs(dArray2[j] - dArray[j]);
                d = Math.max(d, d2);
            }
            if (d > 1.0E-10) {
                System.err.println("\tsize = 2^" + n3 + ";\terror = " + d);
            } else {
                System.out.println("\tsize = 2^" + n3 + ";\terror = " + d);
            }
            dArray = null;
            dArray2 = null;
            doubleDCT_1D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDCT_2D(int n, int n2) {
        double d;
        int n3;
        Object object;
        Object object2;
        double d2;
        DoubleDCT_2D doubleDCT_2D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 2D DCT (double[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDCT_2D = new DoubleDCT_2D(n4, n4);
            d2 = 0.0;
            object2 = new double[n4 * n4];
            IOUtils.fillMatrix_2D(n4, n4, object2);
            object = new double[n4 * n4];
            IOUtils.fillMatrix_2D(n4, n4, object);
            doubleDCT_2D.forward((double[])object2, true);
            doubleDCT_2D.inverse((double[])object2, true);
            for (n3 = 0; n3 < n4 * n4; ++n3) {
                d = Math.abs(object[n3] - object2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDCT_2D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 2D DCT (double[][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDCT_2D = new DoubleDCT_2D(n4, n4);
            d2 = 0.0;
            object2 = new double[n4][n4];
            IOUtils.fillMatrix_2D(n4, n4, (double[][])object2);
            object = new double[n4][n4];
            IOUtils.fillMatrix_2D(n4, n4, (double[][])object);
            doubleDCT_2D.forward((double[][])object2, true);
            doubleDCT_2D.inverse((double[][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    d = Math.abs((double)(object[n3][i] - object2[n3][i]));
                    d2 = Math.max(d2, d);
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + ";\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDCT_2D = null;
            System.gc();
        }
    }

    public static void checkAccuracyDCT_3D(int n, int n2) {
        double d;
        int n3;
        Object object;
        Object object2;
        double d2;
        DoubleDCT_3D doubleDCT_3D;
        int n4;
        int n5;
        int n6;
        System.out.println("Checking accuracy of 3D DCT (double[] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDCT_3D = new DoubleDCT_3D(n4, n4, n4);
            d2 = 0.0;
            object2 = new double[n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, object2);
            object = new double[n4 * n4 * n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, object);
            doubleDCT_3D.forward((double[])object2, true);
            doubleDCT_3D.inverse((double[])object2, true);
            for (n3 = 0; n3 < n4 * n4 * n4; ++n3) {
                d = Math.abs(object[n3] - object2[n3]);
                d2 = Math.max(d2, d);
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDCT_3D = null;
            System.gc();
        }
        System.out.println("Checking accuracy of 3D DCT (double[][][] input)...");
        for (n6 = 0; n6 < n2; ++n6) {
            n5 = n + n6;
            n4 = (int)Math.pow(2.0, n5);
            doubleDCT_3D = new DoubleDCT_3D(n4, n4, n4);
            d2 = 0.0;
            object2 = new double[n4][n4][n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, (double[][][])object2);
            object = new double[n4][n4][n4];
            IOUtils.fillMatrix_3D(n4, n4, n4, (double[][][])object);
            doubleDCT_3D.forward((double[][][])object2, true);
            doubleDCT_3D.inverse((double[][][])object2, true);
            for (n3 = 0; n3 < n4; ++n3) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        d = Math.abs((double)(object[n3][i][j] - object2[n3][i][j]));
                        d2 = Math.max(d2, d);
                    }
                }
            }
            if (d2 > 1.0E-10) {
                System.err.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            } else {
                System.out.println("\tsize = 2^" + n5 + " x 2^" + n5 + " x 2^" + n5 + ";\t\terror = " + d2);
            }
            object2 = null;
            object = null;
            doubleDCT_3D = null;
            System.gc();
        }
    }

    public static void main(String[] stringArray) {
        AccuracyCheckDoubleDCT.checkAccuracyDCT_1D(0, 21);
        AccuracyCheckDoubleDCT.checkAccuracyDCT_2D(1, 11);
        AccuracyCheckDoubleDCT.checkAccuracyDCT_3D(1, 7);
        System.exit(0);
    }
}

