/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio;

import gnu.java.net.PlainDatagramSocketImpl;
import gnu.java.nio.NIODatagramSocket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;

public final class DatagramChannelImpl
extends DatagramChannel {
    private NIODatagramSocket socket = new NIODatagramSocket(new PlainDatagramSocketImpl(), this);
    private boolean inChannelOperation;

    public final boolean isInChannelOperation() {
        return this.inChannelOperation;
    }

    public final void setInChannelOperation(boolean b) {
        this.inChannelOperation = b;
    }

    public final DatagramSocket socket() {
        return this.socket;
    }

    protected final void implCloseSelectableChannel() throws IOException {
        this.socket.close();
    }

    protected final void implConfigureBlocking(boolean blocking) throws IOException {
        this.socket.setSoTimeout(blocking ? 0 : 50);
    }

    public final DatagramChannel connect(SocketAddress remote) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        this.socket.connect(remote);
        return this;
    }

    public final DatagramChannel disconnect() throws IOException {
        this.socket.disconnect();
        return this;
    }

    public final boolean isConnected() {
        return this.socket.isConnected();
    }

    public final int write(ByteBuffer src) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        return this.send(src, this.socket.getRemoteSocketAddress());
    }

    public final long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > srcs.length || length < 0 || length > srcs.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long result = 0L;
        int index = offset;
        while (index < offset + length) {
            result += (long)this.write(srcs[index]);
            ++index;
        }
        return result;
    }

    public final int read(ByteBuffer dst) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        int remaining = dst.remaining();
        this.receive(dst);
        return remaining - dst.remaining();
    }

    public final long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        if (!this.isConnected()) {
            throw new NotYetConnectedException();
        }
        if (offset < 0 || offset > dsts.length || length < 0 || length > dsts.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        long result = 0L;
        int index = offset;
        while (index < offset + length) {
            result += (long)this.read(dsts[index]);
            ++index;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final SocketAddress receive(ByteBuffer dst) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        try {
            int len = dst.capacity() - dst.position();
            DatagramPacket packet = dst.hasArray() ? new DatagramPacket(dst.array(), dst.arrayOffset() + dst.position(), len) : new DatagramPacket(new byte[len], len);
            boolean completed = false;
            try {
                this.begin();
                this.setInChannelOperation(true);
                this.socket.receive(packet);
                completed = true;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.end(completed);
                this.setInChannelOperation(false);
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            this.end(completed);
            this.setInChannelOperation(false);
            if (!dst.hasArray()) {
                dst.put(packet.getData(), packet.getOffset(), packet.getLength());
                return packet.getSocketAddress();
            }
            dst.position(dst.position() + packet.getLength());
            return packet.getSocketAddress();
        }
        catch (SocketTimeoutException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final int send(ByteBuffer src, SocketAddress target) throws IOException {
        byte[] buffer;
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (target instanceof InetSocketAddress && ((InetSocketAddress)target).isUnresolved()) {
            throw new IOException("Target address not resolved");
        }
        int offset = 0;
        int len = src.remaining();
        if (src.hasArray()) {
            buffer = src.array();
            offset = src.arrayOffset() + src.position();
        } else {
            buffer = new byte[len];
            src.get(buffer);
        }
        DatagramPacket packet = new DatagramPacket(buffer, offset, len, target);
        boolean completed = false;
        try {
            this.begin();
            this.setInChannelOperation(true);
            this.socket.send(packet);
            completed = true;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.end(completed);
            this.setInChannelOperation(false);
            throw throwable;
        }
        {
            Object var9_10 = null;
        }
        this.end(completed);
        this.setInChannelOperation(false);
        if (src.hasArray()) {
            src.position(src.position() + len);
        }
        return len;
    }

    protected DatagramChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.configureBlocking(true);
    }
}

