/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationAdapter;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.WatchedRootsProvider;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.roots.impl.ModuleRootEventImpl;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.ex.VirtualFileManagerAdapter;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ProjectRootManagerComponent
extends ProjectRootManagerImpl
implements ProjectComponent,
Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectRootManagerComponent.class);
    private static final boolean LOG_CACHES_UPDATE = ApplicationManager.getApplication().isInternal() && !ApplicationManager.getApplication().isUnitTestMode();
    private boolean myPointerChangesDetected;
    private int myInsideRefresh;
    private final BatchUpdateListener myHandler;
    private final MessageBusConnection myConnection;
    @NotNull
    private Set<LocalFileSystem.WatchRequest> myRootsToWatch = new THashSet();
    private Disposable myRootPointersDisposable = Disposer.newDisposable();
    private final VirtualFilePointerListener myRootsChangedListener = new VirtualFilePointerListener(){

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                4.$$$reportNull$$$0(0);
            }
            if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                return;
            }
            if (ProjectRootManagerComponent.this.myInsideRefresh == 0) {
                ProjectRootManagerComponent.this.beforeRootsChange(false);
                if (LOG_CACHES_UPDATE || LOG.isDebugEnabled()) {
                    LOG.debug(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                }
            } else if (!ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = true;
                ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                if (LOG_CACHES_UPDATE || LOG.isDebugEnabled()) {
                    LOG.debug(new Throwable(pointers.length > 0 ? pointers[0].getPresentableUrl() : ""));
                }
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                4.$$$reportNull$$$0(1);
            }
            if (ProjectRootManagerComponent.this.myProject.isDisposed()) {
                return;
            }
            if (ProjectRootManagerComponent.this.myInsideRefresh > 0) {
                ProjectRootManagerComponent.this.clearScopesCaches();
            } else {
                ProjectRootManagerComponent.this.rootsChanged(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "pointers";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$4";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeValidityChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validityChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ProjectRootManagerComponent(Project project, StartupManager startupManager) {
        super(project);
        this.myConnection = project.getMessageBus().connect((Disposable)project);
        this.myConnection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProjectRootManagerComponent.this.beforeRootsChange(true);
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProjectRootManagerComponent.this.rootsChanged(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeFileTypesChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileTypesChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        VirtualFileManager.getInstance().addVirtualFileManagerListener((VirtualFileManagerListener)new VirtualFileManagerAdapter(){

            @Override
            public void afterRefreshFinish(boolean asynchronous) {
                ProjectRootManagerComponent.this.doUpdateOnRefresh();
            }
        }, (Disposable)project);
        if (!this.myProject.isDefault()) {
            startupManager.registerStartupActivity(() -> {
                this.myStartupActivityPerformed = true;
            });
        }
        this.myHandler = new BatchUpdateListener(){

            @Override
            public void onBatchUpdateStarted() {
                ProjectRootManagerComponent.this.myRootsChanged.levelUp();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelUp();
            }

            @Override
            public void onBatchUpdateFinished() {
                ProjectRootManagerComponent.this.myRootsChanged.levelDown();
                ProjectRootManagerComponent.this.myFileTypesChanged.levelDown();
            }
        };
    }

    public void initComponent() {
        this.myConnection.subscribe(BatchUpdateListener.TOPIC, (Object)this.myHandler);
    }

    public void projectOpened() {
        this.addRootsToWatch();
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new AppListener(), (Disposable)this.myProject);
    }

    public void projectClosed() {
        LocalFileSystem.getInstance().removeWatchedRoots(this.myRootsToWatch);
    }

    @Override
    protected void addRootsToWatch() {
        if (!this.myProject.isDefault()) {
            THashSet recursivePaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            THashSet flatPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
            this.collectWatchRoots((Set<String>)recursivePaths, (Set<String>)flatPaths);
            this.myRootsToWatch = LocalFileSystem.getInstance().replaceWatchedRoots(this.myRootsToWatch, (Collection)recursivePaths, (Collection)flatPaths);
        }
    }

    private void beforeRootsChange(boolean fileTypes) {
        if (this.myProject.isDisposed()) {
            return;
        }
        this.getBatchSession(fileTypes).beforeRootsChanged();
    }

    private void rootsChanged(boolean fileTypes) {
        this.getBatchSession(fileTypes).rootsChanged();
    }

    private void doUpdateOnRefresh() {
        if (ApplicationManager.getApplication().isUnitTestMode() && (!this.myStartupActivityPerformed || this.myProject.isDisposed())) {
            return;
        }
        if (this.myProject.isDefault()) {
            return;
        }
        if (LOG_CACHES_UPDATE || LOG.isDebugEnabled()) {
            LOG.debug("refresh");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        DumbModeTask task = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(this.myProject);
        if (task != null) {
            dumbService.queueTask(task);
        }
    }

    @Override
    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).beforeRootsChange((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    @Override
    protected void fireRootsChangedEvent(boolean fileTypes) {
        this.isFiringEvent = true;
        try {
            ((ModuleRootListener)this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(this.myProject, fileTypes));
        }
        finally {
            this.isFiringEvent = false;
        }
    }

    private void collectWatchRoots(Set<String> recursive, Set<String> flat) {
        Set toWatch;
        ApplicationManager.getApplication().assertIsDispatchThread();
        String projectFilePath = this.myProject.getProjectFilePath();
        if (projectFilePath != null) {
            File projectDirFile = new File(projectFilePath).getParentFile();
            if (projectDirFile.getName().equals(".idea")) {
                recursive.add(FileUtil.toSystemIndependentName((String)projectDirFile.getAbsolutePath()));
            } else {
                flat.add(FileUtil.toSystemIndependentName((String)projectFilePath));
                String wsFilePath = ProjectKt.getStateStore(this.myProject).getWorkspaceFilePath();
                if (wsFilePath != null) {
                    flat.add(FileUtil.toSystemIndependentName((String)wsFilePath));
                }
            }
        }
        for (AdditionalLibraryRootsProvider additionalLibraryRootsProvider : (AdditionalLibraryRootsProvider[])AdditionalLibraryRootsProvider.EP_NAME.getExtensions()) {
            toWatch = additionalLibraryRootsProvider.getRootsToWatch(this.myProject);
            if (toWatch.isEmpty()) continue;
            recursive.addAll(ContainerUtil.map(toWatch, VirtualFile::getPath));
        }
        for (WatchedRootsProvider watchedRootsProvider : (WatchedRootsProvider[])WatchedRootsProvider.EP_NAME.getExtensions((AreaInstance)this.myProject)) {
            toWatch = watchedRootsProvider.getRootsToWatch();
            if (toWatch.isEmpty()) continue;
            recursive.addAll(ContainerUtil.map((Collection)toWatch, FileUtil::toSystemIndependentName));
        }
        Disposable oldDisposable = this.myRootPointersDisposable;
        this.myRootPointersDisposable = Disposer.newDisposable();
        Disposer.register((Disposable)this, (Disposable)this.myRootPointersDisposable);
        VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(this.myRootPointersDisposable, this.getRootsValidityChangedListener());
        recursive.forEach(path -> container.addJarDirectory(VfsUtilCore.pathToUrl((String)path), true));
        flat.forEach(path -> container.add(VfsUtilCore.pathToUrl((String)path)));
        Disposer.dispose((Disposable)oldDisposable);
        this.collectModuleWatchRoots(recursive, flat);
    }

    private void collectModuleWatchRoots(Set<String> recursive, Set<String> flat) {
        THashSet urls = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            ContainerUtil.addAll((Collection)urls, (Object[])rootManager.getContentRootUrls());
            rootManager.orderEntries().withoutModuleSourceEntries().withoutDepModules().forEach(arg_0 -> ProjectRootManagerComponent.lambda$collectModuleWatchRoots$3((Set)urls, arg_0));
        }
        for (String url : urls) {
            String protocol = VirtualFileManager.extractProtocol((String)url);
            if (protocol == null || "file".equals(protocol)) {
                recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if ("jar".equals(protocol)) {
                flat.add(ProjectRootManagerComponent.extractLocalPath(url));
                continue;
            }
            if (!"jrt".equals(protocol)) continue;
            recursive.add(ProjectRootManagerComponent.extractLocalPath(url));
        }
    }

    @Override
    protected void doSynchronizeRoots() {
        if (!this.myStartupActivityPerformed) {
            return;
        }
        if (LOG_CACHES_UPDATE || LOG.isDebugEnabled()) {
            LOG.debug(new Throwable("sync roots"));
        } else if (!ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("project roots have changed");
        }
        DumbServiceImpl dumbService = DumbServiceImpl.getInstance(this.myProject);
        if (FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
            dumbService.queueTask(new UnindexedFilesUpdater(this.myProject));
        }
    }

    @Override
    protected void clearScopesCaches() {
        super.clearScopesCaches();
        LibraryScopeCache.getInstance(this.myProject).clear();
    }

    @Override
    public void clearScopesCachesForModules() {
        Module[] modules;
        super.clearScopesCachesForModules();
        for (Module module : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleEx)module).clearScopesCache();
        }
    }

    @Override
    public void markRootsForRefresh() {
        THashSet paths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
        this.collectModuleWatchRoots((Set<String>)paths, (Set<String>)paths);
        LocalFileSystem fs = LocalFileSystem.getInstance();
        for (String path : paths) {
            VirtualFile root = fs.findFileByPath(path);
            if (!(root instanceof NewVirtualFile)) continue;
            ((NewVirtualFile)root).markDirtyRecursively();
        }
    }

    public void dispose() {
        this.assertListenersAreDisposed();
    }

    @Override
    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myRootsChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerComponent.$$$reportNull$$$0(0);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ boolean lambda$collectModuleWatchRoots$3(Set urls, OrderEntry entry) {
        for (OrderRootType type : OrderRootType.getAllTypes()) {
            ContainerUtil.addAll((Collection)urls, (Object[])entry.getUrls(type));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectRootManagerComponent", "getRootsValidityChangedListener"));
    }

    private class AppListener
    extends ApplicationAdapter {
        private AppListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action) {
            if (action == null) {
                AppListener.$$$reportNull$$$0(0);
            }
            ProjectRootManagerComponent.this.myInsideRefresh++;
        }

        public void writeActionFinished(@NotNull Object action) {
            if (action == null) {
                AppListener.$$$reportNull$$$0(1);
            }
            if (--ProjectRootManagerComponent.this.myInsideRefresh == 0 && ProjectRootManagerComponent.this.myPointerChangesDetected) {
                ProjectRootManagerComponent.this.myPointerChangesDetected = false;
                ProjectRootManagerComponent.this.incModificationCount();
                ((ModuleRootListener)ProjectRootManagerComponent.this.myProject.getMessageBus().syncPublisher(ProjectTopics.PROJECT_ROOTS)).rootsChanged((ModuleRootEvent)new ModuleRootEventImpl(ProjectRootManagerComponent.this.myProject, false));
                ProjectRootManagerComponent.this.doSynchronizeRoots();
                ProjectRootManagerComponent.this.addRootsToWatch();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "action";
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerComponent$AppListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeWriteActionStart";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "writeActionFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

