/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.impl.AbstractUrl;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import org.jetbrains.annotations.NonNls;

public class NamedLibraryUrl
extends AbstractUrl {
    @NonNls
    private static final String ELEMENT_TYPE = "namedLibrary";

    public NamedLibraryUrl(String url, String moduleName) {
        super(url, moduleName, ELEMENT_TYPE);
    }

    @Override
    public Object[] createPath(Project project) {
        Module module;
        Module module2 = module = this.moduleName != null ? ModuleManager.getInstance((Project)project).findModuleByName(this.moduleName) : null;
        if (module == null) {
            return null;
        }
        for (OrderEntry orderEntry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) && (!(orderEntry instanceof JdkOrderEntry) || !orderEntry.getPresentableName().equals(this.url))) continue;
            return new Object[]{new NamedLibraryElement(module, (LibraryOrSdkOrderEntry)orderEntry)};
        }
        return null;
    }

    @Override
    protected AbstractUrl createUrl(String moduleName, String url) {
        return new NamedLibraryUrl(url, moduleName);
    }

    @Override
    public AbstractUrl createUrlByElement(Object element) {
        if (element instanceof NamedLibraryElement) {
            NamedLibraryElement libraryElement = (NamedLibraryElement)element;
            Module context = libraryElement.getModule();
            return new NamedLibraryUrl(libraryElement.getOrderEntry().getPresentableName(), context != null ? context.getName() : null);
        }
        return null;
    }
}

