/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;

public final class FileUtil {
    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(FileObject file) throws IOException {
        FileContent content = file.getContent();
        InputStream in = content.getInputStream();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int nRead;
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
        }
        finally {
            in.close();
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static void writeContent(FileObject file, OutputStream output) throws IOException {
        file.getContent().write(output);
    }

    public static void copyContent(FileObject srcFile, FileObject destFile) throws IOException {
        srcFile.getContent().write(destFile);
    }
}

