/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.UnfairLocalInspectionTool;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.CucumberBundle;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateAllStepsFix;
import org.jetbrains.plugins.cucumber.inspections.CucumberCreateStepFix;
import org.jetbrains.plugins.cucumber.inspections.GherkinInspection;
import org.jetbrains.plugins.cucumber.psi.GherkinElementVisitor;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.GherkinStepsHolder;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberStepInspection
extends GherkinInspection
implements UnfairLocalInspectionTool {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = CucumberBundle.message("cucumber.inspection.undefined.step.name", new Object[0]);
        if (string == null) {
            CucumberStepInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("CucumberUndefinedStep" == null) {
            CucumberStepInspection.$$$reportNull$$$0(1);
        }
        return "CucumberUndefinedStep";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CucumberStepInspection.$$$reportNull$$$0(2);
        }
        GherkinElementVisitor gherkinElementVisitor = new GherkinElementVisitor(){

            @Override
            public void visitStep(GherkinStep step) {
                super.visitStep(step);
                PsiElement parent = step.getParent();
                if (parent instanceof GherkinStepsHolder) {
                    PsiReference[] references = step.getReferences();
                    if (references.length != 1 || !(references[0] instanceof CucumberStepReference)) {
                        return;
                    }
                    CucumberStepReference reference = (CucumberStepReference)references[0];
                    AbstractStepDefinition definition = reference.resolveToDefinition();
                    if (definition == null) {
                        CucumberCreateStepFix createStepFix = null;
                        CucumberCreateAllStepsFix createAllStepsFix = null;
                        if (CucumberStepsIndex.getInstance(step.getProject()).getExtensionCount() > 0) {
                            createStepFix = new CucumberCreateStepFix();
                            createAllStepsFix = new CucumberCreateAllStepsFix();
                        }
                        holder.registerProblem(reference.getElement(), reference.getRangeInElement(), CucumberBundle.message("cucumber.inspection.undefined.step.msg.name", new Object[0]) + " #loc #ref", new LocalQuickFix[]{createStepFix, createAllStepsFix});
                    }
                }
            }
        };
        if (gherkinElementVisitor == null) {
            CucumberStepInspection.$$$reportNull$$$0(3);
        }
        return gherkinElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/cucumber/inspections/CucumberStepInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/cucumber/inspections/CucumberStepInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

