/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.async.ResultCallback;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import java.io.Closeable;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public abstract class StreamCallbackBase<T>
implements ResultCallback<T> {
    private final CloudAgentLogger myLogger;
    private final PipedInputStream myInputStream;
    private final PipedOutputStream myReverseOfInputStream;

    public StreamCallbackBase(CloudAgentLogger logger) throws IOException {
        this.myLogger = logger;
        this.myInputStream = new PipedInputStream();
        this.myReverseOfInputStream = new PipedOutputStream(this.myInputStream);
    }

    public PipedInputStream getInputStream() {
        return this.myInputStream;
    }

    protected PipedOutputStream getReverseOfInputStream() {
        return this.myReverseOfInputStream;
    }

    public void close() throws IOException {
        this.myReverseOfInputStream.close();
    }

    private void safeClose() {
        try {
            this.close();
        }
        catch (IOException e) {
            this.myLogger.debugEx((Exception)e);
        }
    }

    public void onStart(Closeable closeable) {
    }

    public void onNext(T packet) {
        try {
            this.onNextWrite(packet);
        }
        catch (IOException e) {
            this.myLogger.debugEx((Exception)e);
        }
    }

    public void onError(Throwable throwable) {
        this.myLogger.debugEx(new Exception(throwable));
        this.safeClose();
    }

    public void onComplete() {
        this.safeClose();
    }

    protected abstract void onNextWrite(T var1) throws IOException;
}

