/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.CommonBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.Dbms;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.actions.AddDataSourceFromPath;
import com.intellij.database.actions.AddDataSourceFromUrl;
import com.intellij.database.actions.DdlActions;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseArtifactManager;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DataSourceProblemsCollector;
import com.intellij.database.dataSource.validation.DataSourceProblemsProvider;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbDataSourceImpl;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.psi.DbPsiFacadeImpl;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.ui.DataSourceErrorsConfigurable;
import com.intellij.database.view.ui.DataSourceSidePanel;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.database.view.ui.SidePanelItem;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Progressive;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.SidePanelCountLabel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.navigation.BackAction;
import com.intellij.ui.navigation.ForwardAction;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectHashingStrategy;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DatabaseConfigEditorImpl
extends SettingsEditor<DataSourceSettings>
implements DatabaseConfigEditor,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance(DatabaseConfigEditorImpl.class);
    private final DatabaseCredentials myDatabaseCredentials;
    private final SimpleModificationTracker myModificationTracker;
    private final DataSourceSettings mySettings;
    private final JPanel myRootPanel;
    private final JPanel myRightPanel;
    private final Map<Object, SidePanelItem> mySidePanelItems;
    private final JPanel myInfoPanel;
    private SidePanelItem mySelectedItem;
    private DataSourceErrorsConfigurable myErrorsConfigurable;
    private final ValidationComponent myValidationComponent;
    private final ValidationComponent myErrorInfoComponent;
    private final DataSourceProblemsCollector<SidePanelItem> myErrorsCollector;
    private final List<Object> myRemovedObjects;
    private final UserDataHolderBase myUserDataHolder;
    private boolean myFilling;
    private History myHistory;
    private DataSourceSidePanel mySidePanel;
    private AddAction myAddAction;
    private List<Progressive> myOnApplyTasks;

    DatabaseConfigEditorImpl(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(0);
        }
        this.myDatabaseCredentials = DatabaseCredentials.newUIInstance();
        this.myModificationTracker = new SimpleModificationTracker();
        this.mySidePanelItems = ContainerUtil.newIdentityHashMap();
        this.myRemovedObjects = ContainerUtil.newArrayList();
        this.myUserDataHolder = new UserDataHolderBase();
        this.myFilling = false;
        this.myHistory = new History((Place.Navigator)this);
        int newDsAmount = settings.newDataSources.size();
        int newDrAmount = settings.newDrivers.size();
        if (newDsAmount > 10 || newDrAmount > 10) {
            LOG.info("Data Sources: " + newDsAmount + ", Drivers: " + newDrAmount);
        }
        this.mySettings = settings;
        this.myRootPanel = new MyRootPanel(new BorderLayout());
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout(0, 5));
        this.myValidationComponent = new ValidationComponent(false);
        this.myErrorInfoComponent = new ValidationComponent(true);
        this.myInfoPanel = new JPanel(new BorderLayout());
        this.myInfoPanel.add((Component)this.myErrorInfoComponent, "North");
        this.myInfoPanel.add((Component)this.myValidationComponent, "South");
        this.myErrorsConfigurable = new DataSourceErrorsConfigurable(this, () -> {
            Place place = this.getPlace(this.myErrorsConfigurable);
            this.mySidePanel.getList().invalidate();
            this.mySidePanel.getList().repaint();
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(place));
        });
        this.myErrorsCollector = new DataSourceProblemsCollector(this.myErrorsConfigurable);
        OnePixelSplitter mySplitter = new OnePixelSplitter(false, 0.3f);
        mySplitter.setFirstComponent(this.createLeftPanel());
        mySplitter.setSecondComponent((JComponent)this.myRightPanel);
        this.myRootPanel.add((Component)mySplitter, "Center");
        Dimension d2 = this.myRootPanel.getPreferredSize();
        d2.width = Math.max(d2.width, 800);
        d2.height = Math.max(d2.height, 600);
        this.myRootPanel.setPreferredSize(d2);
        this.putUserData(DataSourceConfigurable.DRIVER_VARIANTS_PROVIDER, dataSource -> this.getDrivers((JBIterable<LocalDataSource>)JBIterable.of((Object)dataSource)).toList());
        this.setSelectedEditor(null);
        this.resetTreeModel(settings);
        DatabaseArtifactManager.getInstance().checkForUpdates();
        DatabaseArtifactManager.getInstance().addListener((artifactName, artifactVersion) -> ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriver.ArtifactRef artifact;
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)driverItem.getConfigurable();
                DatabaseDriverImpl driver = configurable == null ? null : configurable.getTempDriver();
                DatabaseDriver.ArtifactRef artifactRef = artifact = driver == null ? null : driver.getArtifact();
                if (artifact != null && (artifactName == null || Comparing.equal((String)artifact.getName(), (String)artifactName) && Comparing.equal((String)artifact.getVersion(), (String)artifactVersion))) {
                    configurable.resetFromTemp();
                    DatabaseConfigEditorImpl.this.updateDriverDependants(driver);
                    driverItem.resetModifiedCache();
                }
                return true;
            }
        }), (Disposable)this);
        this.addSettingsEditorListener(e -> {
            this.stateChangedAsyncInner();
            this.updateSidePanelImpl();
        });
    }

    void updateDriverDependants(DatabaseDriver driver) {
        final DatabaseDriver actualDriver = (DatabaseDriver)this.getTempTargetOrTarget(driver).get();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                DatabaseDriver dataSourceDriver;
                LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                DatabaseDriver databaseDriver = dataSourceDriver = dataSource == null ? null : dataSource.getDatabaseDriver();
                if (dataSourceDriver != null && actualDriver == DatabaseConfigEditorImpl.this.getTempTargetOrTarget(dataSourceDriver).get()) {
                    AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)dataSourceItem.getConfigurable();
                    if (configurable != null) {
                        configurable.onUserActivity();
                    } else {
                        DatabaseConfigEditorImpl.createEditorIfNeeded(dataSourceItem);
                    }
                    DatabaseConfigEditorImpl.this.myErrorsCollector.update(dataSourceItem);
                }
                return true;
            }
        });
    }

    private void updateSidePanelImpl() {
        final SidePanelItem item = this.mySelectedItem;
        if (item == null) {
            return;
        }
        this.myErrorsCollector.update(item);
        this.updateValidationProblem(this.mySelectedItem);
        this.mySidePanel.getList().invalidate();
        this.mySidePanel.getList().repaint();
        if (item.getObject() instanceof DatabaseDriver) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dsItem) {
                    LocalDataSource source = dsItem.extractActualLocalDataSource();
                    if (source == null || source.getDatabaseDriver() != item.getObject()) {
                        return true;
                    }
                    DataSourceConfigurable conf = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(dsItem), DataSourceConfigurable.class);
                    if (conf != null) {
                        conf.actualizeDriver();
                    }
                    return true;
                }
            });
        }
    }

    private void stateChangedAsyncInner() {
        DatabaseDriverConfigurable driverConfigurable;
        AbstractDataSourceConfigurable dsConfigurable;
        if (this.myFilling) {
            return;
        }
        this.clearModifiedCache();
        AbstractDataSourceConfigurable abstractDataSourceConfigurable = dsConfigurable = this.mySelectedItem == null ? null : (AbstractDataSourceConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), AbstractDataSourceConfigurable.class);
        if (dsConfigurable != null) {
            dsConfigurable.onUserActivity();
        }
        DatabaseDriverConfigurable databaseDriverConfigurable = driverConfigurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class);
        if (driverConfigurable != null) {
            this.updateDriverDependants(driverConfigurable.getTempDriver());
        }
    }

    @Nullable
    private Place getPlace(@Nullable Object object) {
        SidePanelItem item = this.mySidePanelItems.get(object);
        return item == null ? null : item.getPlace();
    }

    @Nullable
    private SidePanelItem getItem(@Nullable Place place) {
        SidePanelItem item = SidePanelItem.getItem(place);
        if (item != null) {
            item = this.mySidePanelItems.get(item.getObject());
        }
        return item;
    }

    @Override
    public void clearModifiedCache() {
        this.myModificationTracker.incModificationCount();
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            item.resetModifiedCache();
        }
    }

    private void removeSidePanelItem(@NotNull SidePanelItem item) {
        if (item == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(1);
        }
        SidePanelItem old = this.mySidePanelItems.remove(item.getObject());
        item.removeConfigurable();
        this.myErrorsCollector.remove(item);
        assert (old == item);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(2);
        }
        return (T)this.myUserDataHolder.getUserData(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value) {
        if (key2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(3);
        }
        this.myUserDataHolder.putUserData(key2, value);
    }

    public void setHistory(History history) {
        this.myHistory = history;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        SidePanelItem item = this.getItem(place);
        if (item != this.mySelectedItem) {
            this.setSelectedEditor(item);
            if (this.mySelectedItem != null) {
                this.myHistory.pushQueryPlace();
                if (requestFocus) {
                    JComponent toFocus;
                    Object configurable = this.mySelectedItem.getConfigurable();
                    JComponent jComponent = toFocus = configurable == null ? null : configurable.getPreferredFocusedComponent();
                    if (toFocus != null) {
                        UiNotifyConnector.doWhenFirstShown((JComponent)toFocus, () -> UIUtil.requestFocus((JComponent)toFocus));
                    }
                }
            }
            this.mySidePanel.select(place);
            this.updateSidePanelImpl();
        }
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(4);
        }
        SidePanelItem.setItem(place, this.mySelectedItem);
    }

    public JComponent getPreferredFocusedComponent() {
        if (this.mySettings.selection != null && this.mySelectedItem != null && this.mySelectedItem.getObject() == this.mySettings.selection) {
            JComponent toFocus;
            Object configurable = this.mySelectedItem.getConfigurable();
            JComponent jComponent = toFocus = configurable == null ? null : configurable.getPreferredFocusedComponent();
            if (toFocus != null) {
                return toFocus;
            }
        }
        return this.mySidePanel.getList();
    }

    protected void disposeEditor() {
        super.disposeEditor();
        for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
            this.removeSidePanelItem(item);
        }
        this.myErrorsConfigurable.disposeUIResources();
        for (DbDataSource o : ContainerUtil.newArrayList(this.mySettings.newDataSources)) {
            if (o.isValid()) continue;
            this.mySettings.newDataSources.remove(o);
        }
        ((DbPsiFacadeImpl)this.mySettings.facade).clearCaches();
    }

    public String getHelpTopic() {
        Object configurable = this.mySelectedItem == null ? null : this.mySelectedItem.getConfigurable();
        return configurable == null ? null : configurable.getHelpTopic();
    }

    public boolean isAnyEditorModified() {
        if (!this.myRemovedObjects.isEmpty()) {
            return true;
        }
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (!this.isObjectModified(item)) continue;
            return true;
        }
        return false;
    }

    protected void resetEditorFrom(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(5);
        }
        this.resetTreeModel(settings);
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (!item.isModified()) continue;
            ((Configurable)ObjectUtils.assertNotNull(item.getConfigurable())).reset();
        }
        this.clearModifiedCache();
    }

    protected void applyEditorTo(@NotNull DataSourceSettings settings) throws ConfigurationException {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(6);
        }
        this.myOnApplyTasks = ContainerUtil.newArrayList();
        for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
            boolean created = this.isObjectCreated(item);
            if (!item.isModified() && !created) continue;
            item.apply();
            if (!created) continue;
            this.ensureNewObjectDropped(item.getObject());
        }
        DdlActions.closeAllFilesBeforeDataSourceRemoval(this.mySettings.facade.getProject(), (Set)JBIterable.from(this.myRemovedObjects).filter(DbDataSourceImpl.class).addAllTo((Collection)ContainerUtil.newLinkedHashSet()));
        Iterator<Object> it = this.myRemovedObjects.iterator();
        while (it.hasNext()) {
            this.removeObject(it.next());
            it.remove();
        }
        this.clearModifiedCache();
        Set selection = this.getSelectedItems().toSet();
        this.refillSidePanel(this.mySettings);
        this.restoreSelection(selection);
        final List<Progressive> queue = this.myOnApplyTasks;
        this.myOnApplyTasks = null;
        new Task.Backgroundable(this.mySettings.facade.getProject(), "Applying Changes to Data Sources", false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(false);
                for (int i2 = 0; i2 < queue.size(); ++i2) {
                    Progressive task = (Progressive)queue.get(i2);
                    indicator.setFraction((double)i2 / (double)queue.size());
                    try {
                        task.run(indicator);
                        continue;
                    }
                    catch (RuntimeException e) {
                        LOG.warn((Throwable)e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$4", "run"));
            }
        }.queue();
    }

    private void resetTreeModel(DataSourceSettings settings) {
        this.refillSidePanel(settings);
        this.navigateTo(this.mySettings.selection, false);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(7);
        }
        return jPanel;
    }

    private <I extends SidePanelItem> I createItem(@NotNull I item) {
        if (item == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(8);
        }
        this.mySidePanelItems.put(item.getObject(), item);
        this.ensureErrorProviderExistence(item);
        return item;
    }

    @NotNull
    private SidePanelItem.DataSourceItem createItem(@NotNull DbDataSource obj2) {
        SidePanelItem.DataSourceItem item;
        if (obj2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(9);
        }
        if ((item = (SidePanelItem.DataSourceItem)this.mySidePanelItems.get(obj2)) == null) {
            item = new SidePanelItem.DataSourceItem(this, (DbDataSourceImpl)obj2);
        }
        SidePanelItem.DataSourceItem dataSourceItem = this.createItem(item);
        if (dataSourceItem == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(10);
        }
        return dataSourceItem;
    }

    @NotNull
    private SidePanelItem.DriverItem createItem(@NotNull DatabaseDriver obj2) {
        SidePanelItem.DriverItem item;
        if (obj2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(11);
        }
        if ((item = (SidePanelItem.DriverItem)this.mySidePanelItems.get(obj2)) == null) {
            item = new SidePanelItem.DriverItem(this, obj2);
        }
        SidePanelItem.DriverItem driverItem = this.createItem(item);
        if (driverItem == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(12);
        }
        return driverItem;
    }

    @NotNull
    private SidePanelItem.ErrorsItem createItem(@NotNull DataSourceErrorsConfigurable obj2) {
        SidePanelItem.ErrorsItem item;
        if (obj2 == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(13);
        }
        if ((item = (SidePanelItem.ErrorsItem)this.mySidePanelItems.get(obj2)) == null) {
            item = new SidePanelItem.ErrorsItem(this, obj2);
        }
        SidePanelItem.ErrorsItem errorsItem = this.createItem(item);
        if (errorsItem == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(14);
        }
        return errorsItem;
    }

    @NotNull
    private SidePanelItem addToSidePanel(@NotNull SidePanelItem item) {
        if (item == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(15);
        }
        Place place = item.createPlace();
        this.mySidePanel.addPlace(place);
        SidePanelItem sidePanelItem = item;
        if (sidePanelItem == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(16);
        }
        return sidePanelItem;
    }

    private void ensureErrorProviderExistence(@NotNull SidePanelItem item) {
        DataSourceProblemsProvider provider;
        if (item == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(17);
        }
        if ((provider = (DataSourceProblemsProvider)ObjectUtils.tryCast((Object)item, DataSourceProblemsProvider.class)) == null || this.myErrorsCollector.contains(item)) {
            return;
        }
        this.myErrorsCollector.add(item, provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refillSidePanel(@NotNull DataSourceSettings settings) {
        if (settings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(18);
        }
        this.myFilling = true;
        try {
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(true);
            this.mySidePanel.clear();
            ArrayList localDataSources = ContainerUtil.newArrayList();
            ArrayList globalDataSources = ContainerUtil.newArrayList();
            ArrayList importedDataSources = ContainerUtil.newArrayList();
            for (DbDataSource element2 : this.getAllDataSources()) {
                SidePanelItem.DataSourceItem item = this.createItem(element2);
                if (item.isGlobal()) {
                    globalDataSources.add(item);
                    continue;
                }
                if (item.isImported()) {
                    importedDataSources.add(item);
                    continue;
                }
                localDataSources.add(item);
            }
            Comparator dataSourceElementComparator = (o1, o2) -> DbPresentation.compareNames(o1.getName(), o2.getName());
            Collections.sort(importedDataSources, dataSourceElementComparator);
            Collections.sort(localDataSources, dataSourceElementComparator);
            Collections.sort(globalDataSources, dataSourceElementComparator);
            HashSet addedItems = ContainerUtil.newHashSet();
            this.mySidePanel.addSeparator("Global Data Sources");
            for (Object ds : globalDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("Project Data Sources");
            for (Object ds : localDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("Imported Data Sources");
            for (Object ds : importedDataSources) {
                addedItems.add(this.addToSidePanel((SidePanelItem)ds));
            }
            this.mySidePanel.addSeparator("--");
            this.mySidePanel.addSeparator("Drivers");
            HashSet newDrivers = ContainerUtil.newHashSet(this.mySettings.newDrivers);
            for (DatabaseDriver driver : this.getAllDrivers(settings)) {
                SidePanelItem item = this.createItem(driver);
                if (newDrivers.contains(driver)) {
                    DatabaseConfigEditorImpl.createEditorIfNeeded(item);
                }
                addedItems.add(this.addToSidePanel(item));
            }
            this.mySidePanel.addSeparator("---");
            SidePanelItem.ErrorsItem errorsItem = this.createItem(this.myErrorsConfigurable);
            addedItems.add(this.addToSidePanel(errorsItem));
            for (SidePanelItem item : ContainerUtil.newArrayList(this.mySidePanelItems.values())) {
                if (addedItems.contains(item)) continue;
                this.removeSidePanelItem(item);
            }
            this.mySidePanel.setMinimumWidth(this.mySidePanel.getItemWidth(this.getPlace(this.myErrorsConfigurable)));
        }
        finally {
            this.myFilling = false;
            this.mySidePanel.getList().getSelectionModel().setValueIsAdjusting(false);
        }
    }

    public int getDataSourceGroup(@Nullable Object object) {
        switch (Kind.kindOf(object)) {
            case DATABASE: {
                return 2;
            }
            case DRIVER: {
                return 1;
            }
        }
        return 0;
    }

    @NotNull
    private JComponent createToolbarComponent(AnAction ... actions) {
        if (actions == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(19);
        }
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.addAll(actions);
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)toolbarGroup, true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setTargetComponent((JComponent)this.myRootPanel);
        JComponent component = toolbar.getComponent();
        component.setBackground(UIUtil.SIDE_PANEL_BACKGROUND);
        JComponent jComponent = component;
        if (jComponent == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(20);
        }
        return jComponent;
    }

    private JComponent createLeftPanel() {
        this.mySidePanel = new DataSourceSidePanel(new MyComponentConfigurator(), (Function<Place, String>)((Function)place -> {
            SidePanelItem item = SidePanelItem.getItem(place);
            return item == null ? null : item.getName();
        }));
        this.mySidePanel.getList().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Object o = ((JList)e.getSource()).getSelectedValue();
                Object object = SidePanelItem.getObject(SidePanelItem.getItem((Place)ObjectUtils.tryCast(o, Place.class)));
                DatabaseConfigEditorImpl.this.navigateTo(object, false);
            }
        });
        ActionManager actionManager = ActionManager.getInstance();
        JList<Place> target = this.mySidePanel.getList();
        this.myAddAction = new AddAction();
        this.myAddAction.registerCustomShortcutSet(CommonShortcuts.getNewForDialogs(), target);
        RemoveAction removeAction = new RemoveAction();
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), target);
        CopyAction copyAction = new CopyAction();
        copyAction.registerCustomShortcutSet(CommonShortcuts.getDuplicate(), target);
        GoToDriverAction editDefaultsAction = new GoToDriverAction();
        editDefaultsAction.registerCustomShortcutSet(actionManager.getAction("GotoDeclaration").getShortcutSet(), target);
        ForwardAction forwardAction = new ForwardAction((JComponent)this.myRootPanel, (Disposable)this);
        BackAction backAction = new BackAction((JComponent)this.myRootPanel, (Disposable)this);
        ShowUsagesAction showUsagesAction = new ShowUsagesAction();
        ResetToPredefinedAction resetToPredefAction = new ResetToPredefinedAction();
        DataSourceScopeAction scopeAction = new DataSourceScopeAction();
        showUsagesAction.registerCustomShortcutSet(actionManager.getAction("FindUsages").getShortcutSet(), target);
        ResetAction revertAction = new ResetAction();
        revertAction.registerCustomShortcutSet(actionManager.getAction("ChangesView.Revert").getShortcutSet(), target);
        SourceLoadingAction sourceLoading = new SourceLoadingAction();
        JPanel toolbarsPanel = new JPanel(new BorderLayout());
        toolbarsPanel.add((Component)this.createToolbarComponent(new AnAction[]{this.myAddAction, removeAction, copyAction, editDefaultsAction, scopeAction}), "Center");
        toolbarsPanel.add((Component)this.createToolbarComponent(new AnAction[]{backAction, forwardAction}), "East");
        JPanel result2 = new JPanel(new BorderLayout());
        result2.add((Component)toolbarsPanel, "North");
        result2.add((Component)this.mySidePanel.getComponent(), "Center");
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)this.myAddAction);
        group2.add((AnAction)removeAction);
        group2.add((AnAction)copyAction);
        group2.add((AnAction)scopeAction);
        group2.addSeparator();
        group2.add((AnAction)editDefaultsAction);
        group2.add((AnAction)new ChooseDriverGroup());
        group2.add((AnAction)showUsagesAction);
        group2.addSeparator();
        group2.add((AnAction)revertAction);
        group2.add((AnAction)resetToPredefAction);
        group2.add((AnAction)sourceLoading);
        PopupHandler.installPopupHandler(target, (ActionGroup)group2, (String)"unknown", (ActionManager)actionManager);
        return result2;
    }

    private void showUsagesPopup(final @Nullable SidePanelItem.DriverItem item) {
        JBPopupFactory popupFactory = JBPopupFactory.getInstance();
        final ArrayList actions = new ArrayList();
        if (item != null) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(final SidePanelItem.DataSourceItem dataSourceItem) {
                    DatabaseDriver driver;
                    LocalDataSource dataSource = dataSourceItem.extractActualLocalDataSource();
                    DatabaseDriver databaseDriver = driver = dataSource == null ? null : dataSource.getDatabaseDriver();
                    if (driver == null) {
                        return true;
                    }
                    if (driver == item.getObject() || driver == DatabaseConfigEditorImpl.this.getTempTargetOrTarget(item.getObject()).get()) {
                        actions.add(new DumbAwareAction(dataSourceItem.getName(), null, ((DbDataSourceImpl)((Object)dataSourceItem.getObject())).getIcon()){

                            public void actionPerformed(@NotNull AnActionEvent e) {
                                if (e == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                DatabaseConfigEditorImpl.this.navigateTo(dataSourceItem.getObject(), false);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$6$1", "actionPerformed"));
                            }
                        });
                    }
                    return true;
                }
            });
        }
        if (actions.isEmpty()) {
            Messages.showInfoMessage((Component)this.mySidePanel.getComponent(), (String)"No usages found", (String)"Driver Usages");
        } else {
            JList<Place> list = this.mySidePanel.getList();
            int selectedRow = list.getSelectedIndex();
            Rectangle rowBounds = list.getCellBounds(selectedRow, selectedRow);
            Point location = rowBounds.getLocation();
            location.x += Math.min(rowBounds.width, list.getParent().getWidth());
            int count2 = actions.size();
            ListPopup popup = popupFactory.createActionGroupPopup("Used By " + count2 + " " + StringUtil.pluralize((String)"Data Source", (int)count2), (ActionGroup)new DefaultActionGroup(actions), DataManager.getInstance().getDataContext(list), null, true);
            popup.show(new RelativePoint(list, location));
        }
    }

    @Nullable
    public String getObjectName(@Nullable Object object) {
        SidePanelItem item = this.mySidePanelItems.get(object);
        return item == null ? null : item.getName();
    }

    private boolean isObjectCreated(@Nullable SidePanelItem item) {
        if (item == null) {
            return false;
        }
        final Ref result2 = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result2.set((Object)((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.newDataSources.contains(dataSourceItem.getObject()));
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                result2.set((Object)((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.newDrivers.contains(driverItem.getObject()));
                return true;
            }
        });
        return (Boolean)result2.get();
    }

    private boolean isObjectModified(@Nullable SidePanelItem item) {
        return this.isObjectCreated(item) || item != null && item.isModified();
    }

    private static Configurable createEditorIfNeeded(@Nullable SidePanelItem item) {
        if (item != null && item.getConfigurable() == null) {
            item.createConfigurable();
        }
        return item == null ? null : (Configurable)item.getConfigurable();
    }

    private void setSelectedEditor(@Nullable SidePanelItem item) {
        if (item == this.mySelectedItem && this.myRightPanel.getComponentCount() != 0) {
            return;
        }
        this.myRightPanel.removeAll();
        this.mySelectedItem = item;
        DatabaseConfigEditorImpl.createEditorIfNeeded(item);
        if (item != null && item.getConfigurable() != null) {
            if (item.getConfigurable() instanceof AbstractDataSourceConfigurable) {
                ((AbstractDataSourceConfigurable)item.getConfigurable()).beforeShowNotify();
            }
            this.myRightPanel.add((Component)ObjectUtils.assertNotNull((Object)item.getComponent()), "Center");
            this.myRightPanel.add((Component)this.myInfoPanel, "South");
        } else {
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.setBorder(JBUI.Borders.empty((int)10));
            panel.add(new JLabel("Press the"));
            ActionButton addIcon = new ActionButton((AnAction)this.myAddAction, this.myAddAction.getTemplatePresentation(), "MainToolbar", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
            addIcon.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
            panel.add((Component)addIcon);
            panel.add(new JLabel("button to create a new data source"));
            JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel, (boolean)true);
            this.myRightPanel.add((Component)scrollPane, "Center");
        }
        UIUtil.setupEnclosingDialogBounds((JComponent)this.myRootPanel);
    }

    @Override
    public boolean isObjectNameUnique(@Nullable Object source, String name) {
        Kind kind = Kind.kindOf(source);
        if (kind == Kind.OTHER) {
            return true;
        }
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            Object o = item.getObject();
            if (Kind.kindOf(o) != kind || o == source || o instanceof DbElement && ((DbElement)o).getDelegate() == source || !Comparing.equal((String)item.getName(), (String)name)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public String generateObjectName(final @Nullable Object source, String baseName) {
        final HashSet existingNames = ContainerUtil.newHashSet();
        ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                if (((DbDataSourceImpl)((Object)dataSourceItem.getObject())).getDelegate() != source) {
                    existingNames.add(dataSourceItem.getName());
                }
                return true;
            }
        });
        String string = DbUtil.generateUniqueName((String)baseName, (Set)existingNames);
        if (string == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    private void onDataSourceCreated(@NotNull DbPsiFacade facade, @NotNull DataSourceManager manager, @NotNull DasDataSource dataSource) {
        if (facade == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(22);
        }
        if (manager == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(23);
        }
        if (dataSource == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(24);
        }
        DbDataSource element2 = ((DbPsiFacadeImpl)facade).createDataSourceWrapperElement(dataSource, manager);
        this.mySettings.newDataSources.add(element2);
        this.putUserData(SELECTED_TAB_KEY, null);
        DatabaseConfigEditorImpl.createEditorIfNeeded(this.createItem(element2));
        this.refillSidePanel(this.mySettings);
        this.navigateTo(element2, true);
    }

    private DatabaseDriver createDatabaseDriver() {
        return DataSourceUiUtil.createDefaultDatabaseDriver(this.getAllDrivers(this.mySettings));
    }

    private void addNewDriverAndNavigate(@NotNull DatabaseDriver newDriver) {
        if (newDriver == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(25);
        }
        this.mySettings.newDrivers.add(newDriver);
        this.refillSidePanel(this.mySettings);
        this.navigateTo(newDriver, true);
    }

    private void removeObject(Object object) {
        block2: {
            block3: {
                if (!(object instanceof DbDataSource)) break block3;
                DbDataSource element2 = (DbDataSource)object;
                for (DbDataSource dbDataSource : this.mySettings.facade.getDataSources()) {
                    if (dbDataSource.getDelegate() != element2.getDelegate()) continue;
                    this.mySettings.facade.getDataSourceManager(element2).removeDataSource((DasDataSource)element2.getDelegate());
                    break block2;
                }
                break block2;
            }
            if (!(object instanceof DatabaseDriver)) break block2;
            DatabaseDriver driver = (DatabaseDriver)object;
            for (DatabaseDriver databaseDriver : DatabaseDriverManager.getInstance().getDrivers()) {
                if (databaseDriver != driver) continue;
                DatabaseDriverManager.getInstance().removeDriver(driver);
                break;
            }
        }
    }

    @NotNull
    private JBIterable<SidePanelItem> getSelectedItems() {
        JBIterable jBIterable = JBIterable.from(this.mySidePanel.getList().getSelectedValuesList()).filterMap(o -> SidePanelItem.getItem(o));
        if (jBIterable == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(26);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DataSourceItem> getSelectedDataSources() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DataSourceItem.class);
        if (jBIterable == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(27);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DataSourceItem> getSelectedLocalDataSources() {
        JBIterable jBIterable = this.getSelectedDataSources().filter(item -> item.extractActualLocalDataSource() != null);
        if (jBIterable == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(28);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<SidePanelItem.DriverItem> getSelectedDrivers() {
        JBIterable jBIterable = this.getSelectedItems().filter(SidePanelItem.DriverItem.class);
        if (jBIterable == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(29);
        }
        return jBIterable;
    }

    void restoreSelection(@NotNull Set<SidePanelItem> sel) {
        if (sel == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(30);
        }
        TIntArrayList newSelection = new TIntArrayList(sel.size());
        int count2 = this.mySidePanel.getList().getModel().getSize();
        for (int i2 = 0; i2 < count2; ++i2) {
            SidePanelItem item = this.getItem((Place)ObjectUtils.tryCast((Object)this.mySidePanel.getList().getModel().getElementAt(i2), Place.class));
            if (!sel.contains(item)) continue;
            newSelection.add(i2);
        }
        this.mySidePanel.getList().setSelectedIndices(newSelection.toNativeArray());
    }

    @NotNull
    public DataSourceSettings getSettings() {
        DataSourceSettings dataSourceSettings = this.mySettings;
        if (dataSourceSettings == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(31);
        }
        return dataSourceSettings;
    }

    private List<AnAction> getAddActions() {
        ArrayList actions = ContainerUtil.newArrayList();
        final LocalDataSourceManager defaultManager = LocalDataSourceManager.getInstance(this.mySettings.facade.getProject());
        Function toTemp = o -> this.myRemovedObjects.contains(o) ? null : (DatabaseDriver)this.getTempTargetOrTarget(o).get();
        JBIterable newDrivers = JBIterable.from(this.mySettings.newDrivers).filterMap(toTemp);
        JBIterable existingDrivers = JBIterable.from(DatabaseDriverManager.getInstance().getDrivers()).filterMap(toTemp);
        actions.addAll(defaultManager.getCreateDataSourceActions(newDrivers.toList(), (Consumer<LocalDataSource>)((Consumer)d2 -> this.onDataSourceCreated(this.mySettings.facade, defaultManager, (DasDataSource)d2))));
        actions.add(Separator.getInstance());
        actions.addAll(defaultManager.getCreateDataSourceActions(existingDrivers.toList(), (Consumer<LocalDataSource>)((Consumer)d2 -> this.onDataSourceCreated(this.mySettings.facade, defaultManager, (DasDataSource)d2))));
        actions.add(Separator.getInstance());
        for (DataSourceManager manager : DataSourceManager.getManagers((Project)this.mySettings.facade.getProject())) {
            if (manager == defaultManager) continue;
            ContainerUtil.addIfNotNull((Collection)actions, (Object)manager.getCreateDataSourceAction(d2 -> this.onDataSourceCreated(this.mySettings.facade, manager, (DasDataSource)d2)));
        }
        actions.add(new AddDataSourceFromUrl(this::onDataSourceCreated));
        actions.add(new AddDataSourceFromPath.FromDialog(this::onDataSourceCreated));
        actions.add(Separator.getInstance());
        actions.add(new DumbAwareAction("Driver and Data Source", null, DatabaseIcons.UserDriver){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                DatabaseDriver driver = DatabaseConfigEditorImpl.this.createDatabaseDriver();
                ((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.newDrivers.add(driver);
                DatabaseConfigEditorImpl.this.onDataSourceCreated(((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.facade, defaultManager, driver.createDataSource(null, null));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$9", "actionPerformed"));
            }
        });
        actions.add(new DumbAwareAction("Driver", null, DatabaseIcons.UserDriver){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                DatabaseConfigEditorImpl.this.addNewDriverAndNavigate(DatabaseConfigEditorImpl.this.createDatabaseDriver());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$10", "actionPerformed"));
            }
        });
        return actions;
    }

    private void ensureNewObjectDropped(Object object) {
        if (object instanceof DbDataSource) {
            this.mySettings.newDataSources.remove((DbDataSource)object);
        } else if (object instanceof DatabaseDriver) {
            this.mySettings.newDrivers.remove((DatabaseDriver)object);
        }
    }

    private boolean canRemove(SidePanelItem item) {
        final Ref result2 = Ref.create((Object)false);
        item.accept(new SidePanelItem.ItemsVisitor(){

            @Override
            boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                result2.set((Object)true);
                return true;
            }

            @Override
            boolean visit(SidePanelItem.DriverItem driverItem) {
                DatabaseDriver actual;
                DatabaseDriver driver = (DatabaseDriver)driverItem.getObject();
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)driverItem.getConfigurable();
                DatabaseDriver databaseDriver = actual = configurable != null ? configurable.getTempDriver() : driver;
                if (driver.isPredefined()) {
                    return false;
                }
                for (DbDataSource ds : DatabaseConfigEditorImpl.this.getAllDataSources()) {
                    DatabaseDriver dsDriver;
                    if (DatabaseConfigEditorImpl.this.myRemovedObjects.contains(ds)) continue;
                    SidePanelItem.DataSourceItem item = (SidePanelItem.DataSourceItem)ObjectUtils.tryCast(DatabaseConfigEditorImpl.this.mySidePanelItems.get(ds), SidePanelItem.DataSourceItem.class);
                    LocalDataSource dataSource = item == null ? null : item.extractActualLocalDataSource();
                    DatabaseDriver databaseDriver2 = dsDriver = dataSource == null ? null : dataSource.getDatabaseDriver();
                    if (dsDriver != driver && dsDriver != actual) continue;
                    return false;
                }
                result2.set((Object)true);
                return true;
            }
        });
        return (Boolean)result2.get();
    }

    private Collection<DbDataSource> getAllDataSources() {
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet((Iterable)this.mySettings.facade.getDataSources());
        result2.addAll(this.mySettings.newDataSources);
        result2.removeAll(this.myRemovedObjects);
        return result2;
    }

    private Collection<DatabaseDriver> getAllDrivers(DataSourceSettings settings) {
        DatabaseDriverManager driverManager = DatabaseDriverManager.getInstance();
        ArrayList result2 = ContainerUtil.newArrayList(driverManager.getDrivers());
        result2.addAll(settings.newDrivers);
        result2.removeAll(this.myRemovedObjects);
        Collections.sort(result2, (o1, o2) -> DbPresentation.compareNames(o1.getName(), o2.getName()));
        return result2;
    }

    @NotNull
    private static Set<String> getDialectEquality(@Nullable String dialect) {
        HashSet res2 = ContainerUtil.newHashSet();
        if (dialect == null) {
            HashSet hashSet = res2;
            if (hashSet == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(32);
            }
            return hashSet;
        }
        res2.add(dialect);
        SqlLanguageDialect lang = SqlDialects.findDialectById(dialect);
        if (lang == null) {
            HashSet hashSet = res2;
            if (hashSet == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(33);
            }
            return hashSet;
        }
        if (!lang.getDbms().isPostgres()) {
            HashSet hashSet = res2;
            if (hashSet == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(34);
            }
            return hashSet;
        }
        for (SqlLanguageDialect d2 : SqlDialects.getSqlDialects()) {
            if (!d2.getDbms().isPostgres()) continue;
            res2.add(d2.getID());
        }
        HashSet hashSet = res2;
        if (hashSet == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(35);
        }
        return hashSet;
    }

    @NotNull
    private JBIterable<DatabaseDriver> getDrivers(JBIterable<LocalDataSource> dataSources2) {
        String defaultDialect = SqlDialects.getGenericDialect().getID();
        JBIterable dialects = dataSources2.filterMap(source -> {
            DatabaseDriver driver = source.getDatabaseDriver();
            return driver == null ? null : StringUtil.notNullize((String)driver.getSqlDialect(), (String)defaultDialect);
        });
        if (dialects.toSet().size() != 1) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(36);
            }
            return jBIterable;
        }
        Set<String> equality = DatabaseConfigEditorImpl.getDialectEquality((String)dialects.first());
        JBIterable jBIterable = JBIterable.from(this.getAllDrivers(this.mySettings)).filter(DatabaseDriver.class).filter(driver -> equality.contains(StringUtil.notNullize((String)((DatabaseDriver)this.getTempTargetOrTarget(driver).get()).getSqlDialect(), (String)defaultDialect)));
        if (jBIterable == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(37);
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(38);
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public ActionCallback navigateTo(final @Nullable Object object, boolean requestFocus) {
        final Ref place = Ref.create((Object)this.getPlace(object));
        if (place.get() == null) {
            ContainerUtil.process(this.mySidePanelItems.values(), (Processor)new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    if (dataSourceItem.getConfigurable() == null || ((AbstractDataSourceConfigurable)dataSourceItem.getConfigurable()).getTempDataSource() != object) {
                        return true;
                    }
                    place.set((Object)dataSourceItem.getPlace());
                    return false;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    if (driverItem.getConfigurable() == null || ((DatabaseDriverConfigurable)driverItem.getConfigurable()).getTempDriver() != object) {
                        return true;
                    }
                    place.set((Object)driverItem.getPlace());
                    return false;
                }
            });
        }
        ActionCallback actionCallback = this.navigateTo((Place)place.get(), requestFocus);
        if (actionCallback == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(39);
        }
        return actionCallback;
    }

    @Override
    @Nullable
    public <T, C extends AbstractDatabaseConfigurable<? extends T>> C getConfigurable(@Nullable T target, boolean createIfNeeded, @NotNull Class<C> clazz) {
        Condition isTarget;
        JBIterable items;
        SidePanelItem byTarget;
        if (clazz == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(40);
        }
        if ((byTarget = (SidePanelItem)(items = JBIterable.from(this.mySidePanelItems.values())).find(arg_0 -> DatabaseConfigEditorImpl.lambda$getConfigurable$17(isTarget = o -> o == target || o instanceof DbElement && ((DbElement)o).getDelegate() == target, arg_0))) != null) {
            if (byTarget.getConfigurable() == null && createIfNeeded) {
                byTarget.createConfigurable();
            }
            return (C)((AbstractDatabaseConfigurable)byTarget.getConfigurable());
        }
        SidePanelItem byTemp = (SidePanelItem)items.find(o -> {
            if (clazz == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(58);
            }
            return !isTarget.value(o.getObject()) && clazz.isInstance(o.getConfigurable()) && ((AbstractDatabaseConfigurable)o.getConfigurable()).getTempTarget() == target;
        });
        return (C)(byTemp == null ? null : (AbstractDatabaseConfigurable)byTemp.getConfigurable());
    }

    @Override
    @NotNull
    public <T> Getter<T> getTempTargetOrTarget(@NotNull T target) {
        if (target == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(41);
        }
        Getter getter = () -> {
            AbstractDatabaseConfigurable configurable;
            if (target == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(57);
            }
            return (configurable = this.getConfigurable(target, false, AbstractDatabaseConfigurable.class)) == null ? target : configurable.getTempTarget();
        };
        if (getter == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(42);
        }
        return getter;
    }

    @Override
    public void showErrorNotification(@NotNull Configurable source, @NotNull Object id, @Nullable Exception e) {
        if (source == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(43);
        }
        if (id == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(44);
        }
        if (e == null) {
            this.showErrorNotification(source, id, null, null, new Object[0]);
            return;
        }
        String longText = JdbcEngine.getErrorMessage(e, source.getDisplayName(), Dbms.UNKNOWN);
        if (longText.isEmpty()) {
            return;
        }
        Pair<String, Object[]> patched = DatabaseConfigEditorImpl.patchMessages(source, longText, new Object[0]);
        if (patched == null) {
            this.showErrorNotification(source, id, "Error", longText, new Object[0]);
        } else {
            this.showErrorNotification(source, id, "Error", (String)patched.first, (Object[])patched.second);
        }
    }

    @Nullable
    private static Pair<String, Object[]> patchMessages(@NotNull Configurable source, @Nullable String message2, Object ... linkActions) {
        if (source == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(45);
        }
        if (linkActions == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(46);
        }
        if (linkActions.length != 0 || message2 == null) {
            return null;
        }
        if (source instanceof DataSourceConfigurable) {
            DatabaseDriver driver = ((DataSourceConfigurable)source).getTempDataSource().getDatabaseDriver();
            if (message2.matches("^Driver class '[^']*' not .*\\n?")) {
                if (driver != null) {
                    return Pair.create((Object)message2.replace("Driver class", "<a href=\"$ACTION0\">Driver class</a>"), (Object)new Object[]{new DataSourceProblem.FocusDriverClass(driver)});
                }
            } else if (message2.contains("Missing native authentication library: ") && message2.contains("driver") && driver != null) {
                return Pair.create((Object)message2.replace("driver", "<a href=\"$ACTION0\">driver</a>").replace("\n", "<br>"), (Object)new Object[]{new DataSourceProblem.Navigate(driver)});
            }
        }
        String shortText = message2;
        int div = message2.indexOf(10);
        if (div > 5) {
            shortText = shortText.substring(0, div);
        }
        for (String exName : Arrays.asList("java.lang.IllegalArgumentException", "com.intellij.execution.ExecutionException", "com.jcraft.jsch.")) {
            int offset;
            if (shortText.length() < exName.length() + 10 || !shortText.startsWith(exName)) continue;
            int len = exName.length();
            int n = exName.endsWith(".") ? len : (offset = shortText.substring(len, len + 2).equals(": ") ? len + 2 : -1);
            if (offset < 0) continue;
            shortText = shortText.substring(offset);
        }
        if (!Comparing.equal((String)message2, (String)(shortText = StringUtil.escapeXml((String)StringUtil.trimLog((String)shortText, (int)80))))) {
            shortText = shortText + " (<a href=\"$ACTION0\">view</a>)";
        }
        class ViewAction
        implements Runnable {
            @Nullable
            private final String myMessage;
            final /* synthetic */ String val$message;

            ViewAction(String string) {
                this.val$message = string;
                this.myMessage = this.val$message;
            }

            @Override
            public void run() {
                Messages.showIdeaMessageDialog(null, (String)this.myMessage, (String)DatabaseMessages.message((String)"message.title.connection.error", (Object[])new Object[0]), (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ViewAction action = (ViewAction)o;
                return Objects.equals(this.myMessage, action.myMessage);
            }

            public int hashCode() {
                return this.myMessage != null ? this.myMessage.hashCode() : 0;
            }
        }
        return Pair.create((Object)shortText, (Object)new Object[]{new ViewAction(message2)});
    }

    @Override
    public void showErrorNotification(@NotNull Configurable source, @NotNull Object id, @Nullable String title, @Nullable String message2, Object ... linkActions) {
        Pair<String, Object[]> patched;
        if (source == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(47);
        }
        if (id == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(48);
        }
        if (linkActions == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(49);
        }
        if ((patched = DatabaseConfigEditorImpl.patchMessages(source, message2, linkActions)) != null) {
            message2 = (String)patched.first;
            linkActions = (Object[])patched.second;
        }
        DataSourceProblem dataSourceProblem = title != null && message2 != null ? new DataSourceProblem(source, id, DataSourceProblem.Level.ERROR, new DataSourceProblem.HyperText(title, message2, message2, linkActions), null) : null;
        for (SidePanelItem item : this.mySidePanelItems.values()) {
            if (item.getConfigurable() != source) continue;
            if (dataSourceProblem == null && item.getDataSourceProblem() != null && !Comparing.equal((Object)item.getDataSourceProblem().getId(), (Object)id)) break;
            item.setDataSourceProblem(dataSourceProblem);
            break;
        }
        if (this.mySelectedItem != null && this.mySelectedItem.getConfigurable() == source) {
            this.updateValidationProblem(this.mySelectedItem);
        }
    }

    @Override
    @NotNull
    public DatabaseCredentials getSecretService() {
        DatabaseCredentials databaseCredentials = this.myDatabaseCredentials;
        if (databaseCredentials == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(50);
        }
        return databaseCredentials;
    }

    @Override
    @Nullable
    public JComponent createResetAction(@Nullable Configurable configurable) {
        Ref itemRef = Ref.create();
        ContainerUtil.process(this.mySidePanelItems.values(), sitem -> {
            if (sitem.getConfigurable() == configurable) {
                itemRef.set(sitem);
                return false;
            }
            return true;
        });
        SidePanelItem item = (SidePanelItem)itemRef.get();
        if (item == null) {
            return null;
        }
        JPanel component = new JPanel(new BorderLayout());
        component.add((Component)item.getResetComponent(), "East");
        Dimension size = component.getPreferredSize();
        Dimension constraint = new Dimension((int)size.getWidth(), (int)size.getHeight());
        component.setMinimumSize(constraint);
        component.setPreferredSize(constraint);
        return component;
    }

    @Override
    public void onDriverDownloaded(@NotNull DatabaseDriver driver) {
        DatabaseDriverConfigurable configurable;
        if (driver == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(51);
        }
        if ((configurable = this.getConfigurable(driver, true, DatabaseDriverConfigurable.class)) != null) {
            configurable.resetFromTemp();
        }
        this.updateDriverDependants(driver);
    }

    @Override
    public void onChangesApplied(@NotNull Progressive task) {
        if (task == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(52);
        }
        if (this.myOnApplyTasks == null) {
            throw new IllegalStateException("Should be called when applying");
        }
        this.myOnApplyTasks.add(task);
    }

    private void updateValidationProblem(@Nullable SidePanelItem item) {
        DataSourceProblem error2 = item == null ? null : item.getDataSourceProblem();
        this.myErrorInfoComponent.updateWarning(error2);
        DataSourceProblem problem = (DataSourceProblem)ContainerUtil.getFirstItem(this.myErrorsCollector.getProblems(item));
        this.myValidationComponent.updateWarning(problem);
    }

    void processAction(final Object action) {
        if (action instanceof Runnable) {
            ((Runnable)action).run();
        } else if (action instanceof Computable) {
            ((Computable)action).compute();
        } else if (action instanceof Progressive) {
            NamedProgressive named = (NamedProgressive)ObjectUtils.tryCast((Object)action, NamedProgressive.class);
            new Task.Modal(null, named == null ? "" : named.getName(), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        13.$$$reportNull$$$0(0);
                    }
                    ((Progressive)action).run(indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$13", "run"));
                }
            }.queue();
        } else if (action instanceof DataSourceProblem.Navigate) {
            this.navigateTo(((DataSourceProblem.Navigate)action).target, false);
        } else if (action instanceof DataSourceProblem.NewUrlTemplate) {
            DataSourceProblem.NewUrlTemplate newUrlTemplate = (DataSourceProblem.NewUrlTemplate)action;
            DatabaseDriverConfigurable configurable = this.getConfigurable(newUrlTemplate.driver, true, DatabaseDriverConfigurable.class);
            this.addTemplate((DatabaseDriver)ObjectUtils.notNull((Object)(configurable == null ? null : configurable.getDriver()), (Object)newUrlTemplate.driver), newUrlTemplate.template);
        } else if (action instanceof DataSourceProblem.FocusDriverClass) {
            DataSourceProblem.FocusDriverClass focusDriverClass = (DataSourceProblem.FocusDriverClass)action;
            this.focusDriverClassSelector(focusDriverClass.driver);
        }
        this.updateSidePanelImpl();
    }

    private void addTemplate(@NotNull DatabaseDriver driver, @NotNull String template) {
        if (driver == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(53);
        }
        if (template == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(54);
        }
        this.navigateTo(driver, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            if (template == null) {
                DatabaseConfigEditorImpl.$$$reportNull$$$0(56);
            }
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            configurable.addNewUrlTemplate(template);
        });
    }

    private void focusDriverClassSelector(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseConfigEditorImpl.$$$reportNull$$$0(55);
        }
        this.navigateTo(driver, false).doWhenDone(() -> {
            DatabaseDriverConfigurable configurable;
            DatabaseDriverConfigurable databaseDriverConfigurable = configurable = this.mySelectedItem == null ? null : (DatabaseDriverConfigurable)ObjectUtils.tryCast(this.mySelectedItem.getConfigurable(), DatabaseDriverConfigurable.class);
            if (configurable == null) {
                return;
            }
            configurable.focusDriverClassSelector();
        });
    }

    public void resurrectDriver(@Nullable DatabaseDriver driver) {
        boolean isNew;
        boolean bl = isNew = !DatabaseDriverManager.getInstance().getDrivers().contains(driver);
        if (isNew && !this.mySettings.newDrivers.contains(driver)) {
            this.mySettings.newDrivers.add(driver);
        }
        this.myRemovedObjects.remove(driver);
        DbUIUtil.invokeLater(() -> {
            Set selection = this.getSelectedItems().toSet();
            this.refillSidePanel(this.mySettings);
            this.restoreSelection(selection);
        });
    }

    private static /* synthetic */ boolean lambda$getConfigurable$17(Condition isTarget, SidePanelItem o) {
        return isTarget.value(o.getObject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facade";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDriver";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sel";
                break;
            }
            case 40: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 43: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkActions";
                break;
            }
            case 51: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createItem";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addToSidePanel";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbarComponent";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateObjectName";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDataSources";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedLocalDataSources";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedDrivers";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectEquality";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrivers";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "navigateTo";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempTargetOrTarget";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecretService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeSidePanelItem";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 50: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addToSidePanel";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "ensureErrorProviderExistence";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refillSidePanel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createToolbarComponent";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onDataSourceCreated";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addNewDriverAndNavigate";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "restoreSelection";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getTempTargetOrTarget";
                break;
            }
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "patchMessages";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "onDriverDownloaded";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "onChangesApplied";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "focusDriverClassSelector";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addTemplate$21";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTempTargetOrTarget$19";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getConfigurable$18";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyComponentConfigurator
    implements DataSourceSidePanel.ComponentConfigurator {
        private final Map<Icon, Icon> myCache = ContainerUtil.newHashMap();

        private MyComponentConfigurator() {
        }

        @Nullable
        private Icon getGrayIcon(@Nullable Icon icon) {
            return icon == null ? null : this.myCache.computeIfAbsent(icon, IconUtil::desaturate);
        }

        @Override
        public void configure(final @NotNull SimpleColoredComponent component, @NotNull Place place, boolean isSelected) {
            int style;
            boolean hasHints;
            SidePanelItem item;
            if (component == null) {
                MyComponentConfigurator.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyComponentConfigurator.$$$reportNull$$$0(1);
            }
            if ((item = SidePanelItem.getItem(place)) == null) {
                return;
            }
            boolean created = DatabaseConfigEditorImpl.this.isObjectCreated(item);
            boolean modified = created || DatabaseConfigEditorImpl.this.isObjectModified(item);
            JBIterable problems = JBIterable.from(DatabaseConfigEditorImpl.this.myErrorsCollector.getProblems(item));
            boolean darcula = UIUtil.isUnderDarcula();
            Object fgColor = isSelected ? UIUtil.getListSelectionForeground() : (created ? (darcula ? JBColor.GREEN : JBColor.GREEN.darker().darker()) : (modified ? JBColor.BLUE : component.getForeground()));
            boolean hasErrors = !problems.filter(p2 -> p2.getLevel() == DataSourceProblem.Level.ERROR).isEmpty();
            boolean hasWarnings = !problems.filter(p2 -> p2.getLevel() == DataSourceProblem.Level.WARNING).isEmpty();
            boolean bl = hasHints = !problems.filter(p2 -> p2.getLevel() == DataSourceProblem.Level.HINT).isEmpty();
            int n = hasErrors ? 8 : (hasWarnings ? 8 : (style = hasHints ? 32 : 0));
            JBColor color = hasErrors ? JBColor.RED : (hasWarnings ? DbUIUtil.WARNING : (darcula ? JBColor.LIGHT_GRAY.brighter() : JBColor.LIGHT_GRAY));
            SimpleTextAttributes textAttributes = new SimpleTextAttributes(style, (Color)fgColor, (Color)color);
            String name = item.getName();
            if (name != null) {
                SpeedSearchUtil.appendColoredFragmentForMatcher((String)name, (SimpleColoredComponent)component, (SimpleTextAttributes)textAttributes, (Matcher)DatabaseConfigEditorImpl.this.mySidePanel.getSpeedSearchMatcher(), (Color)UIUtil.getTreeSelectionBackground(), (boolean)isSelected);
            }
            component.setIcon((Icon)JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)16)));
            item.accept(new SidePanelItem.ItemsVisitor(){

                @Override
                boolean visit(SidePanelItem.DataSourceItem dataSourceItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DbDataSourceImpl)((Object)dataSourceItem.getObject())).getIcon(true)));
                    String comment = ((DbDataSourceImpl)((Object)dataSourceItem.getObject())).getComment();
                    if (StringUtil.isNotEmpty((String)comment)) {
                        component.setToolTipText(StringUtil.shortenTextWithEllipsis((String)comment, (int)2000, (int)0, (boolean)true));
                    }
                    return true;
                }

                @Override
                boolean visit(SidePanelItem.DriverItem driverItem) {
                    component.setIcon(MyComponentConfigurator.this.getGrayIcon(((DatabaseDriver)driverItem.getObject()).getIcon(0)));
                    return true;
                }
            });
        }

        @Override
        public void updateCount(@NotNull SidePanelCountLabel count2, @NotNull Place place) {
            SidePanelItem.ErrorsItem item;
            if (count2 == null) {
                MyComponentConfigurator.$$$reportNull$$$0(2);
            }
            if (place == null) {
                MyComponentConfigurator.$$$reportNull$$$0(3);
            }
            count2.setVisible((item = (SidePanelItem.ErrorsItem)ObjectUtils.tryCast((Object)SidePanelItem.getItem(place), SidePanelItem.ErrorsItem.class)) != null && ((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount() > 0);
            if (item != null) {
                count2.setText(String.valueOf(((DataSourceErrorsConfigurable)item.getObject()).getErrorsCount()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "count";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyComponentConfigurator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configure";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyRootPanel
    extends NonOpaquePanel
    implements DataProvider {
        MyRootPanel(LayoutManager layout) {
            super(layout);
        }

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyRootPanel.$$$reportNull$$$0(0);
            }
            if (History.KEY.is(dataId)) {
                return DatabaseConfigEditorImpl.this.myHistory;
            }
            if (DatabaseDataKeys.DB_PSI_FACADE.is(dataId)) {
                return ((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.facade;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$MyRootPanel", "getData"));
        }
    }

    public class ValidationComponent
    extends JPanel {
        private final JEditorPane myWarningLabel;
        private final List<Object> myActions = ContainerUtil.newArrayList();
        private DataSourceProblem myProblem;

        public ValidationComponent(boolean closeable) {
            this.setLayout(new BorderLayout(5, 5));
            this.setBorder(new CompoundBorder(JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)1, (int)0, (int)0, (int)0), DsUiDefaults.DEFAULT_PANEL_BORDER));
            this.setVisible(false);
            JLabel iconLabel = new JLabel(UIUtil.getBalloonWarningIcon());
            iconLabel.setHorizontalAlignment(2);
            iconLabel.setVerticalAlignment(1);
            this.myWarningLabel = IdeTooltipManager.initPane((String)"", (HintHint)new HintHint(), null);
            this.myWarningLabel.setEditable(false);
            NonOpaquePanel.setTransparent((JComponent)this.myWarningLabel);
            this.myWarningLabel.setBorder(null);
            this.myWarningLabel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || ValidationComponent.this.myProblem == null) {
                        return;
                    }
                    Object action = DataSourceProblem.extractAction(e.getDescription(), ValidationComponent.this.myActions);
                    if (action != null) {
                        DatabaseConfigEditorImpl.this.processAction(action);
                    }
                }
            });
            this.add((Component)iconLabel, "West");
            this.add((Component)this.myWarningLabel, "Center");
            if (closeable) {
                JPanel comp = new JPanel(new BorderLayout());
                comp.add((Component)new LinkLabel(null, AllIcons.Actions.Close, (aSource, aLinkData) -> {
                    Configurable configurable;
                    Configurable configurable2 = configurable = this.myProblem.getId() == null ? null : (Configurable)ObjectUtils.tryCast((Object)this.myProblem.getOwner(), Configurable.class);
                    if (configurable != null) {
                        DatabaseConfigEditorImpl.this.showErrorNotification(configurable, this.myProblem.getId(), null);
                    }
                }), "North");
                this.add((Component)comp, "East");
            }
        }

        private void updateWarning(@Nullable DataSourceProblem problem) {
            if (Comparing.equal((Object)problem, (Object)this.myProblem)) {
                return;
            }
            if (problem != null) {
                this.setVisible(true);
                this.myProblem = problem;
                this.myActions.clear();
                this.myWarningLabel.setText(this.generateWarningLabelText());
            } else {
                this.setVisible(false);
                this.myActions.clear();
                this.myProblem = null;
            }
        }

        private String generateWarningLabelText() {
            StringBuilder builder = new StringBuilder("<html><body>");
            String title = this.myProblem.getText().getTitle();
            builder.append("<font face=\"verdana\">");
            if (!StringUtil.isEmptyOrSpaces((String)title)) {
                builder.append("<b>");
                DataSourceProblem.formatText(builder, this.myActions, title, this.myProblem.getText().getLinkActions());
                builder.append("</b>: ");
            }
            DataSourceProblem.formatText(builder, this.myActions, this.myProblem.getText().getShortDescription(), this.myProblem.getText().getLinkActions());
            builder.append("</font></body></html>");
            return builder.toString();
        }
    }

    private class GoToDriverAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        GoToDriverAction() {
            super("Go to Driver", null, AllIcons.General.Settings);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(0);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            JBIterable selection;
            SidePanelItem.DataSourceItem dataSource;
            LocalDataSource localDataSource;
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(1);
            }
            LocalDataSource localDataSource2 = localDataSource = (dataSource = (SidePanelItem.DataSourceItem)(selection = DatabaseConfigEditorImpl.this.getSelectedDataSources()).first()) == null ? null : dataSource.extractActualLocalDataSource();
            if (localDataSource == null) {
                return;
            }
            DatabaseConfigEditorImpl.this.navigateTo(localDataSource.getDatabaseDriver(), false);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            JBIterable selection;
            if (e == null) {
                GoToDriverAction.$$$reportNull$$$0(2);
            }
            if ((selection = DatabaseConfigEditorImpl.this.getSelectedDataSources()).size() != 1) {
                return false;
            }
            LocalDataSource localDataSource = ((SidePanelItem.DataSourceItem)ObjectUtils.assertNotNull((Object)selection.first())).extractActualLocalDataSource();
            return localDataSource != null && localDataSource.getDatabaseDriver() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$GoToDriverAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class CopyAction
    extends DumbAwareAction
    implements AnActionButtonUpdater {
        private CopyAction() {
            super("Duplicate", null, PlatformIcons.COPY_ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(1);
            }
            SidePanelItem.DataSourceItem dataSourceItem = this.getSelectedDatasourceItem();
            SidePanelItem.DriverItem databaseDriverItem = this.getSelectedDriverItem();
            if (dataSourceItem != null) {
                DbDataSource dataSource = (DbDataSource)dataSourceItem.getObject();
                AbstractDataSourceConfigurable configurable = (AbstractDataSourceConfigurable)dataSourceItem.getConfigurable();
                Object delegate = configurable instanceof DataSourceConfigurable ? ((DataSourceConfigurable)configurable).getTempDataSourceForConnection() : (configurable != null ? configurable.getTempDataSource() : dataSource.getDelegate());
                String newName = DatabaseConfigEditorImpl.this.generateObjectName(null, delegate.getName());
                DataSourceManager dbManager = ((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.facade.getDataSourceManager(dataSource);
                DasDataSource databaseSystem = dbManager.copyDataSource(newName, (DasDataSource)delegate);
                DatabaseConfigEditorImpl.this.onDataSourceCreated(((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.facade, dbManager, databaseSystem);
            } else if (databaseDriverItem != null) {
                DatabaseDriverImpl databaseDriver = (DatabaseDriverImpl)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(databaseDriverItem.getObject()).get();
                Set names = (Set)JBIterable.from((Iterable)DatabaseConfigEditorImpl.this.getAllDrivers(DatabaseConfigEditorImpl.this.mySettings)).map(DatabaseDriver::getName).addAllTo((Collection)new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
                String newName = DbUtil.generateUniqueName((String)databaseDriver.getName(), (Set)names);
                DatabaseConfigEditorImpl.this.addNewDriverAndNavigate(databaseDriver.copy(newName, false));
            }
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyAction.$$$reportNull$$$0(2);
            }
            return this.getSelectedDatasourceItem() != null ^ this.getSelectedDriverItem() != null;
        }

        public SidePanelItem.DataSourceItem getSelectedDatasourceItem() {
            JBIterable selection = DatabaseConfigEditorImpl.this.getSelectedDataSources();
            if (selection.size() != 1) {
                return null;
            }
            return (SidePanelItem.DataSourceItem)selection.first();
        }

        public SidePanelItem.DriverItem getSelectedDriverItem() {
            JBIterable selection = DatabaseConfigEditorImpl.this.getSelectedDrivers();
            return selection.size() == 1 ? (SidePanelItem.DriverItem)selection.first() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$CopyAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SourceLoadingAction
    extends ActionGroup {
        private final AnAction[] mySetActions;

        SourceLoadingAction() {
            super("Load Sources", "Which sources to load", AllIcons.Actions.Download);
            this.mySetActions = new AnAction[]{new SetValueAction("None", DBIntrospectionOptions.SourceLoading.NO_SOURCES), new SetValueAction("Except System Schemas", DBIntrospectionOptions.SourceLoading.USER_SOURCES), new SetValueAction("All Schemas", DBIntrospectionOptions.SourceLoading.USER_AND_SYSTEM_SOURCES)};
            this.setPopup(true);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (this.mySetActions == null) {
                SourceLoadingAction.$$$reportNull$$$0(0);
            }
            return this.mySetActions;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SourceLoadingAction.$$$reportNull$$$0(1);
            }
            boolean enabled = !this.getLocalDsItems().isEmpty();
            e.getPresentation().setEnabledAndVisible(enabled);
        }

        @NotNull
        private JBIterable<SidePanelItem.DataSourceItem> getLocalDsItems() {
            JBIterable jBIterable = JBIterable.from((Iterable)DatabaseConfigEditorImpl.this.getSelectedItems()).filter(SidePanelItem.DataSourceItem.class).filter(item -> item.extractActualLocalDataSource() != null);
            if (jBIterable == null) {
                SourceLoadingAction.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLocalDsItems";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class SetValueAction
        extends DumbAwareAction {
            private final DBIntrospectionOptions.SourceLoading myMode;

            SetValueAction(@NotNull String caption, DBIntrospectionOptions.SourceLoading mode) {
                if (SourceLoadingAction.this == null) {
                    SetValueAction.$$$reportNull$$$0(0);
                }
                if (caption == null) {
                    SetValueAction.$$$reportNull$$$0(1);
                }
                if (mode == null) {
                    SetValueAction.$$$reportNull$$$0(2);
                }
                super(caption);
                this.myMode = mode;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    SetValueAction.$$$reportNull$$$0(3);
                }
                for (SidePanelItem.DataSourceItem item : SourceLoadingAction.this.getLocalDsItems()) {
                    DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast(item.createConfigurable(), DataSourceConfigurable.class);
                    if (configurable == null) continue;
                    configurable.setSourceLoading(this.myMode);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument %s for @NotNull parameter of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "0";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "caption";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mode";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$SourceLoadingAction$SetValueAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format(string, objectArray));
            }
        }
    }

    private class ResetAction
    extends DumbAwareAction {
        ResetAction() {
            super("Reset Changes", "Reset modifications to item", AllIcons.Actions.Rollback);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetAction.$$$reportNull$$$0(0);
            }
            boolean modified = false;
            for (SidePanelItem item : DatabaseConfigEditorImpl.this.getSelectedItems()) {
                if (!item.isModified()) continue;
                modified = true;
                break;
            }
            e.getPresentation().setEnabled(modified);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetAction.$$$reportNull$$$0(1);
            }
            Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            for (SidePanelItem item : DatabaseConfigEditorImpl.this.getSelectedItems()) {
                if (!item.isModified()) continue;
                item.reset();
            }
            DatabaseConfigEditorImpl.this.refillSidePanel(DatabaseConfigEditorImpl.this.mySettings);
            DatabaseConfigEditorImpl.this.restoreSelection(selection);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ResetAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class DataSourceScopeAction
    extends DumbAwareAction {
        DataSourceScopeAction() {
            super("Data Source Scope", null, AllIcons.ToolbarDecorator.Import);
        }

        boolean isIDEScopeSelected() {
            boolean isIDEScope = true;
            for (SidePanelItem.DataSourceItem item : DatabaseConfigEditorImpl.this.getSelectedLocalDataSources()) {
                isIDEScope &= item.isGlobal();
            }
            return isIDEScope;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(!DatabaseConfigEditorImpl.this.getSelectedLocalDataSources().filter(ds -> this.canMoveToScope((SidePanelItem.DataSourceItem)ds, null)).isEmpty());
            e.getPresentation().setText(this.isIDEScopeSelected() ? "Move to Project" : "Make Global");
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DataSourceScopeAction.$$$reportNull$$$0(1);
            }
            Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            boolean isIDEScope = this.isIDEScopeSelected();
            for (SidePanelItem.DataSourceItem item : DatabaseConfigEditorImpl.this.getSelectedLocalDataSources()) {
                DataSourceConfigurable configurable;
                if (!this.canMoveToScope(item, !isIDEScope) || (configurable = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class)) == null) continue;
                configurable.setGlobal(!isIDEScope);
            }
            DatabaseConfigEditorImpl.this.refillSidePanel(DatabaseConfigEditorImpl.this.mySettings);
            DatabaseConfigEditorImpl.this.restoreSelection(selection);
        }

        private boolean canMoveToScope(SidePanelItem.DataSourceItem item, Boolean global) {
            LocalDataSource ds = (LocalDataSource)ObjectUtils.tryCast((Object)((DbDataSourceImpl)((Object)item.getObject())).getDelegate(), LocalDataSource.class);
            if (ds == null) {
                return false;
            }
            String id = ds.getUniqueId();
            if (id == null) {
                return true;
            }
            if (global == null) {
                global = !ds.isGlobal();
            }
            DataSourceStorage storage = global != false ? DataSourceStorage.getStorage() : DataSourceStorage.getProjectStorage(((DatabaseConfigEditorImpl)DatabaseConfigEditorImpl.this).mySettings.facade.getProject());
            for (LocalDataSource source : storage.getDataSources()) {
                if (source.isGlobal() != global.booleanValue() || !id.equals(source.getUniqueId()) || source == ds) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$DataSourceScopeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ChooseDriverGroup
    extends ActionGroup
    implements DumbAware {
        ChooseDriverGroup() {
            super("Change Driver", "Change data source driver", null);
        }

        public boolean isPopup() {
            return true;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ChooseDriverGroup.$$$reportNull$$$0(0);
            }
            JBIterable dataSources2 = DatabaseConfigEditorImpl.this.getSelectedLocalDataSources();
            JBIterable drivers = DatabaseConfigEditorImpl.this.getDrivers((JBIterable<LocalDataSource>)dataSources2.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource));
            e.getPresentation().setVisible(!dataSources2.isEmpty());
            e.getPresentation().setEnabled(drivers.take(2).size() > 1);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            final JBIterable dataSources2 = DatabaseConfigEditorImpl.this.getSelectedLocalDataSources();
            List drivers = DatabaseConfigEditorImpl.this.getDrivers((JBIterable<LocalDataSource>)dataSources2.filterMap(SidePanelItem.DataSourceItem::extractActualLocalDataSource)).filterMap(o -> (DatabaseDriver)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(o).get()).toList();
            if (drivers.size() < 2) {
                if (EMPTY_ARRAY == null) {
                    ChooseDriverGroup.$$$reportNull$$$0(1);
                }
                return EMPTY_ARRAY;
            }
            final Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            ArrayList res2 = ContainerUtil.newArrayList();
            for (final DatabaseDriver driver : drivers) {
                res2.add(new DumbAwareAction(driver.getName(), null, driver.getIcon(0)){

                    public void actionPerformed(@NotNull AnActionEvent e1) {
                        if (e1 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        for (SidePanelItem.DataSourceItem item : dataSources2) {
                            DataSourceConfigurable configurable = (DataSourceConfigurable)ObjectUtils.tryCast((Object)DatabaseConfigEditorImpl.createEditorIfNeeded(item), DataSourceConfigurable.class);
                            if (configurable == null) continue;
                            configurable.setDriver(driver);
                        }
                        DatabaseConfigEditorImpl.this.restoreSelection(selection);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e1", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup$1", "actionPerformed"));
                    }
                });
            }
            AnAction[] anActionArray = res2.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                ChooseDriverGroup.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ChooseDriverGroup";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ResetToPredefinedAction
    extends DumbAwareAction {
        ResetToPredefinedAction() {
            super("Reset to Predefined", null, AllIcons.Actions.Undo);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(0);
            }
            JBIterable drivers = DatabaseConfigEditorImpl.this.getSelectedDrivers().filter(this.isPredefinedChangedCondition());
            for (SidePanelItem.DriverItem driverItem : drivers) {
                DatabaseDriverConfigurable configurable = (DatabaseDriverConfigurable)driverItem.createConfigurable();
                DatabaseDriverImpl driver = configurable.getTempDriver();
                DatabaseDriverManager.getInstance().resetToPredefined(driver);
                configurable.resetFromTemp();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(1);
            }
            JBIterable selectedDrivers = DatabaseConfigEditorImpl.this.getSelectedDrivers().filter(this.isPredefinedChangedCondition());
            e.getPresentation().setEnabledAndVisible(!selectedDrivers.isEmpty());
        }

        @NotNull
        private Condition<SidePanelItem.DriverItem> isPredefinedChangedCondition() {
            Condition condition = item -> !DatabaseDriverManager.getInstance().isInPredefinedState((DatabaseDriver)DatabaseConfigEditorImpl.this.getTempTargetOrTarget(item.getObject()).get());
            if (condition == null) {
                ResetToPredefinedAction.$$$reportNull$$$0(2);
            }
            return condition;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ResetToPredefinedAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ResetToPredefinedAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "isPredefinedChangedCondition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class ShowUsagesAction
    extends DumbAwareAction {
        ShowUsagesAction() {
            super("Show Driver Usages", null, AllIcons.Actions.Find);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowUsagesAction.$$$reportNull$$$0(0);
            }
            DatabaseConfigEditorImpl.this.showUsagesPopup((SidePanelItem.DriverItem)DatabaseConfigEditorImpl.this.getSelectedDrivers().first());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowUsagesAction.$$$reportNull$$$0(1);
            }
            JBIterable selectedDrivers = DatabaseConfigEditorImpl.this.getSelectedDrivers();
            e.getPresentation().setEnabledAndVisible(selectedDrivers.size() == 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$ShowUsagesAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class RemoveAction
    extends DumbAwareAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater {
        private RemoveAction() {
            super("Remove", null, IconUtil.getRemoveIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(0);
            }
            this.run(null);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(1);
            }
            boolean enabled = this.isEnabled(e);
            e.getPresentation().setEnabled(enabled);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAction.$$$reportNull$$$0(2);
            }
            Set selection = DatabaseConfigEditorImpl.this.getSelectedItems().toSet();
            for (SidePanelItem item : selection) {
                if (DatabaseConfigEditorImpl.this.canRemove(item)) continue;
                return false;
            }
            return !selection.isEmpty();
        }

        public void run(AnActionButton button) {
            JList<Place> list = DatabaseConfigEditorImpl.this.mySidePanel.getList();
            int index2 = list.getSelectionModel().getMinSelectionIndex();
            for (SidePanelItem item : DatabaseConfigEditorImpl.this.getSelectedItems()) {
                if (!DatabaseConfigEditorImpl.this.canRemove(item)) continue;
                DatabaseConfigEditorImpl.this.myRemovedObjects.add(item.getObject());
                DatabaseConfigEditorImpl.this.ensureNewObjectDropped(item.getObject());
            }
            DatabaseConfigEditorImpl.this.refillSidePanel(DatabaseConfigEditorImpl.this.mySettings);
            index2 = Math.max(0, Math.min(list.getModel().getSize() - 2, index2));
            list.getSelectionModel().setSelectionInterval(index2, index2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$RemoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class AddAction
    extends ActionGroup
    implements DumbAware,
    AlwaysVisibleActionGroup {
        private AddAction() {
            super("Add", null, IconUtil.getAddIcon());
        }

        public boolean isPopup() {
            return true;
        }

        public boolean canBePerformed(@NotNull DataContext context) {
            if (context == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAction.$$$reportNull$$$0(1);
            }
            ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("", (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20);
            DbUIUtil.showPopup((JBPopup)popup, null, e);
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            List actions = DatabaseConfigEditorImpl.this.getAddActions();
            AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                AddAction.$$$reportNull$$$0(2);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$AddAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/view/ui/DatabaseConfigEditorImpl$AddAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "canBePerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum Kind {
        DATABASE,
        DRIVER,
        OTHER;


        static Kind kindOf(Object o) {
            if (o instanceof DasDataSource) {
                return DATABASE;
            }
            if (o instanceof DatabaseDriver) {
                return DRIVER;
            }
            return OTHER;
        }
    }

    static class DataSourceSettings {
        final DbPsiFacade facade;
        @Nullable
        Object selection;
        final List<DbDataSource> newDataSources;
        final List<DatabaseDriver> newDrivers;

        DataSourceSettings(@NotNull DbPsiFacade psiFacade) {
            if (psiFacade == null) {
                DataSourceSettings.$$$reportNull$$$0(0);
            }
            this.newDataSources = ContainerUtil.newArrayList();
            this.newDrivers = ContainerUtil.newArrayList();
            this.facade = psiFacade;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFacade", "com/intellij/database/view/ui/DatabaseConfigEditorImpl$DataSourceSettings", "<init>"));
        }
    }
}

