/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.ui;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.inject.Singleton;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.StringUtil;
import org.wiztools.restclient.IGlobalOptions;
import org.wiztools.restclient.ServiceLocator;

@Singleton
class RecentFilesHelper {
    private static final String KEY_RECENT_FILES = "recent.files";
    private static final String KEY_RECENT_FILES_COUNT = "recent.files.count";
    private static final String SPLIT_KEY = ";";
    private static final int DEFAULT_RECENT_FILES_COUNT = 10;
    private int recentFilesCount = 10;
    private final LinkedList<File> recentFiles = new LinkedList();
    private final IGlobalOptions options = ServiceLocator.getInstance(IGlobalOptions.class);
    private static final Logger LOG = Logger.getLogger(RecentFilesHelper.class.getName());

    RecentFilesHelper() {
        String recentOpenedFilesStr = this.options.getProperty(KEY_RECENT_FILES);
        if (StringUtil.isNotEmpty(recentOpenedFilesStr)) {
            List<File> l = this.getListRepresentation(recentOpenedFilesStr);
            this.recentFiles.addAll(l);
        }
        try {
            this.recentFilesCount = Integer.parseInt(this.options.getProperty(KEY_RECENT_FILES_COUNT));
            if (this.recentFilesCount < 10) {
                this.recentFilesCount = 10;
            }
        }
        catch (NumberFormatException ex) {
            LOG.warning("Property contains non-numeric value: recent.files.count");
        }
    }

    protected final String getStringRepresentation(LinkedList<File> recentFiles) {
        StringBuilder sb = new StringBuilder();
        for (File file : recentFiles) {
            try {
                sb.append(URLEncoder.encode(file.getAbsolutePath(), Charsets.UTF_8.name()));
                sb.append(SPLIT_KEY);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    protected final List<File> getListRepresentation(String recentFilesStr) {
        String[] arr;
        if (StringUtil.isEmpty(recentFilesStr)) {
            return Collections.emptyList();
        }
        LinkedList<File> out = new LinkedList<File>();
        for (String str : arr = recentFilesStr.split(SPLIT_KEY)) {
            try {
                out.addLast(new File(URLDecoder.decode(str, Charsets.UTF_8.name())));
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        return out;
    }

    void openedFile(File f) {
        this.recentFiles.remove(f);
        this.recentFiles.addFirst(f);
        if (this.recentFiles.size() == 11) {
            this.recentFiles.removeLast();
        }
    }

    List<File> getRecentFiles() {
        return Collections.unmodifiableList(this.recentFiles);
    }

    boolean isEmpty() {
        return this.recentFiles.isEmpty();
    }

    void clear() {
        this.recentFiles.clear();
    }

    void store() {
        if (this.recentFiles.isEmpty()) {
            this.options.removeProperty(KEY_RECENT_FILES);
        } else {
            this.options.setProperty(KEY_RECENT_FILES, this.getStringRepresentation(this.recentFiles));
        }
        this.options.setProperty(KEY_RECENT_FILES_COUNT, String.valueOf(this.recentFilesCount));
    }
}

