/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import org.intellij.plugins.relaxNG.model.descriptors.CompositeDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngElementDescriptor;
import org.intellij.plugins.relaxNG.model.descriptors.RngXmlAttributeDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.rngom.digested.DElementPattern;

final class RngDocumentationProvider
implements DocumentationProvider {
    private static final Logger LOG = Logger.getInstance(RngDocumentationProvider.class);
    @NonNls
    private static final String COMPATIBILITY_ANNOTATIONS_1_0 = "http://relaxng.org/ns/compatibility/annotations/1.0";

    RngDocumentationProvider() {
    }

    @Nullable
    @Nls
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        XmlElement c = (XmlElement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, (Class[])new Class[]{XmlTag.class, XmlAttribute.class});
        if (c != null && c.getManager() == null) {
            LOG.warn("Invalid context element passed to generateDoc()", new Throwable("<stack trace>"));
            return null;
        }
        if (c instanceof XmlTag) {
            PsiElement declaration;
            XmlTag xmlElement = (XmlTag)c;
            XmlElementDescriptor descriptor = xmlElement.getDescriptor();
            if (descriptor instanceof CompositeDescriptor) {
                CompositeDescriptor d = (CompositeDescriptor)descriptor;
                StringBuilder sb = new StringBuilder();
                DElementPattern[] patterns = d.getElementPatterns();
                ReferenceOpenHashSet elements = new ReferenceOpenHashSet();
                for (DElementPattern pattern2 : patterns) {
                    PsiElement psiElement = d.getDeclaration(pattern2.getLocation());
                    if (!(psiElement instanceof XmlTag) || !elements.add(psiElement)) continue;
                    if (sb.length() > 0) {
                        sb.append("<hr>");
                    }
                    sb.append((CharSequence)RngDocumentationProvider.getDocumentationFromTag((XmlTag)psiElement, xmlElement.getLocalName(), "Element"));
                }
                return RngDocumentationProvider.makeDocumentation(sb);
            }
            if (descriptor instanceof RngElementDescriptor && (declaration = descriptor.getDeclaration()) instanceof XmlTag) {
                return RngDocumentationProvider.makeDocumentation(RngDocumentationProvider.getDocumentationFromTag((XmlTag)declaration, xmlElement.getLocalName(), "Element"));
            }
        } else if (c instanceof XmlAttribute) {
            XmlAttribute attribute = (XmlAttribute)c;
            XmlAttributeDescriptor descriptor = attribute.getDescriptor();
            if (descriptor instanceof RngXmlAttributeDescriptor) {
                StringBuilder sb = new StringBuilder();
                ReferenceOpenHashSet declaration = new ReferenceOpenHashSet(descriptor.getDeclarations());
                for (PsiElement psiElement : declaration) {
                    if (!(psiElement instanceof XmlTag)) continue;
                    if (sb.length() > 0) {
                        sb.append("<hr>");
                    }
                    sb.append((CharSequence)RngDocumentationProvider.getDocumentationFromTag((XmlTag)psiElement, descriptor.getName(), "Attribute"));
                }
                return RngDocumentationProvider.makeDocumentation(sb);
            }
        } else if (element instanceof XmlTag) {
            return RngDocumentationProvider.makeDocumentation(RngDocumentationProvider.getDocumentationFromTag((XmlTag)element, ((XmlTag)element).getLocalName(), "Element"));
        }
        return null;
    }

    private static String makeDocumentation(CharSequence sb) {
        if (sb == null) {
            return null;
        }
        String s = sb.toString().replaceAll("\n", "<br>");
        if (!s.startsWith("<html>")) {
            s = XmlStringUtil.wrapInHtml((CharSequence)s);
        }
        return s;
    }

    private static StringBuilder getDocumentationFromTag(XmlTag tag, String localName, String kind) {
        if (tag.getNamespace().equals("http://relaxng.org/ns/structure/1.0")) {
            XmlTag[] docTags;
            StringBuilder sb = new StringBuilder();
            sb.append(kind).append(": <b>").append(localName).append("</b><br>");
            for (XmlTag docTag : docTags = tag.findSubTags("documentation", COMPATIBILITY_ANNOTATIONS_1_0)) {
                sb.append(docTag.getValue().getTrimmedText());
                sb.append("\n");
            }
            XmlTag nextTag = (XmlTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, XmlTag.class);
            if (nextTag != null && "documentation".equals(nextTag.getLocalName()) && COMPATIBILITY_ANNOTATIONS_1_0.equals(nextTag.getNamespace())) {
                sb.append(nextTag.getValue().getTrimmedText());
            }
            return sb;
        }
        return null;
    }

    public int hashCode() {
        return 0;
    }
}

