/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.NotNull;

public class VcsSelection {
    private final Document myDocument;
    private final int mySelectionStartLineNumber;
    private final int mySelectionEndLineNumber;
    private final @NlsActions.ActionText String myActionName;
    @NlsContexts.DialogTitle
    private final String myDialogTitle;

    public VcsSelection(@NotNull Document document2, TextRange textRange, String actionName) {
        if (document2 == null) {
            VcsSelection.$$$reportNull$$$0(0);
        }
        this.myDocument = document2;
        int startOffset = textRange.getStartOffset();
        this.mySelectionStartLineNumber = document2.getLineNumber(startOffset);
        int endOffset = textRange.getEndOffset();
        this.mySelectionEndLineNumber = endOffset >= document2.getTextLength() ? document2.getLineCount() - 1 : document2.getLineNumber(endOffset);
        this.myActionName = VcsBundle.message("show.history.action.name.template", actionName);
        this.myDialogTitle = VcsBundle.message("show.history.dialog.title.template", actionName);
    }

    @NotNull
    public Document getDocument() {
        Document document2 = this.myDocument;
        if (document2 == null) {
            VcsSelection.$$$reportNull$$$0(1);
        }
        return document2;
    }

    public int getSelectionStartLineNumber() {
        return this.mySelectionStartLineNumber;
    }

    public int getSelectionEndLineNumber() {
        return this.mySelectionEndLineNumber;
    }

    @NlsActions.ActionText
    public String getActionName() {
        return this.myActionName;
    }

    @NlsContexts.DialogTitle
    public String getDialogTitle() {
        return this.myDialogTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsSelection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsSelection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1 -> new IllegalStateException(string2);
        };
    }
}

