/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.vcs.commit.CommitExceptionWithActions;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcs.commit.ShowNotificationCommitResultHandlerKt;
import com.intellij.vcs.commit.VcsCommitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0003J\r\u0010\u000b\u001a\u00070\t\u00a2\u0006\u0002\b\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/commit/ShowNotificationCommitResultHandler;", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "committer", "Lcom/intellij/vcs/commit/VcsCommitter;", "(Lcom/intellij/vcs/commit/VcsCommitter;)V", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "getCommitSummary", "", "Lcom/intellij/openapi/util/NlsSafe;", "getFileSummaryReport", "Lorg/jetbrains/annotations/Nls;", "onCancel", "", "onFailure", "onSuccess", "reportResult", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nShowNotificationCommitResultHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n800#2,11:95\n1360#2:106\n1446#2,5:107\n1855#2,2:112\n1549#2:114\n1620#2,3:115\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 ShowNotificationCommitResultHandler.kt\ncom/intellij/vcs/commit/ShowNotificationCommitResultHandler\n*L\n43#1:95,11\n43#1:106\n43#1:107,5\n61#1:112,2\n76#1:114\n76#1:115,3\n81#1:118\n81#1:119,3\n*E\n"})
public final class ShowNotificationCommitResultHandler
implements CommitterResultHandler {
    @NotNull
    private final VcsCommitter committer;
    private final VcsNotifier notifier;

    public ShowNotificationCommitResultHandler(@NotNull VcsCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
        this.committer = committer;
        this.notifier = VcsNotifier.getInstance(this.committer.getProject());
    }

    @Override
    public void onSuccess() {
        this.reportResult();
    }

    @Override
    public void onCancel() {
        this.notifier.notifyMinorWarning("vcs.commit.canceled", "", VcsBundle.message("vcs.commit.canceled", new Object[0]));
    }

    @Override
    public void onFailure() {
        this.reportResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void reportResult() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        void $this$filterIsInstanceTo$iv$iv;
        String message2 = this.getCommitSummary();
        List<VcsException> allExceptions = this.committer.getExceptions();
        if (allExceptions.isEmpty()) {
            this.notifier.notifyMinorInfo("vcs.commit.finished", "", message2);
            return;
        }
        List<VcsException> errors = Committer.Companion.collectErrors(allExceptions);
        int errorsSize = errors.size();
        int warningsSize = allExceptions.size() - errorsSize;
        Iterable $this$filterIsInstance$iv = allExceptions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CommitExceptionWithActions)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            CommitExceptionWithActions it = (CommitExceptionWithActions)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getActions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List notificationActions = (List)destination$iv$iv;
        String title2 = null;
        String displayId = null;
        NotificationType notificationType = null;
        if (errorsSize > 0) {
            displayId = "vcs.commit.failed";
            $i$f$flatMapTo = new Object[]{errorsSize};
            String string2 = VcsBundle.message("message.text.commit.failed.with.error", $i$f$flatMapTo);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"message.text.co\u2026.with.error\", errorsSize)");
            title2 = string2;
            notificationType = NotificationType.ERROR;
        } else {
            displayId = "vcs.commit.finished.with.warnings";
            $i$f$flatMapTo = new Object[]{warningsSize};
            String string3 = VcsBundle.message("message.text.commit.finished.with.warning", $i$f$flatMapTo);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"message.text.co\u2026h.warning\", warningsSize)");
            title2 = string3;
            notificationType = NotificationType.WARNING;
        }
        Notification notification = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title2, message2, notificationType);
        notification.setDisplayId(displayId);
        Iterable $this$forEach$iv = notificationActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotificationAction it = (NotificationAction)element$iv;
            boolean bl = false;
            notification.addAction((AnAction)it);
        }
        VcsNotifier.addShowDetailsAction(this.committer.getProject(), notification);
        notification.notify(this.committer.getProject());
    }

    /*
     * WARNING - void declaration
     */
    @NlsContexts.NotificationContent
    private final String getCommitSummary() {
        List<VcsException> exceptions2;
        Collection<HtmlChunk> collection;
        Collection destination$iv$iv;
        HtmlBuilder htmlBuilder;
        HtmlChunk htmlChunk;
        Set<String> feedback;
        HtmlBuilder htmlBuilder2;
        HtmlBuilder $this$getCommitSummary_u24lambda_u243 = htmlBuilder2 = new HtmlBuilder();
        boolean bl = false;
        $this$getCommitSummary_u24lambda_u243.append(this.getFileSummaryReport());
        String commitMessage = this.committer.getCommitMessage();
        if (!StringUtil.isEmpty((String)commitMessage)) {
            $this$getCommitSummary_u24lambda_u243.append(": ").append(commitMessage);
        }
        if (!((Collection)(feedback = this.committer.getFeedback())).isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getCommitSummary_u24lambda_u243.br();
            Iterable iterable = feedback;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u243;
            boolean $i$f$map = false;
            void var10_11 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(HtmlChunk.text((String)p0));
            }
            collection = (List)destination$iv$iv;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        if (!ShowNotificationCommitResultHandlerKt.access$hasOnlyWarnings(exceptions2 = this.committer.getExceptions())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            $this$getCommitSummary_u24lambda_u243.br();
            Iterable $i$f$map = exceptions2;
            htmlChunk = (HtmlChunk)HtmlChunk.br();
            htmlBuilder = $this$getCommitSummary_u24lambda_u243;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VcsException bl2 = (VcsException)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(HtmlChunk.text((String)it.getMessage()));
            }
            collection = (List)destination$iv$iv2;
            htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection);
        }
        String string3 = htmlBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"HtmlBuilder().apply {\n  \u2026) })\n    }\n  }.toString()");
        return string3;
    }

    private final String getFileSummaryReport() {
        int failed = this.committer.getFailedToCommitChanges().size();
        int committed = this.committer.getChanges().size() - failed;
        if (failed > 0) {
            Object[] objectArray = new Object[]{committed, failed};
            String string2 = VcsBundle.message("vcs.commit.files.committed.and.files.failed.to.commit", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"vcs.commit.file\u2026mmit\", committed, failed)");
            return string2;
        }
        Object[] objectArray = new Object[]{committed};
        String string3 = VcsBundle.message("vcs.commit.files.committed", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"vcs.commit.files.committed\", committed)");
        return string3;
    }
}

