/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.vfs;

import com.intellij.codeInsight.daemon.OutsidersPsiFileSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.vfs.VcsFileSystem;
import com.intellij.openapi.vcs.vfs.VcsVirtualFolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractVcsVirtualFile
extends VirtualFile {
    @NlsSafe
    protected final String myName;
    @NlsSafe
    protected final String myPath;
    @NlsSafe
    protected String myRevision;
    private final VirtualFile myParent;
    protected int myModificationStamp;
    @NotNull
    private final VirtualFileSystem myFileSystem;

    protected AbstractVcsVirtualFile(String path2, @NotNull VirtualFileSystem fileSystem) {
        if (fileSystem == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(0);
        }
        this.myModificationStamp = 0;
        this.myFileSystem = fileSystem;
        this.myPath = path2;
        File file = new File(this.myPath);
        this.myName = file.getName();
        this.myParent = !this.isDirectory() ? new VcsVirtualFolder(file.getParent(), this, this.myFileSystem) : null;
        OutsidersPsiFileSupport.markFile((VirtualFile)this);
    }

    protected AbstractVcsVirtualFile(@Nullable VirtualFile parent, @NotNull String name, @NotNull VirtualFileSystem fileSystem) {
        if (name == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(1);
        }
        if (fileSystem == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(2);
        }
        this.myModificationStamp = 0;
        this.myFileSystem = fileSystem;
        this.myPath = parent != null && !StringUtil.isEmpty((String)parent.getPath()) ? parent.getPath() + "/" + name : name;
        this.myName = name;
        this.myParent = parent;
        OutsidersPsiFileSupport.markFile((VirtualFile)this);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFileSystem;
        if (virtualFileSystem == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(3);
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string2 = this.myPath;
        if (string2 == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public String getPresentableName() {
        String string2 = this.getPresentableName(this.myName);
        if (string2 == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    @Nls
    protected String getPresentableName(@NotNull @Nls String baseName) {
        if (baseName == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(7);
        }
        if (this.myRevision == null) {
            String string2 = baseName;
            if (string2 == null) {
                AbstractVcsVirtualFile.$$$reportNull$$$0(8);
            }
            return string2;
        }
        String string3 = baseName + " (" + this.myRevision + ")";
        if (string3 == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(9);
        }
        return string3;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return this.myParent;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM((byte[])this.contentsToByteArray(), (VirtualFile)this);
        if (inputStream == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(10);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new RuntimeException(VcsFileSystem.getCouldNotImplementMessage());
    }

    public abstract byte @NotNull [] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        return this.myModificationStamp;
    }

    public long getTimeStamp() {
        return this.myModificationStamp;
    }

    public long getLength() {
        try {
            return this.contentsToByteArray().length;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        if (postRunnable != null) {
            postRunnable.run();
        }
    }

    protected void setRevision(String revision) {
        this.myRevision = revision;
    }

    protected void showLoadingContentFailedMessage(@NotNull VcsException e) {
        if (e == null) {
            AbstractVcsVirtualFile.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((String)VcsBundle.message("message.text.could.not.load.virtual.file.content", this.getPresentableUrl(), e.getLocalizedMessage()), (String)VcsBundle.message("message.title.could.not.load.content", new Object[0]), (Icon)Messages.getInformationIcon()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSystem";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showLoadingContentFailedMessage";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 4, 5, 6, 8, 9, 10 -> new IllegalStateException(string2);
        };
    }
}

