/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.history.VcsHistoryCache;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vcs.impl.VcsEP;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;

public class VcsCacheManager {
    private final VcsHistoryCache myVcsHistoryCache;
    private final ContentRevisionCache myContentRevisionCache;

    public static VcsCacheManager getInstance(Project project2) {
        return (VcsCacheManager)project2.getService(VcsCacheManager.class);
    }

    public VcsCacheManager(@NotNull Project project2) {
        if (project2 == null) {
            VcsCacheManager.$$$reportNull$$$0(0);
        }
        this.myVcsHistoryCache = new VcsHistoryCache();
        this.myContentRevisionCache = new ContentRevisionCache();
        MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this.myVcsHistoryCache::clearAll);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, this.myVcsHistoryCache::clearAll);
        connection.subscribe(UpdatedFilesListener.UPDATED_FILES, this.myContentRevisionCache::clearCurrent);
        VcsEP.EP_NAME.addChangeListener(() -> {
            this.myVcsHistoryCache.clearAll();
            this.myContentRevisionCache.clearAll();
        }, (Disposable)project2);
    }

    public VcsHistoryCache getVcsHistoryCache() {
        return this.myVcsHistoryCache;
    }

    public ContentRevisionCache getContentRevisionCache() {
        return this.myContentRevisionCache;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/impl/VcsCacheManager", "<init>"));
    }
}

