/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.dialog.ModelScopeItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.Nullable;

public class VcsScopeItem
implements ModelScopeItem {
    private final ChangeListManager myChangeListManager;
    private final DefaultComboBoxModel<LocalChangeList> myModel;
    private final Project myProject;

    @Nullable
    public static VcsScopeItem createIfHasVCS(Project project2) {
        if (ChangeListManager.getInstance(project2).getAffectedFiles().isEmpty()) {
            return null;
        }
        return new VcsScopeItem(project2);
    }

    public VcsScopeItem(Project project2) {
        this.myProject = project2;
        this.myChangeListManager = ChangeListManager.getInstance(project2);
        assert (!this.myChangeListManager.getAffectedFiles().isEmpty());
        if (ChangesUtil.hasMeaningfulChangelists(this.myProject)) {
            this.myModel = new DefaultComboBoxModel();
            this.myModel.addElement(null);
            List<LocalChangeList> changeLists = this.myChangeListManager.getChangeLists();
            for (LocalChangeList changeList : changeLists) {
                this.myModel.addElement(changeList);
            }
        } else {
            this.myModel = null;
        }
    }

    public AnalysisScope getScope() {
        LocalChangeList list;
        ChangeList changeList;
        ChangeList changeList2 = changeList = this.myModel != null ? (ChangeList)this.myModel.getSelectedItem() : null;
        List<Object> files2 = changeList == null ? this.myChangeListManager.getAffectedFiles() : ((list = this.myChangeListManager.findChangeList(changeList.getName())) != null ? ChangesUtil.iterateAfterRevisionsFiles(list.getChanges()).toList() : Collections.emptyList());
        return new AnalysisScope(this.myProject, new HashSet<VirtualFile>(files2));
    }

    @Nullable
    public DefaultComboBoxModel<LocalChangeList> getChangeListsModel() {
        return this.myModel;
    }
}

