/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.version;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;
import org.apache.ivy.plugins.version.AbstractVersionMatcher;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Checks;

public class ChainVersionMatcher
extends AbstractVersionMatcher {
    private final List<VersionMatcher> matchers = new LinkedList<VersionMatcher>();

    public ChainVersionMatcher() {
        super("chain");
    }

    public void add(VersionMatcher matcher2) {
        Checks.checkNotNull(matcher2, "matcher");
        this.matchers.add(0, matcher2);
        if (this.getSettings() != null && matcher2 instanceof IvySettingsAware) {
            ((IvySettingsAware)((Object)matcher2)).setSettings(this.getSettings());
        }
    }

    @Override
    public void setSettings(IvySettings settings2) {
        super.setSettings(settings2);
        for (VersionMatcher matcher2 : this.matchers) {
            if (!(matcher2 instanceof IvySettingsAware)) continue;
            ((IvySettingsAware)((Object)matcher2)).setSettings(settings2);
        }
    }

    public List<VersionMatcher> getMatchers() {
        return Collections.unmodifiableList(this.matchers);
    }

    @Override
    public boolean isDynamic(ModuleRevisionId askedMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        for (VersionMatcher matcher2 : this.matchers) {
            if (!matcher2.isDynamic(askedMrid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid, Comparator<ModuleRevisionId> staticComparator) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Checks.checkNotNull(staticComparator, "staticComparator");
        for (VersionMatcher matcher2 : this.matchers) {
            if (!matcher2.isDynamic(askedMrid)) continue;
            return matcher2.compare(askedMrid, foundMrid, staticComparator);
        }
        throw new IllegalArgumentException("impossible to compare revisions: askedMrid is not dynamic: " + askedMrid);
    }

    @Override
    public boolean accept(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Iterator<VersionMatcher> iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher2 = iter.next();
            if (iter.hasNext() && !matcher2.isDynamic(askedMrid)) continue;
            return matcher2.accept(askedMrid, foundMrid);
        }
        return false;
    }

    @Override
    public boolean needModuleDescriptor(ModuleRevisionId askedMrid, ModuleRevisionId foundMrid) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMrid, "foundMrid");
        Iterator<VersionMatcher> iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher2 = iter.next();
            if (iter.hasNext() && !matcher2.isDynamic(askedMrid)) continue;
            return matcher2.needModuleDescriptor(askedMrid, foundMrid);
        }
        return false;
    }

    @Override
    public boolean accept(ModuleRevisionId askedMrid, ModuleDescriptor foundMD) {
        Checks.checkNotNull(askedMrid, "askedMrid");
        Checks.checkNotNull(foundMD, "foundMD");
        Iterator<VersionMatcher> iter = this.matchers.iterator();
        while (iter.hasNext()) {
            VersionMatcher matcher2 = iter.next();
            if (iter.hasNext() && !matcher2.isDynamic(askedMrid)) continue;
            return matcher2.accept(askedMrid, foundMD);
        }
        return false;
    }
}

