/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.trigger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.event.IvyEvent;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.plugins.trigger.AbstractTrigger;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;

public class LogTrigger
extends AbstractTrigger {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private String message = "";
    private File file = null;
    private boolean append = true;
    private String encoding;

    @Override
    public void progress(IvyEvent event2) {
        this.log(IvyPatternHelper.substituteVariables(this.message, event2.getAttributes()));
    }

    protected void log(String message2) {
        if (this.file == null) {
            Message.info(message2);
        } else {
            Writer out = null;
            try {
                message2 = message2 + LINE_SEPARATOR;
                String filename = this.file.getAbsolutePath();
                out = StringUtils.isNullOrEmpty(this.encoding) ? new FileWriter(filename, this.append) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename, this.append), this.encoding));
                out.write(message2, 0, message2.length());
            }
            catch (IOException e) {
                throw new ResolveProcessException(e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        throw new ResolveProcessException(e);
                    }
                }
            }
        }
    }

    public void setMessage(String msg) {
        this.message = msg;
    }

    public void setFile(File file2) {
        this.file = file2;
    }

    public void setAppend(boolean append2) {
        this.append = append2;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

