/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.repository.url;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.settings.TimeoutConstraint;
import org.apache.ivy.plugins.repository.AbstractRepository;
import org.apache.ivy.plugins.repository.RepositoryCopyProgressListener;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.url.ApacheURLLister;

public class URLRepository
extends AbstractRepository {
    private RepositoryCopyProgressListener progress = new RepositoryCopyProgressListener(this);
    private final Map<String, Resource> resourcesCache = new HashMap<String, Resource>();
    private ApacheURLLister lister = new ApacheURLLister();

    public URLRepository() {
    }

    public URLRepository(TimeoutConstraint timeoutConstraint) {
        super(timeoutConstraint);
    }

    @Override
    public Resource getResource(String source2) throws IOException {
        Resource res = this.resourcesCache.get(source2);
        if (res == null) {
            res = new URLResource(new URL(source2), this.getTimeoutConstraint());
            this.resourcesCache.put(source2, res);
        }
        return res;
    }

    @Override
    public void get(String source2, File destination) throws IOException {
        this.fireTransferInitiated(this.getResource(source2), 5);
        try {
            Resource res = this.getResource(source2);
            long totalLength = res.getContentLength();
            if (totalLength > 0L) {
                this.progress.setTotalLength(totalLength);
            }
            FileUtil.copy(new URL(source2), destination, (CopyProgressListener)this.progress, this.getTimeoutConstraint());
        }
        catch (IOException | RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    @Override
    public void put(File source2, String destination, boolean overwrite) throws IOException {
        if (!overwrite && this.getResource(destination).exists()) {
            throw new IOException("destination file exists and overwrite == false");
        }
        this.fireTransferInitiated(this.getResource(destination), 6);
        try {
            long totalLength = source2.length();
            if (totalLength > 0L) {
                this.progress.setTotalLength(totalLength);
            }
            FileUtil.copy(source2, new URL(destination), (CopyProgressListener)this.progress, this.getTimeoutConstraint());
        }
        catch (IOException | RuntimeException ex) {
            this.fireTransferError(ex);
            throw ex;
        }
        finally {
            this.progress.setTotalLength(null);
        }
    }

    @Override
    public List<String> list(String parent) throws IOException {
        if (parent.startsWith("http")) {
            List<URL> urls = this.lister.listAll(new URL(parent));
            if (urls != null) {
                ArrayList<String> ret = new ArrayList<String>(urls.size());
                for (URL url2 : urls) {
                    ret.add(url2.toExternalForm());
                }
                return ret;
            }
        } else if (parent.startsWith("file")) {
            String path2;
            try {
                URI uri = new URI(parent);
                path2 = uri.isOpaque() ? uri.getSchemeSpecificPart() : uri.getPath();
            }
            catch (URISyntaxException e) {
                throw new IOException("Couldn't list content of '" + parent + "'", e);
            }
            File file2 = new File(path2);
            if (file2.exists() && file2.isDirectory()) {
                String[] files2 = file2.list();
                ArrayList<String> ret = new ArrayList<String>(files2.length);
                URL context2 = path2.endsWith("/") ? new URL(parent) : new URL(parent + "/");
                for (String fileName : files2) {
                    ret.add(new URL(context2, fileName).toExternalForm());
                }
                return ret;
            }
            return Collections.emptyList();
        }
        return null;
    }
}

