/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.lineSeparator();

    private XmlModuleDescriptorUpdater() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL srcURL, File destFile, UpdateOptions options2) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream destStream = new FileOutputStream(destFile);
        try {
            XmlModuleDescriptorUpdater.update(srcURL, destStream, options2);
        }
        finally {
            try {
                ((OutputStream)destStream).close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(URL srcURL, OutputStream destFile, UpdateOptions options2) throws IOException, SAXException {
        InputStream in = srcURL.openStream();
        try {
            XmlModuleDescriptorUpdater.update(srcURL, in, destFile, options2);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
            try {
                destFile.close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(InputStream in, Resource res, File destFile, UpdateOptions options2) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(destFile);
        try {
            URL inputStreamContext = null;
            if (res instanceof URLResource) {
                inputStreamContext = ((URLResource)res).getURL();
            } else if (res instanceof FileResource) {
                inputStreamContext = ((FileResource)res).getFile().toURI().toURL();
            }
            XmlModuleDescriptorUpdater.update(inputStreamContext, in, fos, options2);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
            try {
                ((OutputStream)fos).close();
            }
            catch (IOException e) {
                Message.warn("failed to close a stream : " + e.toString());
            }
        }
    }

    public static void update(URL inStreamCtx, InputStream inStream, OutputStream outStream, UpdateOptions options2) throws IOException, SAXException {
        PrintWriter out = new PrintWriter(new OutputStreamWriter(outStream, StandardCharsets.UTF_8));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.write(LINE_SEPARATOR);
        try {
            UpdaterHandler updaterHandler = new UpdaterHandler(inStreamCtx, out, options2);
            InputSource inSrc = new InputSource(new BufferedInputStream(inStream));
            if (inStreamCtx != null) {
                inSrc.setSystemId(inStreamCtx.toExternalForm());
            }
            XMLHelper.parse(inSrc, null, (DefaultHandler)updaterHandler, (LexicalHandler)updaterHandler);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("impossible to update Ivy files: parser problem", e);
        }
    }

    protected static class ConfigurationPrinter
    implements ItemPrinter {
        public static final ConfigurationPrinter INSTANCE = new ConfigurationPrinter();

        protected ConfigurationPrinter() {
        }

        @Override
        public void print(ModuleDescriptor parent, Object item2, PrintWriter out) {
            XmlModuleDescriptorWriter.printConfiguration((Configuration)item2, out);
        }
    }

    protected static class DependencyPrinter
    implements ItemPrinter {
        public static final DependencyPrinter INSTANCE = new DependencyPrinter();

        protected DependencyPrinter() {
        }

        @Override
        public void print(ModuleDescriptor parent, Object item2, PrintWriter out) {
            XmlModuleDescriptorWriter.printDependency(parent, (DependencyDescriptor)item2, out);
        }
    }

    protected static interface ItemPrinter {
        public void print(ModuleDescriptor var1, Object var2, PrintWriter var3);
    }

    private static class ExtendedBuffer {
        private String context = null;
        private Boolean print = null;
        private boolean defaultPrint = false;
        private StringWriter buffer = new StringWriter();
        private PrintWriter writer = new PrintWriter(this.buffer);

        ExtendedBuffer(String context2) {
            this.context = context2;
        }

        boolean isPrint() {
            if (this.print == null) {
                return this.defaultPrint;
            }
            return this.print;
        }

        void setPrint(boolean print2) {
            this.print = print2;
        }

        void setDefaultPrint(boolean print2) {
            this.defaultPrint = print2;
        }

        PrintWriter getWriter() {
            return this.writer;
        }

        String getContext() {
            return this.context;
        }

        public String toString() {
            this.writer.flush();
            return this.buffer.toString();
        }
    }

    private static class UpdaterHandler
    extends DefaultHandler
    implements LexicalHandler {
        private static final Collection<String> STD_ATTS = Arrays.asList("organisation", "module", "branch", "revision", "status", "publication", "namespace");
        private static final List<String> MODULE_ELEMENTS = Arrays.asList("info", "configurations", "publications", "dependencies", "conflicts");
        private static final int CONFIGURATIONS_POSITION = MODULE_ELEMENTS.indexOf("configurations");
        private static final int DEPENDENCIES_POSITION = MODULE_ELEMENTS.indexOf("dependencies");
        private static final Collection<String> INFO_ELEMENTS = Arrays.asList("extends", "ivyauthor", "license", "repository", "description");
        private final ParserSettings settings;
        private final PrintWriter out;
        private final Map<ModuleRevisionId, String> resolvedRevisions;
        private final Map<ModuleRevisionId, String> resolvedBranches;
        private final String status;
        private final String revision;
        private final Date pubdate;
        private final Namespace ns;
        private final boolean replaceInclude;
        private final boolean generateRevConstraint;
        private boolean inHeader = true;
        private final List<String> confs;
        private final URL relativePathCtx;
        private final UpdateOptions options;
        private String organisation = null;
        private String defaultConf = null;
        private String defaultConfMapping = null;
        private Boolean confMappingOverride = null;
        private String justOpen = null;
        private boolean indenting;
        private StringBuilder currentIndent = new StringBuilder();
        private List<String> indentLevels = new ArrayList<String>();
        private boolean hasDescription = false;
        private boolean mergedConfigurations = false;
        private boolean mergedDependencies = false;
        private String newDefaultConf = null;
        private Stack<String> context = new Stack();
        private Stack<ExtendedBuffer> buffers = new Stack();
        private Stack<ExtendedBuffer> confAttributeBuffers = new Stack();

        public UpdaterHandler(URL relativePathCtx, PrintWriter out, UpdateOptions options2) {
            this.options = options2;
            this.settings = options2.getSettings();
            this.out = out;
            this.resolvedRevisions = options2.getResolvedRevisions();
            this.resolvedBranches = options2.getResolvedBranches();
            this.status = options2.getStatus();
            this.revision = options2.getRevision();
            this.pubdate = options2.getPubdate();
            this.ns = options2.getNamespace();
            this.replaceInclude = options2.isReplaceInclude();
            this.generateRevConstraint = options2.isGenerateRevConstraint();
            this.relativePathCtx = relativePathCtx;
            this.confs = options2.getConfsToExclude() != null ? Arrays.asList(options2.getConfsToExclude()) : Collections.emptyList();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.inHeader = false;
            this.endIndent();
            if (this.justOpen != null) {
                this.write(">");
            }
            this.flushMergedElementsBefore(qName);
            if (this.options.isMerge() && ("exclude".equals(localName) || "override".equals(localName) || "conflict".equals(localName)) && "ivy-module/dependencies".equals(this.getContext())) {
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                this.writeInheritedDependencies(merged);
                this.out.println();
                this.out.print(this.getIndent());
            }
            this.context.push(qName);
            String path2 = this.getContext();
            if ("info".equals(qName)) {
                this.infoStarted(attributes);
            } else if (this.replaceInclude && "include".equals(qName) && this.context.contains("configurations")) {
                this.includeStarted(attributes);
            } else if ("ivy-module/info/extends".equals(path2)) {
                if (this.options.isMerge()) {
                    ModuleDescriptor mergedDescriptor = this.options.getMergedDescriptor();
                    for (ExtendsDescriptor inheritedDescriptor : mergedDescriptor.getInheritedDescriptors()) {
                        ModuleDescriptor rprid = inheritedDescriptor.getParentMd();
                        if (!(rprid instanceof DefaultModuleDescriptor)) continue;
                        DefaultModuleDescriptor defaultModuleDescriptor = (DefaultModuleDescriptor)rprid;
                        if (defaultModuleDescriptor.getDefaultConf() != null) {
                            this.defaultConf = defaultModuleDescriptor.getDefaultConf();
                        }
                        if (defaultModuleDescriptor.getDefaultConfMapping() != null) {
                            this.defaultConfMapping = defaultModuleDescriptor.getDefaultConfMapping();
                        }
                        if (!defaultModuleDescriptor.isMappingOverride()) continue;
                        this.confMappingOverride = Boolean.TRUE;
                    }
                }
                this.startExtends(attributes);
            } else if ("ivy-module/dependencies/dependency".equals(path2)) {
                this.startElementInDependency(attributes);
            } else if ("ivy-module/configurations/conf".equals(path2)) {
                this.startElementInConfigurationsConf(qName, attributes);
            } else if ("dependencies".equals(qName) || "configurations".equals(qName)) {
                this.startElementWithConfAttributes(qName, attributes);
            } else if ("ivy-module/publications/artifact/conf".equals(path2) || "ivy-module/dependencies/dependency/conf".equals(path2) || "ivy-module/dependencies/dependency/artifact/conf".equals(path2)) {
                this.buffers.push(new ExtendedBuffer(this.getContext()));
                this.confAttributeBuffers.peek().setDefaultPrint(false);
                String confName = this.substitute(this.settings, attributes.getValue("name"));
                if (!this.confs.contains(confName)) {
                    this.confAttributeBuffers.peek().setPrint(true);
                    this.buffers.peek().setPrint(true);
                    this.write("<" + qName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                    }
                }
            } else if ("ivy-module/publications/artifact".equals(path2)) {
                ExtendedBuffer buffer2 = new ExtendedBuffer(this.getContext());
                this.buffers.push(buffer2);
                this.confAttributeBuffers.push(buffer2);
                this.write("<" + qName);
                buffer2.setDefaultPrint(attributes.getValue("conf") == null && (this.newDefaultConf == null || !this.newDefaultConf.isEmpty()));
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    if ("conf".equals(attName)) {
                        String confName = this.substitute(this.settings, attributes.getValue("conf"));
                        String newConf = this.removeConfigurationsFromList(confName);
                        if (newConf.isEmpty()) continue;
                        this.write(" " + attName + "=\"" + newConf + "\"");
                        this.buffers.peek().setPrint(true);
                        continue;
                    }
                    this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/dependencies/dependency/artifact".equals(path2)) {
                ExtendedBuffer buffer3 = new ExtendedBuffer(this.getContext());
                this.buffers.push(buffer3);
                this.confAttributeBuffers.push(buffer3);
                this.write("<" + qName);
                buffer3.setDefaultPrint(attributes.getValue("conf") == null);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String attName = attributes.getQName(i);
                    if ("conf".equals(attName)) {
                        String confName = this.substitute(this.settings, attributes.getValue("conf"));
                        String newConf = this.removeConfigurationsFromList(confName);
                        if (newConf.isEmpty()) continue;
                        this.write(" " + attName + "=\"" + newConf + "\"");
                        this.buffers.peek().setPrint(true);
                        continue;
                    }
                    this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            } else if ("ivy-module/publications".equals(path2)) {
                this.startPublications(attributes);
            } else {
                if (this.options.isMerge() && path2.startsWith("ivy-module/info")) {
                    ModuleDescriptor merged = this.options.getMergedDescriptor();
                    if (path2.equals("ivy-module/info/description")) {
                        this.hasDescription = true;
                    } else if (!INFO_ELEMENTS.contains(qName)) {
                        this.writeInheritedDescription(merged);
                    }
                }
                this.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
            this.justOpen = qName;
        }

        private void startExtends(Attributes attributes) {
            if (this.options.isMerge()) {
                this.write("<!-- ");
            }
            this.write("<extends");
            String org = this.substitute(this.settings, attributes.getValue("organisation"));
            String module2 = this.substitute(this.settings, attributes.getValue("module"));
            ModuleId parentId = new ModuleId(org, module2);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String name2 = attributes.getQName(i);
                String value2 = null;
                switch (name2) {
                    case "organisation": {
                        value2 = org;
                        break;
                    }
                    case "module": {
                        value2 = module2;
                        break;
                    }
                    case "revision": {
                        ModuleDescriptor merged = this.options.getMergedDescriptor();
                        if (merged != null) {
                            ExtendsDescriptor parent;
                            ModuleRevisionId resolvedId;
                            ExtendsDescriptor[] extendsDescriptorArray = merged.getInheritedDescriptors();
                            int n = extendsDescriptorArray.length;
                            for (int j = 0; !(j >= n || parentId.equals((resolvedId = (parent = extendsDescriptorArray[j]).getResolvedParentRevisionId()).getModuleId()) && (value2 = resolvedId.getRevision()) != null); ++j) {
                            }
                        }
                        if (value2 != null) break;
                        value2 = this.substitute(this.settings, attributes.getValue(i));
                        break;
                    }
                    default: {
                        value2 = this.substitute(this.settings, attributes.getValue(i));
                    }
                }
                this.write(" " + name2 + "=\"" + value2 + "\"");
            }
        }

        private void startElementInConfigurationsConf(String qName, Attributes attributes) {
            this.buffers.push(new ExtendedBuffer(this.getContext()));
            String confName = this.substitute(this.settings, attributes.getValue("name"));
            if (!this.confs.contains(confName)) {
                this.buffers.peek().setPrint(true);
                String extend = this.substitute(this.settings, attributes.getValue("extends"));
                if (extend != null) {
                    for (String tok : StringUtils.splitToArray(extend)) {
                        if (!this.confs.contains(tok)) continue;
                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                    }
                }
                this.write("<" + qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    this.write(" " + attributes.getQName(i) + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
                }
            }
        }

        private void startElementWithConfAttributes(String qName, Attributes attributes) {
            String newMapping;
            String newConf;
            this.write("<" + qName);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("defaultconf".equals(attName) || "defaultconfmapping".equals(attName)) {
                    String newMapping2 = this.removeConfigurationsFromMapping(this.substitute(this.settings, attributes.getValue(attName)));
                    if (newMapping2.isEmpty()) continue;
                    this.write(" " + attName + "=\"" + newMapping2 + "\"");
                    continue;
                }
                this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
            if (this.defaultConf != null && attributes.getValue("defaultconf") == null && !(newConf = this.removeConfigurationsFromMapping(this.defaultConf)).isEmpty()) {
                this.write(" defaultconf=\"" + newConf + "\"");
            }
            if (this.defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null && !(newMapping = this.removeConfigurationsFromMapping(this.defaultConfMapping)).isEmpty()) {
                this.write(" defaultconfmapping=\"" + newMapping + "\"");
            }
            if (this.confMappingOverride != null && attributes.getValue("confmappingoverride") == null) {
                this.write(" confmappingoverride=\"" + this.confMappingOverride.toString() + "\"");
            }
        }

        private void startPublications(Attributes attributes) {
            this.write("<publications");
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attName = attributes.getQName(i);
                if ("defaultconf".equals(attName)) {
                    this.newDefaultConf = this.removeConfigurationsFromList(this.substitute(this.settings, attributes.getValue("defaultconf")));
                    if (this.newDefaultConf.isEmpty()) continue;
                    this.write(" " + attName + "=\"" + this.newDefaultConf + "\"");
                    continue;
                }
                this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(i)) + "\"");
            }
        }

        private void startElementInDependency(Attributes attributes) {
            ExtendedBuffer buffer2 = new ExtendedBuffer(this.getContext());
            this.buffers.push(buffer2);
            this.confAttributeBuffers.push(buffer2);
            buffer2.setDefaultPrint(StringUtils.isNullOrEmpty(attributes.getValue("conf")));
            this.write("<dependency");
            String org = this.substitute(this.settings, attributes.getValue("org"));
            if (org == null) {
                org = this.organisation;
            }
            String module2 = this.substitute(this.settings, attributes.getValue("name"));
            String branch2 = this.substitute(this.settings, attributes.getValue("branch"));
            String branchConstraint = this.substitute(this.settings, attributes.getValue("branchConstraint"));
            if (branchConstraint == null) {
                branchConstraint = branch2;
            }
            if (branch2 == null) {
                ModuleId mid = ModuleId.newInstance(org, module2);
                if (this.ns != null) {
                    mid = NameSpaceHelper.transform(mid, this.ns.getToSystemTransformer());
                }
                for (ModuleRevisionId mrid : this.resolvedRevisions.keySet()) {
                    if (!mrid.getModuleId().equals(mid)) continue;
                    branch2 = mrid.getBranch();
                    break;
                }
            }
            String revision = this.substitute(this.settings, attributes.getValue("rev"));
            String revisionConstraint = this.substitute(this.settings, attributes.getValue("revConstraint"));
            Map<String, String> extraAttributes = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, XmlModuleDescriptorParser.DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId localMrid = ModuleRevisionId.newInstance(org, module2, branch2, revision, extraAttributes);
            ModuleRevisionId systemMrid = this.ns == null ? localMrid : this.ns.getToSystemTransformer().transform(localMrid);
            String newBranch = this.resolvedBranches.get(systemMrid);
            block19: for (int i = 0; i < attributes.getLength(); ++i) {
                String attName;
                switch (attName = attributes.getQName(i)) {
                    case "org": {
                        this.write(" org=\"" + systemMrid.getOrganisation() + "\"");
                        continue block19;
                    }
                    case "name": {
                        this.write(" name=\"" + systemMrid.getName() + "\"");
                        continue block19;
                    }
                    case "rev": {
                        String rev = this.resolvedRevisions.get(systemMrid);
                        if (rev == null) {
                            this.write(" rev=\"" + systemMrid.getRevision() + "\"");
                            continue block19;
                        }
                        this.write(" rev=\"" + rev + "\"");
                        if (attributes.getIndex("branchConstraint") == -1 && branchConstraint != null) {
                            this.write(" branchConstraint=\"" + branchConstraint + "\"");
                        }
                        if (!this.generateRevConstraint || attributes.getIndex("revConstraint") != -1 || rev.equals(systemMrid.getRevision())) continue block19;
                        this.write(" revConstraint=\"" + systemMrid.getRevision() + "\"");
                        continue block19;
                    }
                    case "revConstraint": {
                        this.write(" revConstraint=\"" + revisionConstraint + "\"");
                        continue block19;
                    }
                    case "branch": {
                        if (newBranch != null) {
                            this.write(" branch=\"" + newBranch + "\"");
                            continue block19;
                        }
                        if (this.resolvedBranches.containsKey(systemMrid)) continue block19;
                        this.write(" branch=\"" + systemMrid.getBranch() + "\"");
                        continue block19;
                    }
                    case "branchConstraint": {
                        this.write(" branchConstraint=\"" + branchConstraint + "\"");
                        continue block19;
                    }
                    case "conf": {
                        String newMapping;
                        String oldMapping = this.substitute(this.settings, attributes.getValue("conf"));
                        if (oldMapping.isEmpty() || (newMapping = this.removeConfigurationsFromMapping(oldMapping)).isEmpty()) continue block19;
                        this.write(" conf=\"" + newMapping + "\"");
                        this.buffers.peek().setPrint(true);
                        continue block19;
                    }
                    default: {
                        this.write(" " + attName + "=\"" + this.substitute(this.settings, attributes.getValue(attName)) + "\"");
                    }
                }
            }
            if (attributes.getIndex("branch") == -1) {
                if (!StringUtils.isNullOrEmpty(newBranch)) {
                    this.write(" branch=\"" + newBranch + "\"");
                } else if (this.options.isUpdateBranch() && systemMrid.getBranch() != null) {
                    this.write(" branch=\"" + systemMrid.getBranch() + "\"");
                }
            }
        }

        private void includeStarted(Attributes attributes) throws SAXException {
            final ExtendedBuffer buffer2 = new ExtendedBuffer(this.getContext());
            this.buffers.push(buffer2);
            try {
                URL url2;
                if (this.settings == null) {
                    String fileName = attributes.getValue("file");
                    if (fileName == null) {
                        String urlStr = attributes.getValue("url");
                        url2 = new URL(urlStr);
                    } else {
                        url2 = Checks.checkAbsolute(fileName, "settings.include").toURI().toURL();
                    }
                } else {
                    url2 = this.settings.getRelativeUrlResolver().getURL(this.relativePathCtx, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
                }
                XMLHelper.parse(url2, null, new DefaultHandler(){
                    private boolean insideConfigurations = false;
                    private boolean doIndent = false;

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if ("configurations".equals(qName)) {
                            String mappingOverride;
                            String defaultMapping;
                            this.insideConfigurations = true;
                            String defaultconf = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("defaultconf"));
                            if (defaultconf != null) {
                                UpdaterHandler.this.defaultConf = defaultconf;
                            }
                            if ((defaultMapping = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("defaultconfmapping"))) != null) {
                                UpdaterHandler.this.defaultConfMapping = defaultMapping;
                            }
                            if ((mappingOverride = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("confmappingoverride"))) != null) {
                                UpdaterHandler.this.confMappingOverride = Boolean.valueOf(mappingOverride);
                            }
                        } else if ("conf".equals(qName) && this.insideConfigurations) {
                            String confName = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("name"));
                            if (!UpdaterHandler.this.confs.contains(confName)) {
                                String extend;
                                buffer2.setPrint(true);
                                if (this.doIndent) {
                                    UpdaterHandler.this.write("/>\n\t\t");
                                }
                                if ((extend = UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue("extends"))) != null) {
                                    for (String tok : StringUtils.splitToArray(extend)) {
                                        if (!UpdaterHandler.this.confs.contains(tok)) continue;
                                        throw new IllegalArgumentException("Cannot exclude a configuration which is extended.");
                                    }
                                }
                                UpdaterHandler.this.write("<" + qName);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    UpdaterHandler.this.write(" " + attributes.getQName(i) + "=\"" + UpdaterHandler.this.substitute(UpdaterHandler.this.settings, attributes.getValue(i)) + "\"");
                                }
                                this.doIndent = true;
                            }
                        }
                    }

                    @Override
                    public void endElement(String uri, String localName, String name2) throws SAXException {
                        if ("configurations".equals(name2)) {
                            this.insideConfigurations = false;
                        }
                    }
                });
            }
            catch (Exception e) {
                Message.warn("exception occurred while importing configurations: " + e.getMessage());
                throw new SAXException(e);
            }
        }

        private void infoStarted(Attributes attributes) {
            String module2 = this.substitute(this.settings, attributes.getValue("module"));
            String rev = null;
            String branch2 = null;
            String status2 = null;
            String namespace = null;
            Map<String, String> extraAttributes = null;
            if (this.options.isMerge()) {
                Namespace ns;
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                ModuleRevisionId mergedMrid = merged.getModuleRevisionId();
                this.organisation = mergedMrid.getOrganisation();
                branch2 = mergedMrid.getBranch();
                rev = mergedMrid.getRevision();
                status2 = merged.getStatus();
                if (merged instanceof DefaultModuleDescriptor && (ns = ((DefaultModuleDescriptor)merged).getNamespace()) != null) {
                    namespace = ns.getName();
                }
                if (namespace == null) {
                    namespace = attributes.getValue("namespace");
                }
                extraAttributes = merged.getQualifiedExtraAttributes();
            } else {
                this.organisation = this.substitute(this.settings, attributes.getValue("organisation"));
                rev = this.substitute(this.settings, attributes.getValue("revision"));
                branch2 = this.substitute(this.settings, attributes.getValue("branch"));
                status2 = this.substitute(this.settings, attributes.getValue("status"));
                namespace = this.substitute(this.settings, attributes.getValue("namespace"));
                extraAttributes = new LinkedHashMap<String, String>(attributes.getLength());
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String qname = attributes.getQName(i);
                    if (STD_ATTS.contains(qname)) continue;
                    extraAttributes.put(qname, this.substitute(this.settings, attributes.getValue(i)));
                }
            }
            if (this.revision != null) {
                rev = this.revision;
            }
            if (this.options.getBranch() != null) {
                branch2 = this.options.getBranch();
            }
            if (this.status != null) {
                status2 = this.status;
            }
            ModuleRevisionId localMid = ModuleRevisionId.newInstance(this.organisation, module2, branch2, rev, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, Arrays.asList("organisation", "module", "revision", "status", "publication", "namespace")));
            ModuleRevisionId systemMid = this.ns == null ? localMid : this.ns.getToSystemTransformer().transform(localMid);
            this.write("<info");
            if (this.organisation != null) {
                this.write(" organisation=\"" + XMLHelper.escape(systemMid.getOrganisation()) + "\"");
            }
            this.write(" module=\"" + XMLHelper.escape(systemMid.getName()) + "\"");
            if (branch2 != null) {
                this.write(" branch=\"" + XMLHelper.escape(systemMid.getBranch()) + "\"");
            }
            if (systemMid.getRevision() != null) {
                this.write(" revision=\"" + XMLHelper.escape(systemMid.getRevision()) + "\"");
            }
            this.write(" status=\"" + XMLHelper.escape(status2) + "\"");
            if (this.pubdate != null) {
                this.write(" publication=\"" + DateUtil.format(this.pubdate) + "\"");
            } else if (attributes.getValue("publication") != null) {
                this.write(" publication=\"" + this.substitute(this.settings, attributes.getValue("publication")) + "\"");
            }
            if (namespace != null) {
                this.write(" namespace=\"" + namespace + "\"");
            }
            for (Map.Entry<String, String> extra : extraAttributes.entrySet()) {
                this.write(" " + extra.getKey() + "=\"" + extra.getValue() + "\"");
            }
        }

        private void write(String content2) {
            this.getWriter().print(content2);
        }

        private PrintWriter getWriter() {
            return this.buffers.isEmpty() ? this.out : this.buffers.peek().getWriter();
        }

        private String getContext() {
            return StringUtils.joinArray(this.context.toArray(new String[this.context.size()]), "/");
        }

        private String substitute(ParserSettings ivy, String value2) {
            String result2 = ivy == null ? value2 : ivy.substitute(value2);
            return XMLHelper.escape(result2);
        }

        private String removeConfigurationsFromMapping(String mapping) {
            StringBuilder newMapping = new StringBuilder();
            String mappingSep = "";
            for (String groups2 : mapping.trim().split("\\s*;\\s*")) {
                String[] ops = groups2.split("->");
                ArrayList<String> confsToWrite = new ArrayList<String>();
                for (String lh : StringUtils.splitToArray(ops[0])) {
                    if (this.confs.contains(lh)) continue;
                    confsToWrite.add(lh);
                }
                if (confsToWrite.isEmpty()) continue;
                newMapping.append(mappingSep);
                String sep = "";
                String listSep = groups2.contains(", ") ? ", " : ",";
                for (String confToWrite : confsToWrite) {
                    newMapping.append(sep).append(confToWrite);
                    sep = listSep;
                }
                if (ops.length == 2) {
                    newMapping.append("->").append(StringUtils.joinArray(StringUtils.splitToArray(ops[1]), sep));
                }
                mappingSep = ";";
            }
            return newMapping.toString();
        }

        private String removeConfigurationsFromList(String list2) {
            StringBuilder newList = new StringBuilder();
            String sep = "";
            String listSep = list2.contains(", ") ? ", " : ",";
            for (String current2 : StringUtils.splitToArray(list2)) {
                if (this.confs.contains(current2)) continue;
                newList.append(sep).append(current2);
                sep = listSep;
            }
            return newList.toString();
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start2, int length) throws SAXException {
            this.characters(ch, start2, length);
        }

        @Override
        public void characters(char[] ch, int start2, int length) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            this.write(XMLHelper.escape(String.valueOf(ch, start2, length)));
            int end = start2 + length;
            for (int i = start2; i < end; ++i) {
                char c = ch[i];
                if (c == '\r' || c == '\n') {
                    this.currentIndent.setLength(0);
                    this.indenting = true;
                    continue;
                }
                if (!this.indenting) continue;
                if (Character.isWhitespace(c)) {
                    this.currentIndent.append(c);
                    continue;
                }
                this.endIndent();
            }
        }

        private void endIndent() {
            if (this.indenting) {
                this.setIndent(this.context.size() - 1, this.currentIndent.toString());
                this.indenting = false;
            }
        }

        private void setIndent(int level, String indent) {
            this.fillIndents(level);
            this.indentLevels.set(level, indent);
        }

        private void fillIndents(int level) {
            if (this.indentLevels.isEmpty()) {
                this.indentLevels.add("    ");
            }
            String oneLevel = this.indentLevels.get(0);
            for (int fill = this.indentLevels.size(); fill <= level; ++fill) {
                this.indentLevels.add(this.indentLevels.get(fill - 1) + oneLevel);
            }
        }

        private String getIndent() {
            int level = this.context.size() - 1;
            this.fillIndents(level);
            return this.indentLevels.get(level);
        }

        private void writeInheritedItems(ModuleDescriptor merged, InheritableItem[] items2, ItemPrinter printer, String itemName, boolean includeContainer) {
            boolean hasItems;
            PrintWriter out = this.getWriter();
            Map<ModuleRevisionId, List<InheritableItem>> inheritedItems = this.collateInheritedItems(merged, items2);
            boolean bl = hasItems = !inheritedItems.isEmpty();
            if (hasItems && includeContainer) {
                if (this.currentIndent.length() == 0) {
                    out.print(this.getIndent());
                }
                String newConf = this.defaultConf == null ? "" : this.removeConfigurationsFromMapping(this.defaultConf);
                String newMapping = this.defaultConfMapping == null ? "" : this.removeConfigurationsFromMapping(this.defaultConfMapping);
                out.print(String.format("<%s%s%s%s>", itemName, newConf.isEmpty() ? "" : " defaultconf=\"" + newConf + "\"", newMapping.isEmpty() ? "" : " defaultconfmapping=\"" + newMapping + "\"", this.confMappingOverride != null ? " confmappingoverride=\"" + this.confMappingOverride + "\"" : ""));
                this.context.push(itemName);
                this.justOpen = null;
            }
            for (Map.Entry<ModuleRevisionId, List<InheritableItem>> entry : inheritedItems.entrySet()) {
                if (this.justOpen != null) {
                    out.println(">");
                    this.justOpen = null;
                }
                this.writeInheritanceComment(itemName, entry.getKey());
                for (InheritableItem item2 : entry.getValue()) {
                    out.print(this.getIndent());
                    printer.print(merged, item2, out);
                }
            }
            if (hasItems) {
                if (includeContainer) {
                    this.context.pop();
                    out.println(this.getIndent() + "</" + itemName + ">");
                    out.println();
                }
                out.print(this.currentIndent);
            }
        }

        private void writeInheritanceComment(String itemDescription, Object parentInfo) {
            PrintWriter out = this.getWriter();
            out.println();
            out.println(this.getIndent() + "<!-- " + itemDescription + " inherited from " + parentInfo + " -->");
        }

        private Map<ModuleRevisionId, List<InheritableItem>> collateInheritedItems(ModuleDescriptor merged, InheritableItem[] items2) {
            LinkedHashMap<ModuleRevisionId, List<InheritableItem>> inheritedItems = new LinkedHashMap<ModuleRevisionId, List<InheritableItem>>();
            for (InheritableItem item2 : items2) {
                ModuleRevisionId source2 = item2.getSourceModule();
                if (source2 == null || source2.getModuleId().equals(merged.getModuleRevisionId().getModuleId())) continue;
                ArrayList<InheritableItem> accum = (ArrayList<InheritableItem>)inheritedItems.get(source2);
                if (accum == null) {
                    accum = new ArrayList<InheritableItem>();
                    inheritedItems.put(source2, accum);
                }
                accum.add(item2);
            }
            return inheritedItems;
        }

        private void writeInheritedDescription(ModuleDescriptor merged) {
            if (!this.hasDescription) {
                this.hasDescription = true;
                String description2 = merged.getDescription();
                if (!StringUtils.isNullOrEmpty(description2)) {
                    PrintWriter writer = this.getWriter();
                    if (this.justOpen != null) {
                        writer.println(">");
                    }
                    this.writeInheritanceComment("description", "parent");
                    writer.println(this.getIndent() + "<description>" + XMLHelper.escape(description2) + "</description>");
                    writer.print(this.currentIndent);
                    this.justOpen = null;
                }
            }
        }

        private void writeInheritedConfigurations(ModuleDescriptor merged) {
            if (!this.mergedConfigurations) {
                this.mergedConfigurations = true;
                this.writeInheritedItems(merged, merged.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", false);
            }
        }

        private void writeInheritedDependencies(ModuleDescriptor merged) {
            if (!this.mergedDependencies) {
                this.mergedDependencies = true;
                this.writeInheritedItems(merged, merged.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", false);
            }
        }

        private void flushMergedElementsBefore(String moduleElement) {
            if (this.options.isMerge() && this.context.size() == 1 && "ivy-module".equals(this.context.peek()) && (!this.mergedConfigurations || !this.mergedDependencies)) {
                int position = moduleElement == null ? MODULE_ELEMENTS.size() : MODULE_ELEMENTS.indexOf(moduleElement);
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                if (!this.mergedConfigurations && position > CONFIGURATIONS_POSITION && merged.getConfigurations().length > 0) {
                    this.mergedConfigurations = true;
                    this.writeInheritedItems(merged, merged.getConfigurations(), ConfigurationPrinter.INSTANCE, "configurations", true);
                }
                if (!this.mergedDependencies && position > DEPENDENCIES_POSITION && merged.getDependencies().length > 0) {
                    this.mergedDependencies = true;
                    this.writeInheritedItems(merged, merged.getDependencies(), DependencyPrinter.INSTANCE, "dependencies", true);
                }
            }
        }

        private void flushAllMergedElements() {
            this.flushMergedElementsBefore(null);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ExtendedBuffer buffer2;
            String path2 = this.getContext();
            if (this.options.isMerge()) {
                ModuleDescriptor merged = this.options.getMergedDescriptor();
                switch (path2) {
                    case "ivy-module/info": {
                        this.writeInheritedDescription(merged);
                        break;
                    }
                    case "ivy-module/configurations": {
                        this.writeInheritedConfigurations(merged);
                        break;
                    }
                    case "ivy-module/dependencies": {
                        this.writeInheritedDependencies(merged);
                        break;
                    }
                    case "ivy-module": {
                        this.flushAllMergedElements();
                    }
                }
            }
            if (qName.equals(this.justOpen)) {
                this.write("/>");
            } else {
                this.write("</" + qName + ">");
            }
            if (!this.buffers.isEmpty() && (buffer2 = this.buffers.peek()).getContext().equals(path2)) {
                this.buffers.pop();
                if (buffer2.isPrint()) {
                    this.write(buffer2.toString());
                }
            }
            if (!this.confAttributeBuffers.isEmpty() && (buffer2 = this.confAttributeBuffers.peek()).getContext().equals(path2)) {
                this.confAttributeBuffers.pop();
            }
            if (this.options.isMerge() && "ivy-module/info/extends".equals(path2)) {
                this.write(" -->");
            }
            this.justOpen = null;
            this.context.pop();
        }

        @Override
        public void endDocument() throws SAXException {
            this.out.print(LINE_SEPARATOR);
            this.out.flush();
            this.out.close();
        }

        @Override
        public void processingInstruction(String target, String data2) throws SAXException {
            this.write("<?");
            this.write(target);
            this.write(" ");
            this.write(data2);
            this.write("?>");
            this.write(LINE_SEPARATOR);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start2, int length) throws SAXException {
            if (this.justOpen != null) {
                this.write(">");
                this.justOpen = null;
            }
            this.write("<!--");
            this.write(String.valueOf(ch, start2, length));
            this.write("-->");
            if (this.inHeader) {
                this.write(LINE_SEPARATOR);
            }
        }

        @Override
        public void endEntity(String name2) throws SAXException {
        }

        @Override
        public void startEntity(String name2) throws SAXException {
        }

        @Override
        public void startDTD(String name2, String publicId, String systemId) throws SAXException {
        }
    }
}

