/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.m2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;

class MavenVersionRangeParser {
    private static final DeweyDecimal javaVersion;

    MavenVersionRangeParser() {
    }

    static boolean currentJavaVersionInRange(String range3) {
        if (range3 == null) {
            return false;
        }
        if (javaVersion == null) {
            return false;
        }
        Range parsedRange = MavenVersionRangeParser.parse(range3);
        return parsedRange != null && parsedRange.accepts(javaVersion);
    }

    static boolean rangeAccepts(String range3, String value2) {
        DeweyDecimal valToCompare;
        if (value2 == null) {
            return false;
        }
        try {
            valToCompare = new DeweyDecimal(value2);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        Range parsedRange = MavenVersionRangeParser.parse(range3);
        return parsedRange != null && parsedRange.accepts(valToCompare);
    }

    private static Range parse(String rangeValue) {
        if (rangeValue == null || rangeValue.trim().isEmpty()) {
            return null;
        }
        try {
            String[] versionParts = rangeValue.split(",");
            if (versionParts.length == 1) {
                String boundVal = versionParts[0].trim();
                String stripped = MavenVersionRangeParser.stripBoundChars(boundVal);
                if (stripped.isEmpty()) {
                    return null;
                }
                DeweyDecimal bound2 = new DeweyDecimal(stripped);
                return new BasicRange(bound2, !boundVal.startsWith("("), bound2, !boundVal.endsWith(")"));
            }
            if (versionParts.length == 2) {
                String lowerBoundVal = versionParts[0].trim();
                String strippedLowerBound = MavenVersionRangeParser.stripBoundChars(lowerBoundVal);
                DeweyDecimal lowerBound = strippedLowerBound.isEmpty() ? null : new DeweyDecimal(strippedLowerBound);
                String upperBoundVal = versionParts[1].trim();
                String strippedUpperBound = MavenVersionRangeParser.stripBoundChars(upperBoundVal);
                DeweyDecimal upperBound = strippedUpperBound.isEmpty() ? null : new DeweyDecimal(strippedUpperBound);
                return new BasicRange(lowerBound, !lowerBoundVal.startsWith("("), upperBound, !upperBoundVal.endsWith(")"));
            }
            if (versionParts.length > 2) {
                ArrayList<Range> ranges2 = new ArrayList<Range>();
                int i = 0;
                while (i < versionParts.length) {
                    String partOne = versionParts[i];
                    String partTwo = i + 1 < versionParts.length ? versionParts[i + 1] : "";
                    Range rangePart = MavenVersionRangeParser.parse(partOne + "," + partTwo);
                    if (rangePart != null) {
                        ranges2.add(rangePart);
                    }
                    i = i + 2 < versionParts.length ? i + 2 : i + 1;
                }
                return ranges2 == null || ranges2.isEmpty() ? null : new MultiSetRange(ranges2);
            }
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private static String stripBoundChars(String value2) {
        if (value2 == null) {
            return null;
        }
        return value2.replace("(", "").replace(")", "").replace("[", "").replace("]", "");
    }

    static {
        DeweyDecimal v = null;
        try {
            v = new DeweyDecimal(System.getProperty("java.specification.version"));
        }
        catch (Exception e) {
            v = null;
        }
        javaVersion = v;
    }

    private static final class DeweyDecimal {
        private final int[] components;

        public DeweyDecimal(int[] components) {
            this.components = new int[components.length];
            System.arraycopy(components, 0, this.components, 0, components.length);
        }

        public DeweyDecimal(String string2) throws NumberFormatException {
            StringTokenizer tokenizer = new StringTokenizer(string2, ".", true);
            int size2 = tokenizer.countTokens();
            this.components = new int[(size2 + 1) / 2];
            for (int i = 0; i < this.components.length; ++i) {
                String component2 = tokenizer.nextToken();
                if (component2.length() == 0) {
                    throw new NumberFormatException("Empty component in string");
                }
                this.components[i] = Integer.parseInt(component2);
                if (!tokenizer.hasMoreTokens()) continue;
                tokenizer.nextToken();
                if (tokenizer.hasMoreTokens()) continue;
                throw new NumberFormatException("DeweyDecimal ended in a '.'");
            }
        }

        public int getSize() {
            return this.components.length;
        }

        public int get(int index2) {
            return this.components[index2];
        }

        public boolean isEqual(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component2 == component1) continue;
                return false;
            }
            return true;
        }

        public boolean isLessThan(DeweyDecimal other) {
            return !this.isGreaterThanOrEqual(other);
        }

        public boolean isLessThanOrEqual(DeweyDecimal other) {
            return !this.isGreaterThan(other);
        }

        public boolean isGreaterThan(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component2 > component1) {
                    return false;
                }
                if (component2 >= component1) continue;
                return true;
            }
            return false;
        }

        public boolean isGreaterThanOrEqual(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component2 > component1) {
                    return false;
                }
                if (component2 >= component1) continue;
                return true;
            }
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int component2 : this.components) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(component2);
            }
            return sb.toString();
        }

        public int compareTo(DeweyDecimal other) {
            int max = Math.max(other.components.length, this.components.length);
            for (int i = 0; i < max; ++i) {
                int component2;
                int component1 = i < this.components.length ? this.components[i] : 0;
                int n = component2 = i < other.components.length ? other.components[i] : 0;
                if (component1 == component2) continue;
                return component1 - component2;
            }
            return 0;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof DeweyDecimal && this.isEqual((DeweyDecimal)o);
        }
    }

    private static final class MultiSetRange
    implements Range {
        private final Collection<Range> ranges;

        private MultiSetRange(Collection<Range> ranges2) {
            this.ranges = ranges2 == null ? Collections.emptySet() : ranges2;
        }

        @Override
        public boolean accepts(DeweyDecimal value2) {
            if (this.ranges.isEmpty()) {
                return false;
            }
            for (Range range3 : this.ranges) {
                if (range3 == null || !range3.accepts(value2)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class BasicRange
    implements Range {
        private final DeweyDecimal lowerBound;
        private final DeweyDecimal upperBound;
        private final boolean lowerInclusive;
        private final boolean upperInclusive;

        private BasicRange(DeweyDecimal lowerBound, boolean lowerInclusive, DeweyDecimal upperBound, boolean upperInclusive) {
            this.lowerBound = lowerBound;
            this.lowerInclusive = lowerInclusive;
            this.upperBound = upperBound;
            this.upperInclusive = upperInclusive;
        }

        @Override
        public boolean accepts(DeweyDecimal value2) {
            return value2 != null && (this.lowerBound == null || (this.lowerInclusive ? value2.isGreaterThanOrEqual(this.lowerBound) : value2.isGreaterThan(this.lowerBound))) && (this.upperBound == null || (this.upperInclusive ? value2.isLessThanOrEqual(this.upperBound) : value2.isLessThan(this.upperBound)));
        }
    }

    private static interface Range {
        public boolean accepts(DeweyDecimal var1);
    }
}

