/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.matcher;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ivy.plugins.matcher.AbstractPatternMatcher;
import org.apache.ivy.plugins.matcher.Matcher;

public final class RegexpPatternMatcher
extends AbstractPatternMatcher {
    public static final RegexpPatternMatcher INSTANCE = new RegexpPatternMatcher();

    public RegexpPatternMatcher() {
        super("regexp");
    }

    @Override
    protected Matcher newMatcher(String expression2) {
        return new RegexpMatcher(expression2);
    }

    private static class RegexpMatcher
    implements Matcher {
        private Pattern pattern;
        private String expression;
        private Boolean exact;

        public RegexpMatcher(String expression2) throws PatternSyntaxException {
            if (expression2 == null) {
                throw new NullPointerException();
            }
            this.expression = expression2;
            this.pattern = Pattern.compile(expression2);
        }

        @Override
        public boolean matches(String input) {
            if (input == null) {
                throw new NullPointerException();
            }
            return this.pattern.matcher(input).matches();
        }

        @Override
        public boolean isExact() {
            if (this.exact == null) {
                this.exact = this.calculateExact();
            }
            return this.exact;
        }

        private Boolean calculateExact() {
            Boolean result2 = Boolean.TRUE;
            for (char ch : this.expression.toCharArray()) {
                if (Character.isLetterOrDigit(ch) || Character.isWhitespace(ch) || '-' == ch || '_' == ch) continue;
                result2 = Boolean.FALSE;
                break;
            }
            return result2;
        }
    }
}

