/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.util.Message;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegatingHandler
extends DefaultHandler
implements DTDHandler,
ContentHandler,
ErrorHandler {
    private DelegatingHandler delegate = null;
    DelegatingHandler parent;
    private final Map<String, DelegatingHandler> saxHandlerMapping = new HashMap<String, DelegatingHandler>();
    private final Map<String, ChildElementHandler<?>> childHandlerMapping = new HashMap();
    private final String tagName;
    private boolean started = false;
    private boolean skip = false;
    private boolean skipOnError = false;
    private StringBuilder charBuffer = new StringBuilder();
    private boolean bufferingChar = false;
    private Locator locator;
    static final String TRUE = Boolean.TRUE.toString().toLowerCase(Locale.US);
    static final String FALSE = Boolean.FALSE.toString().toLowerCase(Locale.US);

    public DelegatingHandler(String name2) {
        this.tagName = name2;
        this.charBuffer.setLength(0);
    }

    protected <DH extends DelegatingHandler> void addChild(DH saxHandler, ChildElementHandler<DH> elementHandler) {
        this.saxHandlerMapping.put(saxHandler.getName(), saxHandler);
        this.childHandlerMapping.put(saxHandler.getName(), elementHandler);
        saxHandler.parent = this;
    }

    public String getName() {
        return this.tagName;
    }

    public DelegatingHandler getParent() {
        return this.parent;
    }

    public void setBufferingChar(boolean bufferingChar) {
        this.bufferingChar = bufferingChar;
    }

    public void setSkipOnError(boolean skipOnError) {
        this.skipOnError = skipOnError;
    }

    public boolean isBufferingChar() {
        return this.bufferingChar;
    }

    public String getBufferedChars() {
        return this.charBuffer.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        for (DelegatingHandler subHandler : this.saxHandlerMapping.values()) {
            subHandler.setDocumentLocator(locator);
        }
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected String getCurrentElementIdentifier() {
        return "";
    }

    public void skip() {
        this.skip = true;
        for (DelegatingHandler subHandler : this.saxHandlerMapping.values()) {
            subHandler.stopDelegating();
        }
    }

    protected void stopDelegating() {
        this.parent.delegate = null;
        this.skip = false;
        this.started = false;
        for (DelegatingHandler subHandler : this.saxHandlerMapping.values()) {
            subHandler.stopDelegating();
        }
    }

    private void skipOnError(SkipOnErrorCallback callback) throws SAXException {
        try {
            callback.call();
        }
        catch (SAXException e) {
            if (this.skipOnError) {
                this.skip();
                this.log(0, e.getMessage(), e);
            }
            throw e;
        }
    }

    @Override
    public final void startDocument() throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.startDocument();
        } else {
            this.doStartDocument();
        }
    }

    protected void doStartDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.endDocument();
        } else {
            this.doEndDocument();
        }
    }

    protected void doEndDocument() throws SAXException {
    }

    @Override
    public final void startElement(final String uri, final String localName, final String n, final Attributes atts) throws SAXException {
        this.charBuffer.setLength(0);
        if (this.delegate != null) {
            this.skipOnError(new SkipOnErrorCallback(){

                @Override
                public void call() throws SAXException {
                    DelegatingHandler.this.delegate.startElement(uri, localName, n, atts);
                }
            });
        } else if (!this.started) {
            if (this.parent == null && !localName.equals(this.tagName)) {
                throw new SAXException("The root element of the parsed document '" + localName + "' didn't matched the expected one: '" + this.tagName + "'");
            }
            this.skipOnError(new SkipOnErrorCallback(){

                @Override
                public void call() throws SAXException {
                    DelegatingHandler.this.handleAttributes(atts);
                }
            });
            this.started = true;
        } else {
            if (this.skip) {
                return;
            }
            this.delegate = this.saxHandlerMapping.get(localName);
            if (this.delegate != null) {
                this.skipOnError(new SkipOnErrorCallback(){

                    @Override
                    public void call() throws SAXException {
                        DelegatingHandler.this.delegate.startElement(uri, localName, n, atts);
                    }
                });
            }
        }
    }

    protected void handleAttributes(Attributes atts) throws SAXException {
    }

    protected void doStartElement(String uri, String localName, String name2, Attributes atts) throws SAXException {
    }

    @Override
    public final void endElement(final String uri, final String localName, final String n) throws SAXException {
        if (this.delegate != null) {
            ChildElementHandler<?> childHandler;
            final DelegatingHandler savedDelegate = this.delegate;
            this.skipOnError(new SkipOnErrorCallback(){

                @Override
                public void call() throws SAXException {
                    DelegatingHandler.this.delegate.endElement(uri, localName, n);
                }
            });
            if (this.delegate == null && (childHandler = this.childHandlerMapping.get(localName)) != null) {
                this.skipOnError(new SkipOnErrorCallback(){

                    @Override
                    public void call() throws SAXException {
                        childHandler._childHandled(savedDelegate);
                    }
                });
            }
        } else {
            if (!this.skip) {
                this.doEndElement(uri, localName, n);
            }
            if (this.parent != null && this.tagName.equals(localName)) {
                this.stopDelegating();
            }
        }
    }

    protected void doEndElement(String uri, String localName, String name2) throws SAXException {
    }

    @Override
    public final void characters(char[] ch, int start2, int length) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.characters(ch, start2, length);
        } else {
            this.doCharacters(ch, start2, length);
        }
    }

    protected void doCharacters(char[] ch, int start2, int length) throws SAXException {
        if (this.bufferingChar) {
            this.charBuffer.append(ch, start2, length);
        }
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.startPrefixMapping(prefix, uri);
        } else {
            this.doStartPrefixMapping(prefix, uri);
        }
    }

    protected void doStartPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.endPrefixMapping(prefix);
        } else {
            this.doEndPrefixMapping(prefix);
        }
    }

    protected void doEndPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void ignorableWhitespace(char[] ch, int start2, int length) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.ignorableWhitespace(ch, start2, length);
        } else {
            this.doIgnorableWhitespace(ch, start2, length);
        }
    }

    protected void doIgnorableWhitespace(char[] ch, int start2, int length) throws SAXException {
    }

    @Override
    public final void notationDecl(String name2, String publicId, String systemId) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.notationDecl(name2, publicId, systemId);
        } else {
            this.doNotationDecl(name2, publicId, systemId);
        }
    }

    protected void doNotationDecl(String name2, String publicId, String systemId) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.processingInstruction(target, data2);
        } else {
            this.doProcessingInstruction(target, data2);
        }
    }

    protected void doProcessingInstruction(String target, String data2) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.skippedEntity(name2);
        } else {
            this.doSkippedEntity(name2);
        }
    }

    protected void doSkippedEntity(String name2) throws SAXException {
    }

    @Override
    public final void unparsedEntityDecl(String name2, String publicId, String systemId, String notationName) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.unparsedEntityDecl(name2, publicId, systemId, notationName);
        } else {
            this.doUnparsedEntityDecl(name2, publicId, systemId, notationName);
        }
    }

    protected void doUnparsedEntityDecl(String name2, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public final void warning(SAXParseException exception2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.warning(exception2);
        } else {
            this.doWarning(exception2);
        }
    }

    protected void doWarning(SAXParseException exception2) throws SAXException {
    }

    @Override
    public final void error(SAXParseException exception2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.error(exception2);
        } else {
            this.doError(exception2);
        }
    }

    protected void doError(SAXParseException exception2) throws SAXException {
    }

    @Override
    public final void fatalError(SAXParseException exception2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.fatalError(exception2);
        } else {
            this.doFatalError(exception2);
        }
    }

    protected void doFatalError(SAXParseException exception2) throws SAXException {
    }

    protected void log(int logLevel, String message2, Throwable t) {
        Message.debug(t);
        this.log(logLevel, message2);
    }

    protected void log(int logLevel, String message2) {
        Message.log(logLevel, DelegatingHandler.getLocation(this.getLocator()) + message2);
    }

    protected static String getLocation(Locator locator) {
        if (locator == null) {
            return "";
        }
        return "[line " + locator.getLineNumber() + " col. " + locator.getColumnNumber() + "] ";
    }

    private void skipOnError(DelegatingHandler currentHandler, Class<? extends DelegatingHandler> handlerClassToSkip, String message2) {
        DelegatingHandler handlerToSkip = currentHandler;
        while (!handlerClassToSkip.isAssignableFrom(handlerToSkip.getClass())) {
            handlerToSkip = handlerToSkip.getParent();
        }
        this.log(0, message2 + ". The '" + handlerToSkip.getName() + "' element " + this.getCurrentElementIdentifier() + " is then ignored.");
        handlerToSkip.skip();
    }

    protected String getRequiredAttribute(Attributes atts, String name2) throws SAXParseException {
        String value2 = atts.getValue(name2);
        if (value2 == null) {
            throw new SAXParseException("Required attribute '" + name2 + "' not found", this.getLocator());
        }
        return value2;
    }

    protected String getOptionalAttribute(Attributes atts, String name2, String defaultValue) {
        String value2 = atts.getValue(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return value2;
    }

    protected int getRequiredIntAttribute(Attributes atts, String name2, Integer logLevel) throws SAXParseException {
        return this.parseInt(name2, this.getRequiredAttribute(atts, name2));
    }

    protected Integer getOptionalIntAttribute(Attributes atts, String name2, Integer defaultValue) throws SAXParseException {
        String value2 = atts.getValue(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return this.parseInt(name2, value2);
    }

    private int parseInt(String name2, String value2) throws SAXParseException {
        try {
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            throw new SAXParseException("Attribute '" + name2 + "' is expected to be an integer but was '" + value2 + "' (" + e.getMessage() + ")", this.getLocator());
        }
    }

    protected long getRequiredLongAttribute(Attributes atts, String name2) throws SAXParseException {
        return this.parseLong(name2, this.getRequiredAttribute(atts, name2));
    }

    protected Long getOptionalLongAttribute(Attributes atts, String name2, Long defaultValue) throws SAXParseException {
        String value2 = atts.getValue(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return this.parseLong(name2, value2);
    }

    private long parseLong(String name2, String value2) throws SAXParseException {
        try {
            return Long.parseLong(value2);
        }
        catch (NumberFormatException e) {
            throw new SAXParseException("Attribute '" + name2 + "' is expected to be an long but was '" + value2 + "' (" + e.getMessage() + ")", this.getLocator());
        }
    }

    protected boolean getRequiredBooleanAttribute(Attributes atts, String name2) throws SAXParseException {
        return this.parseBoolean(name2, this.getRequiredAttribute(atts, name2));
    }

    protected Boolean getOptionalBooleanAttribute(Attributes atts, String name2, Boolean defaultValue) throws SAXParseException {
        String value2 = atts.getValue(name2);
        if (value2 == null) {
            return defaultValue;
        }
        return this.parseBoolean(name2, value2);
    }

    private boolean parseBoolean(String name2, String value2) throws SAXParseException {
        String lowerValue = value2.toLowerCase(Locale.US);
        if (lowerValue.equals(TRUE)) {
            return true;
        }
        if (lowerValue.equals(FALSE)) {
            return false;
        }
        throw new SAXParseException("Attribute '" + name2 + "' is expected to be a boolean but was '" + value2 + "'", this.getLocator());
    }

    public static abstract class ChildElementHandler<DH extends DelegatingHandler> {
        @Deprecated
        public void childHanlded(DH child) throws SAXParseException {
            this.childHandled(child);
        }

        public abstract void childHandled(DH var1) throws SAXParseException;

        private void _childHandled(DelegatingHandler delegate2) throws SAXParseException {
            this.childHandled(delegate2);
        }
    }

    private static interface SkipOnErrorCallback {
        public void call() throws SAXException;
    }
}

