/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.InheritableItem;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.util.extendable.DefaultExtendableItem;

public class Configuration
extends DefaultExtendableItem
implements InheritableItem {
    private String name;
    private String description;
    private Set<String> extendsFrom;
    private Visibility visibility;
    private boolean transitive = true;
    private String deprecated;
    private ModuleRevisionId sourceModule;

    public static Collection<Configuration> findConfigurationExtending(String conf, Configuration[] confs) {
        ArrayList<Configuration> extendingConfs = new ArrayList<Configuration>();
        for (Configuration cf : confs) {
            if (cf == null || !Arrays.asList(cf.getExtends()).contains(conf)) continue;
            extendingConfs.add(cf);
            extendingConfs.addAll(Configuration.findConfigurationExtending(cf.getName(), confs));
        }
        return extendingConfs;
    }

    public Configuration(String name2) {
        this(name2, Visibility.PUBLIC, null, null, true, null);
    }

    public Configuration(Configuration source2, ModuleRevisionId sourceModule) {
        this(source2.getAttributes(), source2.getQualifiedExtraAttributes(), source2.getName(), source2.getVisibility(), source2.getDescription(), source2.getExtends(), source2.isTransitive(), source2.getDeprecated(), sourceModule);
    }

    public Configuration(String name2, Visibility visibility, String description2, String[] ext2, boolean transitive, String deprecated) {
        this(null, null, name2, visibility, description2, ext2, transitive, deprecated, null);
    }

    private Configuration(Map<String, String> attributes, Map<String, String> extraAttributes, String name2, Visibility visibility, String description2, String[] exts, boolean transitive, String deprecated, ModuleRevisionId sourceModule) {
        super(attributes, extraAttributes);
        if (name2 == null) {
            throw new NullPointerException("null configuration name not allowed");
        }
        if (visibility == null) {
            throw new NullPointerException("null visibility not allowed");
        }
        this.name = name2;
        this.visibility = visibility;
        this.description = description2;
        if (exts == null) {
            this.extendsFrom = Collections.emptySet();
        } else {
            this.extendsFrom = new LinkedHashSet<String>();
            for (String ext2 : exts) {
                this.extendsFrom.add(ext2.trim());
            }
        }
        this.transitive = transitive;
        this.deprecated = deprecated;
        this.sourceModule = sourceModule;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getExtends() {
        return this.extendsFrom.toArray(new String[this.extendsFrom.size()]);
    }

    public String getName() {
        return this.name;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public final boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public ModuleRevisionId getSourceModule() {
        return this.sourceModule;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return obj instanceof Configuration && ((Configuration)obj).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public void replaceWildcards(ModuleDescriptor md) {
        if (this != md.getConfiguration(this.name)) {
            throw new IllegalArgumentException("The given ModuleDescriptor doesn't own this configuration!");
        }
        Configuration[] configs = md.getConfigurations();
        LinkedHashSet<String> newExtends = new LinkedHashSet<String>();
        Iterator<String> iterator2 = this.extendsFrom.iterator();
        block10: while (iterator2.hasNext()) {
            String extend;
            switch (extend = iterator2.next()) {
                case "*": {
                    this.addOther(configs, null, newExtends);
                    continue block10;
                }
                case "*(public)": {
                    this.addOther(configs, Visibility.PUBLIC, newExtends);
                    continue block10;
                }
                case "*(private)": {
                    this.addOther(configs, Visibility.PRIVATE, newExtends);
                    continue block10;
                }
            }
            newExtends.add(extend);
        }
        this.extendsFrom = newExtends;
    }

    private void addOther(Configuration[] allConfigs, Visibility visibility, Set<String> configs) {
        for (Configuration allConfig : allConfigs) {
            String currentName = allConfig.getName();
            if (this.name.equals(currentName) || visibility != null && !visibility.equals(allConfig.getVisibility())) continue;
            configs.add(currentName);
        }
    }

    public static final class Visibility {
        public static final Visibility PUBLIC = new Visibility("public");
        public static final Visibility PRIVATE = new Visibility("private");
        private String name;

        public static Visibility getVisibility(String name2) {
            switch (name2) {
                case "private": {
                    return PRIVATE;
                }
                case "public": {
                    return PUBLIC;
                }
            }
            throw new IllegalArgumentException("unknown visibility " + name2);
        }

        private Visibility(String name2) {
            this.name = name2;
        }

        public String toString() {
            return this.name;
        }
    }
}

