/*
 * Decompiled with CFR 0.152.
 */
package libraries.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import libraries.collections.Trie;
import libraries.collections.TrieNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001 B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0011J\u001d\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J9\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0018\u001a\u00020\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u0019\b\u0002\u0010\u001b\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00040\u001c\u00a2\u0006\u0002\b\u001eJ\f\u0010\u001f\u001a\u00020\u000f*\u00020\u000fH\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Llibraries/collections/Trie;", "T", "", "ignoreCase", "", "(Z)V", "getIgnoreCase", "()Z", "root", "Llibraries/collections/TrieNode;", "getRoot", "()Llibraries/collections/TrieNode;", "putName", "", "name", "", "item", "(Ljava/lang/String;Ljava/lang/Object;)V", "removeName", "(Ljava/lang/String;Ljava/lang/Object;)Z", "resolveName", "", "searchMaxPrefix", "Llibraries/collections/Trie$SearchPrefixResult;", "text", "startIx", "", "breakAt", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "key", "SearchPrefixResult", "libraries-collections"})
@SourceDebugExtension(value={"SMAP\nTrie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Trie.kt\nlibraries/collections/Trie\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,86:1\n1174#2,2:87\n1174#2,2:89\n1174#2,2:91\n*S KotlinDebug\n*F\n+ 1 Trie.kt\nlibraries/collections/Trie\n*L\n10#1:87,2\n23#1:89,2\n45#1:91,2\n*E\n"})
public abstract class Trie<T> {
    private final boolean ignoreCase;
    @NotNull
    private final TrieNode<T> root;

    public Trie(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.root = new TrieNode();
    }

    public final boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    @NotNull
    protected final TrieNode<T> getRoot() {
        return this.root;
    }

    /*
     * WARNING - void declaration
     */
    protected final void putName(@NotNull String name2, T item2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Ref.ObjectRef node = new Ref.ObjectRef();
        node.element = this.root;
        CharSequence $this$forEach$iv = this.key(name2);
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            Ref.ObjectRef objectRef = node;
            TrieNode trieNode = ((TrieNode)node.element).get(ch);
            if (trieNode == null) {
                void it;
                TrieNode trieNode2;
                TrieNode trieNode3 = trieNode2 = new TrieNode();
                Ref.ObjectRef objectRef2 = objectRef;
                boolean bl2 = false;
                ((TrieNode)node.element).set(ch, it);
                objectRef = objectRef2;
                trieNode = trieNode2;
            }
            objectRef.element = trieNode;
        }
        ((TrieNode)node.element).addItem(item2);
    }

    protected final boolean removeName(@NotNull String name2, T item2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        List stack = new ArrayList();
        TrieNode node = null;
        node = this.root;
        String key2 = this.key(name2);
        CharSequence $this$forEach$iv = key2;
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            stack.add(TuplesKt.to(node, (Object)Character.valueOf(ch)));
            if (node.get(ch) != null) continue;
            return false;
        }
        node.removeItem(item2);
        for (int index2 = stack.size() - 1; index2 >= 0 && node.isEmpty(); --index2) {
            Pair pair = (Pair)stack.get(index2);
            TrieNode parent = (TrieNode)pair.component1();
            char ch = ((Character)pair.component2()).charValue();
            parent.removeChild(ch);
            node = parent;
        }
        return true;
    }

    @NotNull
    protected final List<T> resolveName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        TrieNode<T> node = null;
        node = this.root;
        CharSequence $this$forEach$iv = this.key(name2);
        boolean $i$f$forEach = false;
        for (int i = 0; i < $this$forEach$iv.length(); ++i) {
            char element$iv;
            char ch = element$iv = $this$forEach$iv.charAt(i);
            boolean bl = false;
            if (node.get(ch) != null) continue;
            return CollectionsKt.emptyList();
        }
        List list2 = node.getItems();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final SearchPrefixResult<T> searchMaxPrefix(@NotNull String text2, int startIx, @NotNull Function1<? super Character, Boolean> breakAt) {
        int index2;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(breakAt, (String)"breakAt");
        if (startIx >= text2.length()) {
            return new SearchPrefixResult(startIx, null);
        }
        Pair result2 = null;
        TrieNode<T> node = this.root;
        for (index2 = startIx; index2 < text2.length() && !((Boolean)breakAt.invoke((Object)Character.valueOf(text2.charAt(index2)))).booleanValue(); ++index2) {
            char charKey;
            char c = charKey = this.ignoreCase ? Character.toLowerCase(text2.charAt(index2)) : text2.charAt(index2);
            if (node.get(charKey) == null) break;
            List<T> nodeItems = node.getItems();
            Collection collection = nodeItems;
            if (collection == null || collection.isEmpty()) continue;
            result2 = TuplesKt.to((Object)new IntRange(startIx, index2), nodeItems);
        }
        return new SearchPrefixResult(index2, result2);
    }

    public static /* synthetic */ SearchPrefixResult searchMaxPrefix$default(Trie trie, String string2, int n, Function1 function1, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: searchMaxPrefix");
        }
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            function1 = searchMaxPrefix.1.INSTANCE;
        }
        return trie.searchMaxPrefix(string2, n, (Function1<Character, Boolean>)function1);
    }

    @NotNull
    protected final String key(@NotNull String $this$key) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        if (this.ignoreCase) {
            String string3 = $this$key.toLowerCase(Locale.ROOT);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string2 = $this$key;
        }
        return string2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0004H\u00c6\u0003J\u001d\u0010\u000f\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b\u0018\u00010\u0006H\u00c6\u0003J7\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u001c\b\u0002\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R%\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\b\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Llibraries/collections/Trie$SearchPrefixResult;", "T", "", "stoppedAtIx", "", "result", "Lkotlin/Pair;", "Lkotlin/ranges/IntRange;", "", "(ILkotlin/Pair;)V", "getResult", "()Lkotlin/Pair;", "getStoppedAtIx", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "libraries-collections"})
    public static final class SearchPrefixResult<T> {
        private final int stoppedAtIx;
        @Nullable
        private final Pair<IntRange, List<T>> result;

        public SearchPrefixResult(int stoppedAtIx, @Nullable Pair<IntRange, ? extends List<? extends T>> result2) {
            this.stoppedAtIx = stoppedAtIx;
            this.result = result2;
        }

        public final int getStoppedAtIx() {
            return this.stoppedAtIx;
        }

        @Nullable
        public final Pair<IntRange, List<T>> getResult() {
            return this.result;
        }

        public final int component1() {
            return this.stoppedAtIx;
        }

        @Nullable
        public final Pair<IntRange, List<T>> component2() {
            return this.result;
        }

        @NotNull
        public final SearchPrefixResult<T> copy(int stoppedAtIx, @Nullable Pair<IntRange, ? extends List<? extends T>> result2) {
            return new SearchPrefixResult<T>(stoppedAtIx, result2);
        }

        public static /* synthetic */ SearchPrefixResult copy$default(SearchPrefixResult searchPrefixResult, int n, Pair pair, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = searchPrefixResult.stoppedAtIx;
            }
            if ((n2 & 2) != 0) {
                pair = searchPrefixResult.result;
            }
            return searchPrefixResult.copy(n, pair);
        }

        @NotNull
        public String toString() {
            return "SearchPrefixResult(stoppedAtIx=" + this.stoppedAtIx + ", result=" + this.result + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.stoppedAtIx);
            result2 = result2 * 31 + (this.result == null ? 0 : this.result.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SearchPrefixResult)) {
                return false;
            }
            SearchPrefixResult searchPrefixResult = (SearchPrefixResult)other;
            if (this.stoppedAtIx != searchPrefixResult.stoppedAtIx) {
                return false;
            }
            return Intrinsics.areEqual(this.result, searchPrefixResult.result);
        }
    }
}

