/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.vcs.review;

import circlet.client.api.TD_MemberProfile;
import circlet.code.api.CodeReviewRecord;
import circlet.platform.api.Ref;
import circlet.workspaces.Workspace;
import com.intellij.collaboration.ui.codereview.list.ReviewListViewModel;
import com.intellij.collaboration.ui.toolwindow.ReviewListTabComponentDescriptor;
import com.intellij.collaboration.ui.toolwindow.ReviewTabsComponentFactory;
import com.intellij.openapi.project.Project;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.space.vcs.SpaceProjectInfo;
import com.intellij.space.vcs.SpaceRepoInfo;
import com.intellij.space.vcs.review.SpaceReviewTabsController;
import com.intellij.space.vcs.review.SpaceReviewToolwindowEmptyComponent;
import com.intellij.space.vcs.review.create.SpaceCreateCodeReviewComponent;
import com.intellij.space.vcs.review.create.SpaceCreateCodeReviewVm;
import com.intellij.space.vcs.review.create.SpaceCreateMergeRequestComponent;
import com.intellij.space.vcs.review.create.SpaceCreateMergeRequestDirectionModel;
import com.intellij.space.vcs.review.create.SpaceCreateMergeRequestVm;
import com.intellij.space.vcs.review.details.SpaceReviewDetailsPanelFactory;
import com.intellij.space.vcs.review.details.SpaceReviewDetailsVm;
import com.intellij.space.vcs.review.details.SpaceReviewDetailsVmKt;
import com.intellij.space.vcs.review.list.SpaceReviewListFactory;
import com.intellij.space.vcs.review.list.SpaceReviewsListVmImpl;
import com.intellij.space.vcs.review.list.filters.SpaceReviewListFiltersPanelFactory;
import com.intellij.space.vcs.review.toolwindow.SpaceReviewTab;
import com.intellij.space.vcs.review.toolwindow.SpaceReviewToolwindowProjectContext;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.GitBranch;
import java.awt.Component;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import libraries.coroutines.extra.Lifetime;
import libraries.coroutines.extra.LifetimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import runtime.reactive.Property;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0013\u0014B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory;", "Lcom/intellij/collaboration/ui/toolwindow/ReviewTabsComponentFactory;", "Lcom/intellij/space/vcs/review/toolwindow/SpaceReviewTab;", "Lcom/intellij/space/vcs/review/toolwindow/SpaceReviewToolwindowProjectContext;", "project", "Lcom/intellij/openapi/project/Project;", "reviewTabController", "Lcom/intellij/space/vcs/review/SpaceReviewTabsController;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/space/vcs/review/SpaceReviewTabsController;)V", "createEmptyTabContent", "Ljavax/swing/JComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "createReviewListComponentDescriptor", "Lcom/intellij/collaboration/ui/toolwindow/ReviewListTabComponentDescriptor;", "projectContext", "createTabComponent", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabComponentWrapper;", "reviewTabType", "ReviewTabComponentWrapper", "ReviewTabOpenedComponent", "intellij.space.vcs"})
public final class SpaceReviewTabComponentFactory
implements ReviewTabsComponentFactory<SpaceReviewTab, SpaceReviewToolwindowProjectContext> {
    @NotNull
    private final Project project;
    @NotNull
    private final SpaceReviewTabsController reviewTabController;

    public SpaceReviewTabComponentFactory(@NotNull Project project2, @NotNull SpaceReviewTabsController reviewTabController) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reviewTabController, (String)"reviewTabController");
        this.project = project2;
        this.reviewTabController = reviewTabController;
    }

    @NotNull
    public ReviewListTabComponentDescriptor createReviewListComponentDescriptor(@NotNull CoroutineScope cs, @NotNull SpaceReviewToolwindowProjectContext projectContext2) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectContext2, (String)"projectContext");
        LifetimeSource tabLifetime = UtilitiesKt.nestedLifetime(cs);
        ReviewTabOpenedComponent.ReviewList reviewListComponent = new ReviewTabOpenedComponent.ReviewList(this.project, tabLifetime, projectContext2.getWorkspace(), projectContext2.getProjectInfo().getSpaceProject());
        return new ReviewListTabComponentDescriptor(reviewListComponent){
            @NotNull
            private final ReviewListViewModel viewModel;
            @NotNull
            private final JComponent component;
            {
                this.viewModel = $reviewListComponent.getReviewsListVm();
                this.component = (JComponent)((Object)new ReviewTabComponentWrapper($reviewListComponent));
            }

            @NotNull
            public ReviewListViewModel getViewModel() {
                return this.viewModel;
            }

            @NotNull
            public JComponent getComponent() {
                return this.component;
            }
        };
    }

    @NotNull
    public ReviewTabComponentWrapper createTabComponent(@NotNull CoroutineScope cs, @NotNull SpaceReviewToolwindowProjectContext projectContext2, @NotNull SpaceReviewTab reviewTabType) {
        ReviewTabOpenedComponent reviewTabOpenedComponent;
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        Intrinsics.checkNotNullParameter((Object)projectContext2, (String)"projectContext");
        Intrinsics.checkNotNullParameter((Object)reviewTabType, (String)"reviewTabType");
        LifetimeSource tabLifetime = UtilitiesKt.nestedLifetime(cs);
        Workspace workspace2 = projectContext2.getWorkspace();
        SpaceProjectInfo spaceProjectInfo = projectContext2.getProjectInfo().getSpaceProject();
        Set<SpaceRepoInfo> spaceRepos = projectContext2.getProjectInfo().getRepos();
        SpaceReviewTab spaceReviewTab = reviewTabType;
        if (spaceReviewTab instanceof SpaceReviewTab.ReviewSelected) {
            reviewTabOpenedComponent = new ReviewTabOpenedComponent.Review(cs, this.project, workspace2, spaceProjectInfo, spaceRepos, ((SpaceReviewTab.ReviewSelected)reviewTabType).getCodeReviewRecordRef());
        } else if (spaceReviewTab instanceof SpaceReviewTab.CreateCommitSetReview) {
            Lifetime lifetime = tabLifetime;
            SpaceRepoInfo spaceRepoInfo = ((SpaceReviewTab.CreateCommitSetReview)reviewTabType).getRepoInfo();
            if (spaceRepoInfo == null) {
                spaceRepoInfo = (SpaceRepoInfo)CollectionsKt.first((Iterable)spaceRepos);
            }
            reviewTabOpenedComponent = new ReviewTabOpenedComponent.CreateCodeReview(lifetime, this.project, workspace2, spaceProjectInfo, spaceRepoInfo, this.reviewTabController, ((SpaceReviewTab.CreateCommitSetReview)reviewTabType).getCommits());
        } else if (spaceReviewTab instanceof SpaceReviewTab.CreateMergeRequest) {
            reviewTabOpenedComponent = new ReviewTabOpenedComponent.CreateMergeRequest(tabLifetime, this.project, workspace2, spaceProjectInfo, spaceRepos, this.reviewTabController, ((SpaceReviewTab.CreateMergeRequest)reviewTabType).getHeadBranch());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        ReviewTabOpenedComponent openedComponent = reviewTabOpenedComponent;
        return new ReviewTabComponentWrapper(openedComponent);
    }

    @NotNull
    public JComponent createEmptyTabContent(@NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return new SpaceReviewToolwindowEmptyComponent(this.project, UtilitiesKt.nestedLifetime(cs));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabComponentWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "openedComponent", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "(Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;)V", "getOpenedComponent", "()Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "intellij.space.vcs"})
    public static final class ReviewTabComponentWrapper
    extends BorderLayoutPanel {
        @NotNull
        private final ReviewTabOpenedComponent openedComponent;

        public ReviewTabComponentWrapper(@NotNull ReviewTabOpenedComponent openedComponent) {
            Intrinsics.checkNotNullParameter((Object)openedComponent, (String)"openedComponent");
            this.openedComponent = openedComponent;
            this.setBackground(UIUtil.getListBackground());
            this.addToCenter(this.openedComponent.getView());
        }

        @NotNull
        public final ReviewTabOpenedComponent getOpenedComponent() {
            return this.openedComponent;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0007\b\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0004\u000b\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "", "()V", "view", "Ljavax/swing/JComponent;", "getView", "()Ljavax/swing/JComponent;", "CreateCodeReview", "CreateMergeRequest", "Review", "ReviewList", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$CreateCodeReview;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$CreateMergeRequest;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$Review;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$ReviewList;", "intellij.space.vcs"})
    public static abstract class ReviewTabOpenedComponent {
        private ReviewTabOpenedComponent() {
        }

        @NotNull
        public abstract JComponent getView();

        public /* synthetic */ ReviewTabOpenedComponent(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$CreateCodeReview;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "workspace", "Lcirclet/workspaces/Workspace;", "spaceProjectInfo", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "spaceRepoInfo", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "reviewTabController", "Lcom/intellij/space/vcs/review/SpaceReviewTabsController;", "initialCommits", "", "", "(Llibraries/coroutines/extra/Lifetime;Lcom/intellij/openapi/project/Project;Lcirclet/workspaces/Workspace;Lcom/intellij/space/vcs/SpaceProjectInfo;Lcom/intellij/space/vcs/SpaceRepoInfo;Lcom/intellij/space/vcs/review/SpaceReviewTabsController;Ljava/util/List;)V", "reviewVm", "Lcom/intellij/space/vcs/review/create/SpaceCreateCodeReviewVm;", "view", "Ljavax/swing/JComponent;", "getView", "()Ljavax/swing/JComponent;", "intellij.space.vcs"})
        public static final class CreateCodeReview
        extends ReviewTabOpenedComponent {
            @NotNull
            private final SpaceCreateCodeReviewVm reviewVm;
            @NotNull
            private final JComponent view;

            public CreateCodeReview(@NotNull Lifetime lifetime, @NotNull Project project2, @NotNull Workspace workspace2, @NotNull SpaceProjectInfo spaceProjectInfo, @NotNull SpaceRepoInfo spaceRepoInfo, @NotNull SpaceReviewTabsController reviewTabController, @NotNull List<String> initialCommits) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)workspace2, (String)"workspace");
                Intrinsics.checkNotNullParameter((Object)spaceProjectInfo, (String)"spaceProjectInfo");
                Intrinsics.checkNotNullParameter((Object)spaceRepoInfo, (String)"spaceRepoInfo");
                Intrinsics.checkNotNullParameter((Object)reviewTabController, (String)"reviewTabController");
                Intrinsics.checkNotNullParameter(initialCommits, (String)"initialCommits");
                super(null);
                this.reviewVm = new SpaceCreateCodeReviewVm(lifetime, project2, spaceProjectInfo, spaceRepoInfo, workspace2.getClient(), workspace2.getMe().getValue(), initialCommits);
                this.view = new SpaceCreateCodeReviewComponent(lifetime, this.reviewVm, reviewTabController).getView();
            }

            public /* synthetic */ CreateCodeReview(Lifetime lifetime, Project project2, Workspace workspace2, SpaceProjectInfo spaceProjectInfo, SpaceRepoInfo spaceRepoInfo, SpaceReviewTabsController spaceReviewTabsController, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x40) != 0) {
                    list2 = CollectionsKt.emptyList();
                }
                this(lifetime, project2, workspace2, spaceProjectInfo, spaceRepoInfo, spaceReviewTabsController, list2);
            }

            @Override
            @NotNull
            public JComponent getView() {
                return this.view;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$CreateMergeRequest;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "workspace", "Lcirclet/workspaces/Workspace;", "spaceProjectInfo", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "spaceRepos", "", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "reviewTabController", "Lcom/intellij/space/vcs/review/SpaceReviewTabsController;", "headBranch", "Lgit4idea/GitBranch;", "(Llibraries/coroutines/extra/Lifetime;Lcom/intellij/openapi/project/Project;Lcirclet/workspaces/Workspace;Lcom/intellij/space/vcs/SpaceProjectInfo;Ljava/util/Set;Lcom/intellij/space/vcs/review/SpaceReviewTabsController;Lgit4idea/GitBranch;)V", "mergeRequestVm", "Lcom/intellij/space/vcs/review/create/SpaceCreateMergeRequestVm;", "view", "Ljavax/swing/JComponent;", "getView", "()Ljavax/swing/JComponent;", "intellij.space.vcs"})
        public static final class CreateMergeRequest
        extends ReviewTabOpenedComponent {
            @NotNull
            private final SpaceCreateMergeRequestVm mergeRequestVm;
            @NotNull
            private final JComponent view;

            public CreateMergeRequest(@NotNull Lifetime lifetime, @NotNull Project project2, @NotNull Workspace workspace2, @NotNull SpaceProjectInfo spaceProjectInfo, @NotNull Set<SpaceRepoInfo> spaceRepos, @NotNull SpaceReviewTabsController reviewTabController, @Nullable GitBranch headBranch) {
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)workspace2, (String)"workspace");
                Intrinsics.checkNotNullParameter((Object)spaceProjectInfo, (String)"spaceProjectInfo");
                Intrinsics.checkNotNullParameter(spaceRepos, (String)"spaceRepos");
                Intrinsics.checkNotNullParameter((Object)reviewTabController, (String)"reviewTabController");
                super(null);
                CreateMergeRequest createMergeRequest2 = this;
                boolean bl = false;
                SpaceRepoInfo baseRepo = (SpaceRepoInfo)CollectionsKt.first((Iterable)spaceRepos);
                SpaceCreateMergeRequestDirectionModel mergeDirectionModel = SpaceCreateMergeRequestDirectionModel.Companion.createDirectionModel$intellij_space_vcs(lifetime, spaceRepos, baseRepo, spaceProjectInfo, workspace2.getClient(), headBranch);
                createMergeRequest2.mergeRequestVm = new SpaceCreateMergeRequestVm(project2, lifetime, workspace2.getClient(), spaceProjectInfo, mergeDirectionModel);
                this.view = new SpaceCreateMergeRequestComponent(lifetime, reviewTabController, (Property<TD_MemberProfile>)workspace2.getMe(), this.mergeRequestVm).getView();
            }

            public /* synthetic */ CreateMergeRequest(Lifetime lifetime, Project project2, Workspace workspace2, SpaceProjectInfo spaceProjectInfo, Set set, SpaceReviewTabsController spaceReviewTabsController, GitBranch gitBranch, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 0x40) != 0) {
                    gitBranch = null;
                }
                this(lifetime, project2, workspace2, spaceProjectInfo, set, spaceReviewTabsController, gitBranch);
            }

            @Override
            @NotNull
            public JComponent getView() {
                return this.view;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010R\u0019\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$Review;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "project", "Lcom/intellij/openapi/project/Project;", "workspace", "Lcirclet/workspaces/Workspace;", "spaceProjectInfo", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "spaceRepos", "", "Lcom/intellij/space/vcs/SpaceRepoInfo;", "currentReview", "Lcirclet/platform/api/Ref;", "Lcirclet/code/api/CodeReviewRecord;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/openapi/project/Project;Lcirclet/workspaces/Workspace;Lcom/intellij/space/vcs/SpaceProjectInfo;Ljava/util/Set;Lcirclet/platform/api/Ref;)V", "detailsVm", "Lcom/intellij/space/vcs/review/details/SpaceReviewDetailsVm;", "getDetailsVm", "()Lcom/intellij/space/vcs/review/details/SpaceReviewDetailsVm;", "view", "Ljavax/swing/JComponent;", "getView", "()Ljavax/swing/JComponent;", "intellij.space.vcs"})
        public static final class Review
        extends ReviewTabOpenedComponent {
            @NotNull
            private final SpaceReviewDetailsVm<? extends CodeReviewRecord> detailsVm;
            @NotNull
            private final JComponent view;

            public Review(@NotNull CoroutineScope cs, @NotNull Project project2, @NotNull Workspace workspace2, @NotNull SpaceProjectInfo spaceProjectInfo, @NotNull Set<SpaceRepoInfo> spaceRepos, @NotNull Ref<? extends CodeReviewRecord> currentReview) {
                Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)workspace2, (String)"workspace");
                Intrinsics.checkNotNullParameter((Object)spaceProjectInfo, (String)"spaceProjectInfo");
                Intrinsics.checkNotNullParameter(spaceRepos, (String)"spaceRepos");
                Intrinsics.checkNotNullParameter(currentReview, (String)"currentReview");
                super(null);
                this.detailsVm = SpaceReviewDetailsVmKt.createReviewDetailsVm(cs, project2, workspace2, spaceProjectInfo, spaceRepos, currentReview);
                this.view = SpaceReviewDetailsPanelFactory.INSTANCE.create$intellij_space_vcs(cs, this.detailsVm);
            }

            @NotNull
            public final SpaceReviewDetailsVm<? extends CodeReviewRecord> getDetailsVm() {
                return this.detailsVm;
            }

            @Override
            @NotNull
            public JComponent getView() {
                return this.view;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent$ReviewList;", "Lcom/intellij/space/vcs/review/SpaceReviewTabComponentFactory$ReviewTabOpenedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "workspace", "Lcirclet/workspaces/Workspace;", "spaceProjectInfo", "Lcom/intellij/space/vcs/SpaceProjectInfo;", "(Lcom/intellij/openapi/project/Project;Llibraries/coroutines/extra/Lifetime;Lcirclet/workspaces/Workspace;Lcom/intellij/space/vcs/SpaceProjectInfo;)V", "reviewsListVm", "Lcom/intellij/space/vcs/review/list/SpaceReviewsListVmImpl;", "getReviewsListVm", "()Lcom/intellij/space/vcs/review/list/SpaceReviewsListVmImpl;", "view", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getView", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "intellij.space.vcs"})
        public static final class ReviewList
        extends ReviewTabOpenedComponent {
            @NotNull
            private final SpaceReviewsListVmImpl reviewsListVm;
            @NotNull
            private final BorderLayoutPanel view;

            /*
             * WARNING - void declaration
             */
            public ReviewList(@NotNull Project project2, @NotNull Lifetime lifetime, @NotNull Workspace workspace2, @NotNull SpaceProjectInfo spaceProjectInfo) {
                void $this$view_u24lambda_u240;
                BorderLayoutPanel borderLayoutPanel;
                Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
                Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
                Intrinsics.checkNotNullParameter((Object)workspace2, (String)"workspace");
                Intrinsics.checkNotNullParameter((Object)spaceProjectInfo, (String)"spaceProjectInfo");
                super(null);
                this.reviewsListVm = new SpaceReviewsListVmImpl(project2, lifetime, workspace2, spaceProjectInfo);
                BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
                ReviewList reviewList = this;
                boolean bl = false;
                JComponent filtersComponent = new SpaceReviewListFiltersPanelFactory(this.reviewsListVm.getFiltersVm()).create(UtilitiesKt.coroutineScope$default(lifetime, null, 1, null));
                JComponent reviewsList2 = SpaceReviewListFactory.INSTANCE.create(lifetime, this.reviewsListVm);
                $this$view_u24lambda_u240.addToTop((Component)filtersComponent);
                $this$view_u24lambda_u240.addToCenter((Component)reviewsList2);
                reviewList.view = borderLayoutPanel;
            }

            @NotNull
            public final SpaceReviewsListVmImpl getReviewsListVm() {
                return this.reviewsListVm;
            }

            @NotNull
            public BorderLayoutPanel getView() {
                return this.view;
            }
        }
    }
}

