/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.index;

import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexSuggestion;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.space.components.SpaceWorkspaceComponent;
import com.intellij.space.index.SpaceSharedIndexDownloadAuthExtension;
import com.intellij.space.index.message.SpaceSharedIndexesBundle;
import com.intellij.space.messages.SpaceBundle;
import com.intellij.space.settings.SpaceLoginState;
import com.intellij.space.settings.SpaceSettings;
import com.intellij.space.tokens.SpaceIdentificationTokenProviderKt;
import com.intellij.space.utils.UtilitiesKt;
import com.intellij.util.text.StringKt;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J<\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/intellij/space/index/SpaceSharedIndexDownloadAuthExtension;", "Lcom/intellij/indexing/shared/download/SharedIndexDownloadAuthExtension;", "()V", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "shownNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "type", "getType", "buildNotification", "presentableReason", "buildNotificationAction", "Lcom/intellij/notification/NotificationAction;", "checkAuthenticated", "", "suggestions", "", "Lcom/intellij/indexing/shared/download/SharedIndexSuggestion;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "lifetime", "Lcom/intellij/openapi/Disposable;", "onAuthCompleted", "Lkotlin/Function0;", "getToken", "tryGenerateToken", "", "feedUrl", "intellij.space.index"})
public final class SpaceSharedIndexDownloadAuthExtension
implements SharedIndexDownloadAuthExtension {
    @NotNull
    private final AtomicReference<Notification> shownNotification = new AtomicReference<Object>(null);
    @NotNull
    private final String type;
    @NotNull
    private final String presentableName;

    public SpaceSharedIndexDownloadAuthExtension() {
        this.type = "Space";
        String string2 = SpaceBundle.message("product.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"product.name\")");
        this.presentableName = string2;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public String getPresentableName() {
        return this.presentableName;
    }

    @NotNull
    public Map<String, String> tryGenerateToken(@NotNull String feedUrl, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)feedUrl, (String)"feedUrl");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Bearer " + this.getToken())));
    }

    public void checkAuthenticated(@NotNull String presentableReason, @NotNull List<? extends SharedIndexSuggestion> suggestions, @NotNull ProgressIndicator indicator, @NotNull Disposable lifetime, @NotNull Function0<Unit> onAuthCompleted) {
        Intrinsics.checkNotNullParameter((Object)presentableReason, (String)"presentableReason");
        Intrinsics.checkNotNullParameter(suggestions, (String)"suggestions");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(onAuthCompleted, (String)"onAuthCompleted");
        if (this.getToken() != null) {
            onAuthCompleted.invoke();
        } else {
            Notification notification;
            SpaceWorkspaceComponent.Companion.getInstance().getLoginState().forEach(UtilitiesKt.nestedLifetime(lifetime), (Function1<SpaceLoginState, Unit>)((Function1)new Function1<SpaceLoginState, Unit>(this, onAuthCompleted){
                final /* synthetic */ SpaceSharedIndexDownloadAuthExtension this$0;
                final /* synthetic */ Function0<Unit> $onAuthCompleted;
                {
                    this.this$0 = $receiver;
                    this.$onAuthCompleted = $onAuthCompleted;
                    super(1);
                }

                public final void invoke(@NotNull SpaceLoginState it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (it instanceof SpaceLoginState.Connected) {
                        Notification notification = (Notification)SpaceSharedIndexDownloadAuthExtension.access$getShownNotification$p(this.this$0).get();
                        if (notification != null) {
                            notification.expire();
                        }
                        this.$onAuthCompleted.invoke();
                    }
                }
            }));
            if (this.shownNotification.get() == null && this.shownNotification.compareAndSet(null, notification = this.buildNotification(presentableReason))) {
                notification.whenExpired(() -> SpaceSharedIndexDownloadAuthExtension.checkAuthenticated$lambda$0(this)).notify(null);
            }
        }
    }

    private final String getToken() {
        return (String)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(null){
            int label;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SpaceIdentificationTokenProviderKt.getIdentificationToken((Continuation<? super String>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final Notification buildNotification(String presentableReason) {
        String string2 = SpaceSharedIndexesBundle.message("notification.auth.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"notification.auth.title\")");
        String title2 = string2;
        Object[] objectArray = new Object[]{presentableReason, SpaceBundle.message("product.name", new Object[0])};
        String string3 = SpaceSharedIndexesBundle.message("notification.auth.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"notification.au\u2026.message(\"product.name\"))");
        String content2 = string3;
        Notification notification = NotificationGroupManager.getInstance().getNotificationGroup("Space Shared Indexes").createNotification(content2, NotificationType.INFORMATION).setTitle(title2).addAction((AnAction)this.buildNotificationAction());
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"getInstance()\n      .get\u2026uildNotificationAction())");
        return notification;
    }

    private final NotificationAction buildNotificationAction() {
        String string2 = SpaceSharedIndexesBundle.message("notification.auth.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"notification.auth.action\")");
        String text2 = string2;
        NotificationAction notificationAction = NotificationAction.createSimple((String)text2, SpaceSharedIndexDownloadAuthExtension::buildNotificationAction$lambda$1);
        Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(text) {\n   \u2026y.DontFocus\n      )\n    }");
        return notificationAction;
    }

    private static final void checkAuthenticated$lambda$0(SpaceSharedIndexDownloadAuthExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.shownNotification.set(null);
    }

    private static final void buildNotificationAction$lambda$1() {
        String server2 = StringKt.nullize((String)SpaceSettings.Companion.getInstance().getServerSettings().getServer(), (boolean)true);
        if (server2 == null) {
            ActionsKt.runInEdt$default(null, (Function0)buildNotificationAction.1.1.INSTANCE, (int)1, null);
            return;
        }
        SpaceWorkspaceComponent workspaceComponent = SpaceWorkspaceComponent.Companion.getInstance();
        workspaceComponent.signInManually(server2, workspaceComponent.getLifetime(), SpaceWorkspaceComponent.FocusOnLoginPolicy.DontFocus.INSTANCE);
    }

    public static final /* synthetic */ AtomicReference access$getShownNotification$p(SpaceSharedIndexDownloadAuthExtension $this) {
        return $this.shownNotification;
    }
}

