/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway.rd.list;

import circlet.platform.api.KDateTime;
import circlet.platform.api.PrimitivesExKt;
import circlet.rd.api.IdeType;
import circlet.rd.api.RdWorkspaceState;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.space.SpaceIcons;
import com.intellij.space.gateway.client.data.RdWorkspaceKt;
import com.intellij.space.gateway.messages.SpaceGatewayBundle;
import com.intellij.space.gateway.rd.SpaceGatewayRdUiParams;
import com.intellij.space.gateway.rd.SpaceIdeTypeMapping;
import com.intellij.space.gateway.rd.SpaceRdMoreActionButtonFactory;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdWorkspaceComponentVm;
import com.intellij.space.gateway.rd.list.SpaceGatewayRdWorkspaceConnectionComponentFactory;
import com.intellij.space.gateway.rd.list.SpaceGatewayWorkspaceComponentFactory;
import com.intellij.space.ui.Mouse;
import com.intellij.space.ui.UtilitiesKt;
import com.intellij.space.ui.panel.SpaceComponentWrapper;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.gateway.ssh.IntelliJPlatformProduct;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import libraries.coroutines.extra.Lifetime;
import org.jetbrains.annotations.NotNull;
import runtime.reactive.MutableProperty;
import runtime.reactive.Property;
import runtime.reactive.ReactionsKt;
import runtime.reactive.XTrackableLifetimed;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0014\u001a\u00020\u00042\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001e\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011H\u0002J\u0011\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e*\u00020\u000eH\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0017H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/space/gateway/rd/list/SpaceGatewayWorkspaceComponentFactory;", "", "()V", "create", "Ljavax/swing/JComponent;", "lifetime", "Llibraries/coroutines/extra/Lifetime;", "workspaceComponentVm", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdWorkspaceComponentVm;", "createActionOnHoverComponent", "actionOnHover", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdWorkspaceComponentVm$ChangeStateAction;", "createErrorStateComponent", "state", "Lcirclet/rd/api/RdWorkspaceState;", "createIdeIcon", "ide", "Lruntime/reactive/Property;", "Lcirclet/rd/api/IdeType;", "createLeftPartComponent", "createMoreActionsComponent", "additionalActions", "", "Lcom/intellij/space/gateway/rd/list/SpaceGatewayRdWorkspaceComponentVm$AdditionalAction;", "createRightPartComponent", "createRightSideInfoComponent", "createStatusIcon", "status", "getLocalizedText", "", "Lorg/jetbrains/annotations/Nls;", "toAnAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "RdWorkspaceHoverWrapper", "intellij.space.gateway"})
public final class SpaceGatewayWorkspaceComponentFactory {
    @NotNull
    public static final SpaceGatewayWorkspaceComponentFactory INSTANCE = new SpaceGatewayWorkspaceComponentFactory();

    private SpaceGatewayWorkspaceComponentFactory() {
    }

    @NotNull
    public final JComponent create(@NotNull Lifetime lifetime, @NotNull SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        RdWorkspaceHoverWrapper rdWorkspaceHoverWrapper;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)workspaceComponentVm, (String)"workspaceComponentVm");
        NonOpaquePanel contentPanel2 = UtilitiesKt.horizontalPanel$default(15, 0, 2, null);
        JComponent leftPart = this.createLeftPartComponent(lifetime, workspaceComponentVm);
        JComponent rightPart = this.createRightPartComponent(lifetime, workspaceComponentVm);
        contentPanel2.add((Component)leftPart, (Object)"LEFT");
        contentPanel2.add((Component)rightPart, (Object)"RIGHT");
        MutableProperty<Boolean> isHovered = workspaceComponentVm.isHovered();
        RdWorkspaceHoverWrapper $this$create_u24lambda_u240 = rdWorkspaceHoverWrapper = new RdWorkspaceHoverWrapper((JComponent)contentPanel2, (Property<Boolean>)isHovered);
        boolean bl = false;
        Mouse.INSTANCE.addMouseHoveringListener((JComponent)((Object)$this$create_u24lambda_u240), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(isHovered){
            final /* synthetic */ MutableProperty<Boolean> $isHovered;
            {
                this.$isHovered = $isHovered;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$isHovered.setValue(it);
            }
        }));
        isHovered.forEach(lifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>($this$create_u24lambda_u240){
            final /* synthetic */ RdWorkspaceHoverWrapper $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(boolean it) {
                this.$this_apply.repaint();
            }
        }));
        return (JComponent)((Object)rdWorkspaceHoverWrapper);
    }

    private final JComponent createLeftPartComponent(Lifetime lifetime, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel component2 = UtilitiesKt.horizontalPanel$default(5, 0, 2, null);
        JComponent statusIcon = this.createStatusIcon(lifetime, workspaceComponentVm.getState());
        JComponent ideIcon = this.createIdeIcon(lifetime, workspaceComponentVm.getIde());
        JComponent connectionComponent = SpaceGatewayRdWorkspaceConnectionComponentFactory.INSTANCE.create(lifetime, workspaceComponentVm.getConnectVm());
        NonOpaquePanel $this$createLeftPartComponent_u24lambda_u241 = nonOpaquePanel = component2;
        boolean bl = false;
        $this$createLeftPartComponent_u24lambda_u241.add((Component)statusIcon);
        $this$createLeftPartComponent_u24lambda_u241.add((Component)ideIcon);
        $this$createLeftPartComponent_u24lambda_u241.add((Component)connectionComponent);
        return (JComponent)nonOpaquePanel;
    }

    private final JComponent createIdeIcon(Lifetime lifetime, Property<IdeType> ide2) {
        JLabel ideIconLabel = new JLabel();
        ide2.forEach(lifetime, (Function1<IdeType, Unit>)((Function1)new Function1<IdeType, Unit>(ideIconLabel){
            final /* synthetic */ JLabel $ideIconLabel;
            {
                this.$ideIconLabel = $ideIconLabel;
                super(1);
            }

            public final void invoke(@NotNull IdeType ideType) {
                Intrinsics.checkNotNullParameter((Object)ideType, (String)"ideType");
                IntelliJPlatformProduct mappedIdeType = SpaceIdeTypeMapping.Companion.getPlatformProduct(ideType);
                Object object = mappedIdeType;
                if (object == null || (object = object.getIcon()) == null) {
                    object = EmptyIcon.ICON_16;
                }
                Object productIcon = object;
                this.$ideIconLabel.setIcon((Icon)productIcon);
                this.$ideIconLabel.repaint();
            }
        }));
        return ideIconLabel;
    }

    private final JComponent createStatusIcon(Lifetime lifetime, Property<? extends RdWorkspaceState> status2) {
        JLabel statusIconLabel = new JLabel();
        status2.forEach(lifetime, (Function1<? extends RdWorkspaceState, Unit>)((Function1)new Function1<RdWorkspaceState, Unit>(statusIconLabel){
            final /* synthetic */ JLabel $statusIconLabel;
            {
                this.$statusIconLabel = $statusIconLabel;
                super(1);
            }

            public final void invoke(@NotNull RdWorkspaceState it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$statusIconLabel.setIcon(switch (createStatusIcon.WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                    case 1, 2, 3, 4, 5, 6, 7 -> (Icon)AnimatedIcon.Default.INSTANCE;
                    case 8 -> SpaceIcons.Icons.Active;
                    case 9 -> SpaceIcons.Icons.Hibernated;
                    case 10, 11, 12 -> SpaceIcons.Icons.Error;
                    case 13 -> (Icon)AnimatedIcon.Default.INSTANCE;
                    default -> throw new NoWhenBranchMatchedException();
                });
                this.$statusIconLabel.repaint();
            }
        }));
        return statusIconLabel;
    }

    private final JComponent createRightPartComponent(Lifetime lifetime, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        NonOpaquePanel nonOpaquePanel;
        NonOpaquePanel component2 = UtilitiesKt.horizontalPanel$default(5, 0, 2, null);
        JComponent updatedLabel = this.createRightSideInfoComponent(lifetime, workspaceComponentVm);
        JComponent moreActionsComponent = this.createMoreActionsComponent(workspaceComponentVm.getAdditionalActions());
        NonOpaquePanel $this$createRightPartComponent_u24lambda_u242 = nonOpaquePanel = component2;
        boolean bl = false;
        $this$createRightPartComponent_u24lambda_u242.add((Component)updatedLabel);
        $this$createRightPartComponent_u24lambda_u242.add((Component)moreActionsComponent);
        return (JComponent)nonOpaquePanel;
    }

    private final JComponent createMoreActionsComponent(Property<? extends List<SpaceGatewayRdWorkspaceComponentVm.AdditionalAction>> additionalActions) {
        return SpaceRdMoreActionButtonFactory.INSTANCE.create((Function0<? extends ActionGroup>)((Function0)new Function0<ActionGroup>(additionalActions){
            final /* synthetic */ Property<List<SpaceGatewayRdWorkspaceComponentVm.AdditionalAction>> $additionalActions;
            {
                this.$additionalActions = $additionalActions;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ActionGroup invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.$additionalActions.getValue();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SpaceGatewayRdWorkspaceComponentVm.AdditionalAction additionalAction = (SpaceGatewayRdWorkspaceComponentVm.AdditionalAction)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(SpaceGatewayWorkspaceComponentFactory.access$toAnAction(SpaceGatewayWorkspaceComponentFactory.INSTANCE, (SpaceGatewayRdWorkspaceComponentVm.AdditionalAction)it));
                }
                List list2 = (List)destination$iv$iv;
                return (ActionGroup)new DefaultActionGroup(list2);
            }
        }));
    }

    private final AnAction toAnAction(SpaceGatewayRdWorkspaceComponentVm.AdditionalAction $this$toAnAction) {
        String string2 = $this$toAnAction.getName();
        return new AnAction($this$toAnAction, string2){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm.AdditionalAction $this_toAnAction;
            {
                this.$this_toAnAction = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$this_toAnAction.getAction().invoke();
            }
        };
    }

    private final String getLocalizedText(RdWorkspaceState $this$getLocalizedText) {
        return RdWorkspaceKt.convertToWorkspaceStatus($this$getLocalizedText.name()).getVisibleString();
    }

    private final JComponent createErrorStateComponent(SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm, RdWorkspaceState state2) {
        ActionLink actionLink2;
        JLabel jLabel;
        NonOpaquePanel contentPanel2 = UtilitiesKt.horizontalPanel$default(5, 0, 2, null);
        JLabel $this$createErrorStateComponent_u24lambda_u243 = jLabel = new JLabel(this.getLocalizedText(state2));
        boolean bl = false;
        $this$createErrorStateComponent_u24lambda_u243.setForeground(NamedColorUtil.getErrorForeground());
        $this$createErrorStateComponent_u24lambda_u243.setFont((Font)JBFont.smallOrNewUiMedium());
        JLabel errorLabel = jLabel;
        String string2 = SpaceGatewayBundle.message("rd.list.failed.learn.why", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"rd.list.failed.learn.why\")");
        ActionLink $this$createErrorStateComponent_u24lambda_u244 = actionLink2 = new ActionLink(string2, (Function1)new Function1<ActionEvent, Unit>(workspaceComponentVm){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm $workspaceComponentVm;
            {
                this.$workspaceComponentVm = $workspaceComponentVm;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent actionEvent) {
                Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<anonymous parameter 0>");
                this.$workspaceComponentVm.openInWeb();
            }
        });
        boolean bl2 = false;
        $this$createErrorStateComponent_u24lambda_u244.setFont((Font)JBFont.smallOrNewUiMedium());
        ActionLink learnWhyLink2 = actionLink2;
        contentPanel2.add((Component)errorLabel);
        contentPanel2.add((Component)learnWhyLink2);
        return (JComponent)contentPanel2;
    }

    private final JComponent createActionOnHoverComponent(SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction actionOnHover) {
        ActionLink actionLink2;
        ActionLink $this$createActionOnHoverComponent_u24lambda_u245 = actionLink2 = new ActionLink(actionOnHover.getName(), (Function1)new Function1<ActionEvent, Unit>(actionOnHover){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction $actionOnHover;
            {
                this.$actionOnHover = $actionOnHover;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent actionEvent) {
                Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<anonymous parameter 0>");
                this.$actionOnHover.getAction().invoke();
            }
        });
        boolean bl = false;
        $this$createActionOnHoverComponent_u24lambda_u245.setFont((Font)JBFont.smallOrNewUiMedium());
        ActionLink actionLink3 = actionLink2;
        return (JComponent)actionLink3;
    }

    @RequiresEdt
    private final JComponent createRightSideInfoComponent(Lifetime lifetime, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm) {
        SpaceComponentWrapper wrapper2 = new SpaceComponentWrapper(null, null, 3, null);
        ReactionsKt.effect(lifetime, (Function1<? super XTrackableLifetimed, Unit>)((Function1)new Function1<XTrackableLifetimed, Unit>(workspaceComponentVm, wrapper2){
            final /* synthetic */ SpaceGatewayRdWorkspaceComponentVm $workspaceComponentVm;
            final /* synthetic */ SpaceComponentWrapper $wrapper;
            {
                this.$workspaceComponentVm = $workspaceComponentVm;
                this.$wrapper = $wrapper;
                super(1);
            }

            public final void invoke(@NotNull XTrackableLifetimed $this$effect) {
                JLabel jLabel;
                Intrinsics.checkNotNullParameter((Object)$this$effect, (String)"$this$effect");
                RdWorkspaceState errorState2 = $this$effect.getLive(this.$workspaceComponentVm.getErrorState());
                if (errorState2 != null) {
                    this.$wrapper.setContent(SpaceGatewayWorkspaceComponentFactory.access$createErrorStateComponent(SpaceGatewayWorkspaceComponentFactory.INSTANCE, this.$workspaceComponentVm, errorState2));
                    return;
                }
                boolean isHovered = (Boolean)$this$effect.getLive((Property)this.$workspaceComponentVm.isHovered());
                SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction actionOnHover = $this$effect.getLive(this.$workspaceComponentVm.getChangeStateAction());
                if (isHovered && actionOnHover != null) {
                    this.$wrapper.setContent(SpaceGatewayWorkspaceComponentFactory.access$createActionOnHoverComponent(SpaceGatewayWorkspaceComponentFactory.INSTANCE, actionOnHover));
                    return;
                }
                RdWorkspaceState state2 = $this$effect.getLive(this.$workspaceComponentVm.getState());
                JLabel $this$invoke_u24lambda_u240 = jLabel = new JLabel();
                boolean bl = false;
                $this$invoke_u24lambda_u240.setForeground(UIUtil.getContextHelpForeground());
                $this$invoke_u24lambda_u240.setFont((Font)JBFont.smallOrNewUiMedium());
                JLabel statusLabel = jLabel;
                this.$wrapper.setContent(statusLabel);
                switch (createRightSideInfoComponent.WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                    case 1: 
                    case 2: {
                        KDateTime updatedTime = $this$effect.getLive(this.$workspaceComponentVm.getUpdated());
                        Object[] objectArray = new Object[]{DateFormatUtil.formatBetweenDates((long)PrimitivesExKt.getMillis(updatedTime), (long)PrimitivesExKt.getNowMs())};
                        statusLabel.setText(SpaceGatewayBundle.message("rd.list.workspace.updated.text", objectArray));
                        break;
                    }
                    default: {
                        statusLabel.setText(SpaceGatewayWorkspaceComponentFactory.access$getLocalizedText(SpaceGatewayWorkspaceComponentFactory.INSTANCE, state2));
                    }
                }
            }
        }));
        return (JComponent)((Object)wrapper2);
    }

    public static final /* synthetic */ AnAction access$toAnAction(SpaceGatewayWorkspaceComponentFactory $this, SpaceGatewayRdWorkspaceComponentVm.AdditionalAction $receiver) {
        return $this.toAnAction($receiver);
    }

    public static final /* synthetic */ JComponent access$createErrorStateComponent(SpaceGatewayWorkspaceComponentFactory $this, SpaceGatewayRdWorkspaceComponentVm workspaceComponentVm, RdWorkspaceState state2) {
        return $this.createErrorStateComponent(workspaceComponentVm, state2);
    }

    public static final /* synthetic */ JComponent access$createActionOnHoverComponent(SpaceGatewayWorkspaceComponentFactory $this, SpaceGatewayRdWorkspaceComponentVm.ChangeStateAction actionOnHover) {
        return $this.createActionOnHoverComponent(actionOnHover);
    }

    public static final /* synthetic */ String access$getLocalizedText(SpaceGatewayWorkspaceComponentFactory $this, RdWorkspaceState $receiver) {
        return $this.getLocalizedText($receiver);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/space/gateway/rd/list/SpaceGatewayWorkspaceComponentFactory$RdWorkspaceHoverWrapper;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "rdWorkspaceComponent", "Ljavax/swing/JComponent;", "isHovered", "Lruntime/reactive/Property;", "", "(Ljavax/swing/JComponent;Lruntime/reactive/Property;)V", "backgroundColor", "Ljava/awt/Color;", "getBackgroundColor", "()Ljava/awt/Color;", "hoverColor", "getHoverColor", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.space.gateway"})
    private static final class RdWorkspaceHoverWrapper
    extends BorderLayoutPanel {
        @NotNull
        private final Property<Boolean> isHovered;

        public RdWorkspaceHoverWrapper(@NotNull JComponent rdWorkspaceComponent, @NotNull Property<Boolean> isHovered) {
            Intrinsics.checkNotNullParameter((Object)rdWorkspaceComponent, (String)"rdWorkspaceComponent");
            Intrinsics.checkNotNullParameter(isHovered, (String)"isHovered");
            this.isHovered = isHovered;
            this.setOpaque(true);
            this.setBackground(this.getBackgroundColor());
            this.setBorder((Border)JBUI.Borders.empty((int)5, (int)2));
            this.addToCenter(rdWorkspaceComponent);
            this.addPropertyChangeListener("UI", arg_0 -> RdWorkspaceHoverWrapper._init_$lambda$0(this, arg_0));
        }

        private final Color getBackgroundColor() {
            return SpaceGatewayRdUiParams.Colors.INSTANCE.getBackgroundColor();
        }

        private final Color getHoverColor() {
            return SpaceGatewayRdUiParams.Colors.INSTANCE.getListHoverBackground();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            Graphics graphics = ((Graphics2D)g).create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D g2 = (Graphics2D)graphics;
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Color color = this.isHovered.getValue() != false ? this.getHoverColor() : this.getBackgroundColor();
                g2.setColor(color);
                int arcSize = 8;
                g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arcSize, arcSize);
            }
            finally {
                g2.dispose();
            }
        }

        private static final void _init_$lambda$0(RdWorkspaceHoverWrapper this$0, PropertyChangeEvent it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            this$0.setBackground(this$0.getBackgroundColor());
        }
    }
}

