/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.space.gateway;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.space.gateway.CwmRelayConnectionUtilsKt;
import com.intellij.space.gateway.CwmRelayStableConnection;
import com.intellij.space.gateway.client.SpaceGatewayApi;
import com.intellij.space.gateway.client.data.RdGatewayConnectionInfo;
import com.intellij.space.gateway.client.data.RdWorkspace;
import com.intellij.space.gateway.client.data.WorkspaceStatus;
import com.intellij.space.gateway.cwm.CwmClient;
import com.intellij.space.gateway.cwm.CwmSocketConnection;
import com.intellij.space.gateway.cwm.SpaceGatewayServerSocketChannel;
import com.intellij.space.gateway.relay.SpaceGatewayRelayConnection;
import com.intellij.util.UriUtilKt;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u0000 12\u00020\u0001:\u00040123B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0011\u0010\u001a\u001a\u00020\u001bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ#\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020$J!\u0010&\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\b\u0010(\u001a\u00020$H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010!\u001a\u00020\u001bH\u0002J\u001d\u0010*\u001a\u00020$*\u00020'2\u0006\u0010+\u001a\u00020\u001eH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u001d\u0010-\u001a\u00020$*\u00020\u001e2\u0006\u0010.\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00070\u00070\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2={"Lcom/intellij/space/gateway/CwmRelayStableConnection;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "api", "Lcom/intellij/space/gateway/client/SpaceGatewayApi;", "workspaceId", "", "openedCwmClient", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "initialOriginalLink", "serverSocket", "Lcom/intellij/space/gateway/cwm/SpaceGatewayServerSocketChannel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/space/gateway/client/SpaceGatewayApi;Ljava/lang/String;Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;Ljava/lang/String;Lcom/intellij/space/gateway/cwm/SpaceGatewayServerSocketChannel;)V", "_connectionStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/space/gateway/CwmRelayStableConnection$ConnectionStatus;", "connectionLifetimes", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "connectionState", "Lkotlinx/coroutines/flow/StateFlow;", "getConnectionState", "()Lkotlinx/coroutines/flow/StateFlow;", "currentOriginalLink", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "acquireRelayConnectionData", "Lcom/intellij/space/gateway/client/data/RdGatewayConnectionInfo;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitCwmConnectionToPort", "Lcom/intellij/space/gateway/cwm/CwmSocketConnection;", "connectionLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "connectionInfo", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/intellij/space/gateway/client/data/RdGatewayConnectionInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "closeClient", "", "connect", "connectToRelay", "Lcom/intellij/space/gateway/relay/SpaceGatewayRelayConnection;", "reconnect", "updateJoinLinkIfChanged", "transferDataToCwm", "cwm", "(Lcom/intellij/space/gateway/relay/SpaceGatewayRelayConnection;Lcom/intellij/space/gateway/cwm/CwmSocketConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "transferDataToRelay", "relay", "(Lcom/intellij/space/gateway/cwm/CwmSocketConnection;Lcom/intellij/space/gateway/relay/SpaceGatewayRelayConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "BackendConnectionStatus", "Companion", "ConnectionStatus", "CwmConnectionStatus", "intellij.space.gateway"})
@SourceDebugExtension(value={"SMAP\nCwmRelayStableConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CwmRelayStableConnection.kt\ncom/intellij/space/gateway/CwmRelayStableConnection\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,252:1\n230#2,5:253\n230#2,5:258\n230#2,5:263\n230#2,5:268\n10#3:273\n*S KotlinDebug\n*F\n+ 1 CwmRelayStableConnection.kt\ncom/intellij/space/gateway/CwmRelayStableConnection\n*L\n103#1:253,5\n110#1:258,5\n140#1:263,5\n157#1:268,5\n250#1:273\n*E\n"})
public final class CwmRelayStableConnection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final SpaceGatewayApi api;
    @NotNull
    private final String workspaceId;
    @NotNull
    private final ThinClientHandle openedCwmClient;
    @NotNull
    private final SpaceGatewayServerSocketChannel serverSocket;
    @NotNull
    private final SequentialLifetimes connectionLifetimes;
    @NotNull
    private final AtomicReference<String> currentOriginalLink;
    @NotNull
    private final MutableStateFlow<ConnectionStatus> _connectionStatus;
    @NotNull
    private final StateFlow<ConnectionStatus> connectionState;
    @NotNull
    private static final Logger LOG;

    public CwmRelayStableConnection(@NotNull Lifetime lifetime, @NotNull SpaceGatewayApi api2, @NotNull String workspaceId, @NotNull ThinClientHandle openedCwmClient, @NotNull String initialOriginalLink, @NotNull SpaceGatewayServerSocketChannel serverSocket) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)api2, (String)"api");
        Intrinsics.checkNotNullParameter((Object)workspaceId, (String)"workspaceId");
        Intrinsics.checkNotNullParameter((Object)openedCwmClient, (String)"openedCwmClient");
        Intrinsics.checkNotNullParameter((Object)initialOriginalLink, (String)"initialOriginalLink");
        Intrinsics.checkNotNullParameter((Object)serverSocket, (String)"serverSocket");
        this.lifetime = lifetime;
        this.api = api2;
        this.workspaceId = workspaceId;
        this.openedCwmClient = openedCwmClient;
        this.serverSocket = serverSocket;
        this.connectionLifetimes = new SequentialLifetimes(this.lifetime);
        this.currentOriginalLink = new AtomicReference<String>(initialOriginalLink);
        this._connectionStatus = StateFlowKt.MutableStateFlow((Object)new ConnectionStatus(CwmConnectionStatus.AWAIT_DEV_ENV, BackendConnectionStatus.AWAIT_DEV_ENV));
        this.connectionState = FlowKt.asStateFlow(this._connectionStatus);
        this.lifetime.onTermination((Function0)1.INSTANCE);
    }

    @NotNull
    public final StateFlow<ConnectionStatus> getConnectionState() {
        return this.connectionState;
    }

    public final void connect() {
        LifetimeDefinition connectionLifetime = this.connectionLifetimes.next();
        connectionLifetime.onTermination((Function0)new Function0<Unit>(this){
            final /* synthetic */ CwmRelayStableConnection this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CwmRelayStableConnection.access$getLOG$cp().info("Cwm-Relay connection terminated.");
                CwmRelayStableConnection.access$reconnect(this.this$0);
            }
        });
        RdCoroutinesUtilKt.launchIOBackground$default((Lifetime)((Lifetime)connectionLifetime), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, connectionLifetime, null){
            Object L$0;
            int label;
            final /* synthetic */ CwmRelayStableConnection this$0;
            final /* synthetic */ LifetimeDefinition $connectionLifetime;
            {
                this.this$0 = $receiver;
                this.$connectionLifetime = $connectionLifetime;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CwmRelayStableConnection.access$acquireRelayConnectionData(this.this$0, (Continuation)this);
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        newConnectionInfo = (RdGatewayConnectionInfo)v0;
                        this.L$0 = newConnectionInfo;
                        this.label = 2;
                        v1 = CwmRelayStableConnection.access$awaitCwmConnectionToPort(this.this$0, this.$connectionLifetime, newConnectionInfo, (Continuation)this);
                        if (v1 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        newConnectionInfo = (RdGatewayConnectionInfo)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        v2 = (CwmSocketConnection)v1;
                        if (v2 == null) {
                            return Unit.INSTANCE;
                        }
                        cwm = v2;
                        this.L$0 = cwm;
                        this.label = 3;
                        v3 = CwmRelayStableConnection.access$connectToRelay(this.this$0, this.$connectionLifetime, newConnectionInfo, (Continuation)this);
                        if (v3 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl38
                    }
                    case 3: {
                        cwm = (CwmSocketConnection)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl38:
                        // 2 sources

                        relay = (SpaceGatewayRelayConnection)v3;
                        RdCoroutinesUtilKt.launchIOBackground$default((Lifetime)((Lifetime)this.$connectionLifetime), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, cwm, relay, null){
                            int label;
                            final /* synthetic */ CwmRelayStableConnection this$0;
                            final /* synthetic */ CwmSocketConnection $cwm;
                            final /* synthetic */ SpaceGatewayRelayConnection $relay;
                            {
                                this.this$0 = $receiver;
                                this.$cwm = $cwm;
                                this.$relay = $relay;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = CwmRelayStableConnection.access$transferDataToRelay(this.this$0, this.$cwm, this.$relay, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        RdCoroutinesUtilKt.launchIOBackground$default((Lifetime)((Lifetime)this.$connectionLifetime), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, relay, cwm, null){
                            int label;
                            final /* synthetic */ CwmRelayStableConnection this$0;
                            final /* synthetic */ SpaceGatewayRelayConnection $relay;
                            final /* synthetic */ CwmSocketConnection $cwm;
                            {
                                this.this$0 = $receiver;
                                this.$relay = $relay;
                                this.$cwm = $cwm;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = CwmRelayStableConnection.access$transferDataToCwm(this.this$0, this.$relay, this.$cwm, (Continuation)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public final void closeClient() {
        LOG.debug("closeClient");
        if (this.openedCwmClient.getClientPresent() && !this.openedCwmClient.getRestartNeeded()) {
            this.openedCwmClient.close();
        }
    }

    private final void reconnect() {
        this._connectionStatus.setValue((Object)new ConnectionStatus(CwmConnectionStatus.AWAIT_DEV_ENV, BackendConnectionStatus.AWAIT_DEV_ENV));
        if (RLifetimeKt.isAlive((Lifetime)this.lifetime)) {
            LOG.info("Reconnecting...");
            this.connect();
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object awaitCwmConnectionToPort(LifetimeDefinition var1_1, RdGatewayConnectionInfo var2_2, Continuation<? super CwmSocketConnection> var3_3) {
        if (!(var3_3 instanceof awaitCwmConnectionToPort.1)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CwmRelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CwmRelayStableConnection.access$awaitCwmConnectionToPort(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (ConnectionStatus)prevValue$iv;
                    $i$a$-update-CwmRelayStableConnection$awaitCwmConnectionToPort$2 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConnectionStatus.copy$default(status, CwmConnectionStatus.CONNECTING, null, 2, null))));
                this.updateJoinLinkIfChanged((RdGatewayConnectionInfo)connectionInfo);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = CwmSocketConnection.Companion.awaitCwmConnection((LifetimeDefinition)connectionLifetime, this.serverSocket.getServerSocket(), (Continuation<? super CwmSocketConnection>)$continuation);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                this = (CwmRelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                if ((cwm = (CwmSocketConnection)v0) == null) {
                    return null;
                }
                CwmRelayStableConnection.LOG.info("CWM connected to Gateway");
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (ConnectionStatus)prevValue$iv;
                    $i$a$-update-CwmRelayStableConnection$awaitCwmConnectionToPort$3 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConnectionStatus.copy$default(status, CwmConnectionStatus.CONNECTED, null, 2, null))));
                return cwm;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateJoinLinkIfChanged(RdGatewayConnectionInfo connectionInfo) {
        String current2 = this.currentOriginalLink.get();
        if (Intrinsics.areEqual((Object)current2, (Object)connectionInfo.getOriginalLink())) {
            LOG.info("Join link is not changed");
            return;
        }
        if (this.currentOriginalLink.compareAndSet(current2, connectionInfo.getOriginalLink())) {
            LOG.info("Updating CWM join link");
            URI newJoinLink = CwmClient.INSTANCE.prepareCwmJoinLink(connectionInfo, this.serverSocket.getPort());
            this.openedCwmClient.updateJoinLink(newJoinLink, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object connectToRelay(LifetimeDefinition var1_1, RdGatewayConnectionInfo var2_2, Continuation<? super SpaceGatewayRelayConnection> var3_3) {
        if (!(var3_3 instanceof connectToRelay.1)) ** GOTO lbl-1000
        var12_4 = var3_3;
        if ((var12_4.label & -2147483648) != 0) {
            var12_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CwmRelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CwmRelayStableConnection.access$connectToRelay(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (ConnectionStatus)prevValue$iv;
                    $i$a$-update-CwmRelayStableConnection$connectToRelay$2 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConnectionStatus.copy$default(status, null, BackendConnectionStatus.CONNECTING, 1, null))));
                relayConnectUri = new URI(connectionInfo.getRelayLink() + "/" + CwmRelayStableConnection.connectToRelay$generateUserId());
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = SpaceGatewayRelayConnection.Companion.connectToRelay(var1_1, relayConnectUri, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)connectionInfo.getRelayAuthData())), (Continuation<? super SpaceGatewayRelayConnection>)$continuation);
                if (v0 == var13_6) {
                    return var13_6;
                }
                ** GOTO lbl32
            }
            case 1: {
                this = (CwmRelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                relay = (SpaceGatewayRelayConnection)v0;
                CwmRelayStableConnection.LOG.info("Connected to relay");
                $this$update$iv = this._connectionStatus;
                $i$f$update = false;
                do {
                    prevValue$iv = $this$update$iv.getValue();
                    status = (ConnectionStatus)prevValue$iv;
                    $i$a$-update-CwmRelayStableConnection$connectToRelay$3 = false;
                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ConnectionStatus.copy$default(status, null, BackendConnectionStatus.CONNECTED, 1, null))));
                return relay;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object transferDataToRelay(CwmSocketConnection $this$transferDataToRelay, SpaceGatewayRelayConnection relay, Continuation<? super Unit> $completion) {
        AtomicInteger counter2 = new AtomicInteger();
        Object object = $this$transferDataToRelay.startReadingLoop((Function2<? super ByteBuffer, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ByteBuffer, Continuation<? super Unit>, Object>(counter2, relay, null){
            int I$0;
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AtomicInteger $counter;
            final /* synthetic */ SpaceGatewayRelayConnection $relay;
            {
                this.$counter = $counter;
                this.$relay = $relay;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        cwmData = (ByteBuffer)this.L$0;
                        currentCounter = this.$counter.incrementAndGet();
                        cwmData.flip();
                        this.I$0 = currentCounter;
                        this.label = 1;
                        v0 = this.$relay.write(cwmData, (Continuation<? super Unit>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        currentCounter = this.I$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        if (currentCounter % 1000 == 0) {
                            CwmRelayStableConnection.access$getLOG$cp().info("1000 packets sent from CWM to Relay");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value2;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull ByteBuffer p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final Object transferDataToCwm(SpaceGatewayRelayConnection var1_1, CwmSocketConnection var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof transferDataToCwm.1)) ** GOTO lbl-1000
        var9_4 = var3_3;
        if ((var9_4.label & -2147483648) != 0) {
            var9_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ CwmRelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CwmRelayStableConnection.access$transferDataToCwm(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                counter = new AtomicInteger();
                var5_8 = $this$transferDataToCwm.getReadChannel().iterator();
lbl14:
                // 3 sources

                while (true) {
                    $continuation.L$0 = cwm;
                    $continuation.L$1 = counter;
                    $continuation.L$2 = var5_8;
                    $continuation.label = 1;
                    v0 = var5_8.hasNext((Continuation)$continuation);
                    if (v0 == var10_6) {
                        return var10_6;
                    }
                    ** GOTO lbl29
                    break;
                }
            }
            case 1: {
                var5_8 = (ChannelIterator)$continuation.L$2;
                counter = (AtomicInteger)$continuation.L$1;
                cwm = (CwmSocketConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) break;
                relayData = (ByteBuffer)var5_8.next();
                currentCounter = counter.incrementAndGet();
                $continuation.L$0 = cwm;
                $continuation.L$1 = counter;
                $continuation.L$2 = var5_8;
                $continuation.I$0 = currentCounter;
                $continuation.label = 2;
                v1 = cwm.write(relayData, (Continuation<? super Unit>)$continuation);
                if (v1 == var10_6) {
                    return var10_6;
                }
                ** GOTO lbl48
            }
            case 2: {
                currentCounter = $continuation.I$0;
                var5_8 = (ChannelIterator)$continuation.L$2;
                counter = (AtomicInteger)$continuation.L$1;
                cwm = (CwmSocketConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                if (currentCounter % 1000 != 0) ** GOTO lbl14
                CwmRelayStableConnection.LOG.info("1000 packets sent from Relay to CWM");
                ** continue;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object acquireRelayConnectionData(Continuation<? super RdGatewayConnectionInfo> var1_1) {
        if (!(var1_1 instanceof acquireRelayConnectionData.1)) ** GOTO lbl-1000
        var10_2 = var1_1;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CwmRelayStableConnection this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return CwmRelayStableConnection.access$acquireRelayConnectionData(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                CwmRelayStableConnection.LOG.info("Waiting for active workspace");
                this._connectionStatus.setValue((Object)new ConnectionStatus(CwmConnectionStatus.AWAIT_DEV_ENV, BackendConnectionStatus.AWAIT_DEV_ENV));
                afterRestart = this.openedCwmClient.getRestartNeeded();
                newConnection = new Ref.ObjectRef();
                isFirstCheck = new Ref.BooleanRef();
                isFirstCheck.element = true;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = CwmRelayConnectionUtilsKt.awaitWorkspaceStatus(this.api, this.workspaceId, (Function2<? super WorkspaceStatus, ? super Continuation<? super Boolean>, ? extends Object>)((Function2)new Function2<WorkspaceStatus, Continuation<? super Boolean>, Object>(afterRestart != false, (Ref.ObjectRef<RdGatewayConnectionInfo>)newConnection, this, isFirstCheck, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ boolean $afterRestart;
                    final /* synthetic */ Ref.ObjectRef<RdGatewayConnectionInfo> $newConnection;
                    final /* synthetic */ CwmRelayStableConnection this$0;
                    final /* synthetic */ Ref.BooleanRef $isFirstCheck;
                    {
                        this.$afterRestart = $afterRestart;
                        this.$newConnection = $newConnection;
                        this.this$0 = $receiver;
                        this.$isFirstCheck = $isFirstCheck;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        block11: {
                            var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    it = (WorkspaceStatus)this.L$0;
                                    if (!Intrinsics.areEqual((Object)it, (Object)WorkspaceStatus.Active.INSTANCE)) break block11;
                                    if (!this.$afterRestart) break;
                                    var3_4 = this.this$0;
                                    var10_5 = this.$newConnection;
                                    $this$invokeSuspend_u24lambda_u240 = var3_4;
                                    $i$a$-runCatching-CwmRelayStableConnection$acquireRelayConnectionData$2$1 = false;
                                    this.L$0 = var10_5;
                                    this.label = 1;
                                    v0 = CwmRelayStableConnection.access$getApi$p((CwmRelayStableConnection)$this$invokeSuspend_u24lambda_u240).rdGatewayConnectionInfo(CwmRelayStableConnection.access$getWorkspaceId$p((CwmRelayStableConnection)$this$invokeSuspend_u24lambda_u240), (Continuation<? super RdGatewayConnectionInfo>)this);
                                    ** if (v0 != var11_2) goto lbl20
lbl19:
                                    // 1 sources

                                    return var11_2;
lbl20:
                                    // 1 sources

                                    ** GOTO lbl28
                                }
                                case 1: {
                                    $i$a$-runCatching-CwmRelayStableConnection$acquireRelayConnectionData$2$1 = false;
                                    var10_5 = (Ref.ObjectRef<RdGatewayConnectionInfo>)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl28:
                                        // 2 sources

                                        $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)((RdGatewayConnectionInfo)v0));
                                    }
                                    catch (Throwable var5_8) {
                                        $this$invokeSuspend_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var5_8));
                                    }
                                    var3_4 = $this$invokeSuspend_u24lambda_u240;
                                    var10_5.element = Result.isFailure-impl((Object)var3_4) != false ? null : var3_4;
                                    fpOld = (String)UriUtilKt.getFragmentParameters((URI)new URI((String)CwmRelayStableConnection.access$getCurrentOriginalLink$p(this.this$0).get())).get("fp");
                                    var5_9 = (RdGatewayConnectionInfo)this.$newConnection.element;
                                    if (var5_9 == null || (var6_10 = var5_9.getOriginalLink()) == null) ** GOTO lbl-1000
                                    it = var6_10;
                                    $i$a$-let-CwmRelayStableConnection$acquireRelayConnectionData$2$fpNew$1 = false;
                                    var7_13 = UriUtilKt.getFragmentParameters((URI)new URI(it));
                                    if (var7_13 != null && (var8_11 = (String)var7_13.get("fp")) != null) {
                                        v1 = var8_11;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = fpOld;
                                    }
                                    fpNew = v1;
                                    CwmRelayStableConnection.access$getLOG$cp().debug("Waiting for new fp after restart");
                                    return Boxing.boxBoolean((boolean)(Intrinsics.areEqual((Object)fpOld, (Object)fpNew) == false));
                                }
                            }
                            return Boxing.boxBoolean((boolean)true);
                        }
                        if (this.$isFirstCheck.element) {
                            this.$isFirstCheck.element = false;
                            CwmRelayStableConnection.access$getLOG$cp().info("Putting client to reconnect mode");
                            CwmRelayStableConnection.access$getOpenedCwmClient$p(this.this$0).notifyReconnect();
                        }
                        return Boxing.boxBoolean((boolean)false);
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull WorkspaceStatus p1, @Nullable Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation<? super RdWorkspace>)$continuation);
                if (v0 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl28
            }
            case 1: {
                this = (CwmRelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                CwmRelayStableConnection.LOG.info("Workspace is active");
                this._connectionStatus.setValue((Object)new ConnectionStatus(CwmConnectionStatus.DISCONNECTED, BackendConnectionStatus.AWAIT_CWM));
lbl31:
                // 2 sources

                while (true) {
                    var6_9 = this;
                    $this$acquireRelayConnectionData_u24lambda_u244 = var6_9;
                    $i$a$-runCatching-CwmRelayStableConnection$acquireRelayConnectionData$connectionInfo$1 = false;
                    $continuation.L$0 = this;
                    $continuation.label = 2;
                    v1 = $this$acquireRelayConnectionData_u24lambda_u244.api.rdGatewayConnectionInfo($this$acquireRelayConnectionData_u24lambda_u244.workspaceId, (Continuation<? super RdGatewayConnectionInfo>)$continuation);
                    ** if (v1 != var11_4) goto lbl43
lbl42:
                    // 1 sources

                    return var11_4;
lbl43:
                    // 1 sources

                    ** GOTO lbl51
                    break;
                }
            }
            case 2: {
                $i$a$-runCatching-CwmRelayStableConnection$acquireRelayConnectionData$connectionInfo$1 = false;
                this = (CwmRelayStableConnection)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl51:
                    // 2 sources

                    var7_10 = Result.constructor-impl((Object)((RdGatewayConnectionInfo)v1));
                }
                catch (Throwable var8_12) {
                    var7_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_12));
                }
                v2 = connectionInfo = (RdGatewayConnectionInfo)LoggerKt.getOrLogException((Object)var7_10, (Logger)CwmRelayStableConnection.LOG);
                if (v2 != null) {
                    return v2;
                }
                $continuation.L$0 = this;
                $continuation.label = 3;
                v3 = DelayKt.delay((long)3000L, (Continuation)$continuation);
                if (v3 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl69
            }
            case 3: {
                this = (CwmRelayStableConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl69:
                // 2 sources

                ** continue;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String connectToRelay$generateUserId() {
        SecureRandom random = new SecureRandom();
        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
        byte[] buffer2 = new byte[16];
        random.nextBytes(buffer2);
        String string2 = encoder.encodeToString(buffer2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encoder.encodeToString(buffer)");
        return string2;
    }

    public static final /* synthetic */ void access$reconnect(CwmRelayStableConnection $this) {
        $this.reconnect();
    }

    public static final /* synthetic */ Object access$acquireRelayConnectionData(CwmRelayStableConnection $this, Continuation $completion) {
        return $this.acquireRelayConnectionData((Continuation<? super RdGatewayConnectionInfo>)$completion);
    }

    public static final /* synthetic */ Object access$awaitCwmConnectionToPort(CwmRelayStableConnection $this, LifetimeDefinition connectionLifetime, RdGatewayConnectionInfo connectionInfo, Continuation $completion) {
        return $this.awaitCwmConnectionToPort(connectionLifetime, connectionInfo, (Continuation<? super CwmSocketConnection>)$completion);
    }

    public static final /* synthetic */ Object access$connectToRelay(CwmRelayStableConnection $this, LifetimeDefinition connectionLifetime, RdGatewayConnectionInfo connectionInfo, Continuation $completion) {
        return $this.connectToRelay(connectionLifetime, connectionInfo, (Continuation<? super SpaceGatewayRelayConnection>)$completion);
    }

    public static final /* synthetic */ Object access$transferDataToRelay(CwmRelayStableConnection $this, CwmSocketConnection $receiver, SpaceGatewayRelayConnection relay, Continuation $completion) {
        return $this.transferDataToRelay($receiver, relay, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$transferDataToCwm(CwmRelayStableConnection $this, SpaceGatewayRelayConnection $receiver, CwmSocketConnection cwm, Continuation $completion) {
        return $this.transferDataToCwm($receiver, cwm, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ AtomicReference access$getCurrentOriginalLink$p(CwmRelayStableConnection $this) {
        return $this.currentOriginalLink;
    }

    public static final /* synthetic */ ThinClientHandle access$getOpenedCwmClient$p(CwmRelayStableConnection $this) {
        return $this.openedCwmClient;
    }

    public static final /* synthetic */ SpaceGatewayApi access$getApi$p(CwmRelayStableConnection $this) {
        return $this.api;
    }

    public static final /* synthetic */ String access$getWorkspaceId$p(CwmRelayStableConnection $this) {
        return $this.workspaceId;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(CwmRelayStableConnection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/gateway/CwmRelayStableConnection$BackendConnectionStatus;", "", "(Ljava/lang/String;I)V", "AWAIT_DEV_ENV", "AWAIT_CWM", "CONNECTING", "CONNECTED", "intellij.space.gateway"})
    public static final class BackendConnectionStatus
    extends Enum<BackendConnectionStatus> {
        public static final /* enum */ BackendConnectionStatus AWAIT_DEV_ENV = new BackendConnectionStatus();
        public static final /* enum */ BackendConnectionStatus AWAIT_CWM = new BackendConnectionStatus();
        public static final /* enum */ BackendConnectionStatus CONNECTING = new BackendConnectionStatus();
        public static final /* enum */ BackendConnectionStatus CONNECTED = new BackendConnectionStatus();
        private static final /* synthetic */ BackendConnectionStatus[] $VALUES;

        public static BackendConnectionStatus[] values() {
            return (BackendConnectionStatus[])$VALUES.clone();
        }

        public static BackendConnectionStatus valueOf(String value2) {
            return Enum.valueOf(BackendConnectionStatus.class, value2);
        }

        static {
            $VALUES = backendConnectionStatusArray = new BackendConnectionStatus[]{BackendConnectionStatus.AWAIT_DEV_ENV, BackendConnectionStatus.AWAIT_CWM, BackendConnectionStatus.CONNECTING, BackendConnectionStatus.CONNECTED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/space/gateway/CwmRelayStableConnection$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.space.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/space/gateway/CwmRelayStableConnection$ConnectionStatus;", "", "cwmStatus", "Lcom/intellij/space/gateway/CwmRelayStableConnection$CwmConnectionStatus;", "backendStatus", "Lcom/intellij/space/gateway/CwmRelayStableConnection$BackendConnectionStatus;", "(Lcom/intellij/space/gateway/CwmRelayStableConnection$CwmConnectionStatus;Lcom/intellij/space/gateway/CwmRelayStableConnection$BackendConnectionStatus;)V", "getBackendStatus", "()Lcom/intellij/space/gateway/CwmRelayStableConnection$BackendConnectionStatus;", "getCwmStatus", "()Lcom/intellij/space/gateway/CwmRelayStableConnection$CwmConnectionStatus;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.space.gateway"})
    public static final class ConnectionStatus {
        @NotNull
        private final CwmConnectionStatus cwmStatus;
        @NotNull
        private final BackendConnectionStatus backendStatus;

        public ConnectionStatus(@NotNull CwmConnectionStatus cwmStatus, @NotNull BackendConnectionStatus backendStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)cwmStatus), (String)"cwmStatus");
            Intrinsics.checkNotNullParameter((Object)((Object)backendStatus), (String)"backendStatus");
            this.cwmStatus = cwmStatus;
            this.backendStatus = backendStatus;
        }

        @NotNull
        public final CwmConnectionStatus getCwmStatus() {
            return this.cwmStatus;
        }

        @NotNull
        public final BackendConnectionStatus getBackendStatus() {
            return this.backendStatus;
        }

        @NotNull
        public final CwmConnectionStatus component1() {
            return this.cwmStatus;
        }

        @NotNull
        public final BackendConnectionStatus component2() {
            return this.backendStatus;
        }

        @NotNull
        public final ConnectionStatus copy(@NotNull CwmConnectionStatus cwmStatus, @NotNull BackendConnectionStatus backendStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)cwmStatus), (String)"cwmStatus");
            Intrinsics.checkNotNullParameter((Object)((Object)backendStatus), (String)"backendStatus");
            return new ConnectionStatus(cwmStatus, backendStatus);
        }

        public static /* synthetic */ ConnectionStatus copy$default(ConnectionStatus connectionStatus, CwmConnectionStatus cwmConnectionStatus, BackendConnectionStatus backendConnectionStatus, int n, Object object) {
            if ((n & 1) != 0) {
                cwmConnectionStatus = connectionStatus.cwmStatus;
            }
            if ((n & 2) != 0) {
                backendConnectionStatus = connectionStatus.backendStatus;
            }
            return connectionStatus.copy(cwmConnectionStatus, backendConnectionStatus);
        }

        @NotNull
        public String toString() {
            return "ConnectionStatus(cwmStatus=" + this.cwmStatus + ", backendStatus=" + this.backendStatus + ")";
        }

        public int hashCode() {
            int result2 = this.cwmStatus.hashCode();
            result2 = result2 * 31 + this.backendStatus.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConnectionStatus)) {
                return false;
            }
            ConnectionStatus connectionStatus = (ConnectionStatus)other;
            if (this.cwmStatus != connectionStatus.cwmStatus) {
                return false;
            }
            return this.backendStatus == connectionStatus.backendStatus;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/space/gateway/CwmRelayStableConnection$CwmConnectionStatus;", "", "(Ljava/lang/String;I)V", "AWAIT_DEV_ENV", "DISCONNECTED", "CONNECTING", "CONNECTED", "intellij.space.gateway"})
    public static final class CwmConnectionStatus
    extends Enum<CwmConnectionStatus> {
        public static final /* enum */ CwmConnectionStatus AWAIT_DEV_ENV = new CwmConnectionStatus();
        public static final /* enum */ CwmConnectionStatus DISCONNECTED = new CwmConnectionStatus();
        public static final /* enum */ CwmConnectionStatus CONNECTING = new CwmConnectionStatus();
        public static final /* enum */ CwmConnectionStatus CONNECTED = new CwmConnectionStatus();
        private static final /* synthetic */ CwmConnectionStatus[] $VALUES;

        public static CwmConnectionStatus[] values() {
            return (CwmConnectionStatus[])$VALUES.clone();
        }

        public static CwmConnectionStatus valueOf(String value2) {
            return Enum.valueOf(CwmConnectionStatus.class, value2);
        }

        static {
            $VALUES = cwmConnectionStatusArray = new CwmConnectionStatus[]{CwmConnectionStatus.AWAIT_DEV_ENV, CwmConnectionStatus.DISCONNECTED, CwmConnectionStatus.CONNECTING, CwmConnectionStatus.CONNECTED};
        }
    }
}

