/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateSerializer
extends JSR310FormattedSerializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();

    protected LocalDateSerializer() {
        super(LocalDate.class);
    }

    protected LocalDateSerializer(LocalDateSerializer base, Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        super(base, useTimestamp, dtf, shape);
    }

    public LocalDateSerializer(DateTimeFormatter formatter2) {
        super(LocalDate.class, formatter2);
    }

    protected LocalDateSerializer withFormat(Boolean useTimestamp, DateTimeFormatter dtf, JsonFormat.Shape shape) {
        return new LocalDateSerializer(this, useTimestamp, dtf, shape);
    }

    public void serialize(LocalDate date2, JsonGenerator g, SerializerProvider provider2) throws IOException {
        if (this.useTimestamp(provider2)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                g.writeNumber(date2.toEpochDay());
            } else {
                g.writeStartArray();
                this._serializeAsArrayContents(date2, g, provider2);
                g.writeEndArray();
            }
        } else {
            g.writeString(this._formatter == null ? date2.toString() : date2.format(this._formatter));
        }
    }

    @Override
    public void serializeWithType(LocalDate value2, JsonGenerator g, SerializerProvider provider2, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId((Object)value2, this.serializationShape(provider2)));
        switch (typeIdDef.valueShape) {
            case START_ARRAY: {
                this._serializeAsArrayContents(value2, g, provider2);
                break;
            }
            case VALUE_NUMBER_INT: {
                g.writeNumber(value2.toEpochDay());
                break;
            }
            default: {
                g.writeString(this._formatter == null ? value2.toString() : value2.format(this._formatter));
            }
        }
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    protected void _serializeAsArrayContents(LocalDate value2, JsonGenerator g, SerializerProvider provider2) throws IOException {
        g.writeNumber(value2.getYear());
        g.writeNumber(value2.getMonthValue());
        g.writeNumber(value2.getDayOfMonth());
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        boolean useTimestamp;
        SerializerProvider provider2 = visitor.getProvider();
        boolean bl = useTimestamp = provider2 != null && this.useTimestamp(provider2);
        if (useTimestamp) {
            this._acceptTimestampVisitor(visitor, typeHint);
        } else {
            JsonStringFormatVisitor v2 = visitor.expectStringFormat(typeHint);
            if (v2 != null) {
                v2.format(JsonValueFormat.DATE);
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider provider2) {
        if (this.useTimestamp(provider2)) {
            if (this._shape == JsonFormat.Shape.NUMBER_INT) {
                return JsonToken.VALUE_NUMBER_INT;
            }
            return JsonToken.START_ARRAY;
        }
        return JsonToken.VALUE_STRING;
    }
}

