/*
 * Decompiled with CFR 0.152.
 */
package circlet.documents;

import circlet.client.api.Document;
import circlet.client.api.DocumentFolder;
import circlet.client.api.DocumentFolderWithChildren;
import circlet.client.api.DocumentFolderWithChildrenBase;
import circlet.documents.DocumentsCommonUtilsKt;
import circlet.platform.api.Ref;
import circlet.platform.client.RefResolveKt;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import platform.common.NaturalComparatorKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a\u0016\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e*\u00020\u000f\u001a\"\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u000e\u001a\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u000e*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u000e\u001a\"\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00020\u000e*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00020\u000e\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"documentsComparator", "Ljava/util/Comparator;", "Lcirclet/platform/api/Ref;", "Lcirclet/client/api/Document;", "folderComparator", "Lcirclet/client/api/DocumentFolder;", "folderWithChildrenComparator", "Lcirclet/client/api/DocumentFolderWithChildrenBase;", "naturalCompare", "", "s1", "", "s2", "sortedDocuments", "", "Lcirclet/client/api/DocumentFolderWithChildren;", "sortedFolders", "sortedFoldersWithChildren", "app-state"})
public final class DocumentsComparatorsKt {
    @NotNull
    private static final Comparator<Ref<Document>> documentsComparator = DocumentsComparatorsKt::documentsComparator$lambda$0;
    @NotNull
    private static final Comparator<Ref<DocumentFolder>> folderComparator = DocumentsComparatorsKt::folderComparator$lambda$1;
    @NotNull
    private static final Comparator<Ref<DocumentFolderWithChildrenBase>> folderWithChildrenComparator = DocumentsComparatorsKt::folderWithChildrenComparator$lambda$2;

    @NotNull
    public static final List<Ref<DocumentFolder>> sortedFolders(@NotNull List<Ref<DocumentFolder>> $this$sortedFolders) {
        Intrinsics.checkNotNullParameter($this$sortedFolders, (String)"<this>");
        return CollectionsKt.sortedWith((Iterable)$this$sortedFolders, folderComparator);
    }

    @NotNull
    public static final List<Ref<DocumentFolderWithChildren>> sortedFoldersWithChildren(@NotNull List<Ref<DocumentFolderWithChildren>> $this$sortedFoldersWithChildren) {
        Intrinsics.checkNotNullParameter($this$sortedFoldersWithChildren, (String)"<this>");
        return CollectionsKt.sortedWith((Iterable)$this$sortedFoldersWithChildren, folderWithChildrenComparator);
    }

    @NotNull
    public static final List<Ref<Document>> sortedDocuments(@NotNull List<Ref<Document>> $this$sortedDocuments) {
        Intrinsics.checkNotNullParameter($this$sortedDocuments, (String)"<this>");
        return CollectionsKt.sortedWith((Iterable)$this$sortedDocuments, documentsComparator);
    }

    @NotNull
    public static final List<Ref<Document>> sortedDocuments(@NotNull DocumentFolderWithChildren $this$sortedDocuments) {
        Intrinsics.checkNotNullParameter((Object)$this$sortedDocuments, (String)"<this>");
        return CollectionsKt.sortedWith((Iterable)DocumentsCommonUtilsKt.getFolderDocuments($this$sortedDocuments), documentsComparator);
    }

    private static final int naturalCompare(String s1, String s2) {
        return NaturalComparatorKt.naturalCompare(s1, s2, s1.length(), s2.length(), true);
    }

    private static final int documentsComparator$lambda$0(Ref doc1, Ref doc2) {
        Intrinsics.checkNotNullExpressionValue((Object)doc1, (String)"doc1");
        String string2 = ((Document)RefResolveKt.resolve(doc1)).notEmptyTitle();
        Intrinsics.checkNotNullExpressionValue((Object)doc2, (String)"doc2");
        return DocumentsComparatorsKt.naturalCompare(string2, ((Document)RefResolveKt.resolve(doc2)).notEmptyTitle());
    }

    private static final int folderComparator$lambda$1(Ref folder1, Ref folder2) {
        Intrinsics.checkNotNullExpressionValue((Object)folder1, (String)"folder1");
        String string2 = ((DocumentFolder)RefResolveKt.resolve(folder1)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)folder2, (String)"folder2");
        return DocumentsComparatorsKt.naturalCompare(string2, ((DocumentFolder)RefResolveKt.resolve(folder2)).getName());
    }

    private static final int folderWithChildrenComparator$lambda$2(Ref folder1, Ref folder2) {
        Intrinsics.checkNotNullExpressionValue((Object)folder1, (String)"folder1");
        String string2 = RefResolveKt.resolve(DocumentsCommonUtilsKt.getDocumentFolderRef(folder1)).getName();
        Intrinsics.checkNotNullExpressionValue((Object)folder2, (String)"folder2");
        return DocumentsComparatorsKt.naturalCompare(string2, RefResolveKt.resolve(DocumentsCommonUtilsKt.getDocumentFolderRef(folder2)).getName());
    }
}

