/*
 * Decompiled with CFR 0.152.
 */
package circlet.common.documents;

import circlet.common.documents.FolderPermissionChecker;
import circlet.common.permissions.ArchiveDocuments;
import circlet.common.permissions.CreateDocuments;
import circlet.common.permissions.DeleteDocumentsForever;
import circlet.common.permissions.EditDocuments;
import circlet.common.permissions.ManageDocuments;
import circlet.common.permissions.ManageDocuments2;
import circlet.common.permissions.Right;
import circlet.common.permissions.ViewDocuments;
import circlet.common.permissions.ViewFoldersMetadata;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lcirclet/common/documents/FolderPermissions;", "", "()V", "canAdministrate", "", "checker", "Lcirclet/common/documents/FolderPermissionChecker;", "canArchive", "canBeMoved", "canCreateDocuments", "canDeleteForever", "canEdit", "canMoveTo", "targetFolderChecker", "canRestore", "canView", "canViewMetadata", "common"})
public final class FolderPermissions {
    @NotNull
    public static final FolderPermissions INSTANCE = new FolderPermissions();

    private FolderPermissions() {
    }

    public final boolean canViewMetadata(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ViewFoldersMetadata.INSTANCE);
    }

    public final boolean canView(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ViewDocuments.INSTANCE);
    }

    public final boolean canEdit(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)EditDocuments.INSTANCE);
    }

    public final boolean canArchive(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ArchiveDocuments.INSTANCE);
    }

    public final boolean canDeleteForever(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)DeleteDocumentsForever.INSTANCE);
    }

    public final boolean canRestore(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.canRestore();
    }

    public final boolean canAdministrate(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ManageDocuments2.INSTANCE) || checker.hasPermission((Right)ManageDocuments.INSTANCE);
    }

    public final boolean canCreateDocuments(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)CreateDocuments.INSTANCE);
    }

    public final boolean canBeMoved(@NotNull FolderPermissionChecker checker) {
        Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
        return checker.hasPermission((Right)ManageDocuments2.INSTANCE) || checker.hasPermission((Right)ManageDocuments.INSTANCE);
    }

    public final boolean canMoveTo(@NotNull FolderPermissionChecker targetFolderChecker) {
        Intrinsics.checkNotNullParameter((Object)targetFolderChecker, (String)"targetFolderChecker");
        return targetFolderChecker.hasPermission((Right)CreateDocuments.INSTANCE);
    }
}

