/*
 * Decompiled with CFR 0.152.
 */
package circlet.client.api;

import circlet.client.api.FilterQuery;
import circlet.client.api.FilterQueryKt;
import circlet.client.api.FilterValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import libraries.collections.UtilsKt;
import libraries.klogging.KLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 *2\u00020\u0001:\u0002*+B'\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bJ\b\u0010)\u001a\u00020\u0004H\u0016R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000bR\u0019\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000bR\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0019\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0019\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0019\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000bR\u0019\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000bR\u0019\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0019\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000b\u00a8\u0006,"}, d2={"Lcirclet/client/api/FilterQuery;", "", "filters", "", "", "", "Lcirclet/client/api/FilterValue;", "text", "(Ljava/util/Map;Ljava/lang/String;)V", "allRefs", "getAllRefs", "()Ljava/util/List;", "ancestor", "getAncestor", "author", "getAuthor", "branch", "getBranch", "date", "getDate", "getFilters", "()Ljava/util/Map;", "firstParent", "getFirstParent", "id", "getId", "idRange", "getIdRange", "isEmpty", "", "()Z", "noMerges", "getNoMerges", "path", "getPath", "tag", "getTag", "getText", "()Ljava/lang/String;", "unique", "getUnique", "toString", "Companion", "Fields", "client-api"})
@SourceDebugExtension(value={"SMAP\nFilterQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterQuery.kt\ncirclet/client/api/FilterQuery\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1045#2:246\n1549#2:247\n1620#2,3:248\n*S KotlinDebug\n*F\n+ 1 FilterQuery.kt\ncirclet/client/api/FilterQuery\n*L\n25#1:246\n26#1:247\n26#1:248,3\n*E\n"})
public final class FilterQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<FilterValue>> filters;
    @NotNull
    private final String text;
    public static final char QUOTE = '\"';
    @NotNull
    public static final String COLON = ":";
    @NotNull
    public static final String COMMA = ",";
    @NotNull
    public static final String RANGE = "..";
    @NotNull
    public static final String WHITESPACE = " ";
    @NotNull
    private static final FilterQuery Empty = new FilterQuery(MapsKt.emptyMap(), "");

    public FilterQuery(@NotNull Map<String, ? extends List<? extends FilterValue>> filters2, @NotNull String text2) {
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.filters = filters2;
        this.text = text2;
    }

    @NotNull
    public final Map<String, List<FilterValue>> getFilters() {
        return this.filters;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$mapTo$iv$iv;
        Iterable $this$sortedBy$iv = this.filters.entrySet();
        boolean $i$f$sortedBy = false;
        Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
            }
        });
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String key2 = (String)entry.getKey();
            List values2 = (List)entry.getValue();
            collection.add(key2 + COLON + CollectionsKt.joinToString$default((Iterable)values2, (CharSequence)COMMA, null, null, (int)0, null, null, (int)62, null));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)(((CharSequence)this.text).length() == 0 ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)FilterQueryKt.access$escapeIfNecessary(this.text, false)))), (CharSequence)WHITESPACE, null, null, (int)0, null, null, (int)62, null);
    }

    public final boolean isEmpty() {
        return this.filters.isEmpty() && StringsKt.isBlank((CharSequence)this.text);
    }

    @Nullable
    public final List<FilterValue> getId() {
        return this.filters.get("id");
    }

    @Nullable
    public final List<FilterValue> getIdRange() {
        return this.filters.get("id-range");
    }

    @Nullable
    public final List<FilterValue> getAuthor() {
        return this.filters.get("author");
    }

    @Nullable
    public final List<FilterValue> getTag() {
        return this.filters.get("tag");
    }

    @Nullable
    public final List<FilterValue> getBranch() {
        return this.filters.get("head");
    }

    @Nullable
    public final List<FilterValue> getDate() {
        return this.filters.get("date");
    }

    @Nullable
    public final List<FilterValue> getAllRefs() {
        return this.filters.get("all-refs");
    }

    @Nullable
    public final List<FilterValue> getNoMerges() {
        return this.filters.get("no-merges");
    }

    @Nullable
    public final List<FilterValue> getPath() {
        return this.filters.get("path");
    }

    @Nullable
    public final List<FilterValue> getFirstParent() {
        return this.filters.get("first-parent");
    }

    @Nullable
    public final List<FilterValue> getUnique() {
        return this.filters.get("unique");
    }

    @Nullable
    public final List<FilterValue> getAncestor() {
        return this.filters.get("ancestor");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002'(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\f\u001a\u00020\u00072*\u0010\r\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f0\u000e\"\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\u00cc\u0001\u0010\f\u001a\u00020\u00072\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u001a\b\u0002\u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000f0\u00132\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u00132\b\b\u0002\u0010\u001d\u001a\u00020\u001a2\b\b\u0002\u0010\u001e\u001a\u00020\u001a2\b\b\u0002\u0010\u001f\u001a\u00020\u00042\u000e\b\u0002\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00040\u0013J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0004J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00132\u0006\u0010\"\u001a\u00020\u0004H\u0002J\f\u0010&\u001a\u00020\u001a*\u00020%H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcirclet/client/api/FilterQuery$Companion;", "", "()V", "COLON", "", "COMMA", "Empty", "Lcirclet/client/api/FilterQuery;", "QUOTE", "", "RANGE", "WHITESPACE", "of", "args", "", "Lkotlin/Pair;", "Lcirclet/client/api/FilterValue;", "([Lkotlin/Pair;)Lcirclet/client/api/FilterQuery;", "id", "", "idRange", "author", "tag", "branch", "date", "allRefs", "", "noMerges", "path", "firstParent", "unique", "text", "ancestor", "parse", "query", "parseSafe", "tokenize", "Lcirclet/client/api/FilterQuery$Companion$Token;", "isIdOrStr", "Token", "TokenType", "client-api"})
    @SourceDebugExtension(value={"SMAP\nFilterQuery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilterQuery.kt\ncirclet/client/api/FilterQuery$Companion\n+ 2 KLogger.kt\nlibraries/klogging/KLogger\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n63#2,5:246\n11335#3:251\n11670#3,3:252\n1#4:255\n1549#5:256\n1620#5,3:257\n*S KotlinDebug\n*F\n+ 1 FilterQuery.kt\ncirclet/client/api/FilterQuery$Companion\n*L\n192#1:246,5\n197#1:251\n197#1:252,3\n214#1:256\n214#1:257,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isIdOrStr(Token $this$isIdOrStr) {
            return $this$isIdOrStr.getType() == TokenType.id || $this$isIdOrStr.getType() == TokenType.str;
        }

        private final List<Token> tokenize(String query2) {
            List result2 = new ArrayList();
            int start2 = 0;
            while (start2 < query2.length()) {
                char nc;
                int next2;
                char c = query2.charAt(start2);
                if (c == ' ') {
                    int from = start2;
                    while (start2 < query2.length() && query2.charAt(start2) == ' ') {
                        ++start2;
                    }
                    result2.add(new Token(TokenType.whitespace, from, start2));
                    continue;
                }
                if (c == ',') {
                    result2.add(new Token(TokenType.comma, start2, start2 + 1));
                    ++start2;
                    continue;
                }
                if (c == ':') {
                    result2.add(new Token(TokenType.colon, start2, start2 + 1));
                    ++start2;
                    continue;
                }
                if (c == '.') {
                    String string2 = query2.substring(start2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    if (StringsKt.startsWith$default((String)string2, (String)FilterQuery.RANGE, (boolean)false, (int)2, null)) {
                        result2.add(new Token(TokenType.dotdot, start2, start2 + 2));
                        start2 += 2;
                        continue;
                    }
                }
                if (c == '\"') {
                    next2 = start2 + 1;
                    while (next2 < query2.length() && (nc = query2.charAt(next2++)) != '\"') {
                        if (nc != '\\' || next2 >= query2.length()) continue;
                        ++next2;
                    }
                    result2.add(new Token(TokenType.str, start2, next2));
                    start2 = next2;
                    continue;
                }
                for (next2 = start2 + 1; next2 < query2.length() && (nc = query2.charAt(next2)) != ' ' && nc != ',' && nc != ':' && (nc != '.' || next2 + 1 >= query2.length() || query2.charAt(next2 + 1) != '.'); ++next2) {
                }
                result2.add(new Token(TokenType.id, start2, next2));
                start2 = next2;
            }
            return result2;
        }

        @NotNull
        public final FilterQuery parse(@NotNull String query2) {
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            List<Token> tokens2 = this.tokenize(query2);
            if (tokens2.isEmpty()) {
                return Empty;
            }
            List fields = new ArrayList();
            List words = new ArrayList();
            Ref.IntRef start2 = new Ref.IntRef();
            while (start2.element < tokens2.size()) {
                int n = start2.element;
                start2.element = n + 1;
                Token token2 = tokens2.get(n);
                if (token2.getType() == TokenType.str) {
                    words.add(circlet.client.api.FilterQuery$Companion.parse$text(token2, query2));
                    continue;
                }
                if (token2.getType() == TokenType.id) {
                    if (start2.element < tokens2.size() && tokens2.get(start2.element).getType() == TokenType.colon) {
                        n = start2.element;
                        start2.element = n + 1;
                        String key2 = circlet.client.api.FilterQuery$Companion.parse$text(token2, query2);
                        List values2 = new ArrayList();
                        circlet.client.api.FilterQuery$Companion.parse$parseValue(start2, tokens2, values2, query2);
                        while (start2.element < tokens2.size() && tokens2.get(start2.element).getType() == TokenType.comma) {
                            int n2 = start2.element;
                            start2.element = n2 + 1;
                            circlet.client.api.FilterQuery$Companion.parse$parseValue(start2, tokens2, values2, query2);
                        }
                        fields.add(TuplesKt.to((Object)key2, (Object)values2));
                        continue;
                    }
                    words.add(circlet.client.api.FilterQuery$Companion.parse$text(token2, query2));
                    continue;
                }
                if (token2.getType() == TokenType.whitespace) continue;
                words.add(circlet.client.api.FilterQuery$Companion.parse$text(token2, query2));
            }
            return new FilterQuery(MapsKt.toMap((Iterable)fields), CollectionsKt.joinToString$default((Iterable)words, (CharSequence)FilterQuery.WHITESPACE, null, null, (int)0, null, null, (int)62, null));
        }

        @NotNull
        public final FilterQuery parseSafe(@NotNull String query2) {
            FilterQuery filterQuery2;
            Intrinsics.checkNotNullParameter((Object)query2, (String)"query");
            try {
                filterQuery2 = this.parse(query2);
            }
            catch (Throwable ex) {
                KLogger this_$iv = FilterQueryKt.access$getLog$p();
                boolean $i$f$warn = false;
                if (this_$iv.isWarnEnabled()) {
                    boolean bl = false;
                    String msgStr$iv = "Parsing query: " + query2;
                    this_$iv.warn(ex, msgStr$iv);
                }
                filterQuery2 = Empty;
            }
            return filterQuery2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FilterQuery of(Pair<String, ? extends FilterValue> ... args) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(args, (String)"args");
            Pair<String, ? extends FilterValue>[] $this$map$iv = args;
            boolean $i$f$map = false;
            Pair<String, ? extends FilterValue>[] pairArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)it.getFirst(), (Object)CollectionsKt.listOf((Object)it.getSecond())));
            }
            String string2 = "";
            Map map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            return new FilterQuery(map2, string2);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final FilterQuery of(@NotNull List<String> id2, @NotNull List<Pair<String, String>> idRange, @NotNull List<String> author, @NotNull List<String> tag, @NotNull List<String> branch2, @Nullable Pair<String, String> date2, boolean allRefs, boolean noMerges, @NotNull List<String> path2, boolean firstParent, boolean unique, @NotNull String text2, @NotNull List<String> ancestor) {
            List list2;
            Intrinsics.checkNotNullParameter(id2, (String)"id");
            Intrinsics.checkNotNullParameter(idRange, (String)"idRange");
            Intrinsics.checkNotNullParameter(author, (String)"author");
            Intrinsics.checkNotNullParameter(tag, (String)"tag");
            Intrinsics.checkNotNullParameter(branch2, (String)"branch");
            Intrinsics.checkNotNullParameter(path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(ancestor, (String)"ancestor");
            Pair[] pairArray = new Pair[12];
            pairArray[0] = TuplesKt.to((Object)"id", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValues(id2));
            pairArray[1] = TuplesKt.to((Object)"id-range", circlet.client.api.FilterQuery$Companion.of$toFilterValues(idRange, of.2.INSTANCE));
            pairArray[2] = TuplesKt.to((Object)"author", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValues(author));
            pairArray[3] = TuplesKt.to((Object)"tag", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValues(tag));
            pairArray[4] = TuplesKt.to((Object)"head", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValues(branch2));
            Pair[] pairArray2 = pairArray;
            int n = 5;
            String string2 = "date";
            Pair<String, String> pair = date2;
            if (pair != null) {
                void it;
                Pair<String, String> pair2 = pair;
                String string3 = string2;
                int n2 = n;
                Pair[] pairArray3 = pairArray2;
                boolean bl = false;
                List list3 = CollectionsKt.listOf((Object)new FilterValue.RangeFilterValue((String)it.getFirst(), (String)it.getSecond()));
                pairArray2 = pairArray3;
                n = n2;
                string2 = string3;
                list2 = list3;
            } else {
                list2 = null;
            }
            pairArray2[n] = TuplesKt.to((Object)string2, list2);
            pairArray[6] = TuplesKt.to((Object)"all-refs", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValue(allRefs));
            pairArray[7] = TuplesKt.to((Object)"no-merges", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValue(noMerges));
            pairArray[8] = TuplesKt.to((Object)"first-parent", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValue(firstParent));
            pairArray[9] = TuplesKt.to((Object)"unique", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValue(unique));
            pairArray[10] = TuplesKt.to((Object)"path", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValues(path2));
            pairArray[11] = TuplesKt.to((Object)"ancestor", circlet.client.api.FilterQuery$Companion.of$toSimpleFilterValues(ancestor));
            Map it = UtilsKt.filterOutNullValues(MapsKt.mapOf((Pair[])pairArray));
            boolean bl = false;
            return new FilterQuery(it, text2);
        }

        public static /* synthetic */ FilterQuery of$default(Companion companion, List list2, List list3, List list4, List list5, List list6, Pair pair, boolean bl, boolean bl2, List list7, boolean bl3, boolean bl4, String string2, List list8, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = CollectionsKt.emptyList();
            }
            if ((n & 2) != 0) {
                list3 = CollectionsKt.emptyList();
            }
            if ((n & 4) != 0) {
                list4 = CollectionsKt.emptyList();
            }
            if ((n & 8) != 0) {
                list5 = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                list6 = CollectionsKt.emptyList();
            }
            if ((n & 0x20) != 0) {
                pair = null;
            }
            if ((n & 0x40) != 0) {
                bl = false;
            }
            if ((n & 0x80) != 0) {
                bl2 = false;
            }
            if ((n & 0x100) != 0) {
                list7 = CollectionsKt.emptyList();
            }
            if ((n & 0x200) != 0) {
                bl3 = false;
            }
            if ((n & 0x400) != 0) {
                bl4 = false;
            }
            if ((n & 0x800) != 0) {
                string2 = "";
            }
            if ((n & 0x1000) != 0) {
                list8 = CollectionsKt.emptyList();
            }
            return companion.of(list2, list3, list4, list5, list6, (Pair<String, String>)pair, bl, bl2, list7, bl3, bl4, string2, list8);
        }

        private static final String parse$text(Token $this$parse_u24text, String $query) {
            String string2;
            if ($this$parse_u24text.getType() == TokenType.str) {
                String string3 = $query.substring($this$parse_u24text.getStart() + 1, $this$parse_u24text.getEnd() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                string2 = StringsKt.replace$default((String)string3, (String)"\\\"", (String)"\"", (boolean)false, (int)4, null);
            } else {
                String string4 = $query.substring($this$parse_u24text.getStart(), $this$parse_u24text.getEnd());
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            return string2;
        }

        private static final void parse$parseValue(Ref.IntRef start2, List<Token> tokens2, List<FilterValue> values2, String $query) {
            if (start2.element < tokens2.size()) {
                int n = start2.element;
                start2.element = n + 1;
                Token v = tokens2.get(n);
                if (Companion.isIdOrStr(v)) {
                    if (start2.element < tokens2.size() && tokens2.get(start2.element).getType() == TokenType.dotdot) {
                        if (start2.element < tokens2.size() - 1 && Companion.isIdOrStr(tokens2.get(start2.element + 1))) {
                            values2.add(new FilterValue.RangeFilterValue(circlet.client.api.FilterQuery$Companion.parse$text(v, $query), circlet.client.api.FilterQuery$Companion.parse$text(tokens2.get(start2.element + 1), $query)));
                            start2.element += 2;
                        } else {
                            values2.add(new FilterValue.RangeFilterValue(circlet.client.api.FilterQuery$Companion.parse$text(v, $query), ""));
                            n = start2.element;
                            start2.element = n + 1;
                        }
                    } else {
                        values2.add(new FilterValue.SimpleFilterValue(circlet.client.api.FilterQuery$Companion.parse$text(v, $query)));
                    }
                } else if (v.getType() == TokenType.dotdot && start2.element < tokens2.size() && Companion.isIdOrStr(tokens2.get(start2.element))) {
                    values2.add(new FilterValue.RangeFilterValue("", circlet.client.api.FilterQuery$Companion.parse$text(tokens2.get(start2.element), $query)));
                    n = start2.element;
                    start2.element = n + 1;
                } else {
                    throw new IllegalStateException(("syntax error at position " + v.getStart()).toString());
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final <T> List<FilterValue> of$toFilterValues(List<? extends T> $this$of_u24toFilterValues, Function1<? super T, ? extends FilterValue> block) {
            List list2;
            List<T> list3;
            List<T> it = list3 = $this$of_u24toFilterValues;
            boolean bl2 = false;
            List<Object> list4 = !it.isEmpty() ? list3 : null;
            if (list4 != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = list4;
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    destination$iv$iv.add(block.invoke(item$iv$iv));
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = null;
            }
            return list2;
        }

        private static final List<FilterValue> of$toSimpleFilterValues(List<String> $this$of_u24toSimpleFilterValues) {
            return circlet.client.api.FilterQuery$Companion.of$toFilterValues($this$of_u24toSimpleFilterValues, of.toSimpleFilterValues.1.INSTANCE);
        }

        private static final List<FilterValue.SimpleFilterValue> of$toSimpleFilterValue(boolean $this$of_u24toSimpleFilterValue) {
            List list2;
            Boolean bl = $this$of_u24toSimpleFilterValue;
            boolean it = bl;
            boolean bl2 = false;
            Boolean bl3 = it ? bl : null;
            if (bl3 != null) {
                it = bl3;
                boolean bl4 = false;
                list2 = CollectionsKt.listOf((Object)new FilterValue.SimpleFilterValue("true"));
            } else {
                list2 = null;
            }
            return list2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lcirclet/client/api/FilterQuery$Companion$Token;", "", "type", "Lcirclet/client/api/FilterQuery$Companion$TokenType;", "start", "", "end", "(Lcirclet/client/api/FilterQuery$Companion$TokenType;II)V", "getEnd", "()I", "getStart", "getType", "()Lcirclet/client/api/FilterQuery$Companion$TokenType;", "toString", "", "client-api"})
        private static final class Token {
            @NotNull
            private final TokenType type;
            private final int start;
            private final int end;

            public Token(@NotNull TokenType type2, int start2, int end) {
                Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
                this.type = type2;
                this.start = start2;
                this.end = end;
            }

            @NotNull
            public final TokenType getType() {
                return this.type;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            @NotNull
            public String toString() {
                return this.type.name();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcirclet/client/api/FilterQuery$Companion$TokenType;", "", "(Ljava/lang/String;I)V", "id", "str", "comma", "colon", "dotdot", "whitespace", "client-api"})
        private static final class TokenType
        extends Enum<TokenType> {
            public static final /* enum */ TokenType id = new TokenType();
            public static final /* enum */ TokenType str = new TokenType();
            public static final /* enum */ TokenType comma = new TokenType();
            public static final /* enum */ TokenType colon = new TokenType();
            public static final /* enum */ TokenType dotdot = new TokenType();
            public static final /* enum */ TokenType whitespace = new TokenType();
            private static final /* synthetic */ TokenType[] $VALUES;

            public static TokenType[] values() {
                return (TokenType[])$VALUES.clone();
            }

            public static TokenType valueOf(String value2) {
                return Enum.valueOf(TokenType.class, value2);
            }

            static {
                $VALUES = tokenTypeArray = new TokenType[]{TokenType.id, TokenType.str, TokenType.comma, TokenType.colon, TokenType.dotdot, TokenType.whitespace};
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcirclet/client/api/FilterQuery$Fields;", "", "()V", "ALL_REFS", "", "ANCESTOR", "AUTHOR", "DATE", "FIRST_PARENT", "HEAD", "ID", "ID_RANGE", "NO_MERGES", "PATH", "TAG", "UNIQUE", "client-api"})
    public static final class Fields {
        @NotNull
        public static final Fields INSTANCE = new Fields();
        @NotNull
        public static final String ID = "id";
        @NotNull
        public static final String ID_RANGE = "id-range";
        @NotNull
        public static final String AUTHOR = "author";
        @NotNull
        public static final String TAG = "tag";
        @NotNull
        public static final String HEAD = "head";
        @NotNull
        public static final String DATE = "date";
        @NotNull
        public static final String ALL_REFS = "all-refs";
        @NotNull
        public static final String NO_MERGES = "no-merges";
        @NotNull
        public static final String PATH = "path";
        @NotNull
        public static final String FIRST_PARENT = "first-parent";
        @NotNull
        public static final String UNIQUE = "unique";
        @NotNull
        public static final String ANCESTOR = "ancestor";

        private Fields() {
        }
    }
}

