/*
 * Decompiled with CFR 0.152.
 */
package git4idea.performanceTesting;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.ChangeListCommitState;
import com.intellij.vcs.commit.LocalChangesCommitter;
import com.jetbrains.performancePlugin.commands.PerformanceCommandCoroutineAdapter;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\u0003H\u0014\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000e"}, d2={"Lgit4idea/performanceTesting/GitCommitCommand;", "Lcom/jetbrains/performancePlugin/commands/PerformanceCommandCoroutineAdapter;", "text", "", "line", "", "(Ljava/lang/String;I)V", "doExecute", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "(Lcom/intellij/openapi/ui/playback/PlaybackContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getName", "Companion", "intellij.vcs.git"})
public final class GitCommitCommand
extends PerformanceCommandCoroutineAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "gitCommit";
    @NotNull
    public static final String PREFIX = "%gitCommit";

    public GitCommitCommand(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @Nullable
    protected Object doExecute(@NotNull PlaybackContext context, @NotNull Continuation<? super Unit> $completion) {
        ArrayList arrayList = this.extractCommandList(PREFIX, ",");
        if (arrayList == null) {
            throw new RuntimeException("Commit message wasn't passed");
        }
        ArrayList arrayList2 = arrayList;
        String filePath = (String)((List)arrayList2).get(0);
        String commitMessage = (String)((List)arrayList2).get(1);
        LocalChangeList localChangeList = LocalChangeListImpl.createEmptyChangeList((Project)context.getProject(), (String)"");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"context.project");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            throw new RuntimeException("Project dir is null");
        }
        VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(filePath);
        if (virtualFile2 == null) {
            throw new RuntimeException("");
        }
        Path path = virtualFile2.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"(context.project.guessPr\u2026xception(\"\")).toNioPath()");
        Path localFilePath = path;
        ContentRevision contentRevision = GitContentRevision.createRevision((FilePath)new LocalFilePath(localFilePath, false), (VcsRevisionNumber)GitRevisionNumber.HEAD, context.getProject(), null);
        Intrinsics.checkNotNullExpressionValue((Object)contentRevision, (String)"createRevision(\n      Lo\u2026project,\n      null\n    )");
        ContentRevision beforeRevision = contentRevision;
        Change change = new Change(beforeRevision, beforeRevision, FileStatus.MODIFIED);
        Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"localChangeList");
        List list2 = CollectionsKt.listOf((Object)change);
        Intrinsics.checkNotNullExpressionValue((Object)commitMessage, (String)"commitMessage");
        ChangeListCommitState listCommitState = new ChangeListCommitState(localChangeList, list2, commitMessage);
        Project project2 = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"context.project");
        new LocalChangesCommitter(project2, listCommitState, new CommitContext(), null, 8, null).runCommit("", true);
        return Unit.INSTANCE;
    }

    @NotNull
    protected String getName() {
        return NAME;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgit4idea/performanceTesting/GitCommitCommand$Companion;", "", "()V", "NAME", "", "PREFIX", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

