/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.collaboration.ui.CollaborationToolsUIUtil;
import com.intellij.collaboration.ui.CollaborationToolsUIUtilKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.InstallButton;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JButtonAction;
import com.intellij.util.ui.UIUtil;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.action.GHPRReviewSubmitAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPullRequestPendingReview;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.ui.component.GHHtmlErrorPanel;
import org.jetbrains.plugins.github.ui.component.GHSimpleErrorPanelModel;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\f0\u0017\u00a2\u0006\u0002\b\u0018\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u0017\u0010\u001b\u001a\u00020\u00172\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0003\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRReviewSubmitAction;", "Lcom/intellij/util/ui/JButtonAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopupComponent", "Lcom/intellij/openapi/ui/ComponentContainer;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "document", "Lcom/intellij/openapi/editor/Document;", "cancelActionListener", "Ljava/awt/event/ActionListener;", "pendingReviewFuture", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPullRequestPendingReview;", "viewerIsAuthor", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getPrefix", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "place", "getText", "pendingComments", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "update", "updateButtonFromPresentation", "button", "Ljavax/swing/JButton;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Companion", "intellij.vcs.github"})
public final class GHPRReviewSubmitAction
extends JButtonAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<String> PROP_PREFIX = new Key("PREFIX");

    public GHPRReviewSubmitAction() {
        super("\u2026", GithubBundle.message("pull.request.review.submit.action.description", new Object[0]), null, 4, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GHPRDataProvider dataProvider = (GHPRDataProvider)e.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        if (dataProvider == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GHPRReviewDataProvider reviewData = dataProvider.getReviewData();
        GHPullRequest details2 = dataProvider.getDetailsData().getLoadedDetails();
        e.getPresentation().setVisible(true);
        CompletableFuture<GHPullRequestPendingReview> pendingReviewFuture = reviewData.loadPendingReview();
        e.getPresentation().setEnabled(pendingReviewFuture.isDone() && details2 != null);
        Presentation presentation = e.getPresentation();
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.place");
        presentation.putClientProperty(PROP_PREFIX, (Object)this.getPrefix(string));
        if (e.getPresentation().isEnabledAndVisible()) {
            GHPullRequestPendingReview gHPullRequestPendingReview;
            try {
                gHPullRequestPendingReview = pendingReviewFuture.getNow(null);
            }
            catch (Exception e2) {
                gHPullRequestPendingReview = null;
            }
            GHPullRequestPendingReview review = gHPullRequestPendingReview;
            boolean pendingReview = review != null;
            GHPullRequestPendingReview gHPullRequestPendingReview2 = review;
            Integer comments = gHPullRequestPendingReview2 != null ? Integer.valueOf(gHPullRequestPendingReview2.getCommentsCount()) : null;
            e.getPresentation().setText(this.getText(comments));
            e.getPresentation().putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)pendingReview);
        }
    }

    private final String getPrefix(String place) {
        String string = Intrinsics.areEqual((Object)place, (Object)"DiffToolbar") ? GithubBundle.message("pull.request.review.submit", new Object[0]) : CollaborationToolsBundle.message((String)"review.start.submit.action", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (place == ActionPlace\u2026iew.start.submit.action\")");
        return string;
    }

    @NlsSafe
    private final String getText(Integer pendingComments) {
        StringBuilder builder = new StringBuilder();
        if (pendingComments != null) {
            builder.append(" (" + pendingComments + ")");
        }
        builder.append("\u2026");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(GHPRAc\u2026LL_REQUEST_DATA_PROVIDER)");
        GHPRDataProvider dataProvider = (GHPRDataProvider)object;
        GHPullRequest gHPullRequest = dataProvider.getDetailsData().getLoadedDetails();
        if (gHPullRequest == null) {
            return;
        }
        GHPullRequest details2 = gHPullRequest;
        GHPRReviewDataProvider reviewDataProvider = dataProvider.getReviewData();
        CompletableFuture<GHPullRequestPendingReview> pendingReviewFuture = reviewDataProvider.loadPendingReview();
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        JComponent parentComponent = jComponent;
        Ref.ObjectRef cancelRunnable = new Ref.ObjectRef();
        ActionListener cancelActionListener = arg_0 -> GHPRReviewSubmitAction.actionPerformed$lambda$0(cancelRunnable, arg_0);
        ComponentContainer container = this.createPopupComponent(reviewDataProvider, reviewDataProvider.getSubmitReviewCommentDocument(), cancelActionListener, pendingReviewFuture, details2.getViewerDidAuthor());
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(container.getComponent(), container.getPreferredFocusableComponent()).setFocusable(true).setRequestFocus(true).setResizable(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"getInstance()\n      .cre\u2026rue)\n      .createPopup()");
        JBPopup popup = jBPopup;
        cancelRunnable.element = new Function0<Unit>(popup){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
                super(0);
            }

            public final void invoke() {
                this.$popup.cancel();
            }
        };
        popup.showUnderneathOf((Component)parentComponent);
    }

    private final ComponentContainer createPopupComponent(GHPRReviewDataProvider reviewDataProvider, Document document, ActionListener cancelActionListener, CompletableFuture<GHPullRequestPendingReview> pendingReviewFuture, boolean viewerIsAuthor) {
        return new ComponentContainer(document, pendingReviewFuture, cancelActionListener, viewerIsAuthor, reviewDataProvider){
            @NotNull
            private final Wrapper wrapper;
            @NotNull
            private final EditorTextField editor;
            @NotNull
            private final GHSimpleErrorPanelModel errorModel;
            @NotNull
            private final createPopupComponent.approveButton.1 approveButton;
            @NotNull
            private final JButton rejectButton;
            @NotNull
            private final JButton commentButton;
            @NotNull
            private final InlineIconButton discardButton;
            @NotNull
            private final InlineIconButton closeButton;
            @NotNull
            private final JLabel loadingLabel;
            final /* synthetic */ Document $document;
            final /* synthetic */ ActionListener $cancelActionListener;
            final /* synthetic */ GHPRReviewDataProvider $reviewDataProvider;
            {
                void $this$closeButton_u24lambda_u244;
                Object $this$discardButton_u24lambda_u243;
                Object $this$commentButton_u24lambda_u242;
                Object $this$rejectButton_u24lambda_u241;
                Object $this$wrapper_u24lambda_u240;
                Object object;
                this.$document = $document;
                this.$cancelActionListener = $cancelActionListener;
                this.$reviewDataProvider = $reviewDataProvider;
                Wrapper wrapper = object = new Wrapper();
                var var9_8 = this;
                boolean bl = false;
                $this$wrapper_u24lambda_u240.setOpaque(true);
                $this$wrapper_u24lambda_u240.setBackground(JBUI.CurrentTheme.List.BACKGROUND);
                $this$wrapper_u24lambda_u240.setPreferredSize((Dimension)new JBDimension(500, 200));
                var9_8.wrapper = object;
                this.editor = this.createEditor($document);
                String string = GithubBundle.message("pull.request.review.submit.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.review.submit.error\")");
                this.errorModel = new GHSimpleErrorPanelModel(string);
                object = GithubBundle.message("pull.request.review.submit.approve.button", new Object[0]);
                this.approveButton = new InstallButton((String)object){

                    protected void setTextAndSize() {
                    }
                };
                $this$wrapper_u24lambda_u240 = object = new JButton(GithubBundle.message("pull.request.review.submit.request.changes", new Object[0]));
                var9_8 = this;
                boolean bl2 = false;
                $this$rejectButton_u24lambda_u241.setOpaque(false);
                var9_8.rejectButton = object;
                $this$rejectButton_u24lambda_u241 = object = new JButton(GithubBundle.message("pull.request.review.submit.comment.button", new Object[0]));
                var9_8 = this;
                boolean bl3 = false;
                $this$commentButton_u24lambda_u242.setOpaque(false);
                $this$commentButton_u24lambda_u242.setToolTipText(GithubBundle.message("pull.request.review.submit.comment.description", new Object[0]));
                var9_8.commentButton = object;
                Icon icon = CollaborationToolsIcons.Delete;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Delete");
                $this$commentButton_u24lambda_u242 = object = new InlineIconButton(icon, CollaborationToolsIcons.DeleteHovered, null, GithubBundle.message("pull.request.discard.pending.comments", new Object[0]), null, 20, null);
                var9_8 = this;
                boolean bl4 = false;
                $this$discardButton_u24lambda_u243.setBorder(JBUI.Borders.empty((int)5));
                var9_8.discardButton = object;
                Icon icon2 = AllIcons.Actions.Close;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Close");
                $this$discardButton_u24lambda_u243 = object = new InlineIconButton(icon2, AllIcons.Actions.CloseHovered, null, null, null, 28, null);
                var9_8 = this;
                boolean bl5 = false;
                $this$closeButton_u24lambda_u244.setBorder(JBUI.Borders.empty((int)5));
                $this$closeButton_u24lambda_u244.setActionListener($cancelActionListener);
                var9_8.closeButton = object;
                this.loadingLabel = new JLabel((Icon)new AnimatedIcon.Default());
                this.approveButton.setVisible(false);
                this.rejectButton.setVisible(false);
                this.discardButton.setVisible(false);
                this.wrapper.setContent((JComponent)this.loadingLabel);
                this.wrapper.repaint();
                $pendingReviewFuture.thenAccept(arg_0 -> createPopupComponent.1._init_$lambda$5((Function1)new Function1<GHPullRequestPendingReview, Unit>(this, $viewerIsAuthor, $reviewDataProvider){
                    final /* synthetic */ createPopupComponent.1 this$0;
                    final /* synthetic */ boolean $viewerIsAuthor;
                    final /* synthetic */ GHPRReviewDataProvider $reviewDataProvider;
                    {
                        this.this$0 = $receiver;
                        this.$viewerIsAuthor = $viewerIsAuthor;
                        this.$reviewDataProvider = $reviewDataProvider;
                        super(1);
                    }

                    public final void invoke(@Nullable GHPullRequestPendingReview pendingReview) {
                        Object object = createPopupComponent.1.access$getApproveButton$p(this.this$0);
                        boolean bl = this.$viewerIsAuthor;
                        createPopupComponent.1 var4_5 = this.this$0;
                        createPopupComponent.approveButton.1 $this$invoke_u24lambda_u240 = object;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u240.setVisible(!bl);
                        $this$invoke_u24lambda_u240.addActionListener(createPopupComponent.1.access$createSubmitButtonActionListener(var4_5, GHPullRequestReviewEvent.APPROVE, pendingReview));
                        object = createPopupComponent.1.access$getRejectButton$p(this.this$0);
                        bl = this.$viewerIsAuthor;
                        var4_5 = this.this$0;
                        Object $this$invoke_u24lambda_u241 = object;
                        boolean bl3 = false;
                        ((JComponent)$this$invoke_u24lambda_u241).setVisible(!bl);
                        ((AbstractButton)$this$invoke_u24lambda_u241).addActionListener(createPopupComponent.1.access$createSubmitButtonActionListener(var4_5, GHPullRequestReviewEvent.REQUEST_CHANGES, pendingReview));
                        object = createPopupComponent.1.access$getCommentButton$p(this.this$0);
                        createPopupComponent.1 var3_4 = this.this$0;
                        Object $this$invoke_u24lambda_u242 = object;
                        boolean bl4 = false;
                        ((AbstractButton)$this$invoke_u24lambda_u242).addActionListener(createPopupComponent.1.access$createSubmitButtonActionListener(var3_4, GHPullRequestReviewEvent.COMMENT, pendingReview));
                        if (pendingReview != null) {
                            createPopupComponent.1.access$getDiscardButton$p(this.this$0).setVisible(true);
                            createPopupComponent.1.access$getDiscardButton$p(this.this$0).setActionListener(arg_0 -> createPopupComponent.1.invoke$lambda$3(this.this$0, this.$reviewDataProvider, pendingReview, arg_0));
                        }
                        JComponent submitActionComponent = createPopupComponent.1.access$createSubmitActionComponent(this.this$0, pendingReview);
                        createPopupComponent.1.access$getWrapper$p(this.this$0).setContent(submitActionComponent);
                        createPopupComponent.1.access$getWrapper$p(this.this$0).repaint();
                        CollaborationToolsUIUtil.INSTANCE.focusPanel((JComponent)createPopupComponent.1.access$getEditor$p(this.this$0));
                    }

                    private static final void invoke$lambda$3(createPopupComponent.1 this$0, GHPRReviewDataProvider $reviewDataProvider, GHPullRequestPendingReview $pendingReview, ActionEvent it) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$reviewDataProvider, (String)"$reviewDataProvider");
                        String string = GithubBundle.message("pull.request.discard.pending.comments.dialog.title", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.di\u2026g.comments.dialog.title\")");
                        String string2 = GithubBundle.message("pull.request.discard.pending.comments.dialog.msg", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.di\u2026ing.comments.dialog.msg\")");
                        MessageDialogBuilder.YesNo discardButtonMessageDialog = MessageDialogBuilder.Companion.yesNo(string, string2);
                        if (discardButtonMessageDialog.ask((Component)createPopupComponent.1.access$getDiscardButton$p(this$0))) {
                            $reviewDataProvider.deleteReview((ProgressIndicator)new EmptyProgressIndicator(), $pendingReview.getId());
                        }
                    }
                }, arg_0));
            }

            @NotNull
            public JComponent getComponent() {
                return (JComponent)this.wrapper;
            }

            @NotNull
            public EditorTextField getPreferredFocusableComponent() {
                return this.editor;
            }

            public void dispose() {
            }

            private final ActionListener createSubmitButtonActionListener(GHPullRequestReviewEvent event, GHPullRequestPendingReview pendingReview) {
                return arg_0 -> createPopupComponent.1.createSubmitButtonActionListener$lambda$6(this, pendingReview, this.$reviewDataProvider, event, this.$cancelActionListener, this.$document, arg_0);
            }

            private final JComponent createSubmitActionComponent(GHPullRequestPendingReview pendingReview) {
                JPanel jPanel;
                JLabel jLabel = new JLabel(CollaborationToolsBundle.message((String)"review.start.submit.action", (Object[])new Object[0]));
                JComponent $this$createSubmitActionComponent_u24lambda_u247 = jLabel;
                boolean bl = false;
                $this$createSubmitActionComponent_u24lambda_u247.setFont($this$createSubmitActionComponent_u24lambda_u247.getFont().deriveFont($this$createSubmitActionComponent_u24lambda_u247.getFont().getStyle() | 1));
                JLabel titleLabel = jLabel;
                JComponent $this$createSubmitActionComponent_u24lambda_u249 = $this$createSubmitActionComponent_u24lambda_u247 = new JPanel((LayoutManager)new HorizontalLayout(0));
                boolean bl2 = false;
                $this$createSubmitActionComponent_u24lambda_u249.setOpaque(false);
                $this$createSubmitActionComponent_u24lambda_u249.add((Component)titleLabel, "LEFT");
                if (pendingReview != null) {
                    int commentsCount = pendingReview.getCommentsCount();
                    $this$createSubmitActionComponent_u24lambda_u249.add(Box.createRigidArea((Dimension)new JBDimension(5, 0)), "LEFT");
                    Object object = new Object[]{commentsCount};
                    Object $this$createSubmitActionComponent_u24lambda_u249_u24lambda_u248 = object = new JLabel(CollaborationToolsBundle.message((String)"review.pending.comments.count", (Object[])object));
                    boolean bl3 = false;
                    ((JComponent)$this$createSubmitActionComponent_u24lambda_u249_u24lambda_u248).setForeground(UIUtil.getContextHelpForeground());
                    Object pendingCommentsLabel = object;
                    $this$createSubmitActionComponent_u24lambda_u249.add((Component)pendingCommentsLabel, "LEFT");
                }
                $this$createSubmitActionComponent_u24lambda_u249.add((Component)this.discardButton, "RIGHT");
                $this$createSubmitActionComponent_u24lambda_u249.add((Component)this.closeButton, "RIGHT");
                JComponent titlePanel = $this$createSubmitActionComponent_u24lambda_u247;
                JComponent $this$createSubmitActionComponent_u24lambda_u2410 = $this$createSubmitActionComponent_u24lambda_u249 = GHHtmlErrorPanel.INSTANCE.create(this.errorModel, 2);
                boolean bl4 = false;
                $this$createSubmitActionComponent_u24lambda_u2410.setBorder(JBUI.Borders.empty((int)4));
                JComponent errorPanel = $this$createSubmitActionComponent_u24lambda_u249;
                JPanel $this$createSubmitActionComponent_u24lambda_u2411 = jPanel = CollaborationToolsUIUtilKt.HorizontalListPanel((int)12);
                boolean bl5 = false;
                $this$createSubmitActionComponent_u24lambda_u2411.add((Component)((Object)this.approveButton));
                $this$createSubmitActionComponent_u24lambda_u2411.add(this.rejectButton);
                $this$createSubmitActionComponent_u24lambda_u2411.add(this.commentButton);
                JPanel buttonsPanel = jPanel;
                JPanel $this$createSubmitActionComponent_u24lambda_u2412 = jPanel = new JPanel((LayoutManager)new MigLayout(new LC().insets("12").fill().flowY().noGrid().hideMode(3)));
                boolean bl6 = false;
                $this$createSubmitActionComponent_u24lambda_u2412.setOpaque(false);
                $this$createSubmitActionComponent_u24lambda_u2412.add((Component)titlePanel, new CC().growX());
                $this$createSubmitActionComponent_u24lambda_u2412.add((Component)this.editor, new CC().growX().growY());
                $this$createSubmitActionComponent_u24lambda_u2412.add((Component)errorPanel, new CC().minHeight("32").growY().growPrioY(0));
                $this$createSubmitActionComponent_u24lambda_u2412.add((Component)buttonsPanel, new CC());
                return jPanel;
            }

            private final EditorTextField createEditor(Document document) {
                EditorTextField editorTextField;
                EditorTextField $this$createEditor_u24lambda_u2414 = editorTextField = new EditorTextField(document, null, (FileType)FileTypes.PLAIN_TEXT);
                boolean bl = false;
                $this$createEditor_u24lambda_u2414.setOneLineMode(false);
                $this$createEditor_u24lambda_u2414.putClientProperty((Object)"AuxEditorComponent", (Object)true);
                $this$createEditor_u24lambda_u2414.setPlaceholder((CharSequence)GithubBundle.message("pull.request.review.comment.empty.text", new Object[0]));
                $this$createEditor_u24lambda_u2414.addSettingsProvider(createPopupComponent.1::createEditor$lambda$14$lambda$13);
                return editorTextField;
            }

            private final void disableUI() {
                this.editor.setEnabled(false);
                this.approveButton.setEnabled(false);
                this.rejectButton.setEnabled(false);
                this.commentButton.setEnabled(false);
                this.discardButton.setEnabled(false);
            }

            private final void enableUI() {
                this.editor.setEnabled(true);
                this.approveButton.setEnabled(true);
                this.rejectButton.setEnabled(true);
                this.commentButton.setEnabled(true);
                this.discardButton.setEnabled(true);
            }

            private static final void _init_$lambda$5(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void createSubmitButtonActionListener$lambda$6(createPopupComponent.1 this$0, GHPullRequestPendingReview $pendingReview, GHPRReviewDataProvider $reviewDataProvider, GHPullRequestReviewEvent $event, ActionListener $cancelActionListener, Document $document, ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$reviewDataProvider, (String)"$reviewDataProvider");
                Intrinsics.checkNotNullParameter((Object)((Object)$event), (String)"$event");
                Intrinsics.checkNotNullParameter((Object)$cancelActionListener, (String)"$cancelActionListener");
                Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                this$0.disableUI();
                GHPullRequestPendingReview gHPullRequestPendingReview = $pendingReview;
                String reviewId = gHPullRequestPendingReview != null ? gHPullRequestPendingReview.getId() : null;
                CompletableFutureUtil.errorOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)(reviewId == null ? GHPRReviewDataProvider.createReview$default($reviewDataProvider, (ProgressIndicator)new EmptyProgressIndicator(), $event, this$0.editor.getText(), null, null, 24, null) : $reviewDataProvider.submitReview((ProgressIndicator)new EmptyProgressIndicator(), reviewId, $event, this$0.editor.getText())), null, (Function1)((Function1)new Function1<?, Unit>($cancelActionListener, e, $document){
                    final /* synthetic */ ActionListener $cancelActionListener;
                    final /* synthetic */ ActionEvent $e;
                    final /* synthetic */ Document $document;
                    {
                        this.$cancelActionListener = $cancelActionListener;
                        this.$e = $e;
                        this.$document = $document;
                        super(1);
                    }

                    public final void invoke(@NotNull Object it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$cancelActionListener.actionPerformed(this.$e);
                        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.$document){
                            final /* synthetic */ Document $document;
                            {
                                this.$document = $document;
                                super(0);
                            }

                            public final void invoke() {
                                this.$document.setText((CharSequence)"");
                            }
                        }));
                    }
                }), (int)1, null), null, (Function1)((Function1)new Function1<Throwable, Unit>(this$0){
                    final /* synthetic */ createPopupComponent.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        createPopupComponent.1.access$getErrorModel$p(this.this$0).setError(it);
                        createPopupComponent.1.access$enableUI(this.this$0);
                    }
                }), (int)1, null);
            }

            private static final void createEditor$lambda$14$lambda$13(EditorEx it) {
                it.getSettings().setUseSoftWraps(true);
                it.setVerticalScrollbarVisible(true);
                it.getScrollPane().setViewportBorder((Border)JBUI.Borders.emptyLeft((int)4));
                it.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)true);
            }

            public static final /* synthetic */ GHSimpleErrorPanelModel access$getErrorModel$p(createPopupComponent.1 $this) {
                return $this.errorModel;
            }

            public static final /* synthetic */ void access$enableUI(createPopupComponent.1 $this) {
                $this.enableUI();
            }

            public static final /* synthetic */ createPopupComponent.approveButton.1 access$getApproveButton$p(createPopupComponent.1 $this) {
                return $this.approveButton;
            }

            public static final /* synthetic */ JButton access$getRejectButton$p(createPopupComponent.1 $this) {
                return $this.rejectButton;
            }

            public static final /* synthetic */ JButton access$getCommentButton$p(createPopupComponent.1 $this) {
                return $this.commentButton;
            }

            public static final /* synthetic */ InlineIconButton access$getDiscardButton$p(createPopupComponent.1 $this) {
                return $this.discardButton;
            }

            public static final /* synthetic */ JComponent access$createSubmitActionComponent(createPopupComponent.1 $this, GHPullRequestPendingReview pendingReview) {
                return $this.createSubmitActionComponent(pendingReview);
            }

            public static final /* synthetic */ Wrapper access$getWrapper$p(createPopupComponent.1 $this) {
                return $this.wrapper;
            }

            public static final /* synthetic */ EditorTextField access$getEditor$p(createPopupComponent.1 $this) {
                return $this.editor;
            }

            public static final /* synthetic */ ActionListener access$createSubmitButtonActionListener(createPopupComponent.1 $this, GHPullRequestReviewEvent event, GHPullRequestPendingReview pendingReview) {
                return $this.createSubmitButtonActionListener(event, pendingReview);
            }
        };
    }

    protected void updateButtonFromPresentation(@NotNull JButton button, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.updateButtonFromPresentation(button, presentation);
        String string = (String)presentation.getClientProperty(PROP_PREFIX);
        if (string == null) {
            string = CollaborationToolsBundle.message((String)"review.start.submit.action", (Object[])new Object[0]);
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"presentation.getClientPr\u2026iew.start.submit.action\")");
        String prefix = string;
        button.setText(prefix + presentation.getText());
        ClientProperty.put((JComponent)button, (Key)DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)presentation.getClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY));
    }

    private static final void actionPerformed$lambda$0(Ref.ObjectRef $cancelRunnable, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$cancelRunnable, (String)"$cancelRunnable");
            Function0 function0 = (Function0)$cancelRunnable.element;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRReviewSubmitAction$Companion;", "", "()V", "PROP_PREFIX", "Lcom/intellij/openapi/util/Key;", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

