/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyConcatenateType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyLiteralStringType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyParamSpecType;
import com.jetbrains.python.psi.types.PySelfType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeCheckerExtension;
import com.jetbrains.python.psi.types.PyTypeParameterType;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyTypingNewType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyTypeChecker {
    private PyTypeChecker() {
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(0);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, new HashMap<PyGenericType, PyType>())).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(1);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(2);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions)).orElse(true);
    }

    public static boolean match(@Nullable PyType expected, @Nullable PyType actual, @NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(3);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(4);
        }
        return PyTypeChecker.match(expected, actual, new MatchContext(context, substitutions, false)).orElse(true);
    }

    @NotNull
    private static Optional<Boolean> match(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> result2;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(5);
        }
        Optional<Boolean> optional = (result2 = (Optional<Boolean>)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)expected, (Object)actual), (boolean)false, () -> PyTypeChecker.matchImpl(expected, actual, context))) == null ? Optional.of(true) : result2;
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(6);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchImpl(@Nullable PyType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(7);
        }
        if (Objects.equals(expected, actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(8);
            }
            return optional;
        }
        for (PyTypeCheckerExtension extension : PyTypeCheckerExtension.EP_NAME.getExtensionList()) {
            Optional<Boolean> result2 = extension.match(expected, actual, context.context, context.mySubstitutions.typeVars);
            if (!result2.isPresent()) continue;
            Optional<Boolean> optional = result2;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(9);
            }
            return optional;
        }
        if (expected instanceof PyClassType && (match = PyTypeChecker.matchObject((PyClassType)expected, actual)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(10);
            }
            return optional;
        }
        if (actual instanceof PyGenericType && context.reversedSubstitutions) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyGenericType)actual, expected, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(11);
            }
            return optional;
        }
        if (expected instanceof PyGenericType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyGenericType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(12);
            }
            return optional;
        }
        if (expected instanceof PySelfType) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, actual, context);
        }
        if (actual instanceof PySelfType && context.reversedSubstitutions) {
            return PyTypeChecker.match(context.mySubstitutions.qualifierType, expected, context);
        }
        if (expected instanceof PyParamSpecType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyParamSpecType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(13);
            }
            return optional;
        }
        if (expected == null || actual == null || PyTypeChecker.isUnknown(actual, context.context)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(14);
            }
            return optional;
        }
        if (actual instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match(expected, (PyUnionType)actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(15);
            }
            return optional;
        }
        if (expected instanceof PyUnionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyUnionType)expected, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(16);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyClassType && (match = PyTypeChecker.match((PyClassType)expected, (PyClassType)actual, context)).isPresent()) {
            Optional<Boolean> optional = match;
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(17);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && ((PyStructuralType)actual).isInferredFromUsages()) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(18);
            }
            return optional;
        }
        if (expected instanceof PyStructuralType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyStructuralType)expected, actual, context.context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(19);
            }
            return optional;
        }
        if (actual instanceof PyStructuralType && expected instanceof PyClassType) {
            Set<String> expectedAttributes = ((PyClassType)expected).getMemberNames(true, context.context);
            Optional<Boolean> optional = Optional.of(expectedAttributes.containsAll(((PyStructuralType)actual).getAttributeNames()));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(20);
            }
            return optional;
        }
        if (actual instanceof PyCallableType) {
            PyCallableType expectedCallable;
            Optional<Boolean> match2;
            PyCallableType actualCallable = (PyCallableType)actual;
            if (expected instanceof PyCallableType && (match2 = PyTypeChecker.match(expectedCallable = (PyCallableType)expected, actualCallable, context)).isPresent()) {
                Optional<Boolean> optional = match2;
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(21);
                }
                return optional;
            }
        }
        if (expected instanceof PyNoneType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyNoneType);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(22);
            }
            return optional;
        }
        if (expected instanceof PyModuleType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyModuleType && ((PyModuleType)expected).getModule() == ((PyModuleType)actual).getModule());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(23);
            }
            return optional;
        }
        if (expected instanceof PyClassType && actual instanceof PyModuleType) {
            return PyTypeChecker.match(expected, (PyType)((PyModuleType)actual).getModuleClassType(), context);
        }
        Optional<Boolean> optional = Optional.of(PyTypeChecker.matchNumericTypes(expected, actual));
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(24);
        }
        return optional;
    }

    @NotNull
    private static Optional<Boolean> matchObject(@NotNull PyClassType expected, @Nullable PyType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(25);
        }
        if (ArrayUtil.contains((String)expected.getName(), (String[])new String[]{"object", "type"})) {
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance((PsiElement)expected.getPyClass());
            if (expected.equals(builtinCache.getObjectType())) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(26);
                }
                return optional;
            }
            if (expected.equals(builtinCache.getTypeType()) && actual instanceof PyInstantiableType && ((PyInstantiableType)actual).isDefinition()) {
                Optional<Boolean> optional = Optional.of(true);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(27);
                }
                return optional;
            }
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(28);
        }
        return optional;
    }

    private static boolean match(@NotNull PyGenericType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(30);
        }
        if (expected.isDefinition() && actual instanceof PyInstantiableType && !((PyInstantiableType)actual).isDefinition()) {
            return false;
        }
        PyType substitution = context.mySubstitutions.typeVars.get(expected);
        PyType bound = expected.getBound();
        if (expected.isDefinition()) {
            Function<PyType, PyType> toDefinition = t -> t instanceof PyInstantiableType ? ((PyInstantiableType)t).toClass() : t;
            bound = PyUnionType.union(PyTypeUtil.toStream(bound).map(toDefinition).toList());
        }
        if ((match = PyTypeChecker.match(bound, actual, context)).isPresent() && !match.get().booleanValue()) {
            return false;
        }
        if (substitution != null) {
            if (expected.equals(actual) || substitution.equals(expected)) {
                return true;
            }
            Optional recursiveMatch = (Optional)RecursionManager.doPreventingRecursion((Object)expected, (boolean)false, (Computable)(context.reversedSubstitutions ? () -> PyTypeChecker.match(actual, substitution, context) : () -> PyTypeChecker.match(substitution, actual, context)));
            return recursiveMatch != null ? recursiveMatch.orElse(false) : false;
        }
        if (actual != null) {
            context.mySubstitutions.typeVars.put(expected, actual);
        } else if (bound != null) {
            context.mySubstitutions.typeVars.put(expected, PyUnionType.createWeakType(bound));
        }
        return true;
    }

    private static boolean match(@NotNull PyParamSpecType expected, @Nullable PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(31);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(32);
        }
        if (actual == null) {
            return true;
        }
        if (!(actual instanceof PyParamSpecType)) {
            return false;
        }
        PyParamSpecType callableActual = (PyParamSpecType)actual;
        List<PyCallableParameter> parameters = callableActual.getParameters();
        if (parameters == null) {
            return false;
        }
        context.mySubstitutions.paramSpecs.put(expected, expected.withParameters(parameters, context.context));
        return true;
    }

    private static boolean match(@NotNull PyType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        Optional<Boolean> match;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(33);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(34);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(35);
        }
        if (expected instanceof PyTupleType && (match = PyTypeChecker.match((PyTupleType)expected, actual, context)).isPresent()) {
            return match.get();
        }
        if (ContainerUtil.exists(actual.getMembers(), x -> x instanceof PyLiteralStringType)) {
            return ContainerUtil.and(actual.getMembers(), type2 -> PyTypeChecker.match(expected, type2, context).orElse(false));
        }
        return ContainerUtil.or(actual.getMembers(), type2 -> PyTypeChecker.match(expected, type2, context).orElse(false));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(36);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(37);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(38);
        }
        int elementCount = expected.getElementCount();
        if (!expected.isHomogeneous() && PyTypeChecker.consistsOfSameElementNumberTuples(actual, elementCount)) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.substituteExpectedElementsWithUnions(expected, elementCount, actual, context));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(39);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(40);
        }
        return optional;
    }

    private static boolean match(@NotNull PyUnionType expected, @NotNull PyType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(41);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(42);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(43);
        }
        if (expected.getMembers().contains(actual)) {
            return true;
        }
        return ContainerUtil.or(expected.getMembers(), type2 -> PyTypeChecker.match(type2, actual, context).orElse(true));
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyTypedDictType.TypeCheckingResult matchResult;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(44);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(45);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(46);
        }
        if (expected.equals(actual)) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(47);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected.isDefinition() ^ actual.isDefinition() && !PyProtocolsKt.isProtocol(expected, context)) {
            if (!expected.isDefinition() && actual.isDefinition()) {
                PyClassLikeType metaClass = actual.getMetaClassType(context, true);
                Optional<Boolean> optional = Optional.of(metaClass != null && PyTypeChecker.match((PyType)expected, metaClass.toInstance(), matchContext).orElse(true) != false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(48);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(49);
            }
            return optional;
        }
        if (expected instanceof PyTupleType && actual instanceof PyTupleType) {
            return PyTypeChecker.match((PyTupleType)expected, (PyTupleType)actual, matchContext);
        }
        if (expected instanceof PyLiteralType) {
            Optional<Boolean> optional = Optional.of(actual instanceof PyLiteralType && PyLiteralType.Companion.match((PyLiteralType)expected, (PyLiteralType)actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(50);
            }
            return optional;
        }
        if (actual instanceof PyTypedDictType && (matchResult = PyTypedDictType.Companion.checkTypes(expected, (PyTypedDictType)actual, context, null)) != null) {
            Optional<Boolean> optional = Optional.of(matchResult.getMatch());
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(51);
            }
            return optional;
        }
        if (expected instanceof PyLiteralStringType) {
            Optional<Boolean> optional = Optional.of(PyLiteralStringType.Companion.match((PyLiteralStringType)expected, actual));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(52);
            }
            return optional;
        }
        PyClass superClass = expected.getPyClass();
        PyClass subClass = actual.getPyClass();
        if (!subClass.isSubclass(superClass, context) && PyProtocolsKt.isProtocol(expected, context)) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.matchProtocols(expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(53);
            }
            return optional;
        }
        if (expected instanceof PyCollectionType) {
            Optional<Boolean> optional = Optional.of(PyTypeChecker.match((PyCollectionType)expected, actual, matchContext));
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(54);
            }
            return optional;
        }
        if (PyTypeChecker.matchClasses(superClass, subClass, context)) {
            if (expected instanceof PyTypingNewType && !expected.equals(actual) && superClass.equals(subClass)) {
                Optional<Boolean> optional = Optional.of(actual.getAncestorTypes(context).contains(expected));
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(55);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(56);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(57);
        }
        return optional;
    }

    private static boolean matchProtocols(@NotNull PyClassType expected, @NotNull PyClassType actual, @NotNull MatchContext matchContext) {
        PyCollectionType genericSuperClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(58);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(59);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(60);
        }
        GenericSubstitutions substitutions = PyTypeChecker.collectTypeSubstitutions(actual, matchContext.context);
        MatchContext protocolContext = new MatchContext(matchContext.context, new GenericSubstitutions(), matchContext.reversedSubstitutions);
        for (kotlin.Pair<PyTypedElement, List<RatedResolveResult>> pair : PyProtocolsKt.inspectProtocolSubclass(expected, actual, matchContext.context)) {
            List subclassElements = (List)pair.getSecond();
            if (ContainerUtil.isEmpty((Collection)subclassElements)) {
                return false;
            }
            PyType protocolElementType = PyTypeChecker.dropSelfIfNeeded(expected, matchContext.context.getType((PyTypedElement)pair.getFirst()), matchContext.context);
            boolean elementResult = StreamEx.of((Collection)subclassElements).map(ResolveResult::getElement).select(PyTypedElement.class).map(matchContext.context::getType).map(type2 -> PyTypeChecker.dropSelfIfNeeded(actual, type2, matchContext.context)).map(type2 -> PyTypeChecker.substitute(type2, substitutions, matchContext.context)).anyMatch(subclassElementType -> {
                boolean matched = PyTypeChecker.match(protocolElementType, subclassElementType, protocolContext).orElse(true);
                if (!matched) {
                    return false;
                }
                if (!(protocolElementType instanceof PyFunctionType) || !(subclassElementType instanceof PyFunctionType)) {
                    return matched;
                }
                PyType protocolReturnType = ((PyFunctionType)protocolElementType).getReturnType(protocolContext.context);
                if (protocolReturnType instanceof PySelfType) {
                    PyType subclassReturnType = ((PyFunctionType)subclassElementType).getReturnType(protocolContext.context);
                    if (subclassReturnType instanceof PySelfType) {
                        return true;
                    }
                    return PyTypeChecker.match((PyType)actual, subclassReturnType, matchContext).orElse(true);
                }
                return matched;
            });
            if (elementResult) continue;
            return false;
        }
        if (expected instanceof PyCollectionType && (genericSuperClass = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), matchContext.context)) != null) {
            PyCollectionType concreteSuperClass = (PyCollectionType)PyTypeChecker.substitute((PyType)genericSuperClass, protocolContext.mySubstitutions, protocolContext.context);
            assert (concreteSuperClass != null);
            return PyTypeChecker.matchGenericClassesParameterWise((PyCollectionType)expected, concreteSuperClass, matchContext);
        }
        return true;
    }

    @Nullable
    private static PyType dropSelfIfNeeded(@NotNull PyClassType classType, @Nullable PyType elementType, @NotNull TypeEvalContext context) {
        PyFunctionType functionType;
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(61);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(62);
        }
        if (elementType instanceof PyFunctionType && (PyUtil.isInitOrNewMethod((PsiElement)(functionType = (PyFunctionType)elementType).getCallable()) || !classType.isDefinition())) {
            return functionType.dropSelf(context);
        }
        return elementType;
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyTupleType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(63);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(64);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(65);
        }
        if (!expected.isHomogeneous() && !actual.isHomogeneous()) {
            if (expected.getElementCount() != actual.getElementCount()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(66);
                }
                return optional;
            }
            for (int i = 0; i < expected.getElementCount(); ++i) {
                if (PyTypeChecker.match(expected.getElementType(i), actual.getElementType(i), context).orElse(true).booleanValue()) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(67);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(68);
            }
            return optional;
        }
        if (expected.isHomogeneous() && !actual.isHomogeneous()) {
            PyType expectedElementType = expected.getIteratedItemType();
            for (int i = 0; i < actual.getElementCount(); ++i) {
                if (PyTypeChecker.match(expectedElementType, actual.getElementType(i), context).orElse(true).booleanValue()) continue;
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(69);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(70);
            }
            return optional;
        }
        if (!expected.isHomogeneous() && actual.isHomogeneous()) {
            Optional<Boolean> optional = Optional.of(false);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(71);
            }
            return optional;
        }
        return PyTypeChecker.match(expected.getIteratedItemType(), actual.getIteratedItemType(), context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        PyClass subClass;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(72);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(73);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(74);
        }
        if (actual instanceof PyTupleType) {
            return PyTypeChecker.match(expected, (PyTupleType)actual, context);
        }
        PyClass superClass = expected.getPyClass();
        return PyTypeChecker.matchClasses(superClass, subClass = actual.getPyClass(), context.context) && PyTypeChecker.matchGenerics(expected, actual, context);
    }

    private static boolean match(@NotNull PyCollectionType expected, @NotNull PyTupleType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(75);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(76);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(77);
        }
        if (!PyTypeChecker.matchClasses(expected.getPyClass(), actual.getPyClass(), context.context)) {
            return false;
        }
        PyType superElementType = expected.getIteratedItemType();
        PyType subElementType = actual.getIteratedItemType();
        return PyTypeChecker.match(superElementType, subElementType, context).orElse(true);
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyType actual, @NotNull TypeEvalContext context) {
        PyFile module;
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(78);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(79);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(80);
        }
        if (actual instanceof PyStructuralType) {
            return PyTypeChecker.match(expected, (PyStructuralType)actual);
        }
        if (actual instanceof PyClassType) {
            return PyTypeChecker.match(expected, (PyClassType)actual, context);
        }
        if (actual instanceof PyModuleType && (module = ((PyModuleType)actual).getModule()).getLanguageLevel().isAtLeast(LanguageLevel.PYTHON37) && PyTypeChecker.definesGetAttr(module, context)) {
            return true;
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext(context);
        return !ContainerUtil.exists(expected.getAttributeNames(), attribute -> ContainerUtil.isEmpty(actual.resolveMember((String)attribute, null, AccessDirection.READ, resolveContext)));
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyStructuralType actual) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(81);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(82);
        }
        if (expected.isInferredFromUsages()) {
            return true;
        }
        return expected.getAttributeNames().containsAll(actual.getAttributeNames());
    }

    private static boolean match(@NotNull PyStructuralType expected, @NotNull PyClassType actual, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(83);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(84);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(85);
        }
        if (PyTypeChecker.overridesGetAttr(actual.getPyClass(), context)) {
            return true;
        }
        Set<String> actualAttributes = actual.getMemberNames(true, context);
        return actualAttributes.containsAll(expected.getAttributeNames());
    }

    @NotNull
    private static Optional<Boolean> match(@NotNull PyCallableType expected, @NotNull PyCallableType actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(86);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(87);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(88);
        }
        if (actual instanceof PyFunctionType && expected instanceof PyClassType && "function".equals(expected.getName()) && expected.equals(PyBuiltinCache.getInstance((PsiElement)actual.getCallable()).getObjectType("function"))) {
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(89);
            }
            return optional;
        }
        TypeEvalContext context = matchContext.context;
        if (expected instanceof PyClassLikeType && !PyTypeChecker.isCallableProtocol((PyClassLikeType)expected, context)) {
            Optional<Boolean> optional = "typing.Callable".equals(((PyClassLikeType)expected).getClassQName()) ? Optional.of(actual.isCallable()) : Optional.empty();
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(90);
            }
            return optional;
        }
        if (expected.isCallable() && actual.isCallable()) {
            List<PyCallableParameter> expectedParameters = expected.getParameters(context);
            List<PyCallableParameter> actualParameters = actual.getParameters(context);
            if (expectedParameters != null && actualParameters != null) {
                int size = Math.min(expectedParameters.size(), actualParameters.size());
                for (int i = 0; i < size; ++i) {
                    PyType actualParamType;
                    PyCallableParameter expectedParam = expectedParameters.get(i);
                    PyCallableParameter actualParam = actualParameters.get(i);
                    PyType expectedParamType = expectedParam.getType(context);
                    if (expectedParamType instanceof PyParamSpecType && expectedParameters.size() == 1) {
                        PyParamSpecType expectedParamSpecType = (PyParamSpecType)expectedParamType;
                        matchContext.mySubstitutions.paramSpecs.put(expectedParamSpecType, expectedParamSpecType.withParameters(actualParameters, context));
                        break;
                    }
                    if (expectedParamType instanceof PyConcatenateType) {
                        PyConcatenateType expectedConcatenateType = (PyConcatenateType)expectedParamType;
                        if (expectedParameters.size() == 1) {
                            if (i != 0) break;
                            actualParamType = actualParam.getType(context);
                            List<PyType> expectedFirstTypes = expectedConcatenateType.getFirstTypes();
                            if (actualParamType instanceof PyConcatenateType) {
                                PyConcatenateType actualConcatenateType = (PyConcatenateType)actualParamType;
                                List<PyType> actualFirstType = actualConcatenateType.getFirstTypes();
                                if (PyTypeChecker.match(expectedFirstTypes, actualFirstType, matchContext)) break;
                                Optional<Boolean> optional = Optional.of(false);
                                if (optional == null) {
                                    PyTypeChecker.$$$reportNull$$$0(91);
                                }
                                return optional;
                            }
                            int actualParamRightBound = Math.min(expectedFirstTypes.size(), actualParameters.size());
                            List actualFirstParamTypes = ContainerUtil.map(actualParameters.subList(0, actualParamRightBound), it -> it.getType(context));
                            if (!PyTypeChecker.match(expectedFirstTypes, actualFirstParamTypes, matchContext)) {
                                Optional<Boolean> optional = Optional.of(false);
                                if (optional == null) {
                                    PyTypeChecker.$$$reportNull$$$0(92);
                                }
                                return optional;
                            }
                            if (actualParamRightBound >= actualParameters.size()) break;
                            PyParamSpecType expectedParamSpecType = expectedConcatenateType.getParamSpec();
                            List<PyCallableParameter> restActualParameters = actualParameters.subList(actualParamRightBound, actualParameters.size());
                            PyParamSpecType parametersSubst = expectedParamSpecType.withParameters(restActualParameters, context);
                            matchContext.mySubstitutions.paramSpecs.put(expectedParamSpecType, parametersSubst);
                            break;
                        }
                    }
                    if (expectedParam.isSelf() && actualParam.isSelf()) {
                        if (PyTypeChecker.match(expectedParam.getType(context), actualParam.getType(context), matchContext).orElse(true).booleanValue()) continue;
                        Optional<Boolean> optional = Optional.of(false);
                        if (optional == null) {
                            PyTypeChecker.$$$reportNull$$$0(93);
                        }
                        return optional;
                    }
                    PyType pyType = actualParamType = actualParam.isPositionalContainer() && PyTypeChecker.couldBeMappedOntoPositionalContainer(expectedParam) ? actualParam.getArgumentType(context) : actualParam.getType(context);
                    if (PyTypeChecker.match(actualParamType, expectedParam.getType(context), matchContext.reverseSubstitutions()).orElse(true).booleanValue()) continue;
                    Optional<Boolean> optional = Optional.of(false);
                    if (optional == null) {
                        PyTypeChecker.$$$reportNull$$$0(94);
                    }
                    return optional;
                }
            }
            if (!PyTypeChecker.match(expected.getReturnType(context), PyTypeChecker.getActualReturnType(actual, context), matchContext).orElse(true).booleanValue()) {
                Optional<Boolean> optional = Optional.of(false);
                if (optional == null) {
                    PyTypeChecker.$$$reportNull$$$0(95);
                }
                return optional;
            }
            Optional<Boolean> optional = Optional.of(true);
            if (optional == null) {
                PyTypeChecker.$$$reportNull$$$0(96);
            }
            return optional;
        }
        Optional<Boolean> optional = Optional.empty();
        if (optional == null) {
            PyTypeChecker.$$$reportNull$$$0(97);
        }
        return optional;
    }

    private static boolean match(@NotNull List<PyType> expected, @NotNull List<PyType> actual, @NotNull MatchContext matchContext) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(98);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(99);
        }
        if (matchContext == null) {
            PyTypeChecker.$$$reportNull$$$0(100);
        }
        int size = Math.min(expected.size(), actual.size());
        for (int i = 0; i < size; ++i) {
            if (PyTypeChecker.match(expected.get(i), actual.get(i), matchContext).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean isCallableProtocol(@NotNull PyClassLikeType expected, @NotNull TypeEvalContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(101);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(102);
        }
        return PyProtocolsKt.isProtocol(expected, context) && expected.getMemberNames(false, context).contains("__call__");
    }

    @Nullable
    private static PyType getActualReturnType(@NotNull PyCallableType actual, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(103);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(104);
        }
        if ((callable = actual.getCallable()) instanceof PyFunction) {
            return PyUtil.getReturnTypeToAnalyzeAsCallType((PyFunction)callable, context);
        }
        return actual.getReturnType(context);
    }

    private static boolean couldBeMappedOntoPositionalContainer(@NotNull PyCallableParameter parameter) {
        PyNamedParameter namedPsi;
        if (parameter == null) {
            PyTypeChecker.$$$reportNull$$$0(105);
        }
        if (parameter.isPositionalContainer() || parameter.isKeywordContainer()) {
            return false;
        }
        PyParameter psi = parameter.getParameter();
        return psi == null || (namedPsi = psi.getAsNamed()) == null || !namedPsi.isKeywordOnly();
    }

    private static boolean consistsOfSameElementNumberTuples(@NotNull PyUnionType unionType, int elementCount) {
        if (unionType == null) {
            PyTypeChecker.$$$reportNull$$$0(106);
        }
        for (PyType type2 : unionType.getMembers()) {
            if (type2 instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)type2;
                if (tupleType.isHomogeneous() || elementCount == tupleType.getElementCount()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean substituteExpectedElementsWithUnions(@NotNull PyTupleType expected, int elementCount, @NotNull PyUnionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(107);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(108);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(109);
        }
        for (int i = 0; i < elementCount; ++i) {
            int currentIndex = i;
            PyType elementType = PyUnionType.union(StreamEx.of(actual.getMembers()).select(PyTupleType.class).map(type2 -> type2.getElementType(currentIndex)).toList());
            if (PyTypeChecker.match(expected.getElementType(i), elementType, context).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchGenerics(@NotNull PyCollectionType expected, @NotNull PyClassType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(110);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(111);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(112);
        }
        if (actual instanceof PyCollectionType && expected.getPyClass().equals(actual.getPyClass())) {
            return PyTypeChecker.matchGenericClassesParameterWise(expected, (PyCollectionType)actual, context);
        }
        PyCollectionType expectedGenericType = PyTypeChecker.findGenericDefinitionType(expected.getPyClass(), context.context);
        if (expectedGenericType != null) {
            GenericSubstitutions actualSubstitutions = PyTypeChecker.collectTypeSubstitutions(actual, context.context);
            PyCollectionType concreteExpected = (PyCollectionType)PyTypeChecker.substitute((PyType)expectedGenericType, actualSubstitutions, context.context);
            assert (concreteExpected != null);
            return PyTypeChecker.matchGenericClassesParameterWise(expected, concreteExpected, context);
        }
        return true;
    }

    @NotNull
    private static GenericSubstitutions collectTypeSubstitutions(@NotNull PyClassType classType, @NotNull TypeEvalContext context) {
        if (classType == null) {
            PyTypeChecker.$$$reportNull$$$0(113);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(114);
        }
        GenericSubstitutions result2 = new GenericSubstitutions();
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyCollectionType genericDefinitionType;
            Map<PyType, PyType> substitutionsFromClassDefinition = provider.getGenericSubstitutions(classType.getPyClass(), context);
            for (Map.Entry<PyType, PyType> entry : substitutionsFromClassDefinition.entrySet()) {
                if (!(entry.getKey() instanceof PyGenericType)) continue;
                result2.typeVars.put((PyGenericType)entry.getKey(), entry.getValue());
            }
            if (!classType.isDefinition() && (genericDefinitionType = PyUtil.as(provider.getGenericType(classType.getPyClass(), context), PyCollectionType.class)) != null) {
                List<PyType> definitionTypeParameters = genericDefinitionType.getElementTypes();
                List instanceTypeArguments = classType instanceof PyCollectionType ? ((PyCollectionType)classType).getElementTypes() : List.of();
                for (int i = 0; i < definitionTypeParameters.size(); ++i) {
                    PyType typeParameter = definitionTypeParameters.get(i);
                    PyType typeArgument = (PyType)ContainerUtil.getOrElse(instanceTypeArguments, (int)i, null);
                    if (typeParameter instanceof PyGenericType) {
                        result2.typeVars.put((PyGenericType)typeParameter, typeArgument);
                    }
                    if (!(typeParameter instanceof PyParamSpecType)) continue;
                    result2.getParamSpecs().put((PyParamSpecType)typeParameter, PyUtil.as(typeArgument, PyParamSpecType.class));
                }
            }
            if (result2.typeVars.isEmpty()) continue;
            GenericSubstitutions genericSubstitutions = result2;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(115);
            }
            return genericSubstitutions;
        }
        GenericSubstitutions genericSubstitutions = result2;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(116);
        }
        return genericSubstitutions;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyCollectionType findGenericDefinitionType(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyTypeChecker.$$$reportNull$$$0(117);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(118);
        }
        for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
            PyType definitionType = provider.getGenericType(pyClass, context);
            if (!(definitionType instanceof PyCollectionType)) continue;
            return (PyCollectionType)definitionType;
        }
        return null;
    }

    private static boolean matchGenericClassesParameterWise(@NotNull PyCollectionType expected, @NotNull PyCollectionType actual, @NotNull MatchContext context) {
        if (expected == null) {
            PyTypeChecker.$$$reportNull$$$0(119);
        }
        if (actual == null) {
            PyTypeChecker.$$$reportNull$$$0(120);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(121);
        }
        if (expected.equals(actual)) {
            return true;
        }
        if (!expected.getPyClass().equals(actual.getPyClass())) {
            return false;
        }
        List<PyType> expectedElementTypes = expected.getElementTypes();
        List<PyType> actualElementTypes = actual.getElementTypes();
        for (int i = 0; i < expectedElementTypes.size(); ++i) {
            PyType subElementType = (PyType)ContainerUtil.getOrElse(actualElementTypes, (int)i, null);
            if (PyTypeChecker.match(expectedElementTypes.get(i), subElementType, context).orElse(true).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean matchNumericTypes(PyType expected, PyType actual) {
        if (expected instanceof PyClassType && actual instanceof PyClassType) {
            String superName = ((PyClassType)expected).getPyClass().getName();
            String subName = ((PyClassType)actual).getPyClass().getName();
            boolean subIsBool = "bool".equals(subName);
            boolean subIsInt = "int".equals(subName);
            boolean subIsLong = "long".equals(subName);
            boolean subIsFloat = "float".equals(subName);
            boolean subIsComplex = "complex".equals(subName);
            if (superName == null || subName == null || superName.equals(subName) || "int".equals(superName) && subIsBool || ("long".equals(superName) || "Integral".equals(superName)) && (subIsBool || subIsInt) || ("float".equals(superName) || "Real".equals(superName)) && (subIsBool || subIsInt || subIsLong) || ("complex".equals(superName) || "Complex".equals(superName)) && (subIsBool || subIsInt || subIsLong || subIsFloat) || "Number".equals(superName) && (subIsBool || subIsInt || subIsLong || subIsFloat || subIsComplex)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isUnknown(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(122);
        }
        return PyTypeChecker.isUnknown(type2, true, context);
    }

    public static boolean isUnknown(@Nullable PyType type2, boolean genericsAreUnknown, @NotNull TypeEvalContext context) {
        PyCallable callable;
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(123);
        }
        if (type2 == null || genericsAreUnknown && type2 instanceof PyTypeParameterType) {
            return true;
        }
        if (type2 instanceof PyFunctionType && (callable = ((PyFunctionType)type2).getCallable()) instanceof PyDecoratable && PyKnownDecoratorUtil.hasChangingReturnTypeDecorator((PyDecoratable)((Object)callable), context)) {
            return true;
        }
        if (type2 instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type2;
            for (PyType t : union.getMembers()) {
                if (!PyTypeChecker.isUnknown(t, genericsAreUnknown, context)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static GenericSubstitutions getSubstitutionsWithUnresolvedReturnGenerics(@NotNull Collection<PyCallableParameter> parameters, @Nullable PyType returnType, @Nullable GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (parameters == null) {
            PyTypeChecker.$$$reportNull$$$0(124);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(125);
        }
        GenericSubstitutions result2 = substitutions == null ? new GenericSubstitutions() : substitutions;
        HashSet visited = new HashSet();
        Generics returnTypeGenerics = new Generics();
        PyTypeChecker.collectGenerics(returnType, context, returnTypeGenerics, visited);
        if (returnTypeGenerics.typeVars.isEmpty()) {
            GenericSubstitutions genericSubstitutions = result2;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(126);
            }
            return genericSubstitutions;
        }
        for (PyGenericType alreadyKnown : result2.typeVars.keySet()) {
            if (returnTypeGenerics.typeVars.remove(alreadyKnown)) continue;
            returnTypeGenerics.typeVars.remove(PyTypeChecker.invert(alreadyKnown));
        }
        if (returnTypeGenerics.isEmpty()) {
            GenericSubstitutions genericSubstitutions = result2;
            if (genericSubstitutions == null) {
                PyTypeChecker.$$$reportNull$$$0(127);
            }
            return genericSubstitutions;
        }
        visited.clear();
        Generics paramGenerics = new Generics();
        for (PyCallableParameter parameter : parameters) {
            PyTypeChecker.collectGenerics(parameter.getArgumentType(context), context, paramGenerics, visited);
        }
        for (PyGenericType returnTypeGeneric : returnTypeGenerics.typeVars) {
            if (paramGenerics.typeVars.contains(returnTypeGeneric) || paramGenerics.typeVars.contains(PyTypeChecker.invert(returnTypeGeneric))) continue;
            result2.typeVars.put(returnTypeGeneric, returnTypeGeneric);
        }
        GenericSubstitutions genericSubstitutions = result2;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(128);
        }
        return genericSubstitutions;
    }

    @NotNull
    private static <T extends PyInstantiableType<T>> T invert(@NotNull PyInstantiableType<T> instantiable) {
        if (instantiable == null) {
            PyTypeChecker.$$$reportNull$$$0(129);
        }
        T t = instantiable.isDefinition() ? instantiable.toInstance() : instantiable.toClass();
        if (t == null) {
            PyTypeChecker.$$$reportNull$$$0(130);
        }
        return t;
    }

    public static boolean hasGenerics(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(131);
        }
        return !PyTypeChecker.collectGenerics(type2, context).isEmpty();
    }

    @ApiStatus.Internal
    @NotNull
    public static Generics collectGenerics(@Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(132);
        }
        Generics result2 = new Generics();
        PyTypeChecker.collectGenerics(type2, context, result2, new HashSet());
        Generics generics = result2;
        if (generics == null) {
            PyTypeChecker.$$$reportNull$$$0(133);
        }
        return generics;
    }

    private static void collectGenerics(@Nullable PyType type2, @NotNull TypeEvalContext context, @NotNull Generics generics, @NotNull Set<? super PyType> visited) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(134);
        }
        if (generics == null) {
            PyTypeChecker.$$$reportNull$$$0(135);
        }
        if (visited == null) {
            PyTypeChecker.$$$reportNull$$$0(136);
        }
        if (type2 instanceof PyGenericType) {
            generics.allTypeVars.add((PyGenericType)type2);
        }
        if (visited.contains(type2)) {
            return;
        }
        visited.add(type2);
        if (type2 instanceof PyGenericType) {
            generics.typeVars.add((PyGenericType)type2);
        }
        if (type2 instanceof PyParamSpecType) {
            generics.paramSpecs.add((PyParamSpecType)type2);
        }
        if (type2 instanceof PyConcatenateType) {
            generics.concatenates.add((PyConcatenateType)type2);
        }
        if (type2 instanceof PySelfType) {
            generics.self = (PySelfType)type2;
        } else if (type2 instanceof PyUnionType) {
            PyUnionType union = (PyUnionType)type2;
            for (PyType t : union.getMembers()) {
                PyTypeChecker.collectGenerics(t, context, generics, visited);
            }
        } else if (type2 instanceof PyTupleType) {
            PyTupleType tuple = (PyTupleType)type2;
            int n = tuple.isHomogeneous() ? 1 : tuple.getElementCount();
            for (int i = 0; i < n; ++i) {
                PyTypeChecker.collectGenerics(tuple.getElementType(i), context, generics, visited);
            }
        } else if (type2 instanceof PyCollectionType) {
            PyCollectionType collection = (PyCollectionType)type2;
            for (PyType elementType : collection.getElementTypes()) {
                PyTypeChecker.collectGenerics(elementType, context, generics, visited);
            }
        } else if (type2 instanceof PyCallableType) {
            PyCallableType callable = (PyCallableType)type2;
            if (!(type2 instanceof PyClassLikeType)) {
                List<PyCallableParameter> parameters = callable.getParameters(context);
                if (parameters != null) {
                    for (PyCallableParameter parameter : parameters) {
                        if (parameter == null) continue;
                        PyTypeChecker.collectGenerics(parameter.getType(context), context, generics, visited);
                    }
                }
                PyTypeChecker.collectGenerics(callable.getReturnType(context), context, generics, visited);
            }
        }
    }

    @Deprecated
    @Nullable
    public static PyType substitute(@Nullable PyType type2, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(137);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(138);
        }
        GenericSubstitutions genericSubstitutions = new GenericSubstitutions(substitutions, new LinkedHashMap<PyParamSpecType, PyParamSpecType>(), null);
        return PyTypeChecker.substitute(type2, genericSubstitutions, context);
    }

    @Nullable
    public static PyType substitute(@Nullable PyType type2, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context) {
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(139);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(140);
        }
        return PyTypeChecker.substitute(type2, substitutions, context, new HashSet<PyType>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static PyType substitute(@Nullable PyType type2, @NotNull GenericSubstitutions substitutions, @NotNull TypeEvalContext context, @NotNull Set<PyType> substituting) {
        boolean alreadySubstituting;
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(141);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(142);
        }
        if (substituting == null) {
            PyTypeChecker.$$$reportNull$$$0(143);
        }
        boolean bl = alreadySubstituting = !substituting.add(type2);
        if (alreadySubstituting) {
            return null;
        }
        try {
            if (PyTypeChecker.hasGenerics(type2, context)) {
                if (type2 instanceof PyGenericType) {
                    PyType invertedTypeVar;
                    PyInstantiableType invertedSubstitution;
                    PyGenericType typeVar = (PyGenericType)type2;
                    PyType substitution = substitutions.typeVars.get(typeVar);
                    if (substitution == null && (invertedSubstitution = PyUtil.as(substitutions.typeVars.get(invertedTypeVar = PyTypeChecker.invert(typeVar)), PyInstantiableType.class)) != null) {
                        substitution = PyTypeChecker.invert(invertedSubstitution);
                    }
                    if (substitution instanceof PyGenericType) {
                        if (!typeVar.equals(substitution) && substitutions.typeVars.containsKey(substitution)) {
                            invertedTypeVar = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                            return invertedTypeVar;
                        }
                    } else if (PyTypeChecker.hasGenerics(substitution, context)) {
                        invertedTypeVar = PyTypeChecker.substitute(substitution, substitutions, context, substituting);
                        return invertedTypeVar;
                    }
                    invertedTypeVar = substitution;
                    return invertedTypeVar;
                }
                if (type2 instanceof PySelfType) {
                    PyType qualifierType = substitutions.qualifierType;
                    PyClassLikeType selfScopeClassType = ((PySelfType)type2).getScopeClassType();
                    PyType invertedSubstitution = (PyType)((StreamEx)PyTypeUtil.toStream(qualifierType).filter(memberType -> PyTypeChecker.match((PyType)selfScopeClassType, memberType, context))).collect(PyTypeUtil.toUnion());
                    return invertedSubstitution;
                }
                if (type2 instanceof PyUnionType) {
                    PyType qualifierType = ((PyUnionType)type2).map(member -> PyTypeChecker.substitute(member, substitutions, context, substituting));
                    return qualifierType;
                }
                if (type2 instanceof PyCollectionTypeImpl) {
                    PyCollectionTypeImpl collection = (PyCollectionTypeImpl)type2;
                    List<PyType> elementTypes = collection.getElementTypes();
                    ArrayList<PyType> substitutes = new ArrayList<PyType>();
                    for (PyType elementType2 : elementTypes) {
                        if (elementType2 instanceof PyParamSpecType) {
                            PyParamSpecType paramSpecType = (PyParamSpecType)elementType2;
                            PyParamSpecType paramSpecTypeSubst = substitutions.paramSpecs.get(paramSpecType);
                            if (paramSpecTypeSubst == null || paramSpecTypeSubst.getParameters() == null) continue;
                            substitutes.add(paramSpecTypeSubst);
                            continue;
                        }
                        substitutes.add(PyTypeChecker.substitute(elementType2, substitutions, context, substituting));
                    }
                    PyCollectionTypeImpl invertedSubstitution = new PyCollectionTypeImpl(collection.getPyClass(), collection.isDefinition(), substitutes);
                    return invertedSubstitution;
                }
                if (type2 instanceof PyTypedDictType) {
                    PyTypedDictType typedDictType = (PyTypedDictType)type2;
                    Map<String, kotlin.Pair<PyExpression, PyType>> tdFields = typedDictType.getKeysToValuesWithTypes();
                    Map substitutedTDFields = ContainerUtil.map2Map(tdFields.entrySet(), field -> Pair.create((Object)((String)field.getKey()), (Object)new kotlin.Pair((Object)((PyExpression)((kotlin.Pair)field.getValue()).getFirst()), (Object)PyTypeChecker.substitute((PyType)((kotlin.Pair)field.getValue()).getSecond(), substitutions, context, substituting))));
                    PyTypedDictType invertedSubstitution = PyTypedDictType.Companion.createFromKeysToValueTypes((PsiElement)typedDictType.myClass, substitutedTDFields, false);
                    return invertedSubstitution;
                }
                if (type2 instanceof PyTupleType) {
                    PyTupleType tupleType = (PyTupleType)type2;
                    PyClass tupleClass = tupleType.getPyClass();
                    List<PyType> oldElementTypes = tupleType.isHomogeneous() ? Collections.singletonList(tupleType.getIteratedItemType()) : tupleType.getElementTypes();
                    List newElementTypes = ContainerUtil.map(oldElementTypes, elementType -> PyTypeChecker.substitute(elementType, substitutions, context, substituting));
                    PyTupleType elementType2 = new PyTupleType(tupleClass, newElementTypes, tupleType.isHomogeneous());
                    return elementType2;
                }
                if (type2 instanceof PyCallableType) {
                    PyCallableType callable = (PyCallableType)type2;
                    if (!(type2 instanceof PyClassLikeType)) {
                        List<PyCallableParameter> substParams = null;
                        List<PyCallableParameter> parameters = callable.getParameters(context);
                        if (parameters != null) {
                            substParams = new ArrayList<PyCallableParameter>();
                            for (PyCallableParameter parameter : parameters) {
                                PyConcatenateType concatenateType;
                                PyParamSpecType paramSpecType;
                                PyParamSpecType paramSpecTypeSubst;
                                PyParamSpecType parameterTypeSubst;
                                PyType parameterType = parameter.getType(context);
                                if (parameters.size() == 1 && parameterType instanceof PyParamSpecType && (parameterTypeSubst = substitutions.paramSpecs.get(parameterType)) != null && parameterTypeSubst.getParameters() != null) {
                                    substParams = parameterTypeSubst.getParameters();
                                    break;
                                }
                                if (parameters.size() == 1 && parameterType instanceof PyConcatenateType && (paramSpecTypeSubst = substitutions.paramSpecs.get(paramSpecType = (concatenateType = (PyConcatenateType)parameterType).getParamSpec())) != null && paramSpecTypeSubst.getParameters() != null) {
                                    List firstParameters = ContainerUtil.map(concatenateType.getFirstTypes(), it -> PyCallableParameterImpl.nonPsi(it));
                                    substParams.addAll(firstParameters);
                                    substParams.addAll(paramSpecTypeSubst.getParameters());
                                    break;
                                }
                                PyType substType = PyTypeChecker.substitute(parameter.getType(context), substitutions, context, substituting);
                                PyParameter psi = parameter.getParameter();
                                PyCallableParameter subst = psi != null ? PyCallableParameterImpl.psi(psi, substType) : PyCallableParameterImpl.nonPsi(parameter.getName(), substType, parameter.getDefaultValue());
                                substParams.add(subst);
                            }
                        }
                        PyType substResult = PyTypeChecker.substitute(callable.getReturnType(context), substitutions, context, substituting);
                        PyCallableTypeImpl pyCallableTypeImpl = new PyCallableTypeImpl(substParams, substResult);
                        return pyCallableTypeImpl;
                    }
                }
            }
        }
        finally {
            substituting.remove(type2);
        }
        return type2;
    }

    @Nullable
    public static GenericSubstitutions unifyGenericCall(@Nullable PyExpression receiver, @NotNull Map<PyExpression, PyCallableParameter> arguments, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(144);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(145);
        }
        GenericSubstitutions substitutions = PyTypeChecker.unifyReceiverWithParamSpecs(receiver, context);
        if (arguments.isEmpty()) {
            return substitutions;
        }
        for (Map.Entry<PyExpression, PyCallableParameter> entry : PyCallExpressionHelper.getRegularMappedParameters(arguments).entrySet()) {
            PyType actualType;
            PyCallableParameter paramWrapper = entry.getValue();
            PyType expectedType = paramWrapper.getArgumentType(context);
            PyType promotedToLiteral = PyLiteralType.Companion.promoteToLiteral(entry.getKey(), expectedType, context, substitutions);
            PyType pyType = actualType = promotedToLiteral != null ? promotedToLiteral : context.getType(entry.getKey());
            if (paramWrapper.isSelf()) {
                PyParameter param = paramWrapper.getParameter();
                PyFunction function = PyUtil.as(ScopeUtil.getScopeOwner((PsiElement)param), PyFunction.class);
                assert (function != null);
                if (function.getModifier() == PyFunction.Modifier.CLASSMETHOD) {
                    actualType = PyTypeUtil.toStream(actualType).select(PyClassLikeType.class).map(PyInstantiableType::toClass).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
                } else if (PyUtil.isInitMethod(function)) {
                    actualType = PyTypeUtil.toStream(actualType).select(PyInstantiableType.class).map(PyInstantiableType::toInstance).select(PyType.class).foldLeft(PyUnionType::union).orElse(actualType);
                }
                PyClass containingClass = function.getContainingClass();
                assert (containingClass != null);
                PyCollectionType genericClass = PyTypeChecker.findGenericDefinitionType(containingClass, context);
                if (genericClass != null && !PyTypeChecker.match((PyType)genericClass, expectedType, context, substitutions)) {
                    return null;
                }
            }
            if (PyTypeChecker.match(expectedType, actualType, context, substitutions)) continue;
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedPositionalContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToPositionalContainer(arguments), substitutions.typeVars, context)) {
            return null;
        }
        if (!PyTypeChecker.matchContainer(PyCallExpressionHelper.getMappedKeywordContainer(arguments), PyCallExpressionHelper.getArgumentsMappedToKeywordContainer(arguments), substitutions.typeVars, context)) {
            return null;
        }
        return substitutions;
    }

    private static boolean matchContainer(@Nullable PyCallableParameter container, @NotNull List<? extends PyExpression> arguments, @NotNull Map<PyGenericType, PyType> substitutions, @NotNull TypeEvalContext context) {
        if (arguments == null) {
            PyTypeChecker.$$$reportNull$$$0(146);
        }
        if (substitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(147);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(148);
        }
        if (container == null) {
            return true;
        }
        List types = ContainerUtil.map(arguments, context::getType);
        return PyTypeChecker.match(container.getArgumentType(context), PyUnionType.union(types), context, substitutions);
    }

    @NotNull
    public static GenericSubstitutions unifyReceiverWithParamSpecs(@Nullable PyExpression receiver, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(149);
        }
        GenericSubstitutions substitutions = new GenericSubstitutions();
        if (receiver != null) {
            PyType receiverType = context.getType(receiver);
            substitutions.qualifierType = receiverType instanceof PyClassType ? ((PyClassType)receiverType).toInstance() : receiverType;
            PyTypeUtil.toStream(receiverType).select(PyClassType.class).map(type2 -> PyTypeChecker.collectTypeSubstitutions(type2, context)).forEach(newSubstitutions -> {
                for (Map.Entry<PyGenericType, PyType> entry : newSubstitutions.typeVars.entrySet()) {
                    substitutions.typeVars.putIfAbsent(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<PyTypeParameterType, PyType> entry : newSubstitutions.paramSpecs.entrySet()) {
                    substitutions.paramSpecs.putIfAbsent((PyParamSpecType)entry.getKey(), (PyParamSpecType)entry.getValue());
                }
            });
        }
        GenericSubstitutions genericSubstitutions = substitutions;
        if (genericSubstitutions == null) {
            PyTypeChecker.$$$reportNull$$$0(150);
        }
        return genericSubstitutions;
    }

    private static boolean matchClasses(@Nullable PyClass superClass, @Nullable PyClass subClass, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(151);
        }
        if (superClass == null || subClass == null || subClass.isSubclass(superClass, context) || PyABCUtil.isSubclass(subClass, superClass, context) || PyTypeChecker.isStrUnicodeMatch(subClass, superClass) || PyTypeChecker.isBytearrayBytesStringMatch(subClass, superClass) || PyUtil.hasUnresolvedAncestors(subClass, context)) {
            return true;
        }
        String superName = superClass.getName();
        return superName != null && superName.equals(subClass.getName());
    }

    private static boolean isStrUnicodeMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(152);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(153);
        }
        return "str".equals(subClass.getName()) && "unicode".equals(superClass.getName());
    }

    private static boolean isBytearrayBytesStringMatch(@NotNull PyClass subClass, @NotNull PyClass superClass) {
        if (subClass == null) {
            PyTypeChecker.$$$reportNull$$$0(154);
        }
        if (superClass == null) {
            PyTypeChecker.$$$reportNull$$$0(155);
        }
        if (!"bytearray".equals(subClass.getName())) {
            return false;
        }
        PsiFile subClassFile = subClass.getContainingFile();
        boolean isPy2 = subClassFile instanceof PyiFile ? PythonRuntimeService.getInstance().getLanguageLevelForSdk(PythonSdkUtil.findPythonSdk((PsiElement)subClassFile)).isPython2() : LanguageLevel.forElement((PsiElement)subClass).isPython2();
        String superClassName = superClass.getName();
        return isPy2 && "str".equals(superClassName) || !isPy2 && "bytes".equals(superClassName);
    }

    @Nullable
    public static Boolean isCallable(@Nullable PyType type2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof PyUnionType) {
            return PyTypeChecker.isUnionCallable((PyUnionType)type2);
        }
        if (type2 instanceof PyCallableType) {
            return ((PyCallableType)type2).isCallable();
        }
        if (type2 instanceof PyStructuralType && ((PyStructuralType)type2).isInferredFromUsages()) {
            return true;
        }
        if (type2 instanceof PyGenericType) {
            if (((PyGenericType)type2).isDefinition()) {
                return true;
            }
            return PyTypeChecker.isCallable(((PyGenericType)type2).getBound());
        }
        return false;
    }

    @Nullable
    private static Boolean isUnionCallable(@NotNull PyUnionType type2) {
        if (type2 == null) {
            PyTypeChecker.$$$reportNull$$$0(156);
        }
        for (PyType member : type2.getMembers()) {
            Boolean callable = PyTypeChecker.isCallable(member);
            if (callable == null) {
                return null;
            }
            if (!callable.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean definesGetAttr(@NotNull PyFile file, @NotNull TypeEvalContext context) {
        PyType type2;
        if (file == null) {
            PyTypeChecker.$$$reportNull$$$0(157);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(158);
        }
        if (file instanceof PyTypedElement && (type2 = context.getType((PyTypedElement)((Object)file))) != null) {
            return PyTypeChecker.resolveTypeMember(type2, "__getattr__", context) != null;
        }
        return false;
    }

    public static boolean overridesGetAttr(@NotNull PyClass cls, @NotNull TypeEvalContext context) {
        PyType type2;
        if (cls == null) {
            PyTypeChecker.$$$reportNull$$$0(159);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(160);
        }
        if ((type2 = context.getType(cls)) != null) {
            if (PyTypeChecker.resolveTypeMember(type2, "__getattr__", context) != null) {
                return true;
            }
            PsiElement method = PyTypeChecker.resolveTypeMember(type2, "__getattribute__", context);
            if (method != null && !PyBuiltinCache.getInstance((PsiElement)cls).isBuiltin(method)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement resolveTypeMember(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        PyResolveContext resolveContext;
        List<? extends RatedResolveResult> results;
        if (type2 == null) {
            PyTypeChecker.$$$reportNull$$$0(161);
        }
        if (name2 == null) {
            PyTypeChecker.$$$reportNull$$$0(162);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(163);
        }
        return !ContainerUtil.isEmpty(results = type2.resolveMember(name2, null, AccessDirection.READ, resolveContext = PyResolveContext.defaultContext(context))) ? results.get(0).getElement() : null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target, @NotNull PyTupleExpression parentTuple, @NotNull PyType assignedType, @NotNull TypeEvalContext context) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(164);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(165);
        }
        if (assignedType == null) {
            PyTypeChecker.$$$reportNull$$$0(166);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(167);
        }
        if (assignedType instanceof PyTupleType) {
            return PyTypeChecker.getTargetTypeFromTupleAssignment(target, parentTuple, (PyTupleType)assignedType);
        }
        if (assignedType instanceof PyClassLikeType) {
            return StreamEx.of(((PyClassLikeType)assignedType).getAncestorTypes(context)).select(PyNamedTupleType.class).findFirst().map(t -> PyTypeChecker.getTargetTypeFromTupleAssignment(target, parentTuple, t)).orElse(null);
        }
        return null;
    }

    @Nullable
    public static PyType getTargetTypeFromTupleAssignment(@NotNull PyTargetExpression target, @NotNull PyTupleExpression parentTuple, @NotNull PyTupleType assignedTupleType) {
        if (target == null) {
            PyTypeChecker.$$$reportNull$$$0(168);
        }
        if (parentTuple == null) {
            PyTypeChecker.$$$reportNull$$$0(169);
        }
        if (assignedTupleType == null) {
            PyTypeChecker.$$$reportNull$$$0(170);
        }
        int count = assignedTupleType.getElementCount();
        Object[] elements = parentTuple.getElements();
        if (elements.length == count || assignedTupleType.isHomogeneous()) {
            int index = ArrayUtil.indexOf((Object[])elements, (Object)target);
            if (index >= 0) {
                return assignedTupleType.getElementType(index);
            }
            for (int i = 0; i < count; ++i) {
                PyType result2;
                PyType elementType;
                Object element = elements[i];
                while (element instanceof PyParenthesizedExpression) {
                    element = ((PyParenthesizedExpression)element).getContainedExpression();
                }
                if (!(element instanceof PyTupleExpression) || !((elementType = assignedTupleType.getElementType(i)) instanceof PyTupleType) || (result2 = PyTypeChecker.getTargetTypeFromTupleAssignment(target, (PyTupleExpression)element, (PyTupleType)elementType)) == null) continue;
                return result2;
            }
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType parameterizeType(@NotNull PyType genericType, @NotNull List<PyType> actualTypeParams, @NotNull TypeEvalContext context) {
        Generics typeParams;
        if (genericType == null) {
            PyTypeChecker.$$$reportNull$$$0(171);
        }
        if (actualTypeParams == null) {
            PyTypeChecker.$$$reportNull$$$0(172);
        }
        if (context == null) {
            PyTypeChecker.$$$reportNull$$$0(173);
        }
        if (!(typeParams = PyTypeChecker.collectGenerics(genericType, context)).isEmpty()) {
            ArrayList formalTypeParams = Lists.newArrayList(typeParams.typeVars);
            HashMap<PyGenericType, PyType> substitutions = new HashMap<PyGenericType, PyType>();
            for (int i = 0; i < Math.min(formalTypeParams.size(), actualTypeParams.size()); ++i) {
                substitutions.put((PyGenericType)formalTypeParams.get(i), actualTypeParams.get(i));
            }
            return PyTypeChecker.substitute(genericType, new GenericSubstitutions(substitutions, Collections.emptyMap(), null), context);
        }
        if (genericType instanceof PyCollectionType) {
            return genericType;
        }
        if (genericType instanceof PyClassType) {
            PyClass cls = ((PyClassType)genericType).getPyClass();
            return new PyCollectionTypeImpl(cls, false, actualTypeParams);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 39, 40, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 66, 67, 68, 69, 70, 71, 89, 90, 91, 92, 93, 94, 95, 96, 97, 115, 116, 126, 127, 128, 130, 133, 150 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 137: 
            case 139: 
            case 141: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 115: 
            case 116: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 133: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 25: 
            case 29: 
            case 31: 
            case 33: 
            case 36: 
            case 41: 
            case 44: 
            case 58: 
            case 63: 
            case 72: 
            case 75: 
            case 78: 
            case 81: 
            case 83: 
            case 86: 
            case 98: 
            case 101: 
            case 107: 
            case 110: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 34: 
            case 37: 
            case 42: 
            case 45: 
            case 59: 
            case 64: 
            case 73: 
            case 76: 
            case 79: 
            case 82: 
            case 84: 
            case 87: 
            case 99: 
            case 103: 
            case 108: 
            case 111: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 46: 
            case 60: 
            case 88: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchContext";
                break;
            }
            case 61: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionType";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiable";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituting";
                break;
            }
            case 144: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 152: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 153: 
            case 155: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 156: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 157: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 159: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 164: 
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 165: 
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTuple";
                break;
            }
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedType";
                break;
            }
            case 170: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedTupleType";
                break;
            }
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualTypeParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker";
                break;
            }
            case 6: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "match";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "matchImpl";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "matchObject";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeSubstitutions";
                break;
            }
            case 126: 
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "invert";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "collectGenerics";
                break;
            }
            case 150: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyReceiverWithParamSpecs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 39: 
            case 40: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 115: 
            case 116: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 133: 
            case 150: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchImpl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "matchObject";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "matchProtocols";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "dropSelfIfNeeded";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "isCallableProtocol";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "getActualReturnType";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "couldBeMappedOntoPositionalContainer";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "consistsOfSameElementNumberTuples";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "substituteExpectedElementsWithUnions";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "matchGenerics";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeSubstitutions";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "findGenericDefinitionType";
                break;
            }
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericClassesParameterWise";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isUnknown";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionsWithUnresolvedReturnGenerics";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "invert";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "hasGenerics";
                break;
            }
            case 132: 
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "collectGenerics";
                break;
            }
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "unifyGenericCall";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "matchContainer";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "unifyReceiverWithParamSpecs";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "matchClasses";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray;
                objectArray[2] = "isStrUnicodeMatch";
                break;
            }
            case 154: 
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "isBytearrayBytesStringMatch";
                break;
            }
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "isUnionCallable";
                break;
            }
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "definesGetAttr";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "overridesGetAttr";
                break;
            }
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeMember";
                break;
            }
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromTupleAssignment";
                break;
            }
            case 171: 
            case 172: 
            case 173: {
                objectArray = objectArray;
                objectArray[2] = "parameterizeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 39, 40, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 66, 67, 68, 69, 70, 71, 89, 90, 91, 92, 93, 94, 95, 96, 97, 115, 116, 126, 127, 128, 130, 133, 150 -> new IllegalStateException(string);
        };
    }

    private static class MatchContext {
        @NotNull
        private final TypeEvalContext context;
        @NotNull
        private final GenericSubstitutions mySubstitutions;
        private final boolean reversedSubstitutions;

        MatchContext(@NotNull TypeEvalContext context, @NotNull Map<PyGenericType, PyType> typeVars) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(0);
            }
            if (typeVars == null) {
                MatchContext.$$$reportNull$$$0(1);
            }
            this(context, new GenericSubstitutions(typeVars), false);
        }

        MatchContext(@NotNull TypeEvalContext context, @NotNull GenericSubstitutions substitutions, boolean reversedSubstitutions) {
            if (context == null) {
                MatchContext.$$$reportNull$$$0(2);
            }
            if (substitutions == null) {
                MatchContext.$$$reportNull$$$0(3);
            }
            this.context = context;
            this.mySubstitutions = substitutions;
            this.reversedSubstitutions = reversedSubstitutions;
        }

        @NotNull
        public MatchContext reverseSubstitutions() {
            return new MatchContext(this.context, this.mySubstitutions, !this.reversedSubstitutions);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeVars";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "substitutions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/psi/types/PyTypeChecker$MatchContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Experimental
    public static class GenericSubstitutions {
        @NotNull
        private final Map<PyGenericType, PyType> typeVars;
        @NotNull
        private final Map<PyParamSpecType, PyParamSpecType> paramSpecs;
        @Nullable
        private PyType qualifierType;

        GenericSubstitutions() {
            this(new LinkedHashMap<PyGenericType, PyType>(), new LinkedHashMap<PyParamSpecType, PyParamSpecType>(), null);
        }

        public GenericSubstitutions(@NotNull Map<PyGenericType, PyType> typeVars) {
            if (typeVars == null) {
                GenericSubstitutions.$$$reportNull$$$0(0);
            }
            this(typeVars, new LinkedHashMap<PyParamSpecType, PyParamSpecType>(), null);
        }

        GenericSubstitutions(@NotNull Map<PyGenericType, PyType> typeVars, @NotNull Map<PyParamSpecType, PyParamSpecType> paramSpecs, @Nullable PyType qualifierType) {
            if (typeVars == null) {
                GenericSubstitutions.$$$reportNull$$$0(1);
            }
            if (paramSpecs == null) {
                GenericSubstitutions.$$$reportNull$$$0(2);
            }
            this.typeVars = typeVars;
            this.paramSpecs = paramSpecs;
            this.qualifierType = qualifierType;
        }

        @NotNull
        public Map<PyParamSpecType, PyParamSpecType> getParamSpecs() {
            Map<PyParamSpecType, PyParamSpecType> map = this.paramSpecs;
            if (map == null) {
                GenericSubstitutions.$$$reportNull$$$0(3);
            }
            return map;
        }

        @Nullable
        public PyType getQualifierType() {
            return this.qualifierType;
        }

        public String toString() {
            return "GenericSubstitutions{typeVars=" + this.typeVars + ", paramSpecs=" + this.paramSpecs + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeVars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paramSpecs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeChecker$GenericSubstitutions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class Generics {
        @NotNull
        private final Set<PyGenericType> typeVars = new LinkedHashSet<PyGenericType>();
        @NotNull
        private final List<PyGenericType> allTypeVars = new ArrayList<PyGenericType>();
        @NotNull
        private final Set<PyParamSpecType> paramSpecs = new LinkedHashSet<PyParamSpecType>();
        @NotNull
        private final Set<PyConcatenateType> concatenates = new LinkedHashSet<PyConcatenateType>();
        @Nullable
        private PySelfType self;

        @NotNull
        public Set<PyGenericType> getTypeVars() {
            Set<PyGenericType> set = Collections.unmodifiableSet(this.typeVars);
            if (set == null) {
                Generics.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public List<PyGenericType> getAllTypeVars() {
            List<PyGenericType> list = Collections.unmodifiableList(this.allTypeVars);
            if (list == null) {
                Generics.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        public Set<PyParamSpecType> getParamSpecs() {
            Set<PyParamSpecType> set = Collections.unmodifiableSet(this.paramSpecs);
            if (set == null) {
                Generics.$$$reportNull$$$0(2);
            }
            return set;
        }

        public boolean isEmpty() {
            return this.typeVars.isEmpty() && this.paramSpecs.isEmpty() && this.concatenates.isEmpty() && this.self == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/psi/types/PyTypeChecker$Generics";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeVars";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllTypeVars";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getParamSpecs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

