/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unresolvedReference;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AutoImportHintAction;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.PythonImportUtils;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyPackageRequirementsInspection;
import com.jetbrains.python.inspections.PyUnresolvedReferenceQuickFixProvider;
import com.jetbrains.python.inspections.quickfix.AddIgnoredIdentifierQuickFix;
import com.jetbrains.python.inspections.quickfix.GenerateBinaryStubsFix;
import com.jetbrains.python.inspections.unresolvedReference.PyPackageAliasesProvider;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspectionBase;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesVisitor;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.references.PyImportReference;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyUnresolvedReferencesInspection
extends PyUnresolvedReferencesInspectionBase {
    public static final Key<PyUnresolvedReferencesInspection> SHORT_NAME_KEY = Key.create((String)PyUnresolvedReferencesInspection.class.getSimpleName());
    public List<String> ignoredIdentifiers = new ArrayList<String>();

    public static PyUnresolvedReferencesInspection getInstance(PsiElement element) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        return (PyUnresolvedReferencesInspection)inspectionProfile.getUnwrappedTool(SHORT_NAME_KEY.toString(), element);
    }

    @Override
    @NotNull
    protected PyUnresolvedReferencesVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, this.ignoredIdentifiers, this, PyInspectionVisitor.getContext(session));
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"ignoredIdentifiers", (String)PyPsiBundle.message("INSP.unresolved.refs.ignore.references.label", new Object[0]))});
        if (optPane == null) {
            PyUnresolvedReferencesInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Visitor
    extends PyUnresolvedReferencesVisitor {
        public Visitor(@Nullable ProblemsHolder holder, List<String> ignoredIdentifiers, @NotNull PyInspection inspection, @NotNull TypeEvalContext context) {
            if (inspection == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, ignoredIdentifiers, inspection, context);
        }

        @Override
        public Iterable<LocalQuickFix> getInstallPackageQuickFixes(@NotNull PyElement node, @NotNull PsiReference reference, String refName) {
            QualifiedName qname;
            List components;
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (reference == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (reference instanceof PyImportReference && !(components = (qname = QualifiedName.fromDottedString((String)refName)).getComponents()).isEmpty()) {
                String packageName = (String)components.get(0);
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
                Sdk sdk2 = PythonSdkUtil.findPythonSdk(module);
                if (module != null && sdk2 != null && PyPackageUtil.packageManagementEnabled(sdk2, false, true)) {
                    return ((StreamEx)StreamEx.of((Object)packageName).append((Collection)PyPsiPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList())).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).map(pkg -> new PyPackageRequirementsInspection.InstallPackageQuickFix((String)pkg));
                }
            }
            return Collections.emptyList();
        }

        @Override
        public Iterable<LocalQuickFix> getAddIgnoredIdentifierQuickFixes(List<QualifiedName> qualifiedNames) {
            ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>(2);
            if (qualifiedNames.size() == 1) {
                QualifiedName qualifiedName = qualifiedNames.get(0);
                result2.add(new AddIgnoredIdentifierQuickFix(qualifiedName, false));
                if (qualifiedName.getComponentCount() > 1) {
                    result2.add(new AddIgnoredIdentifierQuickFix(qualifiedName.removeLastComponent(), true));
                }
            }
            return result2;
        }

        @Override
        public Iterable<LocalQuickFix> getImportStatementQuickFixes(PsiElement element) {
            PyImportStatementBase importStatementBase = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)element, PyImportStatementBase.class);
            if (importStatementBase != null && GenerateBinaryStubsFix.isApplicable(importStatementBase)) {
                return GenerateBinaryStubsFix.generateFixes(importStatementBase);
            }
            return Collections.emptyList();
        }

        @Override
        protected Iterable<LocalQuickFix> getAutoImportFixes(PyElement node, PsiReference reference, PsiElement element) {
            if (!PythonImportUtils.isImportable(element)) {
                return Collections.emptyList();
            }
            PsiFile file = InjectedLanguageManager.getInstance((Project)node.getProject()).getTopLevelFile((PsiElement)node);
            if (!(file instanceof PyFile)) {
                return Collections.emptyList();
            }
            ArrayList<LocalQuickFix> result2 = new ArrayList<LocalQuickFix>();
            AutoImportQuickFix importFix = PythonImportUtils.proposeImportFix(node, reference);
            if (importFix != null) {
                if (!Visitor.suppressHintForAutoImport(node, importFix) && PyCodeInsightSettings.getInstance().SHOW_IMPORT_POPUP) {
                    AutoImportHintAction autoImportHintAction = new AutoImportHintAction(importFix);
                    result2.add(autoImportHintAction);
                } else {
                    result2.add((LocalQuickFix)importFix);
                }
                if (ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyFunction) {
                    result2.add((LocalQuickFix)importFix.forLocalImport());
                }
            } else {
                PyReferenceExpression refExpr;
                String referencedName;
                String string = referencedName = node instanceof PyReferenceExpression && !(refExpr = (PyReferenceExpression)node).isQualified() ? refExpr.getReferencedName() : null;
                if (referencedName != null && PythonSdkUtil.findPythonSdk((PsiElement)node) != null) {
                    if (PyPIPackageUtil.INSTANCE.isInPyPI(referencedName)) {
                        result2.add(new PyPackageRequirementsInspection.InstallAndImportPackageQuickFix(referencedName, null));
                    } else {
                        String realPackageName = PyPackageAliasesProvider.commonImportAliases.get(referencedName);
                        if (realPackageName != null && PyPIPackageUtil.INSTANCE.isInPyPI(realPackageName)) {
                            result2.add(new PyPackageRequirementsInspection.InstallAndImportPackageQuickFix(realPackageName, referencedName));
                        }
                    }
                }
            }
            return result2;
        }

        private static boolean suppressHintForAutoImport(PyElement node, AutoImportQuickFix importFix) {
            if (!Visitor.isCall(node) && importFix.hasOnlyFunctions()) {
                return true;
            }
            PyClass containingClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)node, PyClass.class);
            return containingClass != null && (containingClass.findMethodByName(importFix.getNameToImport(), true, null) != null || containingClass.findInstanceAttribute(importFix.getNameToImport(), true) != null);
        }

        private static boolean isCall(PyElement node) {
            PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PyCallExpression.class);
            return callExpression != null && node == callExpression.getCallee();
        }

        @Override
        void getPluginQuickFixes(List<LocalQuickFix> fixes, PsiReference reference) {
            for (PyUnresolvedReferenceQuickFixProvider provider : PyUnresolvedReferenceQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerQuickFixes(reference, fixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inspection";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/unresolvedReference/PyUnresolvedReferencesInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getInstallPackageQuickFixes";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

