/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.variablesview.usertyperenderers;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.QualifiedName;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.ConfigureTypeRenderersActionKt;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserNodeRenderer;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserTypeRenderersConfigurable;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.PyTypeNameResolver;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/ConfigureTypeRenderersAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "perform", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "nodeName", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.python.community.impl"})
public final class ConfigureTypeRenderersAction
extends XDebuggerTreeActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConfigureTypeRenderersAction() {
        this.getTemplatePresentation().setText(PyBundle.message("action.PyDebugger.CustomizeDataView.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible((xDebugSession != null ? xDebugSession.getDebugProcess() : null) instanceof PyDebugProcess && XDebuggerTreeActionBase.getSelectedNodes((DataContext)e.getDataContext()).size() == 1);
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: ProjectMana\u2026Instance().defaultProject");
        Project project2 = project;
        XValueContainer xValueContainer = node.getValueContainer();
        PyDebugValue pyDebugValue = xValueContainer instanceof PyDebugValue ? (PyDebugValue)xValueContainer : null;
        if (pyDebugValue == null) {
            return;
        }
        PyDebugValue debugValue = pyDebugValue;
        String typeRendererId = debugValue.getTypeRendererId();
        if (typeRendererId == null) {
            Companion.showSettingsWithNewRenderer(project2, debugValue);
            return;
        }
        Integer rendererIndexToSelect = ConfigureTypeRenderersActionKt.getRendererIndexWithId(typeRendererId);
        if (rendererIndexToSelect != null) {
            Companion.showSettingsWithSelectedRenderer(project2, rendererIndexToSelect);
        } else {
            Companion.showSettingsWithNewRenderer(project2, debugValue);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/ConfigureTypeRenderersAction$Companion;", "", "()V", "showSettingsWithNewRenderer", "", "project", "Lcom/intellij/openapi/project/Project;", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "showSettingsWithSelectedRenderer", "rendererIndexToSelect", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void showSettingsWithNewRenderer(@NotNull Project project, @NotNull PyDebugValue debugValue) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)debugValue), (String)"debugValue");
            ShowSettingsUtil.getInstance().showSettingsDialog(project, PyUserTypeRenderersConfigurable.class, arg_0 -> Companion.showSettingsWithNewRenderer$lambda$0((Function1)new Function1<PyUserTypeRenderersConfigurable, Unit>(debugValue, project){
                final /* synthetic */ PyDebugValue $debugValue;
                final /* synthetic */ Project $project;
                {
                    this.$debugValue = $debugValue;
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(PyUserTypeRenderersConfigurable it) {
                    PyUserNodeRenderer newRenderer = new PyUserNodeRenderer(true, it.getCurrentlyVisibleNames());
                    String qualifiedType = this.$debugValue.getQualifiedType();
                    newRenderer.setName(this.$debugValue.getType() + " " + PyBundle.message("form.debugger.variables.view.user.type.renderers.renderer", new Object[0]));
                    if (qualifiedType == null) {
                        it.setNewRendererToAdd(newRenderer);
                        return;
                    }
                    PyClass pyClass = new PyTypeNameResolver(this.$project).resolve(qualifiedType);
                    if (pyClass != null) {
                        newRenderer.setToType(qualifiedType);
                    } else {
                        Collection<PyClass> classes = PyClassNameIndex.find(this.$debugValue.getType(), this.$project, GlobalSearchScope.projectScope((Project)this.$project));
                        boolean resolveFound = false;
                        Intrinsics.checkNotNullExpressionValue(classes, (String)"classes");
                        if (!classes.isEmpty()) {
                            QualifiedName canonicalImportPath;
                            QualifiedName qualifiedName = canonicalImportPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)CollectionsKt.first((Iterable)classes), null);
                            if (qualifiedName != null) {
                                QualifiedName qualifiedName2 = qualifiedName;
                                PyDebugValue pyDebugValue = this.$debugValue;
                                QualifiedName path2 = qualifiedName2;
                                boolean bl = false;
                                newRenderer.setToType(path2.toString() + "." + pyDebugValue.getType());
                                resolveFound = true;
                            }
                        }
                        if (!resolveFound) {
                            String string = this.$debugValue.getQualifiedType();
                            if (string == null) {
                                string = "";
                            }
                            newRenderer.setToType(string);
                            String string2 = this.$debugValue.getQualifiedType();
                            if (string2 == null) {
                                string2 = "";
                            }
                            newRenderer.setTypeCanonicalImportPath(string2);
                            String string3 = this.$debugValue.getQualifiedType();
                            if (string3 == null) {
                                string3 = "";
                            }
                            newRenderer.setTypeQualifiedName(string3);
                        }
                    }
                    it.setNewRendererToAdd(newRenderer);
                }
            }, arg_0));
        }

        public final void showSettingsWithSelectedRenderer(@NotNull Project project, int rendererIndexToSelect) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ShowSettingsUtil.getInstance().showSettingsDialog(project, PyUserTypeRenderersConfigurable.class, arg_0 -> Companion.showSettingsWithSelectedRenderer$lambda$1((Function1)new Function1<PyUserTypeRenderersConfigurable, Unit>(rendererIndexToSelect){
                final /* synthetic */ int $rendererIndexToSelect;
                {
                    this.$rendererIndexToSelect = $rendererIndexToSelect;
                    super(1);
                }

                public final void invoke(PyUserTypeRenderersConfigurable it) {
                    it.setRendererIndexToSelect(this.$rendererIndexToSelect);
                }
            }, arg_0));
        }

        private static final void showSettingsWithNewRenderer$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final void showSettingsWithSelectedRenderer$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

