/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J \u0010\u0014\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J \u0010\u0015\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0002J \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\fH\u0014J\u0018\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "DEFAULT_QUOTE", "", "addCompletionForTypedDictKeys", "", "expectedType", "Lcom/jetbrains/python/psi/types/PyType;", "actualType", "dictCompletion", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "quote", "addCompletionToAssignment", "originalElement", "Lcom/intellij/psi/PsiElement;", "possibleSequenceExpr", "Lcom/jetbrains/python/psi/PySequenceExpression;", "result", "addCompletionToCallExpression", "addCompletionToReturnStatement", "addCompletions", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "getForcedQuote", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyDictLiteralCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDictLiteralCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n11653#2,9:152\n13579#2:161\n13580#2:163\n11662#2:164\n1282#2,2:189\n1#3:162\n1#3:188\n800#4,11:165\n1360#4:176\n1446#4,5:177\n1549#4:182\n1620#4,3:183\n288#4,2:186\n819#4:191\n847#4,2:192\n*S KotlinDebug\n*F\n+ 1 PyDictLiteralCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider\n*L\n67#1:152,9\n67#1:161\n67#1:163\n67#1:164\n93#1:189,2\n67#1:162\n68#1:165,11\n69#1:176\n69#1:177,5\n70#1:182\n70#1:183,3\n84#1:186,2\n135#1:191\n135#1:192,2\n*E\n"})
final class DictLiteralCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final String DEFAULT_QUOTE;

    public DictLiteralCompletionProvider() {
        this.DEFAULT_QUOTE = "\"";
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiElement possibleSequenceExpr;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getOriginalPosition();
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (object == null) {
            return;
        }
        PsiElement originalElement = object;
        PsiElement psiElement2 = possibleSequenceExpr = originalElement instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)originalElement).getParent() : originalElement;
        if (possibleSequenceExpr instanceof PyKeyValueExpression) {
            possibleSequenceExpr = ((PyKeyValueExpression)possibleSequenceExpr).getParent();
        }
        if (possibleSequenceExpr instanceof PyDictLiteralExpression || possibleSequenceExpr instanceof PySetLiteralExpression) {
            this.addCompletionToCallExpression(originalElement, (PySequenceExpression)possibleSequenceExpr, result2);
            this.addCompletionToAssignment(originalElement, (PySequenceExpression)possibleSequenceExpr, result2);
            this.addCompletionToReturnStatement(originalElement, (PySequenceExpression)possibleSequenceExpr, result2);
        }
    }

    private final void addCompletionToCallExpression(PsiElement originalElement, PySequenceExpression possibleSequenceExpr, CompletionResultSet result2) {
        PyCallExpression callExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyCallExpression.class);
        if (callExpression != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(originalElement.getProject(), originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(originalE\u2026alElement.containingFile)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            PyExpression pyExpression = callExpression.getCallee();
            if (pyExpression == null) {
                return;
            }
            PyType callType = typeEvalContext2.getType(pyExpression);
            if (!(callType instanceof PyCallableType)) {
                return;
            }
            int argumentIndex = PyPsiUtils.findArgumentIndex(callExpression, (PsiElement)possibleSequenceExpr);
            if (argumentIndex < 0) {
                return;
            }
            List<PyCallableParameter> list = ((PyCallableType)callType).getParameters(typeEvalContext2);
            if (list == null) {
                return;
            }
            List<PyCallableParameter> params = list;
            if (params.size() <= argumentIndex) {
                return;
            }
            PyType expectedType = params.get(argumentIndex).getType(typeEvalContext2);
            PyType actualType = typeEvalContext2.getType(possibleSequenceExpr);
            this.addCompletionForTypedDictKeys(expectedType, actualType, result2, this.getForcedQuote(possibleSequenceExpr, originalElement));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getForcedQuote(PySequenceExpression possibleSequenceExpr, PsiElement originalElement) {
        if (!(originalElement instanceof PyStringLiteralExpression)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            void $this$mapNotNullTo$iv$iv;
            PyExpression[] pyExpressionArray = possibleSequenceExpr.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"possibleSequenceExpr.elements");
            Object $this$mapNotNull$iv = pyExpressionArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PyExpression it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                PyExpression it = (PyExpression)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof PyKeyValueExpression ? ((PyKeyValueExpression)it).getKey() : it) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PyStringLiteralExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PyStringLiteralExpression it = (PyStringLiteralExpression)element$iv$iv;
                boolean bl = false;
                List<PyStringElement> list = it.getStringElements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"it.stringElements");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyStringElement list$iv$iv = (PyStringElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getQuote());
            }
            Set usedQuotes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String string = (String)CollectionsKt.singleOrNull((Iterable)usedQuotes);
            if (string == null) {
                string = this.DEFAULT_QUOTE;
            }
            return string;
        }
        return "";
    }

    private final void addCompletionToAssignment(PsiElement originalElement, PySequenceExpression possibleSequenceExpr, CompletionResultSet result2) {
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyAssignmentStatement.class);
        if (assignment != null) {
            Pair targetToValue;
            Pair pair;
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(originalElement.getProject(), originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(originalE\u2026alElement.containingFile)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            if (assignment.getTargets().length == 1) {
                pair = TuplesKt.to((Object)assignment.getTargets()[0], (Object)assignment.getAssignedValue());
            } else {
                Object v3;
                block13: {
                    List<com.intellij.openapi.util.Pair<PyExpression, PyExpression>> list = assignment.getTargetsToValuesMapping();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"assignment.targetsToValuesMapping");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        com.intellij.openapi.util.Pair it = (com.intellij.openapi.util.Pair)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.second, (Object)possibleSequenceExpr)) continue;
                        v3 = element$iv;
                        break block13;
                    }
                    v3 = null;
                }
                com.intellij.openapi.util.Pair pair2 = v3;
                if (pair2 != null) {
                    com.intellij.openapi.util.Pair it = pair2;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)it.first, (Object)it.second);
                } else {
                    pair = null;
                }
            }
            Pair pair3 = targetToValue = pair;
            if ((pair3 != null ? (PyExpression)pair3.getFirst() : null) != null && targetToValue.getSecond() != null) {
                Object object = targetToValue.getFirst();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyTypedElement");
                PyType expectedType = typeEvalContext2.getType((PyTypedElement)object);
                Object object2 = targetToValue.getSecond();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyTypedElement");
                PyType actualType = typeEvalContext2.getType((PyTypedElement)object2);
                this.addCompletionForTypedDictKeys(expectedType, actualType, result2, this.getForcedQuote(possibleSequenceExpr, originalElement));
            } else {
                Object object;
                PyExpression targetExpr;
                block14: {
                    targetExpr = assignment.getAssignedValue();
                    if (targetExpr instanceof PyTupleExpression) {
                        PyExpression[] pyExpressionArray = ((PyTupleExpression)targetExpr).getElements();
                        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"targetExpr.elements");
                        Object[] $this$firstOrNull$iv = pyExpressionArray;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PyExpression it = (PyExpression)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)possibleSequenceExpr)) continue;
                            object = element$iv;
                            break block14;
                        }
                        object = null;
                    } else {
                        return;
                    }
                }
                PyExpression element = (PyExpression)object;
                if (element != null) {
                    PyExpression[] pyExpressionArray = ((PyTupleExpression)targetExpr).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"targetExpr.elements");
                    int index = ArraysKt.indexOf((Object[])pyExpressionArray, (Object)element);
                    if (index < assignment.getTargets().length) {
                        PyType expectedType = typeEvalContext2.getType(assignment.getTargets()[index]);
                        PyType actualType = typeEvalContext2.getType(element);
                        this.addCompletionForTypedDictKeys(expectedType, actualType, result2, this.getForcedQuote(possibleSequenceExpr, originalElement));
                    }
                }
            }
        }
    }

    private final void addCompletionToReturnStatement(PsiElement originalElement, PySequenceExpression possibleSequenceExpr, CompletionResultSet result2) {
        PyReturnStatement returnStatement = (PyReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyReturnStatement.class);
        if (returnStatement != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(originalElement.getProject(), originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(originalE\u2026alElement.containingFile)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)returnStatement);
            if (owner instanceof PyFunction) {
                PyAnnotation annotation = ((PyFunction)owner).getAnnotation();
                String typeCommentAnnotation = ((PyFunction)owner).getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyType expectedType = typeEvalContext2.getReturnType((PyCallable)((Object)owner));
                    PyType actualType = typeEvalContext2.getType(possibleSequenceExpr);
                    this.addCompletionForTypedDictKeys(expectedType, actualType, result2, this.getForcedQuote(possibleSequenceExpr, originalElement));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCompletionForTypedDictKeys(PyType expectedType, PyType actualType, CompletionResultSet dictCompletion, String quote) {
        if (expectedType instanceof PyTypedDictType) {
            Collection collection;
            if (actualType instanceof PyTypedDictType) {
                void $this$filterNotTo$iv$iv;
                Set<String> set = ((PyTypedDictType)expectedType).getFields().keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"expectedType.fields.keys");
                Iterable $this$filterNot$iv = set;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    Map map = ((PyTypedDictType)actualType).getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (map.containsKey(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                collection = (List)destination$iv$iv;
            } else if (actualType instanceof PyClassType && Intrinsics.areEqual((Object)"set", (Object)((PyClassType)actualType).getName())) {
                Set<String> set = ((PyTypedDictType)expectedType).getFields().keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"expectedType.fields.keys");
                collection = set;
            } else {
                return;
            }
            Collection keys = collection;
            for (String key : keys) {
                dictCompletion.addElement((LookupElement)LookupElementBuilder.create((String)(quote + key + quote)).withTypeText("dict key").withIcon(IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Parameter)));
            }
        }
    }
}

