/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.ShellCommandListener;
import org.jetbrains.plugins.terminal.exp.TerminalCompletionContributor;
import org.jetbrains.plugins.terminal.exp.TerminalCompletionManager;
import org.jetbrains.plugins.terminal.exp.TerminalModel;
import org.jetbrains.plugins.terminal.exp.TerminalSession;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005!\"#$%B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00110\u001e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u001fH\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "calculatePrefix", "", "text", "createElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "item", "Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$CompletionItem;", "lookup", "Lcom/intellij/codeInsight/lookup/LookupEx;", "invokeCompletion", "Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$CompletionResult;", "session", "Lorg/jetbrains/plugins/terminal/exp/TerminalSession;", "completionManager", "Lorg/jetbrains/plugins/terminal/exp/TerminalCompletionManager;", "command", "timeoutMillis", "", "parseCompletionItems", "", "Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$ParsingContext;", "parseSingleItem", "Companion", "CompletionItem", "CompletionResult", "ParsingContext", "TerminalCompletionPrefixMatcher", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShCompletionProvider.kt\norg/jetbrains/plugins/terminal/exp/ShCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,248:1\n1549#2:249\n1620#2,3:250\n1620#2,3:276\n1620#2,3:279\n363#2,9:282\n107#3:253\n79#3,22:254\n*S KotlinDebug\n*F\n+ 1 ShCompletionProvider.kt\norg/jetbrains/plugins/terminal/exp/ShCompletionProvider\n*L\n68#1:249\n68#1:250,3\n152#1:276,3\n155#1:279,3\n199#1:282,9\n142#1:253\n142#1:254,22\n*E\n"})
public final class ShCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex SPLIT_REGEX = new Regex("(?<!\\\\) +");

    /*
     * WARNING - void declaration
     */
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        String addedPart;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        TerminalSession session = (TerminalSession)parameters.getEditor().getUserData(TerminalSession.Companion.getKEY());
        TerminalCompletionManager completionManager = (TerminalCompletionManager)parameters.getEditor().getUserData(TerminalCompletionManager.Companion.getKEY());
        if (session == null || completionManager == null || parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        String string = parameters.getEditor().getDocument().getText(new TextRange(0, parameters.getOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameters.editor.docume\u2026ge(0, parameters.offset))");
        String rawCommand = string;
        if (StringsKt.isBlank((CharSequence)rawCommand)) {
            return;
        }
        String command = StringsKt.replace$default((String)rawCommand, (String)"\\\n", (String)"", (boolean)false, (int)4, null);
        String prefix = this.calculatePrefix(command);
        TerminalCompletionPrefixMatcher prefixMatcher = new TerminalCompletionPrefixMatcher(prefix);
        CompletionResultSet completionResultSet = result2.caseInsensitive().withPrefixMatcher((PrefixMatcher)prefixMatcher);
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"result.caseInsensitive()\u2026fixMatcher(prefixMatcher)");
        CompletionResultSet resultSet = completionResultSet;
        int baseTimeoutMillis = 1000;
        CompletionResult completionResult = this.invokeCompletion(session, completionManager, command, baseTimeoutMillis);
        if (completionResult.isSingleItem() && !StringsKt.endsWith$default((CharSequence)(addedPart = ((CompletionItem)CollectionsKt.single(completionResult.getItems())).getValue()), (char)'/', (boolean)false, (int)2, null)) {
            CompletionResult secondResult = this.invokeCompletion(session, completionManager, command + addedPart, baseTimeoutMillis / 2);
            if (secondResult.isSingleItem()) {
                completionResult = new CompletionResult(new CompletionItem(addedPart + ((CompletionItem)CollectionsKt.single(secondResult.getItems())).getValue(), null, 2, null));
            } else if (!secondResult.getItems().isEmpty()) {
                completionResult = secondResult;
            }
        }
        LookupEx lookup = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (completionResult.isSingleItem()) {
            LookupElement option = this.createElement(new CompletionItem(resultSet.getPrefixMatcher().getPrefix() + ((CompletionItem)CollectionsKt.single(completionResult.getItems())).getValue(), null, 2, null), lookup);
            resultSet.addElement(option);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = completionResult.getItems();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CompletionItem completionItem = (CompletionItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.createElement((CompletionItem)it, lookup));
            }
            List options = (List)destination$iv$iv;
            resultSet.addAllElements((Iterable)options);
        }
        resultSet.stopHere();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CompletionResult invokeCompletion(TerminalSession session, TerminalCompletionManager completionManager, String command, int timeoutMillis) {
        completionManager.waitForTerminalLock();
        TerminalModel model = session.getModel();
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable listenerDisposable = disposable;
        CompletableFuture<CompletionResult> future = new CompletableFuture<CompletionResult>();
        ParsingContext context = new ParsingContext(command, model.getWidth());
        try {
            model.addContentListener(new TerminalModel.ContentListener(model, future, this, context){
                final /* synthetic */ TerminalModel $model;
                final /* synthetic */ CompletableFuture<CompletionResult> $future;
                final /* synthetic */ ShCompletionProvider this$0;
                final /* synthetic */ ParsingContext $context;
                {
                    this.$model = $model;
                    this.$future = $future;
                    this.this$0 = $receiver;
                    this.$context = $context;
                }

                public void onTextWritten(int x, int y, @NotNull String text) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        String allText = this.$model.getAllText(x + text.length(), y);
                        if (((CharSequence)allText).length() == 0 || this.$future.isDone()) {
                            return;
                        }
                        String string = ShCompletionProvider.access$parseSingleItem(this.this$0, allText, this.$context);
                        if (string == null) break block1;
                        String string2 = string;
                        CompletableFuture<CompletionResult> completableFuture = this.$future;
                        String it = string2;
                        boolean bl = false;
                        completableFuture.complete(new CompletionResult(new CompletionItem(it, null, 2, null)));
                    }
                }
            }, listenerDisposable);
            session.addCommandListener(new ShellCommandListener(model, future, this, context){
                final /* synthetic */ TerminalModel $model;
                final /* synthetic */ CompletableFuture<CompletionResult> $future;
                final /* synthetic */ ShCompletionProvider this$0;
                final /* synthetic */ ParsingContext $context;
                {
                    this.$model = $model;
                    this.$future = $future;
                    this.this$0 = $receiver;
                    this.$context = $context;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public void promptShown() {
                    String string;
                    void this_$iv;
                    TerminalModel terminalModel = this.$model;
                    TerminalModel terminalModel2 = this.$model;
                    boolean $i$f$withContentLock = false;
                    this_$iv.lockContent();
                    try {
                        boolean bl = false;
                        string = TerminalModel.getAllText$default(terminalModel2, 0, 0, 3, null);
                    }
                    finally {
                        this_$iv.unlockContent();
                    }
                    String allText = string;
                    if (((CharSequence)allText).length() == 0 || this.$future.isDone()) {
                        return;
                    }
                    List items = ShCompletionProvider.access$parseCompletionItems(this.this$0, allText, this.$context);
                    this.$future.complete(new CompletionResult(items));
                }
            }, listenerDisposable);
            new Alarm(Alarm.ThreadToUse.POOLED_THREAD, listenerDisposable).addRequest(() -> ShCompletionProvider.invokeCompletion$lambda$1(future), timeoutMillis);
            completionManager.invokeCompletion(command);
            ApplicationUtil.runWithCheckCanceled((Future)future, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        }
        finally {
            Disposer.dispose((Disposable)listenerDisposable);
            if (!future.isDone()) {
                future.complete(new CompletionResult());
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> ShCompletionProvider.invokeCompletion$lambda$2(completionManager));
        }
        CompletionResult completionResult = future.getNow(new CompletionResult());
        Intrinsics.checkNotNullExpressionValue((Object)completionResult, (String)"future.getNow(CompletionResult())");
        return completionResult;
    }

    private final String parseSingleItem(String text, ParsingContext context) {
        String addedPart;
        if (StringsKt.startsWith$default((String)text, (String)context.getCommandText(), (boolean)false, (int)2, null) && !StringsKt.isBlank((CharSequence)(addedPart = StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)text, (CharSequence)context.getCommandText()), (char)'\n', null, (int)2, null)))) {
            return addedPart;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CompletionItem> parseCompletionItems(String text, ParsingContext context) {
        String $this$trim$iv = StringsKt.removePrefix((String)text, (CharSequence)context.getCommandText());
        boolean $i$f$trim22 = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = it == ' ' || it == '\n';
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String optionsText = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String[] $i$f$trim22 = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)optionsText, (String[])$i$f$trim22, (boolean)false, (int)0, (int)6, null);
        List result2 = new ArrayList();
        for (String line : lines) {
            void $this$mapTo$iv;
            Collection collection;
            String delimiter;
            int delimiterIndex = StringsKt.indexOf$default((CharSequence)line, (String)(delimiter = " -- "), (int)0, (boolean)false, (int)6, null);
            if (delimiterIndex != -1) {
                void $this$mapTo$iv2;
                String string = line.substring(0, delimiterIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String values = ((Object)StringsKt.trim((CharSequence)string)).toString();
                String string2 = line.substring(delimiterIndex + delimiter.length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                String description = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                Object match$iv$iv = values;
                Regex bl = SPLIT_REGEX;
                int n = 0;
                match$iv$iv = bl.split((CharSequence)match$iv$iv, n);
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv2) {
                    void it;
                    String string3 = (String)item$iv;
                    collection = result2;
                    boolean bl3 = false;
                    collection.add(new CompletionItem((String)it, description));
                }
                continue;
            }
            Object values = ((Object)StringsKt.trim((CharSequence)line)).toString();
            Regex description = SPLIT_REGEX;
            int n = 0;
            values = description.split((CharSequence)values, n);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                String string = (String)item$iv;
                collection = result2;
                boolean bl = false;
                collection.add(new CompletionItem((String)it, null, 2, null));
            }
        }
        return result2;
    }

    private final LookupElement createElement(CompletionItem item, LookupEx lookup) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)item.getValue()).withTypeText(item.getDescription(), true).withInsertHandler((arg_0, arg_1) -> ShCompletionProvider.createElement$lambda$6(lookup, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(item.value)\n     \u2026AutoPopup(editor)\n      }");
        return (LookupElement)lookupElementBuilder;
    }

    private final String calculatePrefix(String text) {
        String string;
        Iterable $this$indexOfLast$iv = StringsKt.withIndex((CharSequence)text);
        boolean $i$f$indexOfLast = false;
        int lastIndex$iv = -1;
        int index$iv = 0;
        for (Object item$iv : $this$indexOfLast$iv) {
            if (index$iv < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IndexedValue indexedValue = (IndexedValue)item$iv;
            boolean bl = false;
            int index = indexedValue.component1();
            char c = ((Character)indexedValue.component2()).charValue();
            if (c == '/' || c == ' ' && (index == 0 || text.charAt(index - 1) != '\\')) {
                lastIndex$iv = index$iv;
            }
            ++index$iv;
        }
        int delimiterIndex = lastIndex$iv;
        if (delimiterIndex != -1) {
            String string2 = text.substring(delimiterIndex + 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        } else {
            string = text;
        }
        return string;
    }

    private static final void invokeCompletion$lambda$1(CompletableFuture $future) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(new CompletionResult());
    }

    private static final void invokeCompletion$lambda$2(TerminalCompletionManager $completionManager) {
        Intrinsics.checkNotNullParameter((Object)$completionManager, (String)"$completionManager");
        $completionManager.resetPrompt();
    }

    private static final void createElement$lambda$6(LookupEx $lookup, InsertionContext context, LookupElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
        String value = string;
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"context.editor");
        Editor editor2 = editor;
        if (TerminalCompletionContributor.Companion.isSingleCharParameter(value) && $lookup != null) {
            String string2 = $lookup.itemPattern(element);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lookup.itemPattern(element)");
            String prefix = string2;
            String toInsert = prefix + StringsKt.removePrefix((String)value, (CharSequence)"-");
            int startOffset = context.getStartOffset();
            editor2.getDocument().replaceString(startOffset, startOffset + value.length(), (CharSequence)toInsert);
            editor2.getCaretModel().moveToOffset(startOffset + toInsert.length());
        }
        if (!TerminalCompletionContributor.Companion.isSingleCharParameter(value) && !StringsKt.endsWith$default((String)value, (String)"/", (boolean)false, (int)2, null)) {
            int offset = editor2.getCaretModel().getOffset();
            editor2.getDocument().insertString(offset, (CharSequence)" ");
            editor2.getCaretModel().moveToOffset(offset + 1);
        }
        AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(editor2);
    }

    public static final /* synthetic */ String access$parseSingleItem(ShCompletionProvider $this, String text, ParsingContext context) {
        return $this.parseSingleItem(text, context);
    }

    public static final /* synthetic */ List access$parseCompletionItems(ShCompletionProvider $this, String text, ParsingContext context) {
        return $this.parseCompletionItems(text, context);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$Companion;", "", "()V", "SPLIT_REGEX", "Lkotlin/text/Regex;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$CompletionItem;", "", "value", "", "description", "(Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class CompletionItem {
        @NotNull
        private final String value;
        @Nullable
        private final String description;

        public CompletionItem(@NotNull String value, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
            this.description = description;
        }

        public /* synthetic */ CompletionItem(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Nullable
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @Nullable
        public final String component2() {
            return this.description;
        }

        @NotNull
        public final CompletionItem copy(@NotNull String value, @Nullable String description) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new CompletionItem(value, description);
        }

        public static /* synthetic */ CompletionItem copy$default(CompletionItem completionItem, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = completionItem.value;
            }
            if ((n & 2) != 0) {
                string2 = completionItem.description;
            }
            return completionItem.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CompletionItem(value=" + this.value + ", description=" + this.description + ")";
        }

        public int hashCode() {
            int result2 = this.value.hashCode();
            result2 = result2 * 31 + (this.description == null ? 0 : this.description.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompletionItem)) {
                return false;
            }
            CompletionItem completionItem = (CompletionItem)other;
            if (!Intrinsics.areEqual((Object)this.value, (Object)completionItem.value)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.description, (Object)completionItem.description);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bB\u001d\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$CompletionResult;", "", "()V", "items", "", "Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$CompletionItem;", "(Ljava/util/List;)V", "item", "(Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$CompletionItem;)V", "isSingleItem", "", "(Ljava/util/List;Z)V", "()Z", "getItems", "()Ljava/util/List;", "toString", "", "intellij.terminal"})
    private static final class CompletionResult {
        @NotNull
        private final List<CompletionItem> items;
        private final boolean isSingleItem;

        private CompletionResult(List<CompletionItem> items, boolean isSingleItem) {
            this.items = items;
            this.isSingleItem = isSingleItem;
        }

        @NotNull
        public final List<CompletionItem> getItems() {
            return this.items;
        }

        public final boolean isSingleItem() {
            return this.isSingleItem;
        }

        public CompletionResult() {
            this(CollectionsKt.emptyList(), false);
        }

        public CompletionResult(@NotNull List<CompletionItem> items) {
            Intrinsics.checkNotNullParameter(items, (String)"items");
            this(items, false);
        }

        public CompletionResult(@NotNull CompletionItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this(CollectionsKt.listOf((Object)item), true);
        }

        @NotNull
        public String toString() {
            return "isSingleItem: " + this.isSingleItem + ", items: " + this.items;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$ParsingContext;", "", "command", "", "terminalWidth", "", "(Ljava/lang/String;I)V", "commandText", "getCommandText", "()Ljava/lang/String;", "createCommandString", "width", "intellij.terminal"})
    private static final class ParsingContext {
        @NotNull
        private final String commandText;

        public ParsingContext(@NotNull String command, int terminalWidth) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            this.commandText = this.createCommandString(command, terminalWidth);
        }

        @NotNull
        public final String getCommandText() {
            return this.commandText;
        }

        private final String createCommandString(String command, int width) {
            StringBuilder builder = new StringBuilder(command);
            for (int pos = width; pos < builder.length(); pos += width + 1) {
                builder.insert(pos, '\n');
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShCompletionProvider$TerminalCompletionPrefixMatcher;", "Lcom/intellij/codeInsight/completion/PrefixMatcher;", "prefix", "", "(Ljava/lang/String;)V", "cloneWithPrefix", "prefixMatches", "", "name", "intellij.terminal"})
    private static final class TerminalCompletionPrefixMatcher
    extends PrefixMatcher {
        public TerminalCompletionPrefixMatcher(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            super(prefix);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean prefixMatches(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (TerminalCompletionContributor.Companion.isSingleCharParameter(name)) {
                String string = this.getPrefix();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"prefix");
                if (StringsKt.startsWith$default((String)string, (String)"-", (boolean)false, (int)2, null)) {
                    String string2 = this.getPrefix();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"prefix");
                    if (!StringsKt.startsWith$default((String)string2, (String)"--", (boolean)false, (int)2, null)) {
                        String parameter = StringsKt.removePrefix((String)name, (CharSequence)"-");
                        String string3 = this.getPrefix();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"prefix");
                        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)parameter, (boolean)false, (int)2, null)) return false;
                        return true;
                    }
                }
            }
            boolean bl = StringUtil.startsWithIgnoreCase((String)name, (String)this.getPrefix());
            return bl;
        }

        @NotNull
        public PrefixMatcher cloneWithPrefix(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return new TerminalCompletionPrefixMatcher(prefix);
        }
    }
}

