/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.internal.statistic.collectors.fus.TerminalFusAwareHandler;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.ClassEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.PathUtil;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUsageCollectorKt;
import org.jetbrains.plugins.terminal.fus.TerminalCommandUsageStatistics;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalUsageTriggerCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "Companion", "intellij.terminal"})
public final class TerminalUsageTriggerCollector
extends CounterUsagesCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("terminalShell", 15, null, 4, null);
    @NotNull
    private static final ClassEventField TERMINAL_COMMAND_HANDLER_FIELD = EventFields.Class((String)"terminalCommandHandler");
    @NotNull
    private static final ClassEventField RUN_ANYTHING_PROVIDER_FIELD = EventFields.Class((String)"runAnythingProvider");
    @NotNull
    private static final EventId sshExecEvent = GROUP.registerEvent("ssh.exec");
    @NotNull
    private static final VarargEventId terminalSmartCommandExecutedEvent;
    @NotNull
    private static final VarargEventId terminalSmartCommandNotExecutedEvent;
    @NotNull
    private static final EventId2<String, String> localExecEvent;
    @NotNull
    private static final EventId2<String, String> commandExecutedEvent;

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    @JvmStatic
    public static final void triggerSshShellStarted(@NotNull Project project) {
        Companion.triggerSshShellStarted(project);
    }

    @JvmStatic
    public static final void triggerCommandExecuted(@NotNull Project project, @NotNull String userCommandLine) {
        Companion.triggerCommandExecuted(project, userCommandLine);
    }

    @JvmStatic
    public static final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull TerminalShellCommandHandler handler, boolean executed) {
        Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, executed);
    }

    @JvmStatic
    public static final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand) {
        Companion.triggerLocalShellStarted(project, shellCommand);
    }

    @JvmStatic
    private static final String getShellNameForStat(String shellName) {
        return TerminalUsageTriggerCollector.Companion.getShellNameForStat(shellName);
    }

    static {
        EventField[] eventFieldArray = new EventField[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.executed", eventFieldArray);
        eventFieldArray = new EventField[]{TERMINAL_COMMAND_HANDLER_FIELD, RUN_ANYTHING_PROVIDER_FIELD};
        terminalSmartCommandNotExecutedEvent = GROUP.registerVarargEvent("terminal.smart.command.not.executed", eventFieldArray);
        localExecEvent = GROUP.registerEvent("local.exec", (EventField)EventFields.StringValidatedByRegexp((String)"os-version", (String)"version"), (EventField)EventFields.String((String)"shell", (List)CollectionsKt.toList((Iterable)TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p())));
        commandExecutedEvent = GROUP.registerEvent("terminal.command.executed", (EventField)TerminalCommandUsageStatistics.INSTANCE.getCommandExecutableField$intellij_terminal(), (EventField)TerminalCommandUsageStatistics.INSTANCE.getSubCommandField$intellij_terminal());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\nH\u0003J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0007J#\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001bJ:\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001fH\u0007J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalUsageTriggerCollector$Companion;", "", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "RUN_ANYTHING_PROVIDER_FIELD", "Lcom/intellij/internal/statistic/eventLog/events/ClassEventField;", "TERMINAL_COMMAND_HANDLER_FIELD", "commandExecutedEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "localExecEvent", "sshExecEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "terminalSmartCommandExecutedEvent", "Lcom/intellij/internal/statistic/eventLog/events/VarargEventId;", "terminalSmartCommandNotExecutedEvent", "getShellNameForStat", "shellName", "triggerCommandExecuted", "", "project", "Lcom/intellij/openapi/project/Project;", "userCommandLine", "triggerLocalShellStarted", "shellCommand", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)V", "triggerSmartCommand", "workingDirectory", "localSession", "", "command", "handler", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "executed", "triggerSshShellStarted", "trimKnownExt", "name", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void triggerSshShellStarted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            sshExecEvent.log(project);
        }

        @JvmStatic
        public final void triggerCommandExecuted(@NotNull Project project, @NotNull String userCommandLine) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)userCommandLine, (String)"userCommandLine");
            TerminalCommandUsageStatistics.INSTANCE.triggerCommandExecuted((EventId2<? super String, ? super String>)commandExecutedEvent, project, userCommandLine);
        }

        @JvmStatic
        public final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull TerminalShellCommandHandler handler, boolean executed) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Object[] objectArray = new EventPair[]{TERMINAL_COMMAND_HANDLER_FIELD.with(handler.getClass())};
            List data = CollectionsKt.mutableListOf((Object[])objectArray);
            if (handler instanceof TerminalFusAwareHandler) {
                ((TerminalFusAwareHandler)handler).fillData(project, workingDirectory, localSession, command, data);
            }
            if (executed) {
                terminalSmartCommandExecutedEvent.log(project, data);
            } else {
                terminalSmartCommandNotExecutedEvent.log(project, data);
            }
        }

        @JvmStatic
        public final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
            EventId2 eventId2 = localExecEvent;
            Version version = Version.parseVersion((String)SystemInfo.OS_VERSION);
            String string = version != null ? version.toCompactString() : null;
            if (string == null) {
                string = "unknown";
            }
            eventId2.log(project, (Object)string, (Object)this.getShellNameForStat((String)ArraysKt.firstOrNull((Object[])shellCommand)));
        }

        @JvmStatic
        private final String getShellNameForStat(String shellName) {
            String string;
            if (shellName == null) {
                return "unspecified";
            }
            String name = ((Object)StringsKt.trimStart((CharSequence)shellName)).toString();
            int ind = StringsKt.indexOf$default((CharSequence)name, (String)" ", (int)0, (boolean)false, (int)6, null);
            if (ind < 0) {
                string = name;
            } else {
                String string2 = name.substring(0, ind);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            name = string;
            if (SystemInfo.isFileSystemCaseSensitive) {
                String string3 = name;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string4 = string3.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(locale)");
                name = string4;
            }
            String string5 = PathUtil.getFileName((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getFileName(name)");
            name = string5;
            name = this.trimKnownExt(name);
            return TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p().contains(name) ? name : "other";
        }

        private final String trimKnownExt(String name) {
            String string;
            String ext = PathUtil.getFileExtension((String)name);
            if (ext != null && TerminalUsageCollectorKt.access$getKNOWN_EXTENSIONS$p().contains(ext)) {
                String string2 = name.substring(0, name.length() - ext.length() - 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            } else {
                string = name;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

