/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import net.n3.nanoxml.IXMLBuilder;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParseException;

public class StdXMLBuilder
implements IXMLBuilder {
    private Stack stack = null;
    private IXMLElement root = null;
    private IXMLElement prototype;

    public StdXMLBuilder() {
        this(new XMLElement());
    }

    public StdXMLBuilder(IXMLElement iXMLElement) {
        this.prototype = iXMLElement;
    }

    protected void finalize() throws Throwable {
        this.prototype = null;
        this.root = null;
        this.stack.clear();
        this.stack = null;
        super.finalize();
    }

    public void startBuilding(String string2, int n) {
        this.stack = new Stack();
        this.root = null;
    }

    public void newProcessingInstruction(String string2, Reader reader) {
    }

    public void startElement(String string2, String string3, String string4, String string5, int n) {
        String string6 = string2;
        if (string3 != null) {
            string6 = string3 + ':' + string2;
        }
        IXMLElement iXMLElement = this.prototype.createElement(string6, string4, string5, n);
        if (this.stack.empty()) {
            this.root = iXMLElement;
        } else {
            IXMLElement iXMLElement2 = (IXMLElement)this.stack.peek();
            iXMLElement2.addChild(iXMLElement);
        }
        this.stack.push(iXMLElement);
    }

    public void elementAttributesProcessed(String string2, String string3, String string4) {
    }

    public void endElement(String string2, String string3, String string4) {
        IXMLElement iXMLElement;
        IXMLElement iXMLElement2 = (IXMLElement)this.stack.pop();
        if (iXMLElement2.getChildrenCount() == 1 && (iXMLElement = iXMLElement2.getChildAtIndex(0)).getName() == null) {
            iXMLElement2.setContent(iXMLElement.getContent());
            iXMLElement2.removeChildAtIndex(0);
        }
    }

    public void addAttribute(String string2, String string3, String string4, String string5, String string6) throws Exception {
        IXMLElement iXMLElement;
        String string7 = string2;
        if (string3 != null) {
            string7 = string3 + ':' + string2;
        }
        if ((iXMLElement = (IXMLElement)this.stack.peek()).hasAttribute(string7)) {
            throw new XMLParseException(iXMLElement.getSystemID(), iXMLElement.getLineNr(), "Duplicate attribute: " + string2);
        }
        if (string3 != null) {
            iXMLElement.setAttribute(string7, string4, string5);
        } else {
            iXMLElement.setAttribute(string7, string5);
        }
    }

    public void addPCData(Reader reader, String string2, int n) {
        int n2 = 2048;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n2);
        char[] cArray = new char[n2];
        while (true) {
            int n4;
            if (n3 >= n2) {
                stringBuffer.ensureCapacity(n2 *= 2);
            }
            try {
                n4 = reader.read(cArray);
            }
            catch (IOException iOException) {
                break;
            }
            if (n4 < 0) break;
            stringBuffer.append(cArray, 0, n4);
            n3 += n4;
        }
        IXMLElement iXMLElement = this.prototype.createElement(null, string2, n);
        iXMLElement.setContent(stringBuffer.toString());
        if (!this.stack.empty()) {
            IXMLElement iXMLElement2 = (IXMLElement)this.stack.peek();
            iXMLElement2.addChild(iXMLElement);
        }
    }

    public Object getResult() {
        return this.root;
    }
}

